/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻STC32GΪоƬʵбдԡ

ʹKeil C251Memory ModelƼXSmallģʽĬ϶edataʱӴȡٶȿ졣

edata鱣1Kջʹãռ䲻ʱɽ顢ñxdataؼֶ嵽xdataռ䡣

ʾ5ʱʹ, ̾ʹ16λԶװ.

ʱ016λԶװ, жƵΪ1000HZжϺP6.7ȡ500HZź.

ʱ116λԶװ, жƵΪ2000HZжϺP6.6ȡ1000HZź.

ʱ216λԶװ, жƵΪ3000HZжϺP6.5ȡ1500HZź.

ʱ316λԶװ, жƵΪ4000HZжϺP6.4ȡ2000HZź.

ʱ416λԶװ, жƵΪ5000HZжϺP6.3ȡ2500HZź.

ʱ, ѡʱ 24MHZ (û޸Ƶ).

******************************************/

#include "..\..\comm\STC32G.h"

#include "stdio.h"
#include "intrins.h"

typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;

#define MAIN_Fosc        24000000UL

//==========================================================================

#define Timer0_Reload   (MAIN_Fosc / 1000)      //Timer 0 жƵ, 1000/
#define Timer1_Reload   (MAIN_Fosc / 2000)      //Timer 1 жƵ, 2000/
#define Timer2_Reload   (MAIN_Fosc / 3000)      //Timer 2 жƵ, 3000/
#define Timer3_Reload   (MAIN_Fosc / 4000)      //Timer 3 жƵ, 4000/
#define Timer4_Reload   (MAIN_Fosc / 5000)      //Timer 4 жƵ, 5000/

void    Timer0_init(void);
void    Timer1_init(void);
void    Timer2_init(void);
void    Timer3_init(void);
void    Timer4_init(void);

/********************  **************************/
void main(void)
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x30;   P0M0 = 0x30;   //P0.4P0.5Ϊ©·(ʵ赽3.3V)
    P1M1 = 0x30;   P1M0 = 0x30;   //P1.4P1.5Ϊ©·(ʵ赽3.3V)
    P2M1 = 0x3c;   P2M0 = 0x3c;   //P2.2~P2.5Ϊ©·(ʵ赽3.3V)
    P3M1 = 0x50;   P3M0 = 0x50;   //P3.4P3.6Ϊ©·(ʵ赽3.3V)
    P4M1 = 0x3c;   P4M0 = 0x3c;   //P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    P5M1 = 0x0c;   P5M0 = 0x0c;   //P5.2P5.3Ϊ©·(ʵ赽3.3V)
    P6M1 = 0xff;   P6M0 = 0xff;   //Ϊ©·(ʵ赽3.3V)
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    EA = 1;     //ж
    P40 = 0;		//LEDԴ
    
    Timer0_init();
    Timer1_init();
    Timer2_init();
    Timer3_init();
    Timer4_init();

    while (1);
}

//========================================================================
// : void Timer0_init(void)
// : timer0ʼ.
// : none.
// : none.
// 汾: V1.0, 2015-1-12
//========================================================================
void Timer0_init(void)
{
        TR0 = 0;    //ֹͣ

    #if (Timer0_Reload < 64)    // ûֵʣ ʱ
        #error "Timer0õжϹ!"

    #elif ((Timer0_Reload/12) < 65536UL)    // ûֵʣ ʱ
        ET0 = 1;    //ж
    //  PT0 = 1;    //ȼж
        TMOD &= ~0x03;
        TMOD |= 0;  //ģʽ, 0: 16λԶװ, 1: 16λʱ/, 2: 8λԶװ, 3: 16λԶװ, ж
    //  T0_CT = 1;  //
        T0_CT = 0;  //ʱ
    //  T0CLKO = 1; //ʱ
        T0CLKO = 0; //ʱ

        #if (Timer0_Reload < 65536UL)
            T0x12 = 1;  //1T mode
            TH0 = (u8)((65536UL - Timer0_Reload) / 256);
            TL0 = (u8)((65536UL - Timer0_Reload) % 256);
        #else
            T0x12 = 0;  //12T mode
            TH0 = (u8)((65536UL - Timer0_Reload/12) / 256);
            TL0 = (u8)((65536UL - Timer0_Reload/12) % 256);
        #endif

        TR0 = 1;    //ʼ

    #else
        #error "Timer0õжϹ!"
    #endif
}

//========================================================================
// : void Timer1_init(void)
// : timer1ʼ.
// : none.
// : none.
// 汾: V1.0, 2015-1-12
//========================================================================
void Timer1_init(void)
{
        TR1 = 0;    //ֹͣ

    #if (Timer1_Reload < 64)    // ûֵʣ ʱ
        #error "Timer1õжϹ!"

    #elif ((Timer1_Reload/12) < 65536UL)    // ûֵʣ ʱ
        ET1 = 1;    //ж
    //  PT1 = 1;    //ȼж
        TMOD &= ~0x30;
        TMOD |= (0 << 4);   //ģʽ, 0: 16λԶװ, 1: 16λʱ/, 2: 8λԶװ
    //  T1_CT = 1;  //
        T1_CT = 0;  //ʱ
    //  T1CLKO = 1; //ʱ
        T1CLKO = 0; //ʱ

        #if (Timer1_Reload < 65536UL)
            T1x12 = 1;  //1T mode
            TH1 = (u8)((65536UL - Timer1_Reload) / 256);
            TL1 = (u8)((65536UL - Timer1_Reload) % 256);
        #else
            T1x12 = 0;  //12T mode
            TH1 = (u8)((65536UL - Timer1_Reload/12) / 256);
            TL1 = (u8)((65536UL - Timer1_Reload/12) % 256);
        #endif

        TR1 = 1;    //ʼ

    #else
        #error "Timer1õжϹ!"
    #endif
}

//========================================================================
// : void Timer2_init(void)
// : timer2ʼ.
// : none.
// : none.
// 汾: V1.0, 2015-1-12
//========================================================================
void Timer2_init(void)
{
        T2R = 0;    //ֹͣ

    #if (Timer2_Reload < 64)    // ûֵʣ ʱ
        #error "Timer2õжϹ!"

    #elif ((Timer2_Reload/12) < 65536UL)    // ûֵʣ ʱ
        ET2 = 1;    //ж
    //  T2_CT = 1;  //
        T2_CT = 0;  //ʱ
    //  T2CLKO = 1; //ʱ
        T2CLKO = 0; //ʱ

        #if (Timer2_Reload < 65536UL)
            T2x12 = 1;    //1T mode
            T2H = (u8)((65536UL - Timer2_Reload) / 256);
            T2L = (u8)((65536UL - Timer2_Reload) % 256);
        #else
            T2x12 = 0;    //12T mode
            T2H = (u8)((65536UL - Timer2_Reload/12) / 256);
            T2L = (u8)((65536UL - Timer2_Reload/12) % 256);
        #endif

        T2R = 1;    //ʼ

    #else
        #error "Timer2õжϹ!"
    #endif
}

//========================================================================
// : void Timer3_init(void)
// : timer3ʼ.
// : none.
// : none.
// 汾: V1.0, 2015-1-12
//========================================================================
void Timer3_init(void)
{
        T3R = 0;    //ֹͣ

    #if (Timer3_Reload < 64)    // ûֵʣ ʱ
        #error "Timer3õжϹ!"

    #elif ((Timer3_Reload/12) < 65536UL)    // ûֵʣ ʱ
        ET3 = 1;    //ж
    //  T3_CT = 1;  //
        T3_CT = 0;  //ʱ
    //  T3CLKO = 1; //ʱ
        T3CLKO = 0; //ʱ

        #if (Timer3_Reload < 65536UL)
            T3x12 = 1;    //1T mode
            T3H = (u8)((65536UL - Timer3_Reload) / 256);
            T3L = (u8)((65536UL - Timer3_Reload) % 256);
        #else
            T3x12 = 0;    //12T mode
            T3H = (u8)((65536UL - Timer3_Reload/12) / 256);
            T3L = (u8)((65536UL - Timer3_Reload/12) % 256);
        #endif

        T3R = 1;    //ʼ

    #else
        #error "Timer3õжϹ!"
    #endif
}

//========================================================================
// : void Timer4_init(void)
// : timer4ʼ.
// : none.
// : none.
// 汾: V1.0, 2015-1-12
//========================================================================
void Timer4_init(void)
{
        T4R = 0;    //ֹͣ

    #if (Timer4_Reload < 64)    // ûֵʣ ʱ
        #error "Timer4õжϹ!"

    #elif ((Timer4_Reload/12) < 65536UL)    // ûֵʣ ʱ
        ET4 = 1;    //ж
    //  T4_CT = 1;  //
        T4_CT = 0;  //ʱ
    //  T4CLKO = 1; //ʱ
        T4CLKO = 0; //ʱ

        #if (Timer4_Reload < 65536UL)
            T4x12 = 1;    //1T mode
            T4H = (u8)((65536UL - Timer4_Reload) / 256);
            T4L = (u8)((65536UL - Timer4_Reload) % 256);
        #else
            T4x12 = 0;    //12T mode
            T4H = (u8)((65536UL - Timer4_Reload/12) / 256);
            T4L = (u8)((65536UL - Timer4_Reload/12) % 256);
        #endif

        T4R = 1;    //ʼ

    #else
        #error "Timer4õжϹ!"
    #endif
}

//========================================================================
// : void timer0_int (void) interrupt TIMER0_VECTOR
// :  timer0жϺ.
// : none.
// : none.
// 汾: V1.0, 2015-1-12
//========================================================================
void timer0_int (void) interrupt 1
{
   P67 = ~P67;
}

//========================================================================
// : void timer1_int (void) interrupt TIMER1_VECTOR
// :  timer1жϺ.
// : none.
// : none.
// 汾: V1.0, 2015-1-12
//========================================================================
void timer1_int (void) interrupt 3
{
   P66 = ~P66;
}

//========================================================================
// : void timer2_int (void) interrupt TIMER2_VECTOR
// :  timer2жϺ.
// : none.
// : none.
// 汾: V1.0, 2015-1-12
//========================================================================
void timer2_int (void) interrupt 12
{
    P65 = ~P65;
}

//========================================================================
// : void timer3_int (void) interrupt TIMER3_VECTOR
// :  timer3жϺ.
// : none.
// : none.
// 汾: V1.0, 2015-1-12
//========================================================================
void timer3_int(void) interrupt 19
{
    P64 = ~P64;
}

//========================================================================
// : void timer4_int (void) interrupt TIMER4_VECTOR
// :  timer4жϺ.
// : none.
// : none.
// 汾: V1.0, 2015-1-12
//========================================================================
void timer4_int(void) interrupt 20
{
    P63 = ~P63;
}
