;/*---------------------------------------------------------------------*/
;/* --- STC MCU Limited ------------------------------------------------*/
;/* --- STC 1T Series MCU Demo Programme -------------------------------*/
;/* --- Mobile: (86)13922805190 ----------------------------------------*/
;/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
;/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
;/* --- Web: www.STCAI.com ---------------------------------------------*/
;/* --- BBS: www.STCAIMCU.com ------------------------------------------*/
;/* --- QQ:  800003751 -------------------------------------------------*/
;/* Ҫڳʹô˴,ڳעʹSTCϼ        */
;/*---------------------------------------------------------------------*/


;*************  ˵    **************

; ̻STC32GΪоƬʵбдԡ

; ʹKeil C251Memory ModelƼXSmallģʽĬ϶edataʱӴȡٶȿ졣

; edata鱣1Kջʹãռ䲻ʱɽ顢ñxdataؼֶ嵽xdataռ䡣

; ʾ5ʱʹ, ̾ʹ16λԶװ.

; ʱ, ѡʱ 24MHZ (û޸Ƶ).

; ʱ016λԶװ, жƵΪ1000HZжϺP6.7ȡ500HZź.

; ʱ116λԶװ, жƵΪ2000HZжϺP6.6ȡ1000HZź.

; ʱ216λԶװ, жƵΪ3000HZжϺP6.5ȡ1500HZź.

; ʱ316λԶװ, жƵΪ4000HZжϺP6.4ȡ2000HZź.

; ʱ416λԶװ, жƵΪ5000HZжϺP6.3ȡ2500HZź.

;******************************************/

$include (../../comm/STC32G.INC)

;/****************************** û ***********************************/
Fosc_KHZ    EQU 24000   ;24000KHZ

STACK_POIRTER   EQU     0D0H    ;ջʼַ

;*******************************************************************
;*******************************************************************
        ORG     0000H               ;λڣԶ嵽 0FF0000H ַ
        LJMP    F_Main

        ORG     000BH               ;1  Timer0 interrupt
        LJMP    F_Timer0_Interrupt

        ORG     001BH               ;3  Timer1 interrupt
        LJMP    F_Timer1_Interrupt

        ORG     0063H               ;12  Timer2 interrupt
        LJMP    F_Timer2_Interrupt

        ORG     009BH               ;19  Timer3 interrupt
        LJMP    F_Timer3_Interrupt

        ORG     00A3H               ;20  Timer4 interrupt
        LJMP    F_Timer4_Interrupt

;*******************************************************************
;*******************************************************************


;********************  **************************/
        ORG     0100H      ;Զ嵽 0FF0100H ַ
F_Main:
    MOV     WTST, #00H     ;óָʱֵΪ0ɽCPUִָٶΪ
    MOV     CKCON,#00H     ;߷XRAMٶ
    ORL     P_SW2,#080H    ;ʹܷXFR

    MOV     P0M1, #30H     ;P0.4P0.5Ϊ©·(ʵ赽3.3V)
    MOV     P0M0, #30H
    MOV     P1M1, #30H     ;P1.4P1.5Ϊ©·(ʵ赽3.3V)
    MOV     P1M0, #30H
    MOV     P2M1, #3cH     ;P2.2~P2.5Ϊ©·(ʵ赽3.3V)
    MOV     P2M0, #3cH
    MOV     P3M1, #50H     ;P3.4P3.6Ϊ©·(ʵ赽3.3V)
    MOV     P3M0, #50H
    MOV     P4M1, #3cH     ;P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    MOV     P4M0, #3cH
    MOV     P5M1, #0cH     ;P5.2P5.3Ϊ©·(ʵ赽3.3V)
    MOV     P5M0, #0cH
    MOV     P6M1, #0ffH    ;Ϊ©·(ʵ赽3.3V)
    MOV     P6M0, #0ffH
    MOV     P7M1, #00H     ;Ϊ׼˫
    MOV     P7M0, #00H

    
    MOV     SP, #STACK_POIRTER
    MOV     PSW, #0
    USING   0       ;ѡ0R0~R7

;================= ûʼ ====================================

    LCALL   F_Timer0_init
    LCALL   F_Timer1_init
    LCALL   F_Timer2_init
    LCALL   F_Timer3_init
    LCALL   F_Timer4_init
    SETB    EA
    
    CLR     P4.0        ;LED Power On

;=================== ѭ ==================================
L_Main_Loop:

    LJMP    L_Main_Loop

;**********************************************/

;========================================================================
; : F_Timer0_init
; : timer0ʼ.
; : none.
; : none.
; 汾: V1.0, 2015-1-12
;========================================================================
F_Timer0_init:
    CLR     TR0 ; ֹͣ
    SETB    ET0 ; ж
;   SETB    PT0 ; ȼж
    ANL     TMOD, #NOT 0x03     ;
    ORL     TMOD, #0            ; ģʽ, 0: 16λԶװ, 1: 16λʱ/, 2: 8λԶװ, 3: 16λԶװ, ж
;   ORL     TMOD, #0x04         ; Ƶ
    ANL     TMOD, #NOT 0x04     ; ʱ
;   ORL     INTCLKO, #0x01      ; ʱ
    ANL     INTCLKO, #NOT 0x01  ; ʱ

;   ANL     AUXR, #NOT 0x80     ; 12T mode
    ORL     AUXR, #0x80         ; 1T mode
    MOV     TH0, #HIGH (-Fosc_KHZ) ; - 24000000 / 1000
    MOV     TL0, #LOW  (-Fosc_KHZ) ;
    SETB    TR0 ; ʼ
    RET


;========================================================================
; : F_Timer1_init
; : timer1ʼ.
; : none.
; : none.
; 汾: V1.0, 2015-1-12
;========================================================================
F_Timer1_init:
    CLR     TR1 ; ֹͣ
    SETB    ET1 ; ж
;   SETB    PT1 ; ȼж
    ANL     TMOD, #NOT 0x30     ;
    ORL     TMOD, #(0 SHL 4)    ; ģʽ, 0: 16λԶװ, 1: 16λʱ/, 2: 8λԶװ, 3: 16λԶװ, ж
;   ORL     TMOD, #0x40         ; Ƶ
    ANL     TMOD, #NOT 0x40     ; ʱ
;   ORL     INTCLKO, #0x02      ; ʱ
    ANL     INTCLKO, #NOT 0x02  ; ʱ

;   ANL     AUXR, #NOT 0x40     ; 12T mode
    ORL     AUXR, #0x40         ; 1T mode
    MOV     TH1, #HIGH (-(Fosc_KHZ / 2)) ; - 24000000 / 2000
    MOV     TL1, #LOW  (-(Fosc_KHZ / 2)) ;
    SETB    TR1 ; ʼ
    RET

;========================================================================
; : F_Timer2_init
; : timer2ʼ.
; : none.
; : none.
; 汾: V1.0, 2015-1-12
;========================================================================
F_Timer2_init:
    ANL     AUXR, #NOT 0x1c     ; ֹͣ, ʱģʽ, 12Tģʽ

;   ANL     IE2, #NOT (1 SHL 2) ; ֹж
    ORL     IE2, #(1 SHL 2)     ; ж
;   ORL     INTCLKO, #0x04      ; ʱ
    ANL     INTCLKO, #NOT 0x04  ; ʱ

;   ORL     AUXR, #(1 SHL 3)    ; Ƶ
;   ORL     INTCLKO, #0x02      ; ʱ
    ANL     INTCLKO, #NOT 0x02  ; ʱ

    ORL     AUXR, #(1 SHL 2)    ; 1T mode
    MOV     T2H, #HIGH (-(Fosc_KHZ / 3))  ; - 24000000 / 3000
    MOV     T2L, #LOW  (-(Fosc_KHZ / 3))  ;

    ORL     AUXR, #(1 SHL 4)    ; ʼ
    RET

;========================================================================
; : F_Timer3_init
; : timer3ʼ.
; : none.
; : none.
; 汾: V1.0, 2015-1-12
;========================================================================
F_Timer3_init:
    ANL     T4T3M, #NOT 0x0F    ; ֹͣ, ʱģʽ, 12Tģʽ

;   ANL     IE2, #NOT (1 SHL 5) ; ֹж
    ORL     IE2, #(1 SHL 5)     ; ж
;   ORL     T4T3M, #0x01        ; ʱ
    ANL     T4T3M, #NOT 0x01    ; ʱ

;   ORL     T4T3M, #(1 SHL 2)   ; Ƶ
;   ORL     INTCLKO, #0x02      ; ʱ
    ANL     INTCLKO, #NOT 0x02  ; ʱ

    ORL     T4T3M, #(1 SHL 1)   ; 1T mode
    MOV     T3H, #HIGH (-(Fosc_KHZ / 4))  ; - 24000000 / 4000
    MOV     T3L, #LOW  (-(Fosc_KHZ / 4))  ;

    ORL     T4T3M, #(1 SHL 3)   ; ʼ
    RET

;========================================================================
; : F_Timer4_init
; : timer4ʼ.
; : none.
; : none.
; 汾: V1.0, 2015-1-12
;========================================================================
F_Timer4_init:
    ANL     T4T3M, #NOT 0xF0    ; ֹͣ, ʱģʽ, 12Tģʽ

;   ANL     IE2, #NOT (1 SHL 6) ; ֹж
    ORL     IE2, #(1 SHL 6)     ; ж
;   ORL     T4T3M, #0x10        ; ʱ
    ANL     T4T3M, #NOT 0x10    ; ʱ

;   ORL     T4T3M, #(1 SHL 6)   ; Ƶ
;   ORL     INTCLKO, #0x02      ; ʱ
    ANL     INTCLKO, #NOT 0x02  ; ʱ

    ORL     T4T3M, #(1 SHL 5)   ; 1T mode
    MOV     T4H, #HIGH (-(Fosc_KHZ / 5))  ; - 24000000 / 5000
    MOV     T4L, #LOW  (-(Fosc_KHZ / 5))  ;

    ORL     T4T3M, #(1 SHL 7)   ; ʼ
    RET


;**************** жϺ ***************************************************
F_Timer0_Interrupt: ;Timer0 жϺ
    PUSH    PSW     ;PSWջ
    PUSH    ACC     ;ACCջ

    CPL     P6.7

    POP     ACC     ;ACCջ
    POP     PSW     ;PSWջ
    RETI
    
F_Timer1_Interrupt: ;Timer1 жϺ
    PUSH    PSW     ;PSWջ
    PUSH    ACC     ;ACCջ

    CPL     P6.6

    POP     ACC     ;ACCջ
    POP     PSW     ;PSWջ
    RETI
    
F_Timer2_Interrupt: ;Timer2 жϺ
    PUSH    PSW     ;PSWջ
    PUSH    ACC     ;ACCջ

    CPL     P6.5

    POP     ACC     ;ACCջ
    POP     PSW     ;PSWջ
    RETI
    
F_Timer3_Interrupt: ;Timer3 жϺ
    PUSH    PSW     ;PSWջ
    PUSH    ACC     ;ACCջ

    CPL     P6.4

    POP     ACC     ;ACCջ
    POP     PSW     ;PSWջ
    RETI
    
F_Timer4_Interrupt: ;Timer4 жϺ
    PUSH    PSW     ;PSWջ
    PUSH    ACC     ;ACCջ

    CPL     P6.3

    POP     ACC     ;ACCջ
    POP     PSW     ;PSWջ
    RETI
    


    END

