;/*---------------------------------------------------------------------*/
;/* --- STC MCU Limited ------------------------------------------------*/
;/* --- STC 1T Series MCU Demo Programme -------------------------------*/
;/* --- Mobile: (86)13922805190 ----------------------------------------*/
;/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
;/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
;/* --- Web: www.STCAI.com ---------------------------------------------*/
;/* --- BBS: www.STCAIMCU.com ------------------------------------------*/
;/* --- QQ:  800003751 -------------------------------------------------*/
;/* Ҫڳʹô˴,ڳעʹSTCϼ        */
;/*---------------------------------------------------------------------*/


;*************  ˵    **************

;̻STC32GΪоƬʵбдԡ

;ʹKeil C251Memory ModelƼXSmallģʽĬ϶edataʱӴȡٶȿ졣

;edata鱣1Kջʹãռ䲻ʱɽ顢ñxdataؼֶ嵽xdataռ䡣

;STCMCUIOʽ8λܡ

;ʾЧΪ: ΪT0(SW21)ⲿжϼ, ұΪT1(SW22)ⲿжϼ, ΧΪ0~255.

;ڰǻе, ж, ûȥ, ԰һжҲ.

;ʱ, ѡʱ 24MHZ (û޸Ƶ).

;******************************************

$include (../../comm/STC32G.INC)

;****************************** û ***********************************/

Fosc_KHZ    EQU 24000   ;24000KHZ

STACK_POIRTER   EQU     0D0H    ;ջʼַ

DIS_DOT         EQU     020H
DIS_BLACK       EQU     010H
DIS_            EQU     011H

;*******************************************************************
;*******************************************************************


;*************  IOڶ    **************/


;*************  ر    **************/
LED8            DATA    30H     ; ʾ 30H ~ 37H
display_index   DATA    38H     ; ʾλ

T0_cnt        DATA    39H     ; õļ
T1_cnt        DATA    3AH     ;


;*******************************************************************
;*******************************************************************
        ORG     0000H               ;λڣԶ嵽 0FF0000H ַ
        LJMP    F_Main

        ORG     000BH               ;1  Timer0 interrupt
        LJMP    F_Timer0_Interrupt

        ORG     001BH               ;3  Timer1 interrupt
        LJMP    F_Timer1_Interrupt


;*******************************************************************
;*******************************************************************


;********************  **************************/
        ORG     0100H       ;Զ嵽 0FF0100H ַ
F_Main:
    MOV     WTST, #00H     ;óָʱֵΪ0ɽCPUִָٶΪ
    MOV     CKCON,#00H     ;߷XRAMٶ
    ORL     P_SW2,#080H    ;ʹܷXFR

    MOV     P0M1, #30H     ;P0.4P0.5Ϊ©·(ʵ赽3.3V)
    MOV     P0M0, #30H
    MOV     P1M1, #30H     ;P1.4P1.5Ϊ©·(ʵ赽3.3V)
    MOV     P1M0, #30H
    MOV     P2M1, #3cH     ;P2.2~P2.5Ϊ©·(ʵ赽3.3V)
    MOV     P2M0, #3cH
    MOV     P3M1, #70H     ;P3.6Ϊ©·(ʵ赽3.3V), P3.4,P3.5Ϊ
    MOV     P3M0, #40H
    MOV     P4M1, #3cH     ;P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    MOV     P4M0, #3cH
    MOV     P5M1, #0cH     ;P5.2P5.3Ϊ©·(ʵ赽3.3V)
    MOV     P5M0, #0cH
    MOV     P6M1, #0ffH    ;Ϊ©·(ʵ赽3.3V)
    MOV     P6M0, #0ffH
    MOV     P7M1, #00H     ;Ϊ׼˫
    MOV     P7M0, #00H

	MOV     A, #020H         ; P3.5ʹڲ4.1K
	MOV     WR6, #WORD0 P3PU
	MOV     WR4, #WORD2 P3PU
	MOV     @DR4, R11

    MOV     SP, #STACK_POIRTER
    MOV     PSW, #0
    USING   0       ;ѡ0R0~R7

;================= ûʼ ====================================

    MOV     display_index, #0
    MOV     R0, #LED8
    MOV     R2, #8
L_ClearLoop:
    MOV     @R0, #DIS_BLACK     ; ϵ
    INC     R0
    DJNZ    R2, L_ClearLoop

    CLR     A
	MOV     TMOD,A
    ORL     TMOD, #(1 SHL 2)    ; ʹT0ⲿģʽ
    ORL     TMOD, #(1 SHL 6)    ; ʹT1ⲿģʽ
    MOV     TH0, #0FFH
    MOV     TL0, #0FFH
    MOV     TH1, #0FFH
    MOV     TL1, #0FFH
    SETB    TR0 ; ʱT0
    SETB    TR1 ; ʱT1
    SETB    ET0 ; ʹܶʱжT0
    SETB    ET1 ; ʹܶʱжT1

    ANL     INTCLKO, #NOT 03H ; T0,T1ʱ

    SETB    EA      ;ж

;=================== ѭ ==================================
L_MainLoop:
    MOV     A, #1           ;ʱ1ms
    LCALL   F_delay_ms  
    LCALL   F_DisplayScan
    LJMP    L_MainLoop

;**********************************************/


;========================================================================
; : F_delay_ms
; : ʱӳ
; : ACC: ʱms.
; : none.
; 汾: VER1.0
; : 2013-4-1
; ע: ACCCPSW, õͨüĴջ
;========================================================================
F_delay_ms:
    PUSH    02H     ;ջR2
    PUSH    03H     ;ջR3
    PUSH    04H     ;ջR4

    MOV     R4,A
L_delay_ms_1:
    MOV     WR2, #(Fosc_KHZ / 4)
L_delay_ms_2:
    DEC     WR2, #1         ;1T
    JNE     L_delay_ms_2    ;3T
    DJNZ    R4, L_delay_ms_1

    POP     04H     ;ջR2
    POP     03H     ;ջR3
    POP     02H     ;ջR4
    RET



; *********************** ʾس ****************************************
T_Display:                      ;׼ֿ
;    0    1    2    3    4    5    6    7    8    9    A    B    C    D    E    F
DB  03FH,006H,05BH,04FH,066H,06DH,07DH,007H,07FH,06FH,077H,07CH,039H,05EH,079H,071H
;  black  -    H    J    K    L    N    o    P    U    t    G    Q    r    M    y
DB  000H,040H,076H,01EH,070H,038H,037H,05CH,073H,03EH,078H,03dH,067H,050H,037H,06EH
;    0.   1.   2.   3.   4.   5.   6.   7.   8.   9.   -1
DB  0BFH,086H,0DBH,0CFH,0E6H,0EDH,0FDH,087H,0FFH,0EFH,046H

T_COM:
DB  001H,002H,004H,008H,010H,020H,040H,080H     ;   λ


;========================================================================
; : F_DisplayScan
; : ʾɨӳ
; : none.
; : none.
; 汾: VER1.0
; : 2020-11-4
; ע: ACCCPSW, õͨüĴջ
;========================================================================
F_DisplayScan:
    PUSH    DPH     ;DPHջ
    PUSH    DPL     ;DPLջ
    PUSH    00H     ;R0 ջ
    
    MOV     DPTR, #T_COM
    MOV     A, display_index
    MOVC    A, @A+DPTR
    CPL     A
	MOV     P7,A
    
    MOV     DPTR, #T_Display
    MOV     A, display_index
    ADD     A, #LED8
    MOV     R0, A
    MOV     A, @R0
    MOVC    A, @A+DPTR
    CPL     A
	MOV     P6,A

    INC     display_index
    MOV     A, display_index
    ANL     A, #0F8H            ; if(display_index >= 8)
    JZ      L_QuitDisplayScan
    MOV     display_index, #0;  ;8λ0
    
    MOV     A, T0_cnt
    MOV     B, #100
    DIV     AB
    MOV     LED8+7, A
    MOV     A, #10
    XCH     A, B
    DIV     AB
    MOV     LED8+6, A
    MOV     LED8+5, B
    MOV     LED8+4, #DIS_BLACK;

    MOV     LED8+3, #DIS_BLACK;
    MOV     A, T1_cnt
    MOV     B, #100
    DIV     AB
    MOV     LED8+2, A
    MOV     A, #10
    XCH     A, B
    DIV     AB
    MOV     LED8+1, A
    MOV     LED8+0, B
L_QuitDisplayScan:
    POP     00H     ;R0 ջ
    POP     DPL     ;DPLջ
    POP     DPH     ;DPHջ
    RET


;========================================================================
; : F_Timer0_Interrupt
; : Timer0жϺ.
; : none.
; : none.
; 汾: VER1.0
; : 2020-11-4
; ע: õͨüĴջ, ˳ʱָԭݲı.
;========================================================================
F_Timer0_Interrupt:
    INC     T0_cnt    ; ж+1
    RETI
    
;========================================================================
; : F_Timer1_Interrupt
; : Timer1жϺ.
; : none.
; : none.
; 汾: VER1.0
; : 2020-11-4
; ע: õͨüĴջ, ˳ʱָԭݲı.
;========================================================================
F_Timer1_Interrupt:
    INC     T1_cnt    ; ж+1
    RETI


    END

