;/*---------------------------------------------------------------------*/
;/* --- STC MCU Limited ------------------------------------------------*/
;/* --- STC 1T Series MCU Demo Programme -------------------------------*/
;/* --- Mobile: (86)13922805190 ----------------------------------------*/
;/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
;/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
;/* --- Web: www.STCAI.com ---------------------------------------------*/
;/* --- BBS: www.STCAIMCU.com ------------------------------------------*/
;/* --- QQ:  800003751 -------------------------------------------------*/
;/* Ҫڳʹô˴,ڳעʹSTCϼ        */
;/*---------------------------------------------------------------------*/


;*************  ˵    **************

; ̻STC32GΪоƬʵбдԡ

; ʹKeil C251Memory ModelƼXSmallģʽĬ϶edataʱӴȡٶȿ졣

; edata鱣1Kջʹãռ䲻ʱɽ顢ñxdataؼֶ嵽xdataռ䡣

; ʱ016λԶװ, жƵΪ1000HZΪɨʾ.

; ʱ116λԶװ, жƵΪ10000HZΪźſȼ.

; STCMCUIOʽ8λܡ

; P33ڲ͵ƽ(ûԶ޸Ķ˿ڸƽ)ʱмʱƽ仯ֹͣʱ

; ʾźſȣλ0.1msΧ0.1ms~6553.5ms.

; ʱ, ѡʱ 24MHZ (û޸Ƶ).

;******************************************/

$include (../../comm/STC32G.INC)

;/****************************** û ***********************************/


Fosc_KHZ    EQU 24000   ;24000KHZ

STACK_POIRTER   EQU     0D0H    ;ջʼַ

DIS_DOT         EQU     020H
DIS_BLACK       EQU     010H
DIS_            EQU     011H

;*******************************************************************
;*******************************************************************

;*************  ر    **************/
Flag0           DATA    20H
B_1ms           BIT     Flag0.0 ; 1ms־

LED8            DATA    30H     ; ʾ 30H ~ 37H
display_index   DATA    38H     ; ʾλ

Test_cnt        DATA    39H     ; ʾõļ
Temp_cnt        DATA    3BH     ; õļ
msecond         DATA    3DH     ;

;*******************************************************************
;*******************************************************************
        ORG     0000H               ;λڣԶ嵽 0FF0000H ַ
        LJMP    F_Main

        ORG     000BH               ;1  Timer0 interrupt
        LJMP    F_Timer0_Interrupt

        ORG     001BH               ;3  Timer1 interrupt
        LJMP    F_Timer1_Interrupt

;*******************************************************************
;*******************************************************************


;********************  **************************/
        ORG     0100H       ;Զ嵽 0FF0100H ַ
F_Main:
    MOV     WTST, #00H     ;óָʱֵΪ0ɽCPUִָٶΪ
    MOV     CKCON,#00H     ;߷XRAMٶ
    ORL     P_SW2,#080H    ;ʹܷXFR

    MOV     P0M1, #30H     ;P0.4P0.5Ϊ©·(ʵ赽3.3V)
    MOV     P0M0, #30H
    MOV     P1M1, #30H     ;P1.4P1.5Ϊ©·(ʵ赽3.3V)
    MOV     P1M0, #30H
    MOV     P2M1, #3cH     ;P2.2~P2.5Ϊ©·(ʵ赽3.3V)
    MOV     P2M0, #3cH
    MOV     P3M1, #50H     ;P3.4P3.6Ϊ©·(ʵ赽3.3V)
    MOV     P3M0, #50H
    MOV     P4M1, #3cH     ;P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    MOV     P4M0, #3cH
    MOV     P5M1, #0cH     ;P5.2P5.3Ϊ©·(ʵ赽3.3V)
    MOV     P5M0, #0cH
    MOV     P6M1, #0ffH    ;Ϊ©·(ʵ赽3.3V)
    MOV     P6M0, #0ffH
    MOV     P7M1, #00H     ;Ϊ׼˫
    MOV     P7M0, #00H

    
    MOV     SP, #STACK_POIRTER
    MOV     PSW, #0
    USING   0       ;ѡ0R0~R7

;================= ûʼ ====================================

    MOV     WR6, #0
    MOV     Test_cnt, WR6
    MOV     Temp_cnt, WR6
    MOV     display_index, #0
    MOV     R0, #LED8
    MOV     R2, #8
L_ClearLoop:
    MOV     @R0, #DIS_BLACK     ;ϵ
    INC     R0
    DJNZ    R2, L_ClearLoop
    
    LCALL   F_Timer0_init
    LCALL   F_Timer1_init
    SETB    EA
    
;=================== ѭ ==================================
L_Main_Loop:
    JNB     B_1ms,  L_Main_Loop     ;1msδ
    CLR     B_1ms

    MOV     WR6, msecond
    INC     WR6, #1         ;msecond + 1
    MOV     msecond, WR6
    CMP     WR6, #1000
    JC      L_Main_Loop     ;if(msecond < 1000), jmp
    MOV     WR6, #0
    MOV     msecond, WR6    ;msecond = 0

    LCALL   F_Display
    LJMP    L_Main_Loop

;**********************************************/

;========================================================================
; : F_Timer0_init
; : timer0ʼ.
; : none.
; : none.
; 汾: V1.0, 2015-1-12
;========================================================================
F_Timer0_init:
    CLR     TR0 ; ֹͣ
    SETB    ET0 ; ж
;   SETB    PT0 ; ȼж
    ANL     TMOD, #NOT 0x03     ;
    ORL     TMOD, #0            ; ģʽ, 0: 16λԶװ, 1: 16λʱ/, 2: 8λԶװ, 3: 16λԶװ, ж
;   ORL     TMOD, #0x04         ; Ƶ
    ANL     TMOD, #NOT 0x04     ; ʱ
;   ORL     INTCLKO, #0x01      ; ʱ
    ANL     INTCLKO, #NOT 0x01  ; ʱ

;   ANL     AUXR, #NOT 0x80     ; 12T mode
    ORL     AUXR, #0x80         ; 1T mode
    MOV     TH0, #HIGH (-Fosc_KHZ) ; - 24000000 / 1000
    MOV     TL0, #LOW  (-Fosc_KHZ) ;
    SETB    TR0 ; ʼ
    RET


;========================================================================
; : F_Timer1_init
; : timer1ʼ.
; : none.
; : none.
; 汾: V1.0, 2015-1-12
;========================================================================
F_Timer1_init:
    CLR     TR1 ; ֹͣ
    SETB    ET1 ; ж
;   SETB    PT1 ; ȼж
    ANL     TMOD, #NOT 0x30     ;
    ORL     TMOD, #(0 SHL 4)    ; ģʽ, 0: 16λԶװ, 1: 16λʱ/, 2: 8λԶװ, 3: 16λԶװ, ж
;   ORL     TMOD, #0x40         ; Ƶ
    ANL     TMOD, #NOT 0x40     ; ʱ
;   ORL     INTCLKO, #0x02      ; ʱ
    ANL     INTCLKO, #NOT 0x02  ; ʱ

;   ANL     AUXR, #NOT 0x40     ; 12T mode
    ORL     AUXR, #0x40         ; 1T mode
    MOV     TH1, #HIGH (-(Fosc_KHZ / 10)) ; - 24000000 / 10000
    MOV     TL1, #LOW  (-(Fosc_KHZ / 10)) ;
    SETB    TR1 ; ʼ
    RET


;**************** жϺ ***************************************************
F_Timer0_Interrupt: ;Timer0 жϺ
    PUSH    PSW     ;PSWջ
    PUSH    ACC     ;ACCջ

    LCALL   F_DisplayScan   ; 1msɨʾһλ
    SETB    B_1ms           ; 1ms־

    POP     ACC     ;ACCջ
    POP     PSW     ;PSWջ
    RETI
    
F_Timer1_Interrupt: ;Timer1 жϺ
    PUSH    PSW     ;PSWջ
    PUSH    ACC     ;ACCջ
    PUSH    R0      ;R0ջ
    PUSH    R1      ;R1ջ

    JB      P3.3, F_Timer1_Next

    MOV     WR0, Temp_cnt
    INC     WR0, #1         ;Temp_cnt + 1
    MOV     Temp_cnt, WR0
    LJMP    F_Timer1_Exit

F_Timer1_Next:
    MOV     WR0, Temp_cnt
    CMP     WR0, #10
    JC      F_Timer1_Clear  ;if(Temp_cnt < 10), jmp
    MOV     WR0, Temp_cnt
    MOV     Test_cnt, WR0

F_Timer1_Clear:
    MOV     WR0, #0
    MOV     Temp_cnt, WR0   ;Temp_cnt = 0

F_Timer1_Exit:
    POP     R1      ;R1ջ
    POP     R0      ;R0ջ
    POP     ACC     ;ACCջ
    POP     PSW     ;PSWջ
    RETI

; *********************** ʾس ****************************************
T_Display:                      ;׼ֿ
;    0    1    2    3    4    5    6    7    8    9    A    B    C    D    E    F
DB  03FH,006H,05BH,04FH,066H,06DH,07DH,007H,07FH,06FH,077H,07CH,039H,05EH,079H,071H
;  black  -    H    J    K    L    N    o    P    U    t    G    Q    r    M    y
DB  000H,040H,076H,01EH,070H,038H,037H,05CH,073H,03EH,078H,03dH,067H,050H,037H,06EH
;    0.   1.   2.   3.   4.   5.   6.   7.   8.   9.   -1
DB  0BFH,086H,0DBH,0CFH,0E6H,0EDH,0FDH,087H,0FFH,0EFH,046H

T_COM:
DB  001H,002H,004H,008H,010H,020H,040H,080H     ;   λ


;========================================================================
; : F_DisplayScan
; : ʾɨӳ
; : none.
; : none.
; 汾: VER1.0
; : 2013-4-1
; ע: ACCCPSW, õͨüĴջ
;========================================================================
F_DisplayScan:
    PUSH    DPH     ;DPHջ
    PUSH    DPL     ;DPLջ
    PUSH    00H     ;R0 ջ
    
    MOV     DPTR, #T_COM
    MOV     A, display_index
    MOVC    A, @A+DPTR
    CPL     A
	MOV     P7,A
    
    MOV     DPTR, #T_Display
    MOV     A, display_index
    ADD     A, #LED8
    MOV     R0, A
    MOV     A, @R0
    MOVC    A, @A+DPTR
    CPL     A
	MOV     P6,A

    INC     display_index
    MOV     A, display_index
    ANL     A, #0F8H            ; if(display_index >= 8)
    JZ      L_QuitDisplayScan
    MOV     display_index, #0;  ;8λ0
L_QuitDisplayScan:
    POP     00H     ;R0 ջ
    POP     DPL     ;DPLջ
    POP     DPH     ;DPHջ
    RET

;========================================================================
; : F_Display
; : ʾ.
; : none.
; : none.
; 汾: V1.0, 2021-3-1
;========================================================================
F_Display:
    MOV     WR4, #00000H    ;
    MOV     WR6, Test_cnt
    MOV     WR0, #00000H    ;
    MOV     WR2, #10000
    MOV     DMAIR, #04H     ;32λ޷ų
    MOV     A, R7           ;ʾֵ
    ANL     A, #0x0F
    MOV     LED8+4, A

    MOV     WR4, WR0        ;
    MOV     WR6, WR2
    MOV     WR0, #00000H
    MOV     WR2, #1000
    MOV     DMAIR, #04H     ;32λ޷ų
    MOV     A, R7           ;ʾֵ
    ANL     A, #0x0F
    MOV     LED8+3, A

    MOV     WR4, WR0        ;
    MOV     WR6, WR2
    MOV     WR0, #00000H
    MOV     WR2, #100
    MOV     DMAIR, #04H     ;32λ޷ų
    MOV     A, R7           ;ʾֵ
    ANL     A, #0x0F
    MOV     LED8+2, A

    MOV     WR4, WR0        ;
    MOV     WR6, WR2
    MOV     WR0, #00000H
    MOV     WR2, #10
    MOV     DMAIR, #04H     ;32λ޷ų
    MOV     A, R7           ;ʾֵ
    ANL     A, #0x0F
    MOV     LED8+1, A

    MOV     A, R3           ;ʾֵ
    ANL     A, #0x0F
    MOV     LED8+0, A

    MOV     A, LED8+4       ;ʾЧ0
    JNZ     F_QuitDisplay
    MOV     LED8+4, #DIS_BLACK
    MOV     A, LED8+3
    JNZ     F_QuitDisplay
    MOV     LED8+3, #DIS_BLACK
    MOV     A, LED8+2
    JNZ     F_QuitDisplay
    MOV     LED8+2, #DIS_BLACK
    MOV     A, LED8+1
    JNZ     F_QuitDisplay
    MOV     LED8+1, #DIS_BLACK
F_QuitDisplay:
    RET




    END

