/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻STC32GΪоƬʵбдԡ

ʹKeil C251Memory ModelƼXSmallģʽĬ϶edataʱӴȡٶȿ졣

edata鱣1Kջʹãռ䲻ʱɽ顢ñxdataؼֶ嵽xdataռ䡣

3ȫ˫жϷʽշͨѶ

ͨPCMCU, MCUյͨ3յԭ.

öʱʷʹ1Tģʽ(ǵͲ12T)ѡɱʱƵʣ߾ȡ

ʱ, ѡʱ 22.1184MHz (û޸Ƶ).

******************************************/

#include "..\..\comm\STC32G.h"

#include "stdio.h"
#include "intrins.h"

typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;

#define MAIN_Fosc        22118400L   //ʱӣȷ115200ʣ

//==========================================================================

#define Baudrate3   (65536 - MAIN_Fosc / 115200 / 4)

#define UART3_BUF_LENGTH    64

//==========================================================================

/*************  س    **************/


/*************  IOڶ    **************/

/*************  ر    **************/

u8  TX3_Cnt;    //ͼ
u8  RX3_Cnt;    //ռ
bit B_TX3_Busy; //æ־

u8  RX3_Buffer[UART3_BUF_LENGTH]; //ջ

/*************  غ    **************/

void    UART3_config(u8 brt);   // ѡ, 2: ʹTimer2, ֵ: ʹTimer3.
void    PrintString3(u8 *puts);

/****************  ⲿⲿ *****************/


/********************  **************************/
void main(void)
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x30;   P0M0 = 0x30;   //P0.4P0.5Ϊ©·(ʵ赽3.3V)
    P1M1 = 0x30;   P1M0 = 0x30;   //P1.4P1.5Ϊ©·(ʵ赽3.3V)
    P2M1 = 0x3c;   P2M0 = 0x3c;   //P2.2~P2.5Ϊ©·(ʵ赽3.3V)
    P3M1 = 0x50;   P3M0 = 0x50;   //P3.4P3.6Ϊ©·(ʵ赽3.3V)
    P4M1 = 0x3c;   P4M0 = 0x3c;   //P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    P5M1 = 0x0c;   P5M0 = 0x0c;   //P5.2P5.3Ϊ©·(ʵ赽3.3V)
    P6M1 = 0xff;   P6M0 = 0xff;   //Ϊ©·(ʵ赽3.3V)
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    UART3_config(0);    //ѡ, 2: ʹTimer2, ֵ: ʹTimer3.
    EA = 1;             //ȫж

    PrintString3("STC32G UART3 Test Programme!\r\n");  //UART3һַ

    while (1)
    {
        if((TX3_Cnt != RX3_Cnt) && (!B_TX3_Busy))   //յ, Ϳ
        {
            S3BUF = RX3_Buffer[TX3_Cnt];
            B_TX3_Busy = 1;
            if(++TX3_Cnt >= UART3_BUF_LENGTH)   TX3_Cnt = 0;
        }
    }
}

//========================================================================
// : void PrintString3(u8 *puts)
// : 3ַ
// : puts:  ַָ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void PrintString3(u8 *puts)
{
    for (; *puts != 0;  puts++)     //ֹͣ0
    {
        S3BUF = *puts;
        B_TX3_Busy = 1;
        while(B_TX3_Busy);
    }
}

//========================================================================
// : SetTimer2Baudraye(u32 dat)
// : Timer2ʷ
// : dat: Timer2װֵ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void SetTimer2Baudraye(u32 dat)  // ʹTimer2.
{
    T2R = 0;		//Timer stop
    T2_CT = 0;	//Timer2 set As Timer
    T2x12 = 1;	//Timer2 set as 1T mode
    T2H = (u8)(dat / 256);
    T2L = (u8)(dat % 256);
    ET2 = 0;    //ֹж
    T2R = 1;		//Timer run enable
}

//========================================================================
// : void UART3_config(u8 brt)
// : UART3ʼ
// : brt: ѡ, 2: ʹTimer2, ֵ: ʹTimer3.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART3_config(u8 brt)    // ѡ, 2: ʹTimer2, ֵ: ʹTimer3.
{
    if(brt == 2)
    {
        SetTimer2Baudraye(Baudrate3);
        S3CON = 0x10;       //8λ, ʹTimer2ʷ, 
    }
    else
    {
        T3R = 0;		//Timer stop
        S3CON = 0x50;       //8λ, ʹTimer3ʷ, 
        T3H = (u8)(Baudrate3 / 256);
        T3L = (u8)(Baudrate3 % 256);
        T3_CT = 0;	//Timer3 set As Timer
        T3x12 = 1;	//Timer3 set as 1T mode
        T3R = 1;		//Timer run enable
    }
    ES3  = 1;       //UART3ж
    S3_S = 1;       //UART3 switch bit1 to: 0: P0.0 P0.1,  1: P5.0 P5.1

    B_TX3_Busy = 0;
    TX3_Cnt = 0;
    RX3_Cnt = 0;
}


//========================================================================
// : void UART3_int (void) interrupt UART3_VECTOR
// : UART3жϺ
// : nine.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART3_int (void) interrupt 17
{
    if(S3RI)
    {
        S3RI = 0;    //Clear Rx flag
        RX3_Buffer[RX3_Cnt] = S3BUF;
        if(++RX3_Cnt >= UART3_BUF_LENGTH)   RX3_Cnt = 0;
    }

    if(S3TI)
    {
        S3TI = 0;   //Clear Tx flag
        B_TX3_Busy = 0;
    }
}

