/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻STC32GΪоƬʵбдԡ

ʹKeil C251Memory ModelƼXSmallģʽĬ϶edataʱӴȡٶȿ졣

edata鱣1Kջʹãռ䲻ʱɽ顢ñxdataؼֶ嵽xdataռ䡣

4ȫ˫жϷʽշͨѶ

ͨPCMCU, MCUյͨ4յԭ.

öʱʷʹ1Tģʽ(ǵͲ12T)ѡɱʱƵʣ߾ȡ

ʱ, ѡʱ 22.1184MHz (û޸Ƶ).

******************************************/

#include "..\..\comm\STC32G.h"

#include "stdio.h"
#include "intrins.h"

typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;

#define MAIN_Fosc        22118400L   //ʱӣȷ115200ʣ

//==========================================================================

#define Baudrate4   (65536 - MAIN_Fosc / 115200 / 4)

#define UART4_BUF_LENGTH    64

//==========================================================================

/*************  س    **************/


/*************  IOڶ    **************/

/*************  ر    **************/

u8  TX4_Cnt;    //ͼ
u8  RX4_Cnt;    //ռ
bit B_TX4_Busy; //æ־

u8  RX4_Buffer[UART4_BUF_LENGTH]; //ջ

/*************  غ    **************/

void UART4_config(u8 brt);   // ѡ, 2: ʹTimer2, ֵ: ʹTimer4.
void PrintString4(u8 *puts);

/****************  ⲿⲿ *****************/


/********************  **************************/
void main(void)
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x30;   P0M0 = 0x30;   //P0.4P0.5Ϊ©·(ʵ赽3.3V)
    P1M1 = 0x30;   P1M0 = 0x30;   //P1.4P1.5Ϊ©·(ʵ赽3.3V)
    P2M1 = 0x3c;   P2M0 = 0x3c;   //P2.2~P2.5Ϊ©·(ʵ赽3.3V)
    P3M1 = 0x50;   P3M0 = 0x50;   //P3.4P3.6Ϊ©·(ʵ赽3.3V)
    P4M1 = 0x3c;   P4M0 = 0x3c;   //P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    P5M1 = 0x0c;   P5M0 = 0x0c;   //P5.2P5.3Ϊ©·(ʵ赽3.3V)
    P6M1 = 0xff;   P6M0 = 0xff;   //Ϊ©·(ʵ赽3.3V)
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    UART4_config(0);    //ѡ, 2: ʹTimer2, ֵ: ʹTimer4.
    EA = 1;             //ȫж

    PrintString4("STC32G UART4 Test Programme!\r\n");  //UART4һַ

    while (1)
    {
        if((TX4_Cnt != RX4_Cnt) && (!B_TX4_Busy))   //յ, Ϳ
        {
            S4BUF = RX4_Buffer[TX4_Cnt];
            B_TX4_Busy = 1;
            if(++TX4_Cnt >= UART4_BUF_LENGTH)   TX4_Cnt = 0;
        }
    }
}

//========================================================================
// : void PrintString4(u8 *puts)
// : 4ַ
// : puts:  ַָ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void PrintString4(u8 *puts)
{
    for (; *puts != 0;  puts++)     //ֹͣ0
    {
        S4BUF = *puts;
        B_TX4_Busy = 1;
        while(B_TX4_Busy);
    }
}

//========================================================================
// : SetTimer2Baudraye(u32 dat)
// : Timer2ʷ
// : dat: Timer2װֵ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void SetTimer2Baudraye(u32 dat)  // ʹTimer2.
{
    T2R = 0;		//Timer stop
    T2_CT = 0;	//Timer2 set As Timer
    T2x12 = 1;	//Timer2 set as 1T mode
    T2H = (u8)(dat / 256);
    T2L = (u8)(dat % 256);
    ET2 = 0;    //ֹж
    T2R = 1;		//Timer run enable
}

//========================================================================
// : void UART4_config(u8 brt)
// : UART4ʼ
// : brt: ѡ, 2: ʹTimer2, ֵ: ʹTimer4.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART4_config(u8 brt)    // ѡ, 2: ʹTimer2, ֵ: ʹTimer4.
{
    if(brt == 2)
    {
        SetTimer2Baudraye(Baudrate4);
        S4CON = 0x10;       //8λ, ʹTimer2ʷ, 
    }
    else
    {
        T4R = 0;	//Timer stop
        S4CON = 0x50;       //8λ, ʹTimer4ʷ, 
        T4H = (u8)(Baudrate4 / 256);
        T4L = (u8)(Baudrate4 % 256);
        T4_CT = 0;	//Timer3 set As Timer
        T4x12 = 1;	//Timer3 set as 1T mode
        T4R = 1;	//Timer run enable
    }
    ES4  = 1;       //UART4ж
    S4_S = 0;       //UART4 switch bit2 to: 0: P0.2 P0.3, 1: P5.2 P5.3

    B_TX4_Busy = 0;
    TX4_Cnt = 0;
    RX4_Cnt = 0;
}


//========================================================================
// : void UART4_int (void) interrupt UART4_VECTOR
// : UART4жϺ
// : nine.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART4_int (void) interrupt 18
{
    if(S4RI)
    {
        S4RI = 0;    //Clear Rx flag
        RX4_Buffer[RX4_Cnt] = S4BUF;
        if(++RX4_Cnt >= UART4_BUF_LENGTH)   RX4_Cnt = 0;
    }

    if(S4TI)
    {
        S4TI = 0;    //Clear Tx flag
        B_TX4_Busy = 0;
    }
}

