/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻STC32GΪоƬʵбдԡ

ʹKeil C251Memory ModelƼXSmallģʽĬ϶edataʱӴȡٶȿ졣

edata鱣1Kջʹãռ䲻ʱɽ顢ñxdataؼֶ嵽xdataռ䡣

STCMCUIOʽ8λܡ

ʾЧΪ: ʱ.

ʹTimer016λԶװ1ms,,û޸MCUʱƵʱ,Զʱ1ms.

4λLEDʾʱ(Сʱ,), ұλʾֵ.

ADCΪ1~16.

ֵֻ֧, ֶ֧ͬʱ, вԤ֪Ľ.

³1,10/ٶṩؼ. ûֻҪKeyCodeǷ0жϼǷ.

ʱ:
1: Сʱ+.
2: Сʱ-.
3: +.
4: -.

ʱ, ѡʱ 24MHZ (û޸Ƶ).

******************************************/

#include "..\..\comm\STC32G.h"

#include "stdio.h"
#include "intrins.h"

typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;

#define MAIN_Fosc        24000000UL

//==========================================================================


#define Timer0_Reload   (65536UL -(MAIN_Fosc / 1000))       //Timer 0 жƵ, 1000/

#define DIS_DOT     0x20
#define DIS_BLACK   0x10
#define DIS_        0x11


u8 code t_display[]={                       //׼ֿ
//   0    1    2    3    4    5    6    7    8    9    A    B    C    D    E    F
    0x3F,0x06,0x5B,0x4F,0x66,0x6D,0x7D,0x07,0x7F,0x6F,0x77,0x7C,0x39,0x5E,0x79,0x71,
//black  -     H    J    K    L    N    o   P    U     t    G    Q    r   M    y
    0x00,0x40,0x76,0x1E,0x70,0x38,0x37,0x5C,0x73,0x3E,0x78,0x3d,0x67,0x50,0x37,0x6e,
    0xBF,0x86,0xDB,0xCF,0xE6,0xED,0xFD,0x87,0xFF,0xEF,0x46};    //0. 1. 2. 3. 4. 5. 6. 7. 8. 9. -1

u8 code T_COM[]={0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80};      //λ


u8  LED8[8];        //ʾ
u8  display_index;  //ʾλ
bit B_1ms;          //1ms־

u8  ADC_KeyState,ADC_KeyState1,ADC_KeyState2,ADC_KeyState3; //״̬
u8  ADC_KeyHoldCnt; //¼ʱ
u8  KeyCode;    //ûʹõļ, 1~16Ч
u8  cnt10ms;

u8  hour,minute,second; //RTC
u16 msecond;

void    CalculateAdcKey(u16 adc);
u16     Get_ADC12bitResult(u8 channel); //channel = 0~15
void    DisplayRTC(void);
void    RTC(void);


/**********************************************/
void main(void)
{
    u8  i;
    u16 j;

    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x30;   P0M0 = 0x30;   //P0.4P0.5Ϊ©·(ʵ赽3.3V)
    P1M1 = 0x31;   P1M0 = 0x30;   //P1.4P1.5Ϊ©·(ʵ赽3.3V), P1.0 Ϊ ADC 
    P2M1 = 0x3c;   P2M0 = 0x3c;   //P2.2~P2.5Ϊ©·(ʵ赽3.3V)
    P3M1 = 0x50;   P3M0 = 0x50;   //P3.4P3.6Ϊ©·(ʵ赽3.3V)
    P4M1 = 0x3c;   P4M0 = 0x3c;   //P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    P5M1 = 0x0c;   P5M0 = 0x0c;   //P5.2P5.3Ϊ©·(ʵ赽3.3V)
    P6M1 = 0xff;   P6M0 = 0xff;   //Ϊ©·(ʵ赽3.3V)
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫
    
    display_index = 0;
    
    ADCTIM = 0x3f;		// ADC ڲʱADCʱ佨ֵ
    ADCCFG = 0x2f;		// ADC ʱΪϵͳʱ/2/16/16
    ADC_CONTR = 0x80;   //ʹ ADC ģ

    AUXR = 0x80;    //Timer0 set as 1T, 16 bits timer auto-reload, 
    TH0 = (u8)(Timer0_Reload / 256);
    TL0 = (u8)(Timer0_Reload % 256);
    ET0 = 1;    //Timer0 interrupt enable
    TR0 = 1;    //Tiner0 run
    EA = 1;     //ж
    
    for(i=0; i<8; i++)  LED8[i] = 0x10; //ϵ

    hour   = 12;    //ʼʱֵ
    minute = 0;
    second = 0;
    DisplayRTC();

    ADC_KeyState  = 0;
    ADC_KeyState1 = 0;
    ADC_KeyState2 = 0;
    ADC_KeyState3 = 0;  //״̬
    ADC_KeyHoldCnt = 0; //¼ʱ
    KeyCode = 0;    //ûʹõļ, 1~16Ч
    cnt10ms = 0;

    while(1)
    {
        if(B_1ms)   //1ms
        {
            B_1ms = 0;
            if(++msecond >= 1000)   //1뵽
            {
                msecond = 0;
                RTC();
                DisplayRTC();
            }
            if(msecond == 500)  DisplayRTC();   //СʱС

            if(++cnt10ms >= 10) //10msһADC
            {
                cnt10ms = 0;
                j = Get_ADC12bitResult(0);  //0~15,ѯʽһADC, ֵǽ, == 4096 Ϊ
                if(j < 4096)    CalculateAdcKey(j); //㰴
            }

            if(KeyCode > 0)     //м
            {
                LED8[6] = KeyCode / 10; //ʾ
                LED8[7] = KeyCode % 10; //ʾ

                if(KeyCode == 1)    //hour +1
                {
                    if(++hour >= 24)    hour = 0;
                    DisplayRTC();
                }
                if(KeyCode == 2)    //hour -1
                {
                    if(--hour >= 24)    hour = 23;
                    DisplayRTC();
                }
                if(KeyCode == 3)    //minute +1
                {
                    second = 0;
                    if(++minute >= 60)  minute = 0;
                    DisplayRTC();
                }
                if(KeyCode == 4)    //minute -1
                {
                    second = 0;
                    if(--minute >= 60)  minute = 59;
                    DisplayRTC();
                }
                KeyCode = 0;
            }
        }
    }
} 
/**********************************************/


/********************** ʾʱӺ ************************/
void DisplayRTC(void)
{
    if(hour >= 10)  LED8[0] = hour / 10;
    else            LED8[0] = DIS_BLACK;
    LED8[1] = hour % 10;
    LED8[2] = minute / 10;
    LED8[3] = minute % 10;
    if(msecond >= 500)      LED8[1] |= DIS_DOT; //СʱС
}

/********************** RTCʾ ************************/
void RTC(void)
{
    if(++second >= 60)
    {
        second = 0;
        if(++minute >= 60)
        {
            minute = 0;
            if(++hour >= 24)    hour = 0;
        }
    }
}


//========================================================================
// : u16 Get_ADC12bitResult(u8 channel)
// : ѯһADC.
// : channel: ѡҪתADC.
// : 12λADC.
// 汾: V1.0, 2012-10-22
//========================================================================
u16 Get_ADC12bitResult(u8 channel)  //channel = 0~15
{
    ADC_RES = 0;
    ADC_RESL = 0;

    ADC_CONTR = (ADC_CONTR & 0xf0) | channel; //ADCתͨ
    ADC_START = 1;//ADCת
    _nop_();
    _nop_();
    _nop_();
    _nop_();

    while(ADC_FLAG == 0);   //wait for ADC finish
    ADC_FLAG = 0;     //ADC־
    return  (((u16)ADC_RES << 8) | ADC_RESL);
}

/***************** ADC̼ *****************************
·㷨: Coody
ADC̷ںܶʵʲƷ, ֤ȶɿ, ʹʹõĤ,ܿɿ.
16,ϸӦADCֵΪ (4096 / 16) * k = 256 * k, k = 1 ~ 16, ر, k=16ʱ,ӦADCֵ4095.
ʵʻƫ,жʱƫ, ADC_OFFSETΪ+-ƫ, ADCֵ (256*k-ADC_OFFSET)  (256*k+ADC_OFFSET)֮ΪЧ.
һʱ,ͲһADC,10ms.
Ϊ˱żȻADCֵ, ߱ADC½ʱ, ʹ3ADCֵƫΧʱ, ADCֵΪЧ.
㷨, ܱ֤ǳɿ.
**********************************************/
#define ADC_OFFSET  64
void CalculateAdcKey(u16 adc)
{
    u8  i;
    u16 j;
    
    if(adc < (256-ADC_OFFSET))
    {
        ADC_KeyState = 0;   //״̬0
        ADC_KeyHoldCnt = 0;
    }
    j = 256;
    for(i=1; i<=16; i++)
    {
        if((adc >= (j - ADC_OFFSET)) && (adc <= (j + ADC_OFFSET)))  break;  //жǷƫΧ
        j += 256;
    }
    ADC_KeyState3 = ADC_KeyState2;
    ADC_KeyState2 = ADC_KeyState1;
    if(i > 16)  ADC_KeyState1 = 0;  //Ч
    else                        //Ч
    {
        ADC_KeyState1 = i;
        if((ADC_KeyState3 == ADC_KeyState2) && (ADC_KeyState2 == ADC_KeyState1) &&
           (ADC_KeyState3 > 0) && (ADC_KeyState2 > 0) && (ADC_KeyState1 > 0))
        {
            if(ADC_KeyState == 0)   //һμ⵽
            {
                KeyCode  = i;   //
                ADC_KeyState = i;   //״̬
                ADC_KeyHoldCnt = 0;
            }
            if(ADC_KeyState == i)   //⵽ͬһ
            {
                if(++ADC_KeyHoldCnt >= 100) //1,10ÿٶRepeat Key
                {
                    ADC_KeyHoldCnt = 90;
                    KeyCode  = i;   //
                }
            }
            else ADC_KeyHoldCnt = 0; //ʱ0
        }
    }
}


/********************** ʾɨ躯 ************************/
void DisplayScan(void)
{   
    P7 = ~T_COM[7-display_index];
    P6 = ~t_display[LED8[display_index]];
    if(++display_index >= 8)    display_index = 0;  //8λ0
}


/********************** Timer0 1msжϺ ************************/
void timer0 (void) interrupt 1
{
    DisplayScan();  //1msɨʾһλ
    B_1ms = 1;      //1ms־
}

