/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/


/*************  ˵  **************

̻STC32GΪоƬʵбдԡ

ʹKeil C251Memory ModelƼXSmallģʽĬ϶edataʱӴȡٶȿ졣

edata鱣1Kջʹãռ䲻ʱɽ顢ñxdataؼֶ嵽xdataռ䡣

ͨ2(P4.6 P4.7)STCڲԴEEPROM(FLASH)ждԡ

FLASHд롢Ĳַָ

Ĭϲ:  115200,8,N,1. 
Ĭʱ:  22.1184MHz.

: (ĸִСд)
    W 0x000040 1234567890  --> 0x000040ַдַ1234567890.
    R 0x000040 10          --> 0x000040ַ10ֽ. 

ע⣺ʱؽ"Ӳѡ"ûEEPROMС

ȷеĵַEEPROMõĴСΧ֮ڡ

******************************************/

#include "..\..\comm\STC32G.h"
#include "intrins.h"

#define     MAIN_Fosc       22118400L   //ʱӣȷ115200ʣ

typedef     unsigned char   u8;
typedef     unsigned int    u16;
typedef     unsigned long   u32;

#define     Baudrate2           115200L
#define     Tmp_Length          100      //дEEPROM峤

#define     UART2_BUF_LENGTH    (Tmp_Length+11)  //ڻ峤

u8  RX2_TimeOut;
u8  TX2_Cnt;    //ͼ
u8  RX2_Cnt;    //ռ
bit B_TX2_Busy; //æ־

u8  RX2_Buffer[UART2_BUF_LENGTH];   //ջ
u8  tmp[Tmp_Length];        //EEPROM


void    UART2_config(u8 brt);   // ѡ, 2: ʹTimer2, ֵ: Ч.
void    PrintString2(u8 *puts);
void    UART2_TxByte(u8 dat);
void    delay_ms(u8 ms);
u8      CheckData(u8 dat);
u32     GetAddress(void);
u8      GetDataLength(void);
void    EEPROM_SectorErase(u32 EE_address);
void    EEPROM_read_n(u32 EE_address,u8 *DataAddress,u8 length);
u8      EEPROM_write_n(u32 EE_address,u8 *DataAddress,u8 length);


/*********************  *************************/
void main(void)
{
    u8  i,j;
    u32 addr;
    u8  status;

    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x30;   P0M0 = 0x30;   //P0.4P0.5Ϊ©·(ʵ赽3.3V)
    P1M1 = 0x30;   P1M0 = 0x30;   //P1.4P1.5Ϊ©·(ʵ赽3.3V)
    P2M1 = 0x3c;   P2M0 = 0x3c;   //P2.2~P2.5Ϊ©·(ʵ赽3.3V)
    P3M1 = 0x50;   P3M0 = 0x50;   //P3.4P3.6Ϊ©·(ʵ赽3.3V)
    P4M1 = 0x3c;   P4M0 = 0x3c;   //P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    P5M1 = 0x0c;   P5M0 = 0x0c;   //P5.2P5.3Ϊ©·(ʵ赽3.3V)
    P6M1 = 0xff;   P6M0 = 0xff;   //Ϊ©·(ʵ赽3.3V)
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    UART2_config(2);    // ѡ, 2: ʹTimer2, ֵ: Ч.
    EA = 1; //ж

    PrintString2("STC32GϵеƬEEPROMԳ򣬴:\r\n");    //UART2һַ
    PrintString2("W 0x000040 1234567890  --> 0x000040ַдַ1234567890.\r\n");   //UART2һַ
    PrintString2("R 0x000040 10          --> 0x000040ַ10ֽ.\r\n"); //UART2һַ

    while(1)
    {
        delay_ms(1);
        if(RX2_TimeOut > 0)     //ʱ
        {
            if(--RX2_TimeOut == 0)
            {
              for(i=0; i<RX2_Cnt; i++)    UART2_TxByte(RX2_Buffer[i]);    //յԭ,ڲ

                status = 0xff;  //״̬һ0ֵ
                if((RX2_Cnt >= 12) && (RX2_Buffer[1] == ' ') && (RX2_Buffer[10] == ' ')) //Ϊ10ֽ
                {
                    for(i=0; i<10; i++)
                    {
                        if((RX2_Buffer[i] >= 'a') && (RX2_Buffer[i] <= 'z'))    RX2_Buffer[i] = RX2_Buffer[i] - 'a' + 'A';  //Сдתд
                    }
                    addr = GetAddress();
                    if(addr < 0x00ffffff)
                    {
                        if(RX2_Buffer[0] == 'W')    //дNֽ
                        {
                            j = RX2_Cnt - 11;
                            if(j > Tmp_Length)  j = Tmp_Length; //Խ
                            EEPROM_SectorErase(addr);           //
                            i = EEPROM_write_n(addr,&RX2_Buffer[11],j);      //дNֽ
                            if(i == 0)
                            {
                                PrintString2("\r\nд");
                                if(j >= 100)    {UART2_TxByte((u8)(j/100+'0'));   j = j % 100;}
                                if(j >= 10)     {UART2_TxByte((u8)(j/10+'0'));    j = j % 10;}
                                UART2_TxByte((u8)(j%10+'0'));
                                PrintString2("ֽڣ\r\n");
                            }
                            else    PrintString2("\r\nд\r\n");
                            status = 0; //ȷ
                        }

                        else if(RX2_Buffer[0] == 'R')   //PC󷵻NֽEEPROM
                        {
                            j = GetDataLength();
                            if(j > Tmp_Length)  j = Tmp_Length; //Խ
                            if(j > 0)
                            {
                                PrintString2("\r\n");
                                UART2_TxByte((u8)(j/10+'0'));
                                UART2_TxByte((u8)(j%10+'0'));
                                PrintString2("ֽ:\r\n");
                                EEPROM_read_n(addr,tmp,j);
                                for(i=0; i<j; i++)  UART2_TxByte(tmp[i]);
                                UART2_TxByte(0x0d);
                                UART2_TxByte(0x0a);
                                status = 0; //ȷ
                            }
                        }
                    }
                }
                if(status != 0) PrintString2("\r\n\r\n");
                RX2_Cnt  = 0;   //ֽ
            }
        }
    }
}
//========================================================================


//========================================================================
// : void delay_ms(u8 ms)
// : ʱ
// : ms,Ҫʱms, ֻ֧1~255ms. ԶӦʱ.
// : none.
// 汾: VER1.0
// : 2021-3-9
// ע: 
//========================================================================
void delay_ms(u8 ms)
{
     u16 i;
     do{
          i = MAIN_Fosc / 6000;
          while(--i);
     }while(--ms);
}

//========================================================================
// : u8 CheckData(u8 dat)
// : ַ"0~9,A~Fa~f"תʮ.
// : dat: Ҫַ.
// : 0x00~0x0FΪȷ. 0xFFΪ.
// 汾: V1.0, 2012-10-22
//========================================================================
u8 CheckData(u8 dat)
{
    if((dat >= '0') && (dat <= '9'))        return (dat-'0');
    if((dat >= 'A') && (dat <= 'F'))        return (dat-'A'+10);
    return 0xff;
}

//========================================================================
// : u32 GetAddress(void)
// : 뷽ʽĵַ.
// : .
// : 24λEEPROMַ.
// 汾: V1.0, 2013-6-6
//========================================================================
u32 GetAddress(void)
{
    u32 address;
    u8  i,j;
    
    address = 0;
    if((RX2_Buffer[2] == '0') && (RX2_Buffer[3] == 'X'))
    {
        for(i=4; i<10; i++)
        {
            j = CheckData(RX2_Buffer[i]);
            if(j >= 0x10)   return 0xffffffff;   //error
            address = (address << 4) + j;
        }
        return (address);
    }
    return  0xffffffff;  //error
}

/**************** ȡҪݵֽ ****************************/
u8 GetDataLength(void)
{
    u8  i;
    u8  length;
    
    length = 0;
    for(i=11; i<RX2_Cnt; i++)
    {
        if(CheckData(RX2_Buffer[i]) >= 10)  break;
        length = length * 10 + CheckData(RX2_Buffer[i]);
    }
    return (length);
}


//========================================================================
// : void UART2_TxByte(u8 dat)
// : һֽ.
// : .
// : .
// 汾: V1.0, 2014-6-30
//========================================================================
void UART2_TxByte(u8 dat)
{
    S2BUF = dat;
    B_TX2_Busy = 1;
    while(B_TX2_Busy);
}


//========================================================================
// : void PrintString2(u8 *puts)
// : 2ַ
// : puts:  ַָ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void PrintString2(u8 *puts) //һַ
{
    for (; *puts != 0;  puts++) UART2_TxByte(*puts);    //ֹͣ0
}

//========================================================================
// : void SetTimer2Baudraye(u16 dat)
// : Timer2ʷ
// : dat: Timer2װֵ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void SetTimer2Baudraye(u16 dat)  // ѡ, 2: ʹTimer2, ֵ: Ч.
{
    T2R = 0;		//Timer stop
    T2_CT = 0;	//Timer2 set As Timer
    T2x12 = 1;	//Timer2 set as 1T mode
    T2H = (u8)(dat / 256);
    T2L = (u8)(dat % 256);
    ET2 = 0;    //ֹж
    T2R = 1;		//Timer run enable
}

//========================================================================
// : void UART2_config(u8 brt)
// : UART2ʼ
// : brt: ѡ, 2: ʹTimer2, ֵ: Ч.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART2_config(u8 brt)    // ѡ, 2: ʹTimer2, ֵ: Ч.
{
    /*********** ʹ̶ʹöʱ2 *****************/
    if(brt == 2)
    {
        SetTimer2Baudraye((u16)(65536UL - (MAIN_Fosc / 4) / Baudrate2));

        S2CFG |= 0x01;     //ʹô2ʱW1λΪ1ܻԤڵĴ
        S2CON = (S2CON & 0x3f) | 0x40;    //UART2ģʽ, 0x00: ͬλ, 0x40: 8λ,ɱ䲨, 0x80: 9λ,̶, 0xc0: 9λ,ɱ䲨
        ES2   = 1;         //ж
        S2REN = 1;         //
        S2_S  = 1;         //UART2 switch to: 0: P1.0 P1.1,  1: P4.6 P4.7

        RX2_TimeOut = 0;
        B_TX2_Busy = 0;
        TX2_Cnt = 0;
        RX2_Cnt = 0;
    }
}


//========================================================================
// : void UART2_int (void) interrupt UART2_VECTOR
// : UART2жϺ
// : nine.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART2_int (void) interrupt 8
{
    if(S2RI)
    {
        S2RI = 0;    //Clear Rx flag
        RX2_Buffer[RX2_Cnt] = S2BUF;
        if(++RX2_Cnt >= UART2_BUF_LENGTH)   RX2_Cnt = 0;
        RX2_TimeOut = 5;
    }

    if(S2TI)
    {
        S2TI = 0;    //Clear Tx flag
        B_TX2_Busy = 0;
    }
}


#define     IAP_STANDBY()   IAP_CMD = 0     //IAPֹ
#define     IAP_READ()      IAP_CMD = 1     //IAP
#define     IAP_WRITE()     IAP_CMD = 2     //IAPд
#define     IAP_ERASE()     IAP_CMD = 3     //IAP

#define     IAP_ENABLE()    IAP_CONTR = IAP_EN; IAP_TPS = MAIN_Fosc / 1000000
#define     IAP_DISABLE()   IAP_CONTR = 0; IAP_CMD = 0; IAP_TRIG = 0; IAP_ADDRE = 0xff; IAP_ADDRH = 0xff; IAP_ADDRL = 0xff

#define IAP_EN          (1<<7)
#define IAP_SWBS        (1<<6)
#define IAP_SWRST       (1<<5)
#define IAP_CMD_FAIL    (1<<4)


//========================================================================
// : void DisableEEPROM(void)
// : ֹEEPROM.
// : none.
// : none.
// 汾: V1.0, 2014-6-30
//========================================================================
void DisableEEPROM(void)        //ֹEEPROM
{
    IAP_CONTR = 0;          //ر IAP 
    IAP_CMD = 0;            //Ĵ
    IAP_TRIG = 0;           //Ĵ
    IAP_ADDRE = 0xff;       //ַõ IAP 
    IAP_ADDRH = 0xff;       //ַõ IAP 
    IAP_ADDRL = 0xff;
}

//========================================================================
// : void EEPROM_Trig(void)
// : EEPROM.
// : none.
// : none.
// 汾: V1.0, 2014-6-30
//========================================================================
void EEPROM_Trig(void)
{
    F0 = EA;    //ȫж
    EA = 0;     //ֹж, ⴥЧ
    IAP_TRIG = 0x5A;
    IAP_TRIG = 0xA5;                    //5AHA5HIAPĴÿζҪ
                                        //A5HIAP
                                        //CPUȴIAPɺ󣬲Żִг
    _nop_();   //STC32GǶ༶ˮߵָϵͳ4NOP֤IAP_DATA׼
    _nop_();
    _nop_();
    _nop_();
    EA = F0;    //ָȫж
}

//========================================================================
// : void EEPROM_SectorErase(u32 EE_address)
// : һ.
// : EE_address:  ҪEEPROMеһֽڵַ.
// : none.
// 汾: V1.0, 2014-6-30
//========================================================================
void EEPROM_SectorErase(u32 EE_address)
{
    IAP_ENABLE();                       //õȴʱ䣬IAPһξ͹
    IAP_ERASE();                        //, ıʱ
                                        //ֻûֽڲ512ֽ/
                                        //һֽڵַַ
    IAP_ADDRE = (u8)(EE_address >> 16); //ַֽڣַҪıʱ͵ַ
    IAP_ADDRH = (u8)(EE_address >> 8);  //ַֽڣַҪıʱ͵ַ
    IAP_ADDRL = (u8)EE_address;         //ַֽڣַҪıʱ͵ַ
    EEPROM_Trig();                      //EEPROM
    DisableEEPROM();                    //ֹEEPROM
}

//========================================================================
// : void EEPROM_read_n(u32 EE_address,u8 *DataAddress,u8 lenth)
// : Nֽں.
// : EE_address:  ҪEEPROM׵ַ.
//       DataAddress: Ҫݵָ.
//       length:      Ҫĳ
// : 0: дȷ.  1: д볤Ϊ0.  2: дݴ.
// 汾: V1.0, 2014-6-30
//========================================================================
void EEPROM_read_n(u32 EE_address,u8 *DataAddress,u8 length)
{
    IAP_ENABLE();                           //õȴʱ䣬IAPһξ͹
    IAP_READ();                             //ֽڶıʱ
    do
    {
        IAP_ADDRE = (u8)(EE_address >> 16); //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRH = (u8)(EE_address >> 8);  //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRL = (u8)EE_address;         //͵ַֽڣַҪıʱ͵ַ
        EEPROM_Trig();                      //EEPROM
        *DataAddress = IAP_DATA;            //
        EE_address++;
        DataAddress++;
    }while(--length);

    DisableEEPROM();
}


//========================================================================
// : u8 EEPROM_write_n(u32 EE_address,u8 *DataAddress,u8 length)
// : дNֽں.
// : EE_address:  ҪдEEPROM׵ַ.
//       DataAddress: Ҫдݵָ.
//       length:      Ҫдĳ
// : 0: дȷ.  1: д볤Ϊ0.  2: дݴ.
// 汾: V1.0, 2014-6-30
//========================================================================
u8 EEPROM_write_n(u32 EE_address,u8 *DataAddress,u8 length)
{
    u8  i;
    u16 j;
    u8  *p;
    
    if(length == 0) return 1;   //Ϊ0

    IAP_ENABLE();                       //õȴʱ䣬IAPһξ͹
    i = length;
    j = EE_address;
    p = DataAddress;
    IAP_WRITE();                            //, ֽд
    do
    {
        IAP_ADDRE = (u8)(EE_address >> 16); //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRH = (u8)(EE_address >> 8);  //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRL = (u8)EE_address;         //͵ַֽڣַҪıʱ͵ַ
        IAP_DATA  = *DataAddress;           //ݵIAP_DATAֻݸıʱ
        EEPROM_Trig();                      //EEPROM
        EE_address++;                       //һַ
        DataAddress++;                      //һ
    }while(--length);                       //ֱ

    EE_address = j;
    length = i;
    DataAddress = p;
    i = 0;
    IAP_READ();                             //NֽڲȽ
    do
    {
        IAP_ADDRE = (u8)(EE_address >> 16); //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRH = (u8)(EE_address >> 8);  //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRL = (u8)EE_address;         //͵ַֽڣַҪıʱ͵ַ
        EEPROM_Trig();                      //EEPROM
        if(*DataAddress != IAP_DATA)        //ԴݱȽ
        {
            i = 2;
            break;
        }
        EE_address++;
        DataAddress++;
    }while(--length);

    DisableEEPROM();
    return i;
}

