/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻STC32GΪоƬʵбдԡ

ʹKeil C251Memory ModelƼXSmallģʽĬ϶edataʱӴȡٶȿ졣

edata鱣1Kջʹãռ䲻ʱɽ顢ñxdataؼֶ嵽xdataռ䡣

ûں궨иıMCUʱƵ. Χ 8MHZ ~ 33MHZ.

ճģгNECı롣

ûں궨ָû.

ʹPWM438KHZز, 1/3ռձ, ÿ38KHZڷܷ9us,ر16.3us.

ʹÿϵ16IOɨ谴, MCU˯, ɨ谴.

, һ֡Ϊ, ֡Ϊظ֡,, 嶨вοNECı.

ͷź, ֹͣ.

ʱ, ѡʱ 24MHz (û޸Ƶ).

******************************************/

#include "..\..\comm\STC32G.h"

#include "stdio.h"
#include "intrins.h"

typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;

#define MAIN_Fosc        24000000UL

/****************************** û ***********************************/


/*****************************************************************************/


/*************  س    **************/


/*************  IO̱  **************/

u8  IO_KeyState, IO_KeyState1, IO_KeyHoldCnt;   //м̱
u8  KeyHoldCnt; //¼ʱ
u8  KeyCode;    //ûʹõļ, 1~16Ч

/*************  ⷢر    **************/
#define User_code   0xFF00      //û

sbit    P_IR_TX   = P2^7;   //ⷢͶ˿
#define IR_TX_ON    0
#define IR_TX_OFF   1

static u16     tx_cnt;     //ͻе(38KHZӦʱ), ƵΪ38KHZ, 26.3us
u8      TxTime;     //ʱ

/*************  غ    **************/
void    delay_ms(u8 ms);
void    IO_KeyScan(void);
void    PWM_config(void);
void    IR_TxPulse(u16 pulse);
void    IR_TxSpace(u16 pulse);
void    IR_TxByte(u8 dat);
void    IR_TxOff(void);
/*********************  *************************/
void main(void)
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x30;   P0M0 = 0x30;   //P0.4P0.5Ϊ©·(ʵ赽3.3V)
    P1M1 = 0x30;   P1M0 = 0x30;   //P1.4P1.5Ϊ©·(ʵ赽3.3V)
    P2M1 = 0x3c;   P2M0 = 0x3c;   //P2.2~P2.5Ϊ©·(ʵ赽3.3V)
    P3M1 = 0x50;   P3M0 = 0x50;   //P3.4P3.6Ϊ©·(ʵ赽3.3V)
    P4M1 = 0x3c;   P4M0 = 0x3c;   //P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    P5M1 = 0x0c;   P5M0 = 0x0c;   //P5.2P5.3Ϊ©·(ʵ赽3.3V)
    P6M1 = 0xff;   P6M0 = 0xff;   //Ϊ©·(ʵ赽3.3V)
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    PWM_config();
    P_IR_TX = IR_TX_OFF;
    
    EA = 1;                     //ж
    
    while(1)
    {
        delay_ms(30);       //30ms
        IO_KeyScan();

        if(KeyCode != 0)        //⵽
        {
            TxTime = 0;
                                //һ֡С = 9 + 4.5 + 0.5625 + 24 * 1.125 + 8 * 2.25 = 59.0625 ms
                                //һ֡󳤶 = 9 + 4.5 + 0.5625 + 8 * 1.125 + 24 * 2.25 = 77.0625 ms
            IR_TxPulse(342);    //Ӧ9msͬͷ       9ms
            IR_TxSpace(171);    //Ӧ4.5msͬͷ 4.5ms
            IR_TxPulse(21);     //ʼ          0.5625ms

            IR_TxByte(User_code%256);   //ûֽ
            IR_TxByte(User_code/256);   //ûֽ
            IR_TxByte(KeyCode);         //
            IR_TxByte(~KeyCode);        //ݷ
            
            if(TxTime < 56)     //һ֡77ms, Ļ,ʱ     108ms
            {
                TxTime = 56 - TxTime;
                TxTime = TxTime + TxTime / 8;
                delay_ms(TxTime);
            }
            delay_ms(31);

            while(IO_KeyState != 0) //δͷ
            {
                IR_TxPulse(342);    //Ӧ9ms   ͬͷ        9ms
                IR_TxSpace(86);     //Ӧ2.25msͬͷ    2.25ms
                IR_TxPulse(21);     //ʼ              0.5625ms
                delay_ms(96);
                IO_KeyScan();
            }
            IR_TxOff();         //رպⷢ
            KeyCode = 0;
        }
    }
}

//========================================================================
// : void delay_ms(unsigned char ms)
// : ʱ
// : ms,Ҫʱms, ֻ֧1~255ms. ԶӦʱ.
// : none.
// 汾: VER1.0
// : 2013-4-1
// ע: 
//========================================================================
void delay_ms(u8 ms)
{
     u16 i;
     do{
          i = MAIN_Fosc / 6000;
          while(--i);
     }while(--ms);
}

/*****************************************************
    мɨ
    ʹXY4x4ķֻܵٶȿ

   Y     P04      P05      P06      P07
          |        |        |        |
X         |        |        |        |
P00 ---- K00 ---- K01 ---- K02 ---- K03 ----
          |        |        |        |
P01 ---- K04 ---- K05 ---- K06 ---- K07 ----
          |        |        |        |
P02 ---- K08 ---- K09 ---- K10 ---- K11 ----
          |        |        |        |
P03 ---- K12 ---- K13 ---- K14 ---- K15 ----
          |        |        |        |
******************************************************/


u8 code T_KeyTable[16] = {0,1,2,0,3,0,0,0,4,0,0,0,0,0,0,0};

void IO_KeyDelay(void)
{
    u8 i;
    i = 60;
    while(--i)  ;
}

void IO_KeyScan(void)    //50ms call
{
    u8  j;

    j = IO_KeyState1;   //һ״̬

    P0 = 0xf0;  //XͣY
    IO_KeyDelay();
    IO_KeyState1 = P0 & 0xf0;

    P0 = 0x0f;  //YͣX
    IO_KeyDelay();
    IO_KeyState1 |= (P0 & 0x0f);
    IO_KeyState1 ^= 0xff;   //ȡ
    
    if(j == IO_KeyState1)   //ζ
    {
        j = IO_KeyState;
        IO_KeyState = IO_KeyState1;
        if(IO_KeyState != 0)    //м
        {
            F0 = 0;
            if(j == 0)  F0 = 1; //һΰ
            else if(j == IO_KeyState)
            {
                if(++IO_KeyHoldCnt >= 20)   //1ؼ
                {
                    IO_KeyHoldCnt = 18;
                    F0 = 1;
                }
            }
            if(F0)
            {
                j = T_KeyTable[IO_KeyState >> 4];
                if((j != 0) && (T_KeyTable[IO_KeyState& 0x0f] != 0)) 
                    KeyCode = (j - 1) * 4 + T_KeyTable[IO_KeyState & 0x0f] + 16;    //룬17~32
            }
        }
        else    IO_KeyHoldCnt = 0;
    }
    P0 = 0xff;
}


/************* 庯 **************/
void IR_TxPulse(u16 pulse)
{
    tx_cnt = pulse;
    PWMA_CCER2 = 0x00; //д CCMRx ǰ CCxE رͨ
    PWMA_CCMR4 = 0x60; // PWM4 ģʽ1 
    PWMA_CCER2 = 0x70; //ʹ CC4NE ͨ, ͵ƽЧ
    PWMA_IER = 0x10;   //ʹܲ/Ƚ 4 ж
    while(tx_cnt);
}

/************* Ϳк **************/
void IR_TxSpace(u16 pulse)
{
    tx_cnt = pulse;
    PWMA_CCER2 = 0x00; //д CCMRx ǰ CCxE رͨ
    PWMA_CCMR4 = 0x40; // PWM4 ǿΪЧƽ
    PWMA_CCER2 = 0x70; //ʹ CC4NE ͨ, ͵ƽЧ
    PWMA_IER = 0x10;   //ʹܲ/Ƚ 4 ж
    while(tx_cnt);
}

/************* ͽ **************/
void IR_TxOff(void)
{
    PWMA_CCER2 = 0x00; //д CCMRx ǰ CCxE رͨ
    PWMA_CCMR4 = 0x50; // PWM4 ǿΪЧƽ
    PWMA_CCER2 = 0x70; //ʹ CC4NE ͨ, ͵ƽЧ
}

/************* һֽں **************/
void IR_TxByte(u8 dat)
{
    u8 i;
    for(i=0; i<8; i++)
    {
        if(dat & 1)     IR_TxSpace(63), TxTime += 2;    //1Ӧ 1.6875 + 0.5625 ms 
        else            IR_TxSpace(21), TxTime++;       //0Ӧ 0.5625 + 0.5625 ms
        IR_TxPulse(21);         //嶼0.5625ms
        dat >>= 1;              //һλ
    }
}

//========================================================================
// : void   PWM_config(void)
// : PCAú.
// : None
// : none.
// 汾: V1.0, 2012-11-22
//========================================================================
void PWM_config(void)
{
    PWMA_CCER2 = 0x00; //д CCMRx ǰ CCxE رͨ
    PWMA_CCMR4 = 0x60; // PWM4 ģʽ1 
    //PWMA_CCER2 = 0xB0; //ʹ CC4E ͨ, ͵ƽЧ

    PWMA_ARRH = 0x02; //ʱ
    PWMA_ARRL = 0x77;
    PWMA_CCR4H = 0;
    PWMA_CCR4L = 210; //ռձʱ

    PWMA_PS = 0x40;  //߼ PWM ͨ 4N ѡλ, 0x00:P1.7, 0x40:P2.7, 0x80:P6.7, 0xC0:P3.3
//  PWMA_PS = 0x40;  //߼ PWM ͨ 4P ѡλ, 0x00:P1.6, 0x40:P2.6, 0x80:P6.6, 0xC0:P3.4
    PWMA_ENO = 0x80; //ʹ PWM4N 
//  PWMA_ENO = 0x40; //ʹ PWM4P 
    PWMA_BKR = 0x80; //ʹ
//    PWMA_IER = 0x10; //ʹж
    PWMA_CR1 |= 0x81;  //ʹARRԤװأʼʱ
}

/******************* PWMжϺ ********************/
void PWMA_ISR() interrupt PWMA_VECTOR
{
    if(PWMA_SR1 & 0X10)
    {
        PWMA_SR1 &=~0X10;
        //PWMA_SR1 = 0;
        if(--tx_cnt == 0)
        {
            PWMA_CCER2 = 0x00; //д CCMRx ǰ CCxE رͨ
            PWMA_CCMR4 = 0x40; // PWM4 ǿΪЧƽ
            PWMA_CCER2 = 0x70; //ʹ CC4NE ͨ, ͵ƽЧ
            PWMA_IER = 0x00;   // رж
        }
    }
}

