/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ        */
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻STC32GΪоƬʵбдԡ

ʹKeil C251Memory ModelƼXSmallģʽĬ϶edataʱӴȡٶȿ졣

edata鱣1Kջʹãռ䲻ʱɽ顢ñxdataؼֶ嵽xdataռ䡣

ADCⲿѹʹڲ׼ѹ.

STCMCUIOʽ8λܡ

ʹTimer016λԶװ1ms,, û޸MCUʱƵʱ,Զʱ1ms.

ұ4λʾĵѹֵ.

ⲿѹӰϲµ, ѹ0~VDD, ҪVDD0V. 

ʵĿʹ봮һ1Kĵ赽ADC, ADCٲһݵ.

ʱ, ѡʱ 24MHz (û޸Ƶ).

******************************************/

#include "..\..\comm\STC32G.h"

#include "stdio.h"
#include "intrins.h"

typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;

#define MAIN_Fosc        24000000UL

/****************************** û ***********************************/
#define DIS_DOT     0x20
#define DIS_BLACK   0x10
#define DIS_        0x11

#define P1n_pure_input(bitn)        P1M1 |=  (bitn),    P1M0 &= ~(bitn)

    #define Cal_MODE    0   //ÿβֻ1ADC. ֱ0.01V
//  #define Cal_MODE    1   //ÿβ16ADC ƽ. ֱ0.01V

#define Timer0_Reload   (65536UL -(MAIN_Fosc / 1000))       //Timer 0 жƵ, 1000/
	
/*****************************************************************************/


/*************  س    **************/
u8 code t_display[]={                       //׼ֿ
//   0    1    2    3    4    5    6    7    8    9    A    B    C    D    E    F
    0x3F,0x06,0x5B,0x4F,0x66,0x6D,0x7D,0x07,0x7F,0x6F,0x77,0x7C,0x39,0x5E,0x79,0x71,
//black  -     H    J    K    L    N    o   P    U     t    G    Q    r   M    y
    0x00,0x40,0x76,0x1E,0x70,0x38,0x37,0x5C,0x73,0x3E,0x78,0x3d,0x67,0x50,0x37,0x6e,
    0xBF,0x86,0xDB,0xCF,0xE6,0xED,0xFD,0x87,0xFF,0xEF,0x46};    //0. 1. 2. 3. 4. 5. 6. 7. 8. 9. -1

u8 code T_COM[]={0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80};      //λ

/*************  ر    **************/
u8  LED8[8];        //ʾ
u8  display_index;  //ʾλ
bit B_1ms;          //1ms־

u16 msecond;
u16 Bandgap;    //

/*************  غ    **************/
u16 Get_ADC12bitResult(u8 channel); //channel = 0~15


/*********************  *************************/
void main(void)
{
    u8  i;
    u16 j;

    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x30;   P0M0 = 0x30;   //P0.4P0.5Ϊ©·(ʵ赽3.3V)
    P1M1 = 0x3a;   P1M0 = 0x32;   //P1.1P1.4P1.5Ϊ©·(ʵ赽3.3V), P1.1PWMDAC·ͨ贮P2.3,  P1.3 Ϊ ADC 
    P2M1 = 0x3c;   P2M0 = 0x3c;   //P2.2~P2.5Ϊ©·(ʵ赽3.3V)
    P3M1 = 0x50;   P3M0 = 0x50;   //P3.4P3.6Ϊ©·(ʵ赽3.3V)
    P4M1 = 0x3c;   P4M0 = 0x3c;   //P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    P5M1 = 0x0c;   P5M0 = 0x0c;   //P5.2P5.3Ϊ©·(ʵ赽3.3V)
    P6M1 = 0xff;   P6M0 = 0xff;   //Ϊ©·(ʵ赽3.3V)
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    display_index = 0;

    ADCTIM = 0x3f;		// ADC ڲʱADCʱ佨ֵ
    ADCCFG = 0x2f;		// ADC ʱΪϵͳʱ/2/16
    ADC_CONTR = 0x80; //ʹ ADC ģ

    AUXR = 0x80;    //Timer0 set as 1T, 16 bits timer auto-reload, 
    TH0 = (u8)(Timer0_Reload / 256);
    TL0 = (u8)(Timer0_Reload % 256);
    ET0 = 1;    //Timer0 interrupt enable
    TR0 = 1;    //Tiner0 run
    EA = 1;     //ж
    
    for(i=0; i<8; i++)  LED8[i] = 0x10; //ϵ

    while(1)
    {
        if(B_1ms)   //1ms
        {
            B_1ms = 0;
            if(++msecond >= 300)    //300ms
            {
                msecond = 0;

            #if (Cal_MODE == 0)
            //=================== ֻ1ADC, 12bit ADC. ֱ0.01V ===============================
                //Get_ADC12bitResult(15);  //ȶһβ, ڲĲݵĵѹֵ.
                Bandgap = Get_ADC12bitResult(15);    //ڲ׼ADC, 15ͨ
                j = Get_ADC12bitResult(3);  //ⲿѹADC
                j = (u16)((u32)j * 119 / Bandgap);  //ⲿѹ, BandgapΪ1.19V, ѹֱ0.01V
            #endif
            //==========================================================================

            //===== 16ADC ƽ. ֱ0.01V =========
            #if (Cal_MODE == 1)
                //Get_ADC12bitResult(15);  //ȶһβ, ڲĲݵĵѹֵ.
                for(j=0, i=0; i<16; i++)
                {
                    j += Get_ADC12bitResult(15); //ڲ׼ADC, 15ͨ
                }
                Bandgap = j >> 4;   //16ƽ
                for(j=0, i=0; i<16; i++)
                {
                    j += Get_ADC12bitResult(3); //ⲿѹADC
                }
                j = j >> 4; //16ƽ
                j = (u16)((u32)j * 119 / Bandgap);  //ⲿѹ, BandgapΪ1.19V, ѹֱ0.01V
            #endif
            //==========================================================================

                LED8[5] = j / 100 + DIS_DOT;    //ʾⲿѹֵ
                LED8[6] = (j % 100) / 10;
                LED8[7] = j % 10;
/*
                j = Bandgap;
                LED8[0] = j / 1000;     //ʾBandgap ADCֵ
                LED8[1] = (j % 1000) / 100;
                LED8[2] = (j % 100) / 10;
                LED8[3] = j % 10;
*/
            }
        }
    }
}


//========================================================================
// : u16 Get_ADC12bitResult(u8 channel)
// : ѯһADC.
// : channel: ѡҪתADC.
// : 12λADC.
// 汾: V1.0, 2012-10-22
//========================================================================
u16 Get_ADC12bitResult(u8 channel)  //channel = 0~15
{
    ADC_RES = 0;
    ADC_RESL = 0;

    ADC_CONTR = (ADC_CONTR & 0xf0) | channel; //ADCתͨ
    ADC_START = 1;//ADCת
    _nop_();
    _nop_();
    _nop_();
    _nop_();

    while(ADC_FLAG == 0);   //wait for ADC finish
    ADC_FLAG = 0;     //ADC־
    return  (((u16)ADC_RES << 8) | ADC_RESL);
}

/********************** ʾɨ躯 ************************/
void DisplayScan(void)
{   
    P7 = ~T_COM[7-display_index];
    P6 = ~t_display[LED8[display_index]];
    if(++display_index >= 8)    display_index = 0;  //8λ0
}

/********************** Timer0 1msжϺ ************************/
void timer0 (void) interrupt 1
{
    DisplayScan();  //1msɨʾһλ
    B_1ms = 1;      //1ms־
}

