/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ        */
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻STC32GΪоƬʵ9.6汾бдԡ

ʹKeil C251Memory ModelƼXSmallģʽĬ϶edataʱӴȡٶȿ졣

edata鱣1Kջʹãռ䲻ʱɽ顢ñxdataؼֶ嵽xdataռ䡣

128*64LCDʾ

ʾͼΣ֣Ӣģ

ʱ, ѡʱ 24MHz (û޸Ƶ).

******************************************/

#include "..\comm\STC32G.h"

#include "stdio.h"
#include "intrins.h"

typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;

#define MAIN_Fosc        24000000UL

/****************************** û ***********************************/
sbit    LCD_RS = P4^5;  //
sbit    LCD_RW = P4^2;  //9.5汾֮ǰʵҪP42P44Եʹ
sbit    LCD_E  = P4^4;
//sbit    PSB    = P3^5;      //PSBΪ12864ĴͨѶлʹ8λнӿڣPSB=1
sbit    LCD_RESET   =   P3^4;   //  17---RESET  L-->Enable
#define LCD_Data P6

#define Busy    0x80 //ڼLCD״̬еBusyʶ
/*****************************************************************************/

/*************  س    **************/
u8  code uctech[] = {"ͨо΢  "};
u8  code net[]    = {" www.stcmcu.com "};
u8  code mcu[]    = {"רҵ51Ƭ"};
u8  code qq[]     = {" QQ: 800003751  "};

    //128*64ͼ
u8 code gImage_gxw[1024] = { /* 0X10,0X01,0X00,0X80,0X00,0X40, */
0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X00,0X3F,0X03,0XF0,0X3F,0X03,0XF0,0X00,0X00,0X00,0X0C,0X00,0X00,0X00,0XC0,0X00,
0X00,0X21,0X02,0X10,0X21,0X02,0X10,0X00,0X00,0X00,0X0C,0X00,0X18,0XFF,0XE0,0X00,
0X00,0X21,0X02,0X10,0X21,0X02,0X10,0X00,0X00,0X00,0X08,0X1C,0X1C,0X1B,0X00,0X00,
0X00,0X21,0X02,0X10,0X21,0X02,0X10,0X00,0X00,0X1F,0XFF,0XFE,0X0C,0X0E,0X00,0X00,
0X00,0X21,0X02,0X10,0X21,0X02,0X10,0X00,0X00,0X00,0X0C,0X00,0X00,0X8C,0X60,0X00,
0X00,0X21,0X02,0X10,0X21,0X02,0X10,0X00,0X00,0X04,0X0C,0X10,0X00,0XFF,0XF0,0X00,
0X00,0X21,0X02,0X10,0X21,0X02,0X10,0X00,0X00,0X07,0XFF,0XF8,0X0C,0XCC,0X60,0X00,
0X00,0X21,0X02,0X10,0X21,0X02,0X10,0X00,0X00,0X06,0X63,0X18,0X7E,0XCC,0X60,0X00,
0X7F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF8,0X00,0X06,0X33,0X98,0X0C,0XFF,0XE0,0X00,
0X7F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF8,0X00,0X06,0X32,0X18,0X0C,0XCC,0X60,0X00,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0X00,0X06,0X05,0XD8,0X0C,0XCC,0X60,0X00,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0X00,0X06,0XFF,0X78,0X0C,0XFF,0XE0,0X00,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0X00,0X06,0X08,0XD8,0X0C,0XCC,0X60,0X00,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0X00,0X07,0XFF,0XF8,0X0C,0XCC,0X60,0X00,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0X00,0X06,0X0C,0X18,0X0C,0XCF,0XE0,0X00,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0X00,0X06,0X0C,0X18,0X3E,0X80,0X40,0X00,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0X00,0X06,0X0C,0X18,0X73,0XC0,0X00,0X00,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0X00,0X06,0X0D,0XF0,0X20,0X7F,0XF8,0X00,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0X00,0X06,0X00,0X30,0X00,0X00,0X00,0X00,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0X00,0X06,0X00,0X18,0X01,0X84,0X00,0X00,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0X00,0X07,0XFF,0XFC,0X01,0XC6,0X00,0X00,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0X00,0X06,0X00,0X58,0X01,0X86,0X30,0X00,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0X00,0X07,0XFF,0XD8,0X7F,0XFF,0XF8,0X00,
0X60,0X00,0XFD,0X1F,0XF0,0X7A,0X00,0X18,0X00,0X06,0X0C,0X18,0X01,0X86,0X00,0X00,
0X60,0X01,0X87,0X13,0X30,0XC6,0X00,0X18,0X00,0X06,0X0C,0X18,0X01,0X86,0X00,0X00,
0X60,0X03,0X03,0X33,0X11,0X83,0X00,0X18,0X00,0X06,0X0C,0X18,0X00,0X40,0X00,0X00,
0X60,0X03,0X03,0X03,0X01,0X83,0X00,0X18,0X00,0X06,0X0C,0XD8,0X00,0X30,0X00,0X00,
0X60,0X03,0X80,0X03,0X03,0X80,0X00,0X18,0X00,0X06,0XFF,0XF8,0X03,0X38,0X00,0X00,
0X60,0X01,0XC0,0X03,0X03,0X00,0X00,0X18,0X00,0X06,0X0F,0X18,0X0B,0X98,0X80,0X00,
0X60,0X00,0X78,0X03,0X03,0X00,0X00,0X18,0X00,0X06,0X0D,0X98,0X0B,0X18,0XC0,0X00,
0X60,0X00,0X1E,0X03,0X03,0X00,0X00,0X18,0X00,0X06,0X0C,0XD8,0X1B,0X00,0X70,0X00,
0X60,0X00,0X07,0X03,0X03,0X00,0X00,0X18,0X00,0X06,0X0C,0X18,0X1B,0X01,0X30,0X00,
0X60,0X00,0X03,0X03,0X03,0X80,0X00,0X18,0X00,0X06,0X0C,0XD8,0X3B,0X01,0X30,0X00,
0X60,0X03,0X03,0X03,0X03,0X83,0X00,0X18,0X00,0X07,0XF7,0XB8,0X33,0X01,0X80,0X00,
0X60,0X03,0X03,0X03,0X01,0X82,0X00,0X18,0X00,0X06,0X00,0X18,0X03,0X01,0X80,0X00,
0X60,0X01,0XC6,0X03,0X01,0XC6,0X00,0X18,0X00,0X07,0XFF,0XF8,0X01,0XFF,0X80,0X00,
0X60,0X01,0X7C,0X07,0XC0,0X7C,0X00,0X18,0X00,0X06,0X00,0X18,0X00,0X00,0X00,0X00,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0X00,0X04,0X00,0X00,0X00,0X00,0X00,0X00,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0X21,0X86,0X00,0X07,0X00,0X00,0X00,0X10,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0X31,0X86,0X00,0X07,0X00,0X03,0XFF,0XF8,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0X65,0X66,0X00,0X02,0X00,0X00,0X00,0X68,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0XC7,0X7C,0X00,0X02,0X08,0X00,0X00,0XC0,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0X95,0X6C,0X41,0XFF,0XFC,0X00,0X03,0X80,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X19,0X3D,0X6F,0XE1,0X82,0X0C,0X00,0X0E,0X00,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0X3E,0XE9,0XA1,0X82,0X0C,0X00,0X0E,0X00,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0X60,0X59,0X81,0X82,0X0C,0X00,0X0C,0X0C,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0X6F,0XFD,0X81,0XFF,0XFC,0X1F,0XFF,0XFE,
0X60,0X00,0X00,0X00,0X00,0X00,0X00,0X18,0XE0,0X15,0X81,0X82,0X0C,0X00,0X0C,0X02,
0X7F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF8,0XA6,0X45,0X81,0X82,0X0C,0X00,0X0C,0X00,
0X7F,0XFF,0XFF,0XFF,0XFF,0XFF,0XFF,0XF9,0X27,0XC7,0X01,0X82,0X0C,0X00,0X0C,0X00,
0X00,0X21,0X02,0X10,0X21,0X02,0X10,0X00,0X26,0X47,0X01,0XFF,0XFC,0X00,0X0C,0X00,
0X00,0X21,0X02,0X10,0X21,0X02,0X10,0X00,0X26,0X5F,0X01,0X82,0X0B,0X00,0X0C,0X00,
0X00,0X21,0X02,0X10,0X21,0X02,0X10,0X00,0X26,0X77,0X01,0X02,0X03,0X00,0X0C,0X00,
0X00,0X21,0X02,0X10,0X21,0X02,0X10,0X00,0X26,0XEF,0X80,0X02,0X03,0X00,0X0C,0X00,
0X00,0X21,0X02,0X10,0X21,0X02,0X10,0X00,0X24,0X59,0XC0,0X02,0X03,0X00,0X0C,0X00,
0X00,0X21,0X02,0X10,0X21,0X02,0X10,0X00,0X38,0X30,0XE0,0X03,0XFF,0X80,0X7C,0X00,
0X00,0X21,0X02,0X10,0X21,0X02,0X10,0X00,0X38,0XE0,0X00,0X00,0X00,0X00,0X18,0X00,
0X00,0X3F,0X03,0XF0,0X3F,0X03,0XF0,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,
};


/*************  ر    **************/


/*************  غ    **************/
void    delay_ms(u16 ms);
void    WriteDataLCD(u8 WDLCD);
void    WriteCommandLCD(u8 WCLCD,u8 BuysC);
u8      ReadDataLCD(void);
u8      ReadStatusLCD(void);
void    LCDInit(void);
void    LCDClear(void);
void    LCDFlash(void);
void    DisplayOneChar(u8 X, u8 Y, u8 DData);
void    DisplayListChar(u8 X, u8 Y, u8 code *DData);
void    DisplayImage (u8 code *DData);

/*********************  *************************/
void main(void)
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x30;   P0M0 = 0x30;   //P0.4P0.5Ϊ©·(ʵ赽3.3V)
    P1M1 = 0x3a;   P1M0 = 0x32;   //P1.1P1.4P1.5Ϊ©·(ʵ赽3.3V), P1.1PWMDAC·ͨ贮P2.3,  P1.3 Ϊ ADC 
    P2M1 = 0x3c;   P2M0 = 0x3c;   //P2.2~P2.5Ϊ©·(ʵ赽3.3V)
    P3M1 = 0x50;   P3M0 = 0x50;   //P3.4P3.6Ϊ©·(ʵ赽3.3V)
    P4M1 = 0x3c;   P4M0 = 0x3c;   //P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    P5M1 = 0x0c;   P5M0 = 0x0c;   //P5.2P5.3Ϊ©·(ʵ赽3.3V)
    P6M1 = 0xff;   P6M0 = 0xff;   //Ϊ©·(ʵ赽3.3V)
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    delay_ms(100); //ȴLCD빤״̬
    LCDInit(); //LCMʼ
    delay_ms(5); //ʱƬ(ɲҪ)

    while(1)
    {
        LCDClear();
        DisplayImage(gImage_gxw);//ʾͼ
        delay_ms(3000);
        LCDClear();
        DisplayListChar(0,1,uctech);    //ʾֿе
        DisplayListChar(0,2,net);       //ʾֿе
        DisplayListChar(0,3,mcu);       //ʾֿе
        DisplayListChar(0,4,qq);        //ʾֿе
        delay_ms(3000);
    }
}


//========================================================================
// : void delay_ms(u8 ms)
// : ʱ
// : ms,Ҫʱms, ֻ֧1~255ms. ԶӦʱ.
// : none.
// 汾: VER1.0
// : 2013-4-1
// ע: 
//========================================================================
void delay_ms(u16 ms)
{
    u16 i;
    do{
        i = MAIN_Fosc / 6000;
        while(--i);
    }while(--ms);
}


//******************************************
void LCD_delay(void)
{
    NOP(30);    //ѹͣIOڷתٶȱźҪʱʱ
    NOP(30);
}


//д
void WriteDataLCD(u8 WDLCD)
{
    ReadStatusLCD(); //æ 
    LCD_RS = 1;
    LCD_delay();
    LCD_RW = 0;
    LCD_Data = WDLCD;
    LCD_delay();
    LCD_E = 1;
    LCD_delay();
    LCD_E = 0;
}

//дָ
void WriteCommandLCD(u8 WCLCD,u8 BuysC) //BuysCΪ0ʱæ
{
    if (BuysC) ReadStatusLCD(); //Ҫæ 
    LCD_RS = 0;
    LCD_delay();
    LCD_RW = 0; 
    LCD_Data = WCLCD;
    LCD_delay();
    LCD_E = 1; 
    LCD_delay();
    LCD_E = 0;  
}

//״̬
u8 ReadStatusLCD(void)
{
    LCD_Data = 0xFF; 

    LCD_RS = 0;
    LCD_delay();
    LCD_RW = 1; 
    LCD_delay();
    LCD_E = 1;
    LCD_delay();
    while (LCD_Data & Busy); //æź
    LCD_E = 0;

    return(LCD_Data);
}

void LCDInit(void) //LCMʼ
{
//  PSB = 1;    //
//  PSB = 0;    //SPI
    delay_ms(10);
    LCD_RESET = 0;
    delay_ms(10);
    LCD_RESET = 1;
    delay_ms(100);
    
    WriteCommandLCD(0x30,1); //ʾģʽ,ʼҪÿμæź
    WriteCommandLCD(0x01,1); //ʾ
    WriteCommandLCD(0x06,1); // ʾƶ
    WriteCommandLCD(0x0C,1); // ʾ
}

void LCDClear(void) //
{
    WriteCommandLCD(0x01,1); //ʾ
    WriteCommandLCD(0x34,1); // ʾƶ
    WriteCommandLCD(0x30,1); // ʾ
}


//ָλʾһַ
void DisplayListChar(u8 X, u8 Y, u8 code *DData)
{
    u8 ListLength,X2;
    ListLength = 0;
    X2 = X;
    if(Y < 1)   Y=1;
    if(Y > 4)   Y=4;
    X &= 0x0F; //Xܴ16Y1-4֮
    switch(Y)
    {
        case 1: X2 |= 0X80; break;  //ѡӦַ
        case 2: X2 |= 0X90; break;
        case 3: X2 |= 0X88; break;
        case 4: X2 |= 0X98; break;
    }
    WriteCommandLCD(X2, 1); //͵ַ
    while (DData[ListLength] >= 0x20) //ִβ˳
    {
        if (X <= 0x0F) //XӦС0xF
        {
            WriteDataLCD(DData[ListLength]); //
            ListLength++;
            X++;
        }
    }
}

//ͼʾ122*32
void DisplayImage (u8 code *DData)
{
    u8 x,y,i;
    unsigned int tmp=0;
    for(i=0;i<9;)       //ϰ°ΪʼַͬҪֿ
    {
        for(x=0;x<32;x++)   //32
        {
            WriteCommandLCD(0x34,1);
            WriteCommandLCD((u8)(0x80+x),1);//еַ
            WriteCommandLCD((u8)(0x80+i),1);    //еַ°еַ0X88
            WriteCommandLCD(0x30,1);        
            for(y=0;y<16;y++)   
                WriteDataLCD(DData[tmp+y]);//ȡдLCD
            tmp+=16;        
        }
        i+=8;
    }
    WriteCommandLCD(0x36,1);    //书趨
    WriteCommandLCD(0x30,1);
}

