#include <math.h>
#include <stdlib.h>
#include <string.h>
#include "alg_linearlist.h"
#include "alg_caculate.h"
#include "alg_atof.h"
#include "alg_complex.h"


#define E 2.718282
#define PI 3.141593
#define PI_FONT 'p'                 //PI12864
#define DEGREE_FONT 'd'                //12864

#define check_if(function,value) if(0 == strcmp(strTemp,#function)) return value
#define CASE break;case
#define STACK_PUSH(pTarget,eElem) if(LArray_FALSE == stack_push(pTarget,eElem)){bResult = LArray_FALSE; break;}

extern uchar g_chCalcStatus;
extern double x,y,z;
extern double g_ans;
uchar alg_const_handle(char c);

/***********************************************************************************
	ܣȽϲȼ˳
	βΣoperator1:1 operator2: 2
	أ1ȼڲ2	--LEVEL_BIGGER
		  1ȼСڲ2	--LEVEL_SMALLER
		  1ȼڲ2	--LEVEL_SAME
		  12ԱȲϷ	--LEVEL_INVALID
	⣺ĹǱȽȼʵȳ˳ӼĹ
		  תʽĹҪȽϵǰջȼ˳
***********************************************************************************/
LEVEL_TYPE alg_compare_level(char operator1, char operator2)
{
	char operator1_level, operator2_level;

	//жȼеλ
	switch(operator1)
	{
		case '+' :
		case '-' : operator1_level = 1;	break;

		case '*' :
		case '/' : operator1_level = 2;	break;

		case '^' :		
		case 'i' :									//ʶ
		case '!' :
        case DEGREE_FONT : operator1_level = 3;	break;

        case 'f' : operator1_level = 4; break;        //ʶ

		case '(' :
		case ')' : operator1_level = 5; break;
        default  : return LEVEL_INVALID;
	}
	switch(operator2)
	{
		case '+' :
		case '-' : operator2_level = 1;	break;

		case '*' :
		case '/' : operator2_level = 2;	break;

		case '^' :
		case 'i' :									//ʶ
		case '!' :
        case DEGREE_FONT : operator2_level = 3;	break;

        case 'f' : operator2_level = 4; break;        //ʶ

		case '(' :
		case ')' : operator2_level = 5; break;
        default  : return LEVEL_INVALID;
	}

	//жȼϵ
	if((operator1_level - operator2_level) > 0)
	{
		return LEVEL_BIGGER;
	}
	else if((operator1_level - operator2_level) < 0)
	{
		return LEVEL_SMALLER;
	}
	else
	{
		return LEVEL_SAME;
	}
}

/***********************************************************************************
	ܣжַ
	βΣc:ַ
	أ	--OPERATOR
		  	--NUMBER
		  Ƿ	--INVALID_TYPE
	⣺жַǰֵΪ֡šǷǷ
***********************************************************************************/
TYPE_FLAG alg_judge_type(char c)
{	
	//ͨģʽ
	if(g_chCalcStatus == CALC_NORMAL)
	{
		if (c == '+' ||
			c == '-' ||
			c == '*' ||
			c == '/' ||
			c == '^' ||
			c == '(' ||
			c == ')' ||
			c == '!' ||
	        c == DEGREE_FONT	       //
	        )
		{
			return OPERATOR;
		}
		else if((c>='0' && c<='9') || c=='.')
		{
			return NUMBER;
		}
		else if(alg_const_handle(c) != NO_CONST)    //Ϊ
	    {
	        return CONST_NUM;
	    }
		else if(c == 'l' || c == 's' || c == 'c' || c == 't' || c == 'a')       //ĸs,c,t,lжΪ
		{
		    return FUNCTION;
		}
		else
		{
			return INVALID_TYPE;
		}
	}
	
	//ģʽ
	else if(g_chCalcStatus == CALC_COMPLEX)
	{
		if (c == '+' ||
			c == '-' ||
			c == '*' ||
			c == '/' ||
			c == '^' ||
			c == '(' ||
			c == ')' ||
			c == 'i'					//ʶ
	        )
		{
			return OPERATOR;
		}
		else if((c>='0' && c<='9') || c=='.')
		{
			return NUMBER;
		}
		else if(alg_const_handle(c) != NO_CONST)    //Ϊ
	    {
	        return CONST_NUM;
	    }
		else
		{
			return INVALID_TYPE;
		}
	}

	return INVALID_TYPE;
}


/***********************************************************************************
	ܣ
	βΣc:ַ
	أ
	⣺δ֪жϣжϽΪδ֪תʽ滻
***********************************************************************************/
uchar alg_const_handle(char c)
{
    switch(c)
    {
        case 'e'     : return E_FLAG;
        case PI_FONT : return PI_FLAG;
		case 'x'	 : return X_FLAG;
		case 'y'	 : return Y_FLAG;
		case 'z'	 : return Z_FLAG;
		case 'A'	 : return ANS_FLAG;
    }

    return NO_CONST;
}


/***********************************************************************************
	ܣ
	βΣc:ַ
	أ
	⣺ʶsincosȣתʽУչԺת
***********************************************************************************/
uchar alg_func_handle(char *c)
{
    char strTemp[5] = {0,0,0,0,0};      //ʼһڴ洢ʱ

    strTemp[0] = c[0];
    strTemp[1] = c[1];                  //ȡǰַ
    check_if(ln,LN_FLAG);                //ǷΪ˫ַĺ

    strTemp[2] = c[2];                  //ȡǰַ
    if('h' != c[3])                     //ֹ˫Ǻ
    {
        check_if(log,LOG_FLAG);             //ǷΪַĺ
        check_if(sin,SIN_FLAG);
        check_if(cos,COS_FLAG);
        check_if(tan,TAN_FLAG);
		check_if(abs,ABS_FLAG);
    }

    strTemp[3] = c[3];                  //ȡǰĸַ
    //ǷΪĸַĺ
    check_if(sinh,SINH_FLAG);
    check_if(cosh,COSH_FLAG);
    check_if(tanh,TANH_FLAG);
	check_if(asin,ASIN_FLAG);
    check_if(acos,ACOS_FLAG);
    check_if(atan,ATAN_FLAG);

    return FUNC_INVALID;
}


/***********************************************************************************
	ܣֺͲ
	βΣeElem1,eElem2	LArrayElemṹ
		  nOperator		
		  eResult		LArrayElemָ
	أɹ	--1
		  ʧ	--0
	⣺ڼʽ֣ѹغʽ
***********************************************************************************/
LArray_BOOL alg_calc(LArrayElem *eElem1, char nOperator, LArrayElem *eElem2, LArrayElem *eResult)
{
	uchar i;
	if(g_chCalcStatus == CALC_NORMAL)
	{
		switch (nOperator)
		{
	        case '+' :
	            eResult->elemValue.dbNum = eElem1->elemValue.dbNum + eElem2->elemValue.dbNum;
	            break;
	
	        case '-' :
	            eResult->elemValue.dbNum = eElem1->elemValue.dbNum - eElem2->elemValue.dbNum;
	            break;
	
	        case '*' :
	            eResult->elemValue.dbNum = eElem1->elemValue.dbNum * eElem2->elemValue.dbNum;
	            break;
	
	        case '/' :
	            if (0 == eElem2->elemValue.dbNum)
	            {
	                return LArray_FALSE;
	            }
	
	            eResult->elemValue.dbNum = eElem1->elemValue.dbNum / eElem2->elemValue.dbNum;
	            break;
				
	        case '^' :
	            if (0 > eElem1->elemValue.dbNum && eElem2->elemValue.dbNum != (uchar)eElem2->elemValue.dbNum)
	            {
	                return LArray_FALSE;
	            }
	            eResult->elemValue.dbNum = pow(eElem1->elemValue.dbNum,eElem2->elemValue.dbNum);
	            break;
	
	        case DEGREE_FONT :
	            eResult->elemValue.dbNum = eElem1->elemValue.dbNum * PI / 180;
	            break;
			
			case '!' :
				if (((int)eElem1->elemValue.dbNum != eElem1->elemValue.dbNum) 
					|| eElem1->elemValue.dbNum > 60 || eElem1->elemValue.dbNum < 0 )	//
	            {
	                return LArray_FALSE;
	            }
				if(eElem1->elemValue.dbNum == 1 ||eElem1->elemValue.dbNum == 0)
				{
					eResult->elemValue.dbNum = 1;
					break;
				}
				eResult->elemValue.dbNum = 1;
				for(i=1;i<eElem1->elemValue.dbNum+1;i++)
				{
	            	eResult->elemValue.dbNum = eResult->elemValue.dbNum  * i;
				}
	            break;
				
	        case 'f' :
	            switch((uchar)eElem1->elemValue.dbNum)
	            {
	                case LN_FLAG    :   eResult->elemValue.dbNum = log(eElem2->elemValue.dbNum);
	                CASE LOG_FLAG   :   eResult->elemValue.dbNum = log10(eElem2->elemValue.dbNum);
	                CASE SIN_FLAG   :   eResult->elemValue.dbNum = sin(eElem2->elemValue.dbNum);
	                CASE COS_FLAG   :   eResult->elemValue.dbNum = cos(eElem2->elemValue.dbNum);
	                CASE TAN_FLAG   :   eResult->elemValue.dbNum = tan(eElem2->elemValue.dbNum);
	                CASE SINH_FLAG  :   eResult->elemValue.dbNum = sinh(eElem2->elemValue.dbNum);
	                CASE COSH_FLAG  :   eResult->elemValue.dbNum = cosh(eElem2->elemValue.dbNum);
	                CASE TANH_FLAG  :   eResult->elemValue.dbNum = tanh(eElem2->elemValue.dbNum);
					CASE ASIN_FLAG  :	eResult->elemValue.dbNum = asin(eElem2->elemValue.dbNum);
            		CASE ACOS_FLAG  :	eResult->elemValue.dbNum = acos(eElem2->elemValue.dbNum);
            		CASE ATAN_FLAG  :	eResult->elemValue.dbNum = atan(eElem2->elemValue.dbNum);
					CASE ABS_FLAG	:	eResult->elemValue.dbNum = fabs(eElem2->elemValue.dbNum);
	
	                break;
	            }
	            break;
		}
	}
	
	else if(g_chCalcStatus == CALC_COMPLEX)
	{
		switch (nOperator)
		{
			case '+' :
	            OPERATOR_COMPLEX(plus,eElem1,eElem2,eResult);
	            break;
	
	        case '-' :
	            OPERATOR_COMPLEX(subtract,eElem1,eElem2,eResult);
	            break;
	
	        case '*' :
	            OPERATOR_COMPLEX(multiply,eElem1,eElem2,eResult);
	            break;
	
	        case '/' :
	            if (0 == complex_mod(eElem2))	//ģΪ0
	            {
	                return LArray_FALSE;
	            }
				OPERATOR_COMPLEX(divide,eElem1,eElem2,eResult);
				break;
			
			case '^' :
				if(LArray_FALSE == complex_power(eElem1,eElem2,eResult))
				{
					return LArray_FALSE;
				}
				break;
			
			case 'i' :					//
				eResult->elemValue.dbNum = -(eElem1->dbComplex);
				eResult->dbComplex = eElem1->elemValue.dbNum;		//ʵ鲿
				break;
		}
	}
	
	return LArray_TRUE;
}


/***********************************************************************************
    ܣƶʽĵǰָ뵽һԪ
    βΣ
    أ
    ⣺תʽУжǰһֵλãƶָ뵽һҪжϵλ
***********************************************************************************/
void alg_pmove(char **ppCur)
{
	if(OPERATOR == alg_judge_type((*ppCur)[0]))
	{
		*ppCur +=1;
	}
	else if(CONST_NUM == alg_judge_type((*ppCur)[0]))
	{
		if(ANS_FLAG == alg_const_handle((*ppCur)[0]))
			*ppCur +=3;			//Ans
		else 
			*ppCur +=1;
	}
	else if(FUNCTION == alg_judge_type((*ppCur)[0]))
    {
        switch(alg_func_handle(*ppCur))
        {
            case LN_FLAG  : *ppCur +=2; break;    //ֺ

            case LOG_FLAG :
            case SIN_FLAG :
            case COS_FLAG :
            case TAN_FLAG :
			case ABS_FLAG : *ppCur +=3; break;    //ֺ

            case SINH_FLAG:
            case COSH_FLAG:
            case TANH_FLAG: 
			case ASIN_FLAG :
            case ACOS_FLAG :
            case ATAN_FLAG : *ppCur +=4; break;    //ֺ
        }
    }
	else
	{
		while(NUMBER == alg_judge_type((*ppCur)[0]) && '\0' != (*ppCur)[0])
		{
			*ppCur +=1;
		}
	}
}

/***********************************************************************************
    ܣʽתΪʽ
    βΣpExpression:ַͱʽ pPostArray:ʽԱ
    أ1:תɹ 2:תʧ
    ⣺תʽĺת˵£
	1һջһԱstackʱ洢ջʱ洢ջѭԭԱllڴ洢תɺĺʽ
	2ʽʽַ˿ʼȡַc
			A.c֣֣תɸllĩ
			B.cǷţ
				c'('ֱѹstack
				c')'򽫾stackһ'('֮ǰջԱllĩˣʱ'()'
				c:x
					a.x'-'
					жǷַһֵǣ򽫺ַţͬʱ
					жջǲ'('ǣ򽫺ַţͬʱ
				xǳʶ(e,,...)תֲllĩ
				Ǻƥ䡣ƥʽԱٲһ'f'ʶ
				''ѹ0ѹ'd'
				.ջ'('ֱѹջ
				.ջ'('Ƚȼxȼ߾ѹ룬stackԱĩˣֱxȼߣѹ
	ȼ
	    >>˷>˳>Ӽע⺯''ǵĿġתʽʱʹˣҪֵٴ
	ʽֵʱҪǡ
***********************************************************************************/
LArray_BOOL alg_mid_to_post(char *pExpression, LArray *pPostArray)
{
    uchar minus_flag = 1;                 //һַ־
    uchar function_temp;                   //ǰ״ָ̬
	char *pCur;
	LArrayElem eTop;
	LArray_BOOL bResult;
	LArray laStackOperator;
	
	//ջ
	LArray						*pStackOperator = &laStackOperator;
	LArrayElem					pElem_StackOperator[STACK_SIZE/2];
	//ʼջ
	pStackOperator->pElem 		= pElem_StackOperator;
	pStackOperator->nLength		= 0;
	pStackOperator->nTotalSize	= STACK_SIZE/2;
	
	pCur = pExpression;
	eTop.elemValue.dbNum = 0;
	eTop.dbComplex 		= 0;
	
	bResult	= LArray_TRUE;
	
	//ʽַ
	while(pCur[0] != '\0')
	{
        if (INVALID_TYPE == alg_judge_type(pCur[0]))//벻Ϸ
		{
			bResult	= LArray_FALSE;
			break;
		}

        else if(CONST_NUM == alg_judge_type(pCur[0]))//Ϊ
        {
            eTop.elemType = NUMBER;
            switch(alg_const_handle(pCur[0]))
            {
                case E_FLAG  :  eTop.elemValue.dbNum = E;   break;
                case PI_FLAG :  eTop.elemValue.dbNum = PI;  break;
				case X_FLAG  :  eTop.elemValue.dbNum = x;  break;
				case Y_FLAG  :  eTop.elemValue.dbNum = y;  break;
				case Z_FLAG  :  eTop.elemValue.dbNum = z;  break;
				case ANS_FLAG:	eTop.elemValue.dbNum = g_ans;  break;
            }
			STACK_PUSH(pPostArray, eTop);
        }

		else if(NUMBER == alg_judge_type(pCur[0]))//ֱ뵽Ա
		{
			eTop.elemType			= NUMBER;
			eTop.elemValue.dbNum	= alg_atof(pCur);//strtod(pCur,(char **)NULL);
			STACK_PUSH(pPostArray, eTop);
		}

		else//
		{
		    if(minus_flag == 1)  //ջΪһǰһΪ(,˵
            {
                if(pCur[0] == '-' || pCur[0] == '+')
                {
                    eTop.elemType			= NUMBER;       //ѹ0
                    eTop.elemValue.dbNum	= 0;
                    STACK_PUSH(pPostArray, eTop);
                }
            }
            if(pCur[0] == DEGREE_FONT || pCur[0] == '!') //ǡ!Ҫڴǰ0
            {
                eTop.elemType			= NUMBER;       //ѹ0
                eTop.elemValue.dbNum	= 0;
                STACK_PUSH(pPostArray, eTop);
            }			
			if(pCur[0] == 'i')
			{
				if(minus_flag == 1 || OPERATOR == alg_judge_type(pCur[-1]))			//㸺һҪ1һǲǷ
				{																	//˴漼ɣҪַʼ㸺ԽʲִСַʼ[-1]ᵼԽ
					eTop.elemType			= NUMBER;       //ѹ1
					eTop.elemValue.dbNum	= 1;			//ڽ a+i
					STACK_PUSH(pPostArray, eTop);
				}
				
                eTop.elemType			= NUMBER;       //ѹ0
                eTop.elemValue.dbNum	= 0;
                STACK_PUSH(pPostArray, eTop);
			}
			
            else if(FUNCTION == alg_judge_type(pCur[0]))         //
            {
                eTop.elemType			= NUMBER;
                eTop.elemValue.dbNum    = alg_func_handle(pCur);       //ѹ뺯
                if(FUNC_INVALID == alg_func_handle(pCur))               //ʽ
                {
                    bResult	= LArray_FALSE;
                    break;
                }

                STACK_PUSH(pPostArray, eTop);
                function_temp = pCur[0];
                pCur[0] = 'f';              //Ӻʶ

            }

			if(pCur[0] == '(')//'('
			{
				eTop.elemType				= OPERATOR;
				eTop.elemValue.cOperator	= pCur[0];
				STACK_PUSH(pStackOperator, eTop);
				minus_flag = 1;                 //
			}
			else if (pCur[0] == ')')//')'
			{
				//һֱջѹԱֱ'('
				while (LArray_TRUE == stack_get_top(pStackOperator, &eTop) &&
					   eTop.elemValue.cOperator != '(')
				{
					stack_pop(pStackOperator, &eTop);
                    STACK_PUSH(pPostArray, eTop);
				}

				if (LArray_TRUE == stack_get_top(pStackOperator, &eTop) &&
					eTop.elemValue.cOperator == '(')
				{
					stack_pop(pStackOperator, NULL);//ֱӵ'('
				}
				else
				{
					bResult	= LArray_FALSE;
					break;
				}
			}
			else if (LArray_TRUE == stack_get_top(pStackOperator, &eTop) &&
					 eTop.elemValue.cOperator == '(')//ջԪΪ'('ǰѹջ
			{
				eTop.elemType				= OPERATOR;
				eTop.elemValue.cOperator	= pCur[0];
				STACK_PUSH(pStackOperator,eTop);
			}
			else if (LArray_FALSE == stack_get_top(pStackOperator, &eTop) ||
					 LEVEL_SMALLER == alg_compare_level(eTop.elemValue.cOperator, pCur[0]))
			{
				//ջΪջջȼСڵǰ(ʱǰ())򽫵ǰѹջ
				eTop.elemType				= OPERATOR;
				eTop.elemValue.cOperator	= pCur[0];
				STACK_PUSH(pStackOperator, eTop);
			}
			else
			{

				//ջΪջȼڵڵǰ(ʱǰ()),
				//һֱջѹԱֱ

				while(LArray_TRUE  == stack_get_top(pStackOperator, &eTop) &&
					  eTop.elemValue.cOperator != '(' &&
					  LEVEL_SMALLER != alg_compare_level(eTop.elemValue.cOperator, pCur[0]))
				{
					stack_pop(pStackOperator, &eTop);
                    STACK_PUSH(pPostArray, eTop);
				}

				//ǰջ
				eTop.elemType				= OPERATOR;
				eTop.elemValue.cOperator	= pCur[0];
				STACK_PUSH(pStackOperator, eTop);
			}
		}
        if(pCur[0] != '(')
            minus_flag = 0;                     //յһַ־
        if(pCur[0] == 'f')
            pCur[0] = function_temp;            //ʶ
		alg_pmove(&pCur);
	}

	//ʣµջȫջ뵽Ա
	if (bResult	== LArray_TRUE)
	{
		while (LArray_FALSE == ll_arry_is_empty(pStackOperator))
		{
			stack_pop(pStackOperator, &eTop);
            stack_push(pPostArray, eTop);
		}
	}

	return bResult;
}


/***********************************************************************************
	ܣʽ
	βΣpExpression:ַͱʽ pRealResult:ʵ pImaginaryResult
	أɹ	--1
		  ʧ	--0
	⣺Աãһַ"1+1"ֱӴresultжȡΪʵ鲿
		  ֻʵ㣬鲿ֱӴNULLҪg_chCalcStatusֵú
		  ģʽ
***********************************************************************************/
LArray_BOOL alg_calc_expression(char *pExpression, double *pRealResult, double *pImaginaryResult)
{
	LArrayElem eNum1, eNum2, eResult;
	LArray_BOOL	bResult;
	uchar i;
	LArray laPostArray, laStackNum;

	//Ա
	LArray					  *pPostArray = &laPostArray;
	LArrayElem				  pElem_PostArry[STACK_SIZE];
	//ջ
	LArray					  *pStackNum = &laStackNum;
	LArrayElem				  pElem_StackNum[(STACK_SIZE-6)/4+3];		//Ϊֻ5ȼջ5


	//Աʼ
	pPostArray->pElem			= pElem_PostArry;
	pPostArray->nLength			= 0;
	pPostArray->nTotalSize		= STACK_SIZE;	
	//ʼջ
	pStackNum->pElem 			= pElem_StackNum;
	pStackNum->nLength			= 0;
	pStackNum->nTotalSize		= (STACK_SIZE-6)/4+3;

	//Ԫسʼ
	eResult.elemValue.dbNum = 0;
	eResult.dbComplex 		= 0;
	
	bResult	= LArray_TRUE;
	
	//õʽ
	if(LArray_TRUE == alg_mid_to_post(pExpression, pPostArray))
	{
		//Ա
		for (i = 0; i < pPostArray->nLength; i++)
		{
			if (pPostArray->pElem[i].elemType == NUMBER)
			{
				stack_push(pStackNum, pPostArray->pElem[i]);
			}
			else
			{
				if (LArray_FALSE == stack_pop(pStackNum, &eNum2) ||
					LArray_FALSE == stack_pop(pStackNum, &eNum1))
				{
					//ջ(벻Ϸʱ)
					bResult	= LArray_FALSE;
					break;
				}
				else
				{
					if (LArray_FALSE == alg_calc(&eNum1,
											     pPostArray->pElem[i].elemValue.cOperator,
											     &eNum2,
											     &eResult))
					{
						//(벻Ϸʱ)
						bResult	= LArray_FALSE;
						break;
					}
					else
					{
						eResult.elemType = NUMBER;
						stack_push(pStackNum, eResult);
					}
				}
			}
		}
	}
	else
	{
		bResult	= LArray_FALSE;
	}

	if (bResult	== LArray_TRUE)
	{
		//ջȲ1ʽϷ
		if (ll_arry_get_len(pStackNum) != 1)
		{
			bResult	= LArray_FALSE;
		}
		else
		{
			stack_get_top(pStackNum, &eResult);
			*pRealResult = eResult.elemValue.dbNum;
			*pImaginaryResult = eResult.dbComplex;
		}
	}
	
	return bResult;
}

