/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ        */
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻STC32GΪоƬʵбдԡ

ʹKeil C251Memory ModelƼXSmallģʽĬ϶edataʱӴȡٶȿ졣

edata鱣1Kջʹãռ䲻ʱɽ顢ñxdataؼֶ嵽xdataռ䡣

ʹP6ƣʾϵͳʱԴлЧ

ÿһлһʱԴֱĬIRCƵƵ12ƵPLL 96M 16Ƶڲ32K IRC

ʱ, ѡʱ 24MHz (û޸Ƶ).

******************************************/

#include "..\..\comm\STC32G.h"

#include "stdio.h"
#include "intrins.h"

typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;

#define MAIN_Fosc        24000000UL

/****************************** û ***********************************/

	
/*****************************************************************************/

/*************  س    **************/

#define CKMS            0x80
#define HSIOCK          0x40
#define MCK2SEL_MSK     0x0c
#define MCK2SEL_SEL1    0x00
#define MCK2SEL_PLL     0x04
#define MCK2SEL_PLLD2   0x08
#define MCK2SEL_IRC48   0x0c
#define MCKSEL_MSK      0x03
#define MCKSEL_HIRC     0x00
#define MCKSEL_XOSC     0x01
#define MCKSEL_X32K     0x02
#define MCKSEL_IRC32K   0x03

#define ENCKM           0x80
#define PCKI_MSK        0x60
#define PCKI_D1         0x00
#define PCKI_D2         0x20
#define PCKI_D4         0x40
#define PCKI_D8         0x60

/*************  ر    **************/
u8 ledIndex;
u8 code ledNum[]={0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80};
u8 mode = 1;

/*************  غ    **************/
void  delay_ms(u8 ms);
void  MCLK_Sel(void);

/*********************  *************************/
void main(void)
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x30;   P0M0 = 0x30;   //P0.4P0.5Ϊ©·(ʵ赽3.3V)
    P1M1 = 0x3a;   P1M0 = 0x32;   //P1.1P1.4P1.5Ϊ©·(ʵ赽3.3V), P1.1PWMDAC·ͨ贮P2.3,  P1.3 Ϊ ADC 
    P2M1 = 0x3c;   P2M0 = 0x3c;   //P2.2~P2.5Ϊ©·(ʵ赽3.3V)
    P3M1 = 0x50;   P3M0 = 0x50;   //P3.4P3.6Ϊ©·(ʵ赽3.3V)
    P4M1 = 0x3c;   P4M0 = 0x3c;   //P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    P5M1 = 0x0c;   P5M0 = 0x0c;   //P5.2P5.3Ϊ©·(ʵ赽3.3V)
    P6M1 = 0xff;   P6M0 = 0xff;   //Ϊ©·(ʵ赽3.3V)
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    P40 = 0;		//LED Power On
    ledIndex = 0;

    while(1)
    {
        P6 = ~ledNum[ledIndex];	//
        ledIndex++;
        if(ledIndex > 7)
        {
            ledIndex = 0;
            MCLK_Sel();
        }
        delay_ms(10);
    }
}

//========================================================================
// : void MCLK_Sel(void)
// : ϵͳʱú
// : none.
// : none.
// 汾: VER1.0
// : 2020-7-29
// ע: 
//========================================================================
void MCLK_Sel(void)
{
    if(mode == 0)
    {
        mode++;
        HIRCCR = 0x80; //ڲ IRC
        while (!(HIRCCR & 1)); //ȴʱȶ
        CLKDIV = 0;
        CLKSEL = 0x00; //ѡڲ IRC ( Ĭ )
    }
    else if(mode == 1)
    {
        mode++;
        HIRCCR = 0x80; //ڲ IRC
        while (!(HIRCCR & 1)); //ȴʱȶ
        CLKDIV = 24;   //MCLK/24
        CLKSEL = 0x00; //ѡڲ IRC ( Ĭ )
    }
    else if(mode == 2)
    {
        mode++;
        CLKSEL &= ~CKMS;            //ѡPLL96MΪPLLʱ
        USBCLK |= PCKI_D2;          //ʱ2Ƶ(ѡPLLʱӷƵ,֤ʱΪ12M)
        //PLL
        USBCLK |= ENCKM;            //ʹPLLƵ
        delay_ms(1);                //ȴPLLƵ
        CLKDIV = 16;                //ʱѡƵǰ,÷Ƶϵ,ᵱ

        CLKSEL &= ~MCKSEL_MSK;
        CLKSEL &= ~MCK2SEL_MSK;
        CLKSEL |= MCKSEL_HIRC;      //ѡڲIRCΪʱ
        CLKSEL |= MCK2SEL_PLLD2;    //ѡPLLʱ2ƵʱΪʱ
    }
    else if(mode == 3)
    {
        mode = 0;
        IRC32KCR = 0x80; //ڲ 32K IRC
        while (!(IRC32KCR & 1)); //ȴʱȶ
        CLKDIV = 0x00; //ʱӲƵ
        CLKSEL = 0x03; //ѡڲ 32K
    }
//    else
//    {
//        mode = 0;
//        XOSCCR = 0xc0; //ⲿ
//        while (!(XOSCCR & 1)); //ȴʱȶ
//        CLKDIV = 0x00; //ʱӲƵ
//        CLKSEL = 0x01; //ѡⲿ
//    }
}

//========================================================================
// : void  delay_ms(u8 ms)
// : ʱ
// : ms,Ҫʱms, ֻ֧1~255ms. ԶӦʱ.
// : none.
// 汾: VER1.0
// : 2013-4-1
// ע: 
//========================================================================
void  delay_ms(u8 ms)
{
    u16 i;
    do{
        i = MAIN_Fosc / 6000;
        while(--i);
    }while(--ms);
}

