/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ        */
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻STC32GΪоƬʵбдԡ

ʹKeil C251Memory ModelƼXSmallģʽĬ϶edataʱӴȡٶȿ졣

edata鱣1Kջʹãռ䲻ʱɽ顢ñxdataؼֶ嵽xdataռ䡣

߼PWMʱ PWM1P/PWM1N,PWM2P/PWM2N,PWM3P/PWM3N,PWM4P/PWM4N ÿͨɶʵPWMԳ.

ʾʹPWM1P,PWM1NSPWM.

ʱѡ24MHZ, PWMʱѡ1T, PWM2400, 12ʱ(0.5us).Ҳ200. 

ҲƵ = 24000000 / 2400 / 200 = 50 HZ.

һSPWMʾ, ûͨļ㷽޸PWMںҲĵͷ.

Ƶʹ̶, ҪƵ, ûԼƱƵ.

P6.0(PWM1P), P6.1(PWM1N)().

ʱ, ѡʱ 24MHz (û޸Ƶ).

******************************************/

#include "..\..\comm\STC32G.h"

#include "stdio.h"
#include "intrins.h"
#include "T_SineTable.h"

typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;

#define MAIN_Fosc        24000000UL

/****************************** û ***********************************/
#define PWM1_1      0x00	//P:P1.0  N:P1.1
#define PWM1_2      0x01	//P:P2.0  N:P2.1
#define PWM1_3      0x02	//P:P6.0  N:P6.1

#define PWM2_1      0x00	//P:P1.2/P5.4  N:P1.3
#define PWM2_2      0x04	//P:P2.2  N:P2.3
#define PWM2_3      0x08	//P:P6.2  N:P6.3

#define PWM3_1      0x00	//P:P1.4  N:P1.5
#define PWM3_2      0x10	//P:P2.4  N:P2.5
#define PWM3_3      0x20	//P:P6.4  N:P6.5

#define PWM4_1      0x00	//P:P1.6  N:P1.7
#define PWM4_2      0x40	//P:P2.6  N:P2.7
#define PWM4_3      0x80	//P:P6.6  N:P6.7
#define PWM4_4      0xC0	//P:P3.4  N:P3.3

#define ENO1P       0x01
#define ENO1N       0x02
#define ENO2P       0x04
#define ENO2N       0x08
#define ENO3P       0x10
#define ENO3N       0x20
#define ENO4P       0x40
#define ENO4N       0x80
/*****************************************************************************/

/*************  س    **************/


/*************  ر    **************/
u16 PWM1_Duty;
u8	PWM_Index;	//SPWM

/*************  غ    **************/


/*********************  *************************/
void main(void)
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x30;   P0M0 = 0x30;   //P0.4P0.5Ϊ©·(ʵ赽3.3V)
    P1M1 = 0x32;   P1M0 = 0x32;   //P1.1P1.4P1.5Ϊ©·(ʵ赽3.3V), P1.1PWMDAC·ͨ贮P2.3
    P2M1 = 0x3c;   P2M0 = 0x3c;   //P2.2~P2.5Ϊ©·(ʵ赽3.3V)
    P3M1 = 0x50;   P3M0 = 0x50;   //P3.4P3.6Ϊ©·(ʵ赽3.3V)
    P4M1 = 0x3c;   P4M0 = 0x3c;   //P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    P5M1 = 0x0c;   P5M0 = 0x0c;   //P5.2P5.3Ϊ©·(ʵ赽3.3V)
    P6M1 = 0xff;   P6M0 = 0xff;   //Ϊ©·(ʵ赽3.3V)
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    PWM1_Duty = 1220;

    PWMA_CCER1 = 0x00; //д CCMRx ǰ CCxE رͨ
    PWMA_CCER2 = 0x00;
    PWMA_CCMR1 = 0x60; //ͨģʽ
//    PWMA_CCMR2 = 0x60;
//    PWMA_CCMR3 = 0x60;
//    PWMA_CCMR4 = 0x60;
    PWMA_CCER1 = 0x05; //ͨʹܺͼ
//    PWMA_CCER2 = 0x55;

    PWMA_CCMR1 |= 0x08; //PWMA_CCRxԤתع(ҪCCxE=1ſд)
//    PWMA_CCMR2 |= 0x08;
//    PWMA_CCMR3 |= 0x08;
//    PWMA_CCMR4 |= 0x08;

    PWMA_ARRH = 0x09; //ʱ
    PWMA_ARRL = 0x60;

    PWMA_CCR1H = (u8)(PWM1_Duty >> 8); //ռձʱ
    PWMA_CCR1L = (u8)(PWM1_Duty);

    PWMA_DTR = 0x0C;   //ʱ

    PWMA_ENO = 0x00;
    PWMA_ENO |= ENO1P; //ʹ
    PWMA_ENO |= ENO1N; //ʹ
//    PWMA_ENO |= ENO2P; //ʹ
//    PWMA_ENO |= ENO2N; //ʹ
//    PWMA_ENO |= ENO3P; //ʹ
//    PWMA_ENO |= ENO3N; //ʹ
//    PWMA_ENO |= ENO4P; //ʹ
//    PWMA_ENO |= ENO4N; //ʹ

    //߼PWMŻԶΪģʽ
    PWMA_PS = 0x00;  //߼ PWM ͨѡλ
    PWMA_PS |= PWM1_3; //ѡ PWM1_3 ͨ
//    PWMA_PS |= PWM2_3; //ѡ PWM2_3 ͨ
//    PWMA_PS |= PWM3_3; //ѡ PWM3_3 ͨ
//    PWMA_PS |= PWM4_3; //ѡ PWM4_3 ͨ

    PWMA_BKR = 0x80; //ʹ
    PWMA_IER = 0x01; //ʹж
    PWMA_CR1 |= 0x81; //ʹARRԤװأʼʱ

    EA = 1;     //ж

    while(1)
    {
    }
}


/******************** жϺ **************************/
void PWMA_ISR() interrupt PWMA_VECTOR 
{ 
    if(PWMA_SR1 & 0X01)
    {
        PWMA_SR1 &=~0X01; 
        PWM1_Duty = T_SinTable[PWM_Index];
        if(++PWM_Index >= 200)	PWM_Index = 0;

        PWMA_CCR1H = (u8)(PWM1_Duty >> 8); //ռձʱ
        PWMA_CCR1L = (u8)(PWM1_Duty);
    }
    PWMA_SR1 = 0;
}
