/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ        */
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻STC32GΪоƬʵбдԡ

ʹKeil C251Memory ModelƼXSmallģʽĬ϶edataʱӴȡٶȿ졣

edata鱣1Kջʹãռ䲻ʱɽ顢ñxdataؼֶ嵽xdataռ䡣

ÿ©ģʽҪϿPWMDAC·еR2衣

ͨڷݸMCU1MCU1յSPI͸MCU2MCU2ͨڷͳȥ.

÷ 2
豸ʼʱ SSIG Ϊ 0MSTR Ϊ0ʱ豸ǲ SS Ĵӻģʽ
һ豸Ҫʱȼ SS ܽŵĵƽʱߵƽ
ͽԼóɺ SS ģʽԼ SS ͵ƽͶԷ SS ţɽݴ䡣

         MCU1                          MCU2
  |-----------------|           |-----------------|
  |            MISO |-----------| MISO            |
--| TX         MOSI |-----------| MOSI         TX |--
  |            SCLK |-----------| SCLK            |
--| RX           SS |-----------| SS           RX |--
  |-----------------|           |-----------------|


ʱ, ѡʱ 22.1184MHz (û޸Ƶ).

******************************************/

#include "..\comm\STC32G.h"

#include "stdio.h"
#include "intrins.h"

typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;

#define MAIN_Fosc        22118400L   //ʱӣȷ115200ʣ

/****************************** û ***********************************/
#define Baudrate2           115200L
#define BUF_LENGTH          128

#define UART2_BUF_LENGTH    (BUF_LENGTH)   //ڻ峤
#define SPI_BUF_LENGTH      (BUF_LENGTH)   //SPI峤
/*****************************************************************************/

/*************  س    **************/
sbit    SPI_SS  = P2^2;
sbit    SPI_SI  = P2^3;
sbit    SPI_SO  = P2^4;
sbit    SPI_SCK = P2^5;

/*************  ر    **************/
u8  RX2_TimeOut;
u8  SPI_TimeOut;
u8  SPI_Cnt;    //SPI
u8  RX2_Cnt;    //UART
bit B_TX2_Busy; //æ־
bit B_SPI_Busy; //æ־
bit B_SPI_Send; //ͱ־

u8  RX2_Buffer[UART2_BUF_LENGTH];   //ջ
u8  SPI_Buffer[SPI_BUF_LENGTH];     //ջ

/*************  غ    **************/
void    delay_ms(u8 ms);
void    UART2_config(u8 brt);   // ѡ, 2: ʹTimer2, ֵ: Ч.
void    PrintString2(u8 *puts);
void    UART2_TxByte(u8 dat);

void    SPI_init(void);
void    SPI_WriteByte(u8 out);

/*********************  *************************/
void main(void)
{
    u8 i;

    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x30;   P0M0 = 0x30;   //P0.4P0.5Ϊ©·(ʵ赽3.3V)
    P1M1 = 0x32;   P1M0 = 0x32;   //P1.1P1.4P1.5Ϊ©·(ʵ赽3.3V), P1.1PWMDAC·ͨ贮P2.3
    P2M1 = 0x3c;   P2M0 = 0x3c;   //P2.2~P2.5Ϊ©·(ʵ赽3.3V)ÿ©ģʽҪϿPWMDAC·еR2
    P3M1 = 0x50;   P3M0 = 0x50;   //P3.4P3.6Ϊ©·(ʵ赽3.3V)
    P4M1 = 0x3c;   P4M0 = 0x3c;   //P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    P5M1 = 0x0c;   P5M0 = 0x0c;   //P5.2P5.3Ϊ©·(ʵ赽3.3V)
    P6M1 = 0xff;   P6M0 = 0xff;   //Ϊ©·(ʵ赽3.3V)
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    UART2_config(2);    // ѡ, 2: ʹTimer2, ֵ: Ч.
    SPI_init();
    EA = 1;     //ж
    
    PrintString2("UART2SPI͸-SPIΪ÷2.\r\n");

    while (1)
    {
        delay_ms(1);

        if(RX2_TimeOut > 0)
        {
            if(--RX2_TimeOut == 0)  //ʱ,򴮿ڽս
            {
                if(RX2_Cnt > 0)
                {
                    B_SPI_Send = 1;
                }
            }
        }
        if((B_SPI_Send) && (SPI_SS))
        {
            B_SPI_Send = 0;
            SPI_SS = 0;     //ʹӻ SS ܽ
            SPCTL = 0xd4;   //ʹ SPI ģʽSSŹ
            for(i=0;i<RX2_Cnt;i++)
            {
                SPI_WriteByte(RX2_Buffer[i]); //ʹ
            }
            SPI_SS = 1;    //ߴӻ SS ܽ
            SPCTL = 0x44;  //Ϊӻ
            RX2_Cnt = 0;
        }
				
        if(SPI_TimeOut > 0)
        {
            if(--SPI_TimeOut == 0)  //ʱ,SPIս
            {
                if(SPI_Cnt > 0)
                {
                    for(i=0;i<SPI_Cnt;i++)
                    {
                        UART2_TxByte(SPI_Buffer[i]); //SPI
                    }
                    SPI_Cnt = 0;
                }
            }
        }
    }
}

//========================================================================
// : void  delay_ms(unsigned char ms)
// : ʱ
// : ms,Ҫʱms, ֻ֧1~255ms. ԶӦʱ.
// : none.
// 汾: VER1.0
// : 2013-4-1
// ע: 
//========================================================================
void delay_ms(u8 ms)
{
    u16 i;
    do{
        i = MAIN_Fosc / 6000;
        while(--i);
    }while(--ms);
}

//========================================================================
// : void UART2_TxByte(u8 dat)
// : һֽ.
// : .
// : .
// 汾: V1.0, 2014-6-30
//========================================================================
void UART2_TxByte(u8 dat)
{
    S2BUF = dat;
    B_TX2_Busy = 1;
    while(B_TX2_Busy);
}

//========================================================================
// : void PrintString2(u8 *puts)
// : 2ַ
// : puts:  ַָ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void PrintString2(u8 *puts) //һַ
{
    for (; *puts != 0;  puts++) UART2_TxByte(*puts);    //ֹͣ0
}

//========================================================================
// : SetTimer2Baudraye(u16 dat)
// : Timer2ʷ
// : dat: Timer2װֵ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void SetTimer2Baudraye(u16 dat)  // ѡ, 2: ʹTimer2, ֵ: Ч.
{
    T2R = 0;	//Timer stop
    T2_CT = 0;	//Timer2 set As Timer
    T2x12 = 1;	//Timer2 set as 1T mode
    T2H = (u8)(dat / 256);
    T2L = (u8)(dat % 256);
    ET2 = 0;    //ֹж
    T2R = 1;	//Timer run enable
}

//========================================================================
// : void UART2_config(u8 brt)
// : UART2ʼ
// : brt: ѡ, 2: ʹTimer2, ֵ: Ч.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART2_config(u8 brt)    // ѡ, 2: ʹTimer2, ֵ: Ч.
{
    if(brt == 2)
    {
        SetTimer2Baudraye((u16)(65536UL - (MAIN_Fosc / 4) / Baudrate2));

        S2CFG |= 0x01;     //ʹô2ʱW1λΪ1ܻԤڵĴ
        S2CON = (S2CON & 0x3f) | 0x40;    //UART2ģʽ, 0x00: ͬλ, 0x40: 8λ,ɱ䲨, 0x80: 9λ,̶, 0xc0: 9λ,ɱ䲨
        ES2   = 1;         //ж
        S2REN = 1;         //
        S2_S  = 1;         //UART2 switch to: 0: P1.0 P1.1,  1: P4.6 P4.7

        RX2_TimeOut = 0;
        B_TX2_Busy = 0;
        RX2_Cnt = 0;
    }
}

//========================================================================
// : void UART2_int (void) interrupt UART2_VECTOR
// : UART2жϺ
// : nine.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART2_int (void) interrupt 8
{
    if(S2RI)
    {
        S2RI = 0;    //Clear Rx flag
        RX2_Buffer[RX2_Cnt] = S2BUF;
        if(++RX2_Cnt >= UART2_BUF_LENGTH)   RX2_Cnt = 0;
        RX2_TimeOut = 5;
    }

    if(S2TI)
    {
        S2TI = 0;    //Clear Tx flag
        B_TX2_Busy = 0;
    }
}

/************************************************************************/

void SPI_Isr() interrupt 9 
{ 
    SPSTAT = 0xc0; //жϱ־
    if (MSTR) 
    { //ģʽ
        B_SPI_Busy = 0;
    }
    else 
    { //ӻģʽ
        if(SPI_Cnt >= SPI_BUF_LENGTH) SPI_Cnt = 0;
        SPI_Buffer[SPI_Cnt] = SPDAT;
        SPI_Cnt++;
        SPI_TimeOut = 10;
    }
}

/************************************************************************/
void SPI_WriteByte(u8 out)
{
    SPDAT = out;
    B_SPI_Busy = 1;
    while(B_SPI_Busy);
}

/************************************************************************/
void SPI_init(void)
{
    SPI_SS = 1;
    SPCTL = 0x44;         //ʹ SPI ӻģʽд
    P_SW1 = (P_SW1 & ~(3<<2)) | (1<<2);  //IOл. 0: P1.2/P5.4 P1.3 P1.4 P1.5, 1: P2.2 P2.3 P2.4 P2.5, 2: P5.4 P4.0 P4.1 P4.3, 3: P3.5 P3.4 P3.3 P3.2
    SPIF = 1;               //д1 SPIF־
    WCOL = 1;               //д1 WCOL־
    ESPI = 1;               //ʹ SPI ж

    HSCLKDIV = 0x06;        //ʱ6ƵĬ2Ƶ©·+跽ʽҪSPIƵźŲ
    
    SPI_TimeOut = 0;
    B_SPI_Busy = 0;
    B_SPI_Send = 0;
    SPI_Cnt = 0;
}

