/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ        */
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻STC32GΪоƬʵбдԡ

ʹKeil C251Memory ModelƼXSmallģʽĬ϶edataʱӴȡٶȿ졣

edata鱣1Kջʹãռ䲻ʱɽ顢ñxdataؼֶ嵽xdataռ䡣

ͨUARTӿLINշʵLINźշ.

UART1ͨڹӵ.

UART2LINշ(TJA1020/1), LIN.

Դڷ͵תLIN; LIN߽յתԴ.

һP32ڰ, MCUӴ2һ֡ݵLIN.

Ĭϴʣ9600ʣLINǰлʣ13Լź.

ʱ, ѡʱ 24MHz (û޸Ƶ).

******************************************/

#include "..\comm\STC32G.h"

#include "stdio.h"
#include "intrins.h"

typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;

#define MAIN_Fosc        24000000UL

/****************************** û ***********************************/

#define Baudrate1           (65536UL - (MAIN_Fosc / 4) / 9600UL)
#define Baudrate2           (65536UL - (MAIN_Fosc / 4) / 9600UL)  //ݴ䲨

#define Baudrate_Break      (65536UL - (MAIN_Fosc / 4) / 6647UL)  //ԼźŲ

#define UART1_BUF_LENGTH    32
#define UART2_BUF_LENGTH    32

#define LIN_ID    0x31

/*****************************************************************************/

sbit SLP_N  = P2^4;     //0: Sleep

/*************  س    **************/


/*************  ر    **************/

u8  TX1_Cnt;    //ͼ
u8  RX1_Cnt;    //ռ
u8  TX2_Cnt;    //ͼ
u8  RX2_Cnt;    //ռ
bit B_TX1_Busy; //æ־
bit B_TX2_Busy; //æ־
u8  RX1_TimeOut;
u8  RX2_TimeOut;

u8  Key1_cnt;
bit Key1_Flag;

u8  TX_BUF[8];
u8  RX1_Buffer[UART1_BUF_LENGTH]; //ջ
u8  RX2_Buffer[UART2_BUF_LENGTH]; //ջ

/*************  غ    **************/
void UART1_config(u8 brt);   // ѡ, 2: ʹTimer2, ֵ: ʹTimer1.
void UART2_config(u8 brt);   // ѡ, 2: ʹTimer2, ֵ: Ч.
void PrintString1(u8 *puts);
void delay_ms(u8 ms);
void UART1_TxByte(u8 dat);
void UART2_TxByte(u8 dat);
void LinSendMsg(u8 lid, u8 *pdat);
void SetTimer2Baudraye(u16 dat);

/*********************  *************************/
void main(void)
{
	u8 i;

    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ
	
    P0M1 = 0x30;   P0M0 = 0x30;   //P0.4P0.5Ϊ©·(ʵ赽3.3V)
    P1M1 = 0x32;   P1M0 = 0x32;   //P1.1P1.4P1.5Ϊ©·(ʵ赽3.3V), P1.1PWMDAC·ͨ贮P2.3
    P2M1 = 0x3c;   P2M0 = 0x3c;   //P2.2~P2.5Ϊ©·(ʵ赽3.3V)
    P3M1 = 0x50;   P3M0 = 0x50;   //P3.4P3.6Ϊ©·(ʵ赽3.3V)
    P4M1 = 0x3c;   P4M0 = 0x3c;   //P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    P5M1 = 0x0c;   P5M0 = 0x0c;   //P5.2P5.3Ϊ©·(ʵ赽3.3V)
    P6M1 = 0xff;   P6M0 = 0xff;   //Ϊ©·(ʵ赽3.3V)
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

	UART1_config(1);    // ѡ, 2: ʹTimer2, ֵ: ʹTimer1.
	UART2_config(2);    // ѡ, 2: ʹTimer2, ֵ: Ч.
	EA = 1;             //ȫж
	SLP_N = 1;
	TX_BUF[0] = 0x11;
	TX_BUF[1] = 0x22;
	TX_BUF[2] = 0x33;
	TX_BUF[3] = 0x44;
	TX_BUF[4] = 0x55;
	TX_BUF[5] = 0x66;
	TX_BUF[6] = 0x77;
	TX_BUF[7] = 0x88;

	PrintString1("STC32 UART to LIN Test Programme!\r\n");  //UART1һַ
	
	while(1)
	{
		delay_ms(1);

		if(!P32)
		{
			if(!Key1_Flag)
			{
				Key1_cnt++;
				if(Key1_cnt > 50)
				{
					Key1_Flag = 1;
					LinSendMsg(LIN_ID, TX_BUF);  //һ
				}
			}
		}
		else
		{
			Key1_cnt = 0;
			Key1_Flag = 0;
		}
		
		if(RX1_TimeOut > 0)
		{
			if(--RX1_TimeOut == 0)  //ʱ,򴮿ڽս
			{
				if(RX1_Cnt > 0)
				{
					LinSendMsg(LIN_ID,RX1_Buffer);  //UART1յݷ͵LIN
				}
				RX1_Cnt = 0;
			}
		}

		if(RX2_TimeOut > 0)
		{
			if(--RX2_TimeOut == 0)  //ʱ,򴮿ڽս
			{
				if(RX2_Cnt > 0)
				{
					for (i=0; i < RX2_Cnt; i++)     //ֹͣ0
					{
						UART1_TxByte(RX2_Buffer[i]);  //LINյݷ͵UART1
					}
				}
				RX2_Cnt = 0;
			}
		}
	}
}

//========================================================================
// : void delay_ms(unsigned char ms)
// : ʱ
// : ms,Ҫʱms, ֻ֧1~255ms. ԶӦʱ.
// : none.
// 汾: VER1.0
// : 2013-4-1
// ע: 
//========================================================================
void delay_ms(u8 ms)
{
	u16 i;
	do{
		i = MAIN_Fosc / 6000;
		while(--i);
	}while(--ms);
}

//========================================================================
// : u8 Lin_CheckPID(u8 id)
// : IDУתPID롣
// : ID.
// : PID.
// 汾: VER1.0
// : 2020-12-2
// ע: 
//========================================================================
u8 Lin_CheckPID(u8 id)
{
	u8 returnpid ;
	u8 P0 ;
	u8 P1 ;

	P0 = (((id)^(id>>1)^(id>>2)^(id>>4))&0x01)<<6 ;
	P1 = ((~((id>>1)^(id>>3)^(id>>4)^(id>>5)))&0x01)<<7 ;

	returnpid = id|P0|P1 ;

	return returnpid ;
}

//========================================================================
// : u8 LINCalcChecksum(u8 *dat)
// : У롣
// : ݳ.
// : У.
// 汾: VER1.0
// : 2020-12-2
// ע: 
//========================================================================
static u8 LINCalcChecksum(u8 *dat)
{
	u16 sum = 0;
	u8 i;

	for(i = 0; i < 8; i++)
	{
		sum += dat[i];
		if(sum & 0xFF00)
		{
			sum = (sum & 0x00FF) + 1;
		}
	}
	sum ^= 0x00FF;
	return (u8)sum;
}

//========================================================================
// : void Lin_SendBreak(void)
// : Լźš
// : none.
// : none.
// 汾: VER1.0
// : 2020-12-2
// ע: 
//========================================================================
void Lin_SendBreak(void)
{
	SetTimer2Baudraye((u16)Baudrate_Break);
	UART2_TxByte(0);
	SetTimer2Baudraye((u16)Baudrate2);
}

//========================================================================
// : void LinSendMsg(u8 lid, u8 *pdat)
// : LIN߱ġ
// : ͵LIN ID, ݳ.
// : none.
// 汾: VER1.0
// : 2020-12-2
// ע: 
//========================================================================
void LinSendMsg(u8 lid, u8 *pdat)
{
	u8 i;

	Lin_SendBreak();		//Break
	UART2_TxByte(0x55);		//SYNC
	UART2_TxByte(Lin_CheckPID(lid));		//LIN ID
	for(i=0;i<8;i++)
	{
		UART2_TxByte(pdat[i]);
	}
	UART2_TxByte(LINCalcChecksum(pdat));
}

//========================================================================
// : void UART1_TxByte(u8 dat)
// : һֽ.
// : .
// : .
// 汾: V1.0, 2014-6-30
//========================================================================
void UART1_TxByte(u8 dat)
{
	SBUF = dat;
	B_TX1_Busy = 1;
	while(B_TX1_Busy);
}

//========================================================================
// : void UART2_TxByte(u8 dat)
// : һֽ.
// : .
// : .
// 汾: V1.0, 2014-6-30
//========================================================================
void UART2_TxByte(u8 dat)
{
	S2BUF = dat;
	B_TX2_Busy = 1;
	while(B_TX2_Busy);
}

//========================================================================
// : void PrintString1(u8 *puts)
// : 1ַ
// : puts:  ַָ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void PrintString1(u8 *puts)
{
	for (; *puts != 0;  puts++)     //ֹͣ0
	{
		SBUF = *puts;
		B_TX1_Busy = 1;
		while(B_TX1_Busy);
	}
}

//========================================================================
// : void PrintString2(u8 *puts)
// : 2ַ
// : puts:  ַָ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
//void PrintString2(u8 *puts)
//{
//	for (; *puts != 0;  puts++)     //ֹͣ0
//	{
//			S2BUF = *puts;
//			B_TX2_Busy = 1;
//			while(B_TX2_Busy);
//	}
//}

//========================================================================
// : SetTimer2Baudraye(u16 dat)
// : Timer2ʷ
// : dat: Timer2װֵ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void SetTimer2Baudraye(u16 dat)
{
    T2R = 0;	//Timer stop
    T2_CT = 0;	//Timer2 set As Timer
    T2x12 = 1;	//Timer2 set as 1T mode
    T2H = (u8)(dat / 256);
    T2L = (u8)(dat % 256);
    ET2 = 0;    //ֹж
    T2R = 1;	//Timer run enable
}

//========================================================================
// : void UART1_config(u8 brt)
// : UART1ʼ
// : brt: ѡ, 2: ʹTimer2, ֵ: ʹTimer1.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART1_config(u8 brt)
{
	/*********** ʹöʱ2 *****************/
	if(brt == 2)
	{
        S1BRT = 1;	//S1 BRT Use Timer2;
		SetTimer2Baudraye((u16)Baudrate1);
	}

	/*********** ʹöʱ1 *****************/
	else
	{
		TR1 = 0;
        S1BRT = 0;		//S1 BRT Use Timer1;
        T1_CT = 0;		//Timer1 set As Timer
        T1x12 = 1;		//Timer1 set as 1T mode
        TMOD &= ~0x30;//Timer1_16bitAutoReload;
		TH1 = (u8)(Baudrate1 / 256);
		TL1 = (u8)(Baudrate1 % 256);
		ET1 = 0;    //ֹж
		TR1  = 1;
	}
	/*************************************************/

	SCON = (SCON & 0x3f) | 0x40;    //UART1ģʽ, 0x00: ͬλ, 0x40: 8λ,ɱ䲨, 0x80: 9λ,̶, 0xc0: 9λ,ɱ䲨
//	PS  = 1;    //ȼж
	ES  = 1;    //ж
	REN = 1;    //
	P_SW1 &= 0x3f;
//	P_SW1 |= 0x80;      //UART1 switch to, 0x00: P3.0 P3.1, 0x40: P3.6 P3.7, 0x80: P1.6 P1.7, 0xC0: P4.3 P4.4

	B_TX1_Busy = 0;
	TX1_Cnt = 0;
	RX1_Cnt = 0;
}

//========================================================================
// : void UART2_config(u8 brt)
// : UART2ʼ
// : brt: ѡ, 2: ʹTimer2, ֵ: Ч.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART2_config(u8 brt)    // ѡ, 2: ʹTimer2, ֵ: Ч.
{
	if(brt == 2)
	{
		SetTimer2Baudraye((u16)Baudrate2);

        S2CFG |= 0x01;     //ʹô2ʱW1λΪ1ܻԤڵĴ
		S2CON = (S2CON & 0x3f) | 0x40;    //UART2ģʽ, 0x00: ͬλ, 0x40: 8λ,ɱ䲨, 0x80: 9λ,̶, 0xc0: 9λ,ɱ䲨
        ES2   = 1;         //ж
        S2REN = 1;         //
        S2_S  = 1;         //UART2 switch to: 0: P1.0 P1.1,  1: P4.6 P4.7

		B_TX2_Busy = 0;
		TX2_Cnt = 0;
		RX2_Cnt = 0;
	}
}

//========================================================================
// : void UART1_int (void) interrupt UART1_VECTOR
// : UART1жϺ
// : nine.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART1_int (void) interrupt 4
{
	if(RI)
	{
		RI = 0;
		if(RX1_Cnt >= UART1_BUF_LENGTH) RX1_Cnt = 0;
		RX1_Buffer[RX1_Cnt] = SBUF;
		RX1_Cnt++;
		RX1_TimeOut = 5;
	}

	if(TI)
	{
		TI = 0;
		B_TX1_Busy = 0;
	}
}

//========================================================================
// : void UART2_int (void) interrupt UART2_VECTOR
// : UART2жϺ
// : nine.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART2_int (void) interrupt 8
{
    if(S2RI)
    {
        S2RI = 0;    //Clear Rx flag
		if(RX2_Cnt >= UART2_BUF_LENGTH) RX2_Cnt = 0;
		RX2_Buffer[RX2_Cnt] = S2BUF;
		RX2_Cnt++;
		RX2_TimeOut = 5;
	}

    if(S2TI)
    {
        S2TI = 0;    //Clear Tx flag
		B_TX2_Busy = 0;
	}
}
