/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ        */
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻STC32GΪоƬʵбдԡ

ʹKeil C251Memory ModelƼXSmallģʽĬ϶edataʱӴȡٶȿ졣

edata鱣1Kջʹãռ䲻ʱɽ顢ñxdataؼֶ嵽xdataռ䡣

LinӻշĬLINλѡP0.2,P0.3.

յһǱӦ֡ͨ2, 浽ݻ.

յһӦ֡ͷ, ͻݽӦ.

3ûյµݣMCU״̬ͨLIN߻.

Ĭϴʣ9600, û޸.

ʱ, Ĭʱ 24MHz (û޸Ƶ).

******************************************/

#include "..\comm\STC32G.h"

#include "stdio.h"
#include "intrins.h"

typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;

#define MAIN_Fosc        24000000UL

/*****************************************************************************/

sbit SLP_N  = P5^3;     //0: Sleep

/*************  س    **************/

#define LIN_MODE      1    //0: LIN2.1;  1: LIN1.3
#define FRAME_LEN     8    //ݳ: 8 ֽ

#define Baudrate      115200L
#define TM            (65536 -(MAIN_Fosc/Baudrate/4))
#define PrintUart     2        //1:printf ʹ UART1; 2:printf ʹ UART2

/*************  ر    **************/

u8 Lin_ID;
u8 TX_BUF[8];
u16 msSecond;

bit RxFlag;

/*************  غ    **************/
void LinInit();
void LinReadMsg(u8 *pdat);
void ResponseRxCmd(void);
u8 WaitLinReady(void);
u8 GetLinError(void);
u8 LinReadReg(u8 addr);
void LinTxResponse(u8 *pdat);
void delay_ms(u8 ms);

/******************** ڴӡ ********************/
void UartInit(void)
{
#if(PrintUart == 1)
	SCON = (SCON & 0x3f) | 0x40; 
	T1x12 = 1;          //ʱʱ1Tģʽ
	S1BRT = 0;          //1ѡʱ1Ϊʷ
	TL1  = TM;
	TH1  = TM>>8;
	TR1 = 1;			//ʱ1ʼʱ

//	SCON = (SCON & 0x3f) | 0x40; 
//	T2L  = TM;
//	T2H  = TM>>8;
//	AUXR |= 0x15;   //1ѡʱ2Ϊʷ
#else
	S2_S = 1;       //UART2 switch to: 0: P1.0 P1.1,  1: P4.6 P4.7
    S2CFG |= 0x01;  //ʹô2ʱW1λΪ1ܻԤڵĴ
	S2CON = (S2CON & 0x3f) | 0x40; 
	T2L  = TM;
	T2H  = TM>>8;
	AUXR |= 0x14;	    //ʱ2ʱ1Tģʽ,ʼʱ
#endif
}

void UartPutc(unsigned char dat)
{
#if(PrintUart == 1)
	SBUF = dat; 
	while(TI == 0);
	TI = 0;
#else
	S2BUF  = dat; 
	while(S2TI == 0);
	S2TI = 0;    //Clear Tx flag
#endif
}

char putchar(char c)
{
	UartPutc(c);
	return c;
}
/*********************  *************************/
void main(void)
{
	u8 isr;
	
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x30;   P0M0 = 0x30;   //P0.4P0.5Ϊ©·(ʵ赽3.3V)
    P1M1 = 0x32;   P1M0 = 0x32;   //P1.1P1.4P1.5Ϊ©·(ʵ赽3.3V), P1.1PWMDAC·ͨ贮P2.3
    P2M1 = 0x3c;   P2M0 = 0x3c;   //P2.2~P2.5Ϊ©·(ʵ赽3.3V)
    P3M1 = 0x50;   P3M0 = 0x50;   //P3.4P3.6Ϊ©·(ʵ赽3.3V)
    P4M1 = 0x3c;   P4M0 = 0x3c;   //P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    P5M1 = 0x0c;   P5M0 = 0x0c;   //P5.2P5.3Ϊ©·(ʵ赽3.3V)
    P6M1 = 0xff;   P6M0 = 0xff;   //Ϊ©·(ʵ赽3.3V)
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

	P0PU = 0x0c;          //LIN_TX, LIN_RX ſڲ

	Lin_ID = 0x32;
	LinInit();
	UartInit();
	
	EA = 1;                 //ж

	SLP_N = 1;
	TX_BUF[0] = 0x81;
	TX_BUF[1] = 0x22;
	TX_BUF[2] = 0x33;
	TX_BUF[3] = 0x44;
	TX_BUF[4] = 0x55;
	TX_BUF[5] = 0x66;
	TX_BUF[6] = 0x77;
	TX_BUF[7] = 0x88;
	
	UartPutc(TX_BUF[0]);
	UartPutc(TX_BUF[1]);
	UartPutc(TX_BUF[2]);
	UartPutc(TX_BUF[3]);
	UartPutc(TX_BUF[4]);
	UartPutc(TX_BUF[5]);
	UartPutc(TX_BUF[6]);
	UartPutc(TX_BUF[7]);

	while(1)
	{
        delay_ms(1);    //ʱ1ms
        msSecond++;
        if(msSecond >= 3000) //3ûյݽ
        {
            msSecond = 0;
            P46 = 1;    //LED9 OFF
            PD = 1;     //Sleep
            _nop_();
            _nop_();
            _nop_();
            _nop_();
            _nop_();
            _nop_();
            _nop_();
            P46 = 0;    //LED9 ON
        }
        
		if(RxFlag == 1)
		{
            msSecond = 0;
			RxFlag = 0;
			isr = LinReadReg(LID);
			if(isr == 0x12)		//жǷӻӦID
			{
				LinTxResponse(TX_BUF);	//Ӧ
			}
			else
			{
				ResponseRxCmd();		//RX response
				WaitLinReady();			//ȴready״̬
				GetLinError();			//ȡĴ

				LinReadMsg(TX_BUF);		//Lin
			}
		}
	}
}

//========================================================================
// : void delay_ms(unsigned char ms)
// : ʱ
// : ms,Ҫʱms, ֻ֧1~255ms. ԶӦʱ.
// : none.
// 汾: VER1.0
// : 2013-4-1
// ע: 
//========================================================================
void delay_ms(u8 ms)
{
     u16 i;
     do{
          i = MAIN_Fosc / 6000;
          while(--i);
     }while(--ms);
}

//========================================================================
// : u8 ReadReg(u8 addr)
// : LinܼĴȡ
// : LinܼĴַ.
// : LinܼĴ.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
u8 LinReadReg(u8 addr)
{
	u8 dat;
	LINAR = addr;
	dat = LINDR;
	return dat;
}

//========================================================================
// : void WriteReg(u8 addr, u8 dat)
// : LinܼĴú
// : LinܼĴַ, LinܼĴ.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinWriteReg(u8 addr, u8 dat)
{
	LINAR = addr;
	LINDR = dat;
}

//========================================================================
// : void LinReadMsg(u8 *pdat)
// : Linݺ
// : *pdat: ݻ.
// : Lin ID.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinReadMsg(u8 *pdat)
{
	u8 i;

	LinWriteReg(LSEL,0x80);	//ַ0ʼ

	for(i=0;i<FRAME_LEN;i++)
	{
		pdat[i] = LinReadReg(LBUF);
		UartPutc(pdat[i]);		//Ӵյ
	}
   printf("\r\n");
}

//========================================================================
// : u16 LinSetMsg(u8 *pdat)
// : Linݺ
// : *pdat: ݻ.
// : Lin ID.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinSetMsg(u8 *pdat)
{
	u8 i;

	LinWriteReg(LSEL,0x80);		//ַ0ʼ
	for(i=0;i<FRAME_LEN;i++)
	{
		LinWriteReg(LBUF,pdat[i]);
	}
}

//========================================================================
// : void LinSetID(u8 lid)
// : LIN ID
// : none.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinSetID(u8 lid)
{
	LinWriteReg(LID,lid);			//ID
}

//========================================================================
// : u8 GetLinError(void)
// : ȡLINߴĴ״̬
// : none.
// : Ĵ״̬.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
u8 GetLinError(void)
{
	u8 sta;
	sta = LinReadReg(LER);		//ȡĴ
	return sta;
}

//========================================================================
// : u8 WaitLinReady(void)
// : ȴLIN߾
// : none.
// : LIN״̬.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
u8 WaitLinReady(void)
{
	u8 lsr;
	do{
		lsr = LinReadReg(LSR);
	}while(!(lsr & 0x02));		//жready״̬
	return lsr;
}

//========================================================================
// : void SendAbortCmd(void)
// : ģʽLinAbort
// : none.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void SendAbortCmd(void)
{
	LinWriteReg(LCR,0x80);		//ģʽ Send Abort
}

//========================================================================
// : void SendHeadCmd(void)
// : ģʽLinHeader
// : none.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void SendHeadCmd(void)
{
	LinWriteReg(LCR,0x81);		//ģʽ Send Header
}

//========================================================================
// : void SendDatCmd(void)
// : ģʽLinݺ
// : none.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void SendDatCmd(void)
{
	u8 lcr_val;
	lcr_val = 0x82+(LIN_MODE<<6)+(FRAME_LEN<<2);
	LinWriteReg(LCR,lcr_val);
}

//========================================================================
// : void ResponseTxCmd(void)
// : ģʽLinTx Response
// : none.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void ResponseTxCmd(void)
{
	u8 lcr_val;
	lcr_val = 0x02+(LIN_MODE<<6)+(FRAME_LEN<<2);
	LinWriteReg(LCR,lcr_val);
}

//========================================================================
// : void ResponseRxCmd(void)
// : ģʽLinRx Response
// : none.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void ResponseRxCmd(void)
{
	u8 lcr_val;
	lcr_val = 0x03+(LIN_MODE<<6)+(FRAME_LEN<<2);
	LinWriteReg(LCR,lcr_val);
}

//========================================================================
// : void LinTxResponse(u8 *pdat)
// : LinӻӦݣ͵Headerƴһ֡
// : *pdat: ݻ.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinTxResponse(u8 *pdat)
{
	LinSetMsg(pdat);
	ResponseTxCmd();					//TX response
	WaitLinReady();						//ȴready״̬
	GetLinError();						//ȡĴ
}

//========================================================================
// : void LinSetBaudrate(u16 brt)
// : Lin߲ú
// : brt: .
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinSetBaudrate(u16 brt)
{
	u16 tmp;
	tmp = (MAIN_Fosc >> 4) / brt;
	LinWriteReg(DLH,(u8)(tmp>>8));
	LinWriteReg(DLL,(u8)tmp);
}

//========================================================================
// : void LinSetHeadDelay(u8 base_ms, u8 prescaler)
// : Lin֡ͷʱ
// : base_ms:ʱ, prescaler:ʱƵ.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinSetHeadDelay(u8 base_ms, u8 prescaler)
{
	u16 tmp;
	tmp = (MAIN_Fosc * base_ms) / 1000;
	LinWriteReg(HDRH,(u8)(tmp>>8));
	LinWriteReg(HDRL,(u8)tmp);		//֡ͷʱ

	LinWriteReg(HDP,prescaler);		//֡ͷʱƵ
}

//========================================================================
// : void LinInit()
// : Linʼ
// : none.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinInit()
{
    P_SW1 = (P_SW1 & 0xfc) | 0x00;    //LINλѡ0x00: P0.2,P0.3, 0x01: P5.2,P5.3, 0x02: P4.6,P4.7, 0x03: P7.2,P7.3
	LINICR = 0x02;		//LINģжʹ
	LINEN = 1;		    //LINģ鱻ʹ

	GetLinError();				//ȡĴ
	LinWriteReg(LIE,0x0F);		//LIRжʹܼĴ
	LinSetBaudrate(9600);		//ò
	LinSetHeadDelay(0x02,0x03);	//֡ͷʱ
}

//========================================================================
// : void LinBUS_Interrupt(void) interrupt LIN_VECTOR
// : LinжϺ
// : none.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinBUS_Interrupt(void) interrupt LIN_VECTOR
{
	u8 isr;
	u8 arTemp;
	arTemp = LINAR;     //LINAR ֳ棬ѭд LINAR жϣж޸ LINAR 
	
	isr = LinReadReg(LSR);
	if((isr & 0x03) == 0x03)
	{
		isr = LinReadReg(LER);
		if(isr == 0x00)		//No Error
		{
			RxFlag = 1;
		}
	}
	else
	{
		isr = LinReadReg(LER);	//ȡĴ
	}

	LINAR = arTemp;    //LINAR ֳָ
}
