/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ        */
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻STC32GΪоƬʵбдԡ

ʹKeil C251Memory ModelƼXSmallģʽĬ϶edataʱӴȡٶȿ졣

edata鱣1Kջʹãռ䲻ʱɽ顢ñxdataؼֶ嵽xdataռ䡣

LinշĬLINλѡP0.2,P0.3.

һP32ڰ, һ֡.
һP33ڰ, ֡ͷȡӻӦݣϲһ֡.

Ĭϴʣ9600, û޸.

ʱ, Ĭʱ 24MHz (û޸Ƶ).

******************************************/

#include "..\comm\STC32G.h"

#include "stdio.h"
#include "intrins.h"

typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;

#define MAIN_Fosc        24000000UL

/*****************************************************************************/

sbit SLP_N  = P5^3;     //0: Sleep

/*************  س    **************/

#define LIN_MODE        1    //0: LIN2.1;  1: LIN1.3
#define FRAME_LEN       8    //ݳ: 8 ֽ

/*************  ر    **************/

u8 Lin_ID;
u8 TX_BUF[8];

u8 Key1_cnt;
u8 Key2_cnt;
bit Key1_Flag;
bit Key2_Flag;

/*************  غ    **************/
void LinInit();
void LinSendMsg(u8 lid, u8 *pdat);
void LinSendHeader(u8 lid);
void delay_ms(u8 ms);
/*********************  *************************/
void main(void)
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x30;   P0M0 = 0x30;   //P0.4P0.5Ϊ©·(ʵ赽3.3V)
    P1M1 = 0x32;   P1M0 = 0x32;   //P1.1P1.4P1.5Ϊ©·(ʵ赽3.3V), P1.1PWMDAC·ͨ贮P2.3
    P2M1 = 0x3c;   P2M0 = 0x3c;   //P2.2~P2.5Ϊ©·(ʵ赽3.3V)
    P3M1 = 0x50;   P3M0 = 0x50;   //P3.4P3.6Ϊ©·(ʵ赽3.3V)
    P4M1 = 0x3c;   P4M0 = 0x3c;   //P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    P5M1 = 0x0c;   P5M0 = 0x0c;   //P5.2P5.3Ϊ©·(ʵ赽3.3V)
    P6M1 = 0xff;   P6M0 = 0xff;   //Ϊ©·(ʵ赽3.3V)
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

	P0PU = 0x0c;          //LIN_TX, LIN_RX ſڲ

	Lin_ID = 0x32;
	LinInit();
	EA = 1;               //ж

	SLP_N = 1;
	TX_BUF[0] = 0x81;
	TX_BUF[1] = 0x22;
	TX_BUF[2] = 0x33;
	TX_BUF[3] = 0x44;
	TX_BUF[4] = 0x55;
	TX_BUF[5] = 0x66;
	TX_BUF[6] = 0x77;
	TX_BUF[7] = 0x88;
	
	while(1)
	{
		delay_ms(1);
		if(!P32)
		{
			if(!Key1_Flag)
			{
				Key1_cnt++;
				if(Key1_cnt > 50)
				{
					P46 = ~P46;
					Key1_Flag = 1;
					LinSendMsg(Lin_ID, TX_BUF);  //һ
				}
			}
		}
		else
		{
			Key1_cnt = 0;
			Key1_Flag = 0;
		}

		if(!P33)
		{
			if(!Key2_Flag)
			{
				Key2_cnt++;
				if(Key2_cnt > 50)
				{
					P47 = ~P47;
					Key2_Flag = 1;
					LinSendHeader(0x13);  //֡ͷȡ֡һ֡
				}
			}
		}
		else
		{
			Key2_cnt = 0;
			Key2_Flag = 0;
		}
	}
}

//========================================================================
// : void delay_ms(u8 ms)
// : ʱ
// : ms,Ҫʱms, ֻ֧1~255ms. ԶӦʱ.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void delay_ms(u8 ms)
{
    u16 i;
    do{
        i = MAIN_Fosc / 6000;
        while(--i);
    }while(--ms);
}

//========================================================================
// : u8 ReadReg(u8 addr)
// : LinܼĴȡ
// : LinܼĴַ.
// : LinܼĴ.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
u8 LinReadReg(u8 addr)
{
	u8 dat;
	LINAR = addr;
	dat = LINDR;
	return dat;
}

//========================================================================
// : void WriteReg(u8 addr, u8 dat)
// : LinܼĴú
// : LinܼĴַ, LinܼĴ.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinWriteReg(u8 addr, u8 dat)
{
	LINAR = addr;
	LINDR = dat;
}

//========================================================================
// : void LinReadMsg(u8 *pdat)
// : Linȡݺ
// : *pdat: ݻ.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinReadMsg(u8 *pdat)
{
	u8 i;

	LinWriteReg(LSEL,0x80);	//ַ0ʼ
	for(i=0;i<FRAME_LEN;i++)
	{
		pdat[i] = LinReadReg(LBUF);
	}
}

//========================================================================
// : u16 LinSetMsg(u8 *pdat)
// : Linݺ
// : *pdat: ݻ.
// : Lin ID.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinSetMsg(u8 *pdat)
{
	u8 i;

	LinWriteReg(LSEL,0x80);		//ַ0ʼ
	for(i=0;i<FRAME_LEN;i++)
	{
		LinWriteReg(LBUF,pdat[i]);
	}
}

//========================================================================
// : void LinSetID(u8 lid)
// : LIN ID
// : none.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinSetID(u8 lid)
{
	LinWriteReg(LID,lid);			//ID
}

//========================================================================
// : u8 GetLinError(void)
// : ȡLINߴĴ״̬
// : none.
// : Ĵ״̬.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
u8 GetLinError(void)
{
	u8 sta;
	sta = LinReadReg(LER);		//ȡĴ
	return sta;
}

//========================================================================
// : u8 WaitLinReady(void)
// : ȴLIN߾
// : none.
// : LIN״̬.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
u8 WaitLinReady(void)
{
	u8 lsr;
	do{
		lsr = LinReadReg(LSR);
	}while(!(lsr & 0x02));		//жready״̬
	return lsr;
}

//========================================================================
// : void SendAbortCmd(void)
// : ģʽLinAbort
// : none.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void SendAbortCmd(void)
{
	LinWriteReg(LCR,0x80);		//ģʽ Send Abort
}

//========================================================================
// : void SendHeadCmd(void)
// : ģʽLinHeader
// : none.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void SendHeadCmd(void)
{
	LinWriteReg(LCR,0x81);		//ģʽ Send Header
}

//========================================================================
// : void SendDatCmd(void)
// : ģʽLinݺ
// : none.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void SendDatCmd(void)
{
	u8 lcr_val;
	lcr_val = 0x82+(LIN_MODE<<6)+(FRAME_LEN<<2);
	LinWriteReg(LCR,lcr_val);
}

//========================================================================
// : void ResponseTxCmd(void)
// : ģʽLinTx Response
// : none.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void ResponseTxCmd(void)
{
	u8 lcr_val;
	lcr_val = 0x02+(LIN_MODE<<6)+(FRAME_LEN<<2);
	LinWriteReg(LCR,lcr_val);
}

//========================================================================
// : void ResponseRxCmd(void)
// : ģʽLinRx Response
// : none.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void ResponseRxCmd(void)
{
	u8 lcr_val;
	lcr_val = 0x03+(LIN_MODE<<6)+(FRAME_LEN<<2);
	LinWriteReg(LCR,lcr_val);
}

//========================================================================
// : void LinSendMsg(u8 lid, u8 *pdat)
// : Lin֡
// : lid: Lin ID; *pdat: ݻ.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinSendMsg(u8 lid, u8 *pdat)
{
	LinSetID(lid);						//ID
	LinSetMsg(pdat);

	SendHeadCmd();						//ģʽ Send Seader
	WaitLinReady();						//ȴready״̬
	GetLinError();						//ȡĴ

	SendDatCmd();						//Send Data
	WaitLinReady();						//ȴready״̬
	GetLinError();						//ȡĴ
}

//========================================================================
// : void LinSendHeader(u8 lid)
// : LinHeaderɴӻӦݣƴһ֡
// : lid: ӦӻID.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinSendHeader(u8 lid)
{
	LinSetID(lid);						//÷ResponseӻID

	SendHeadCmd();						//ģʽ send header
	WaitLinReady();						//ȴready״̬
	GetLinError();						//ȡĴ
	
	ResponseRxCmd();					//RX response
	WaitLinReady();						//ȴready״̬
	GetLinError();						//ȡĴ

	LinReadMsg(TX_BUF);				//Linߴӻ͵Ӧ
}

//========================================================================
// : void LinSetBaudrate(u16 brt)
// : Lin߲ú
// : brt: .
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinSetBaudrate(u16 brt)
{
	u16 tmp;
	tmp = (MAIN_Fosc >> 4) / brt;
	LinWriteReg(DLH,(u8)(tmp>>8));
	LinWriteReg(DLL,(u8)tmp);
}

//========================================================================
// : void LinSetHeadDelay(u8 base_ms, u8 prescaler)
// : Lin֡ͷʱ
// : base_ms:ʱ, prescaler:ʱƵ.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinSetHeadDelay(u8 base_ms, u8 prescaler)
{
	u16 tmp;
	tmp = (MAIN_Fosc * base_ms) / 1000;
	LinWriteReg(HDRH,(u8)(tmp>>8));
	LinWriteReg(HDRL,(u8)tmp);		//֡ͷʱ

	LinWriteReg(HDP,prescaler);		//֡ͷʱƵ
}

//========================================================================
// : void LinInit()
// : Linʼ
// : none.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinInit()
{
    P_SW1 = (P_SW1 & 0xfc) | 0x00;    //LINλѡ0x00: P0.2,P0.3, 0x01: P5.2,P5.3, 0x02: P4.6,P4.7, 0x03: P7.2,P7.3
	LINICR = 0x02;		//LINģжʹ
	LINEN = 1;		    //LINģ鱻ʹ

	GetLinError();				//ȡĴ
	LinWriteReg(LIE,0x00);		//LIEжʹܼĴ
	LinSetBaudrate(9600);		//ò
	LinSetHeadDelay(0x01,0x01);	//֡ͷʱ
}

//========================================================================
// : void LinBUS_Interrupt(void) interrupt LIN_VECTOR
// : LinжϺ
// : none.
// : none.
// 汾: VER1.0
// : 2021-01-05
// ע: 
//========================================================================
void LinBUS_Interrupt(void) interrupt LIN_VECTOR
{
	u8 isr;
	u8 arTemp;
	arTemp = LINAR;     //LINAR ֳ棬ѭд LINAR жϣж޸ LINAR 
	
	isr = LinReadReg(LSR);		//ȡĴ״̬־λ
//	if((isr & 0x03) == 0x03)
//	{
//		isr = LinReadReg(LER);
//		if(isr == 0x00)		//No Error
//		{
//			P46 = ~P46;
//		}
//	}

	LINAR = arTemp;    //LINAR ֳָ
}
