/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

/*************	˵	**************

̻STC32GΪоƬʵбдԡ

ʹKeil C251Memory ModelƼXSmallģʽĬ϶edataʱӴȡٶȿ졣

edata鱣1Kջʹãռ䲻ʱɽ顢ñxdataؼֶ嵽xdataռ䡣

ʾ15·ADCbandgapѯ2(P4.6 P4.7)͸λ115200,N,8,1.

0~7ͨӦP1.0~P1.7, 8~14ͨӦP0.0~P0.6, 15ͨΪڲ1.19V׼ѹADCֵ.

ʼʱȰҪADCתΪ.

ʱ, ѡʱ 22.1184MHz (û޸Ƶ).

******************************************/

#include "..\..\comm\STC32G.h"
#include "intrins.h"
#include "stdio.h"

typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;


#define MAIN_Fosc     22118400L  //ʱ
#define Baudrate      115200L
#define TM            (65536 -(MAIN_Fosc/Baudrate/4))


/*************	س	**************/

#define	ADC_SPEED	15		/* 0~15, ADCתʱ(CPUʱ) = (n+1)*32  ADCCFG */
#define	RES_FMT		(1<<5)	/* ADCʽ 0: , ADC_RES: D11 D10 D9 D8 D7 D6 D5 D4, ADC_RESL: D3 D2 D1 D0 0 0 0 0 */
							/* ADCCFG      1: Ҷ, ADC_RES: 0 0 0 0 D11 D10 D9 D8, ADC_RESL: D7 D6 D5 D4 D3 D2 D1 D0 */

/*************	ر	**************/


/*************	غ	**************/

void	delay_ms(u8 ms);
void	ADC_convert(u8 chn);	//chn=0~7ӦP1.0~P1.7, chn=8~14ӦP0.0~P0.6, chn=15ӦBandGapѹ
u16	Get_ADC12bitResult(u8 channel);

/******************** ڴӡ ********************/
void UartInit(void)
{
	S2_S = 1;       //UART2 switch to: 0: P1.0 P1.1,  1: P4.6 P4.7
    S2CFG |= 0x01;  //ʹô2ʱW1λΪ1ܻԤڵĴ
	S2CON = (S2CON & 0x3f) | 0x40; 
	T2L  = TM;
	T2H  = TM>>8;
	AUXR |= 0x14;	      //ʱ2ʱ1Tģʽ,ʼʱ
}

void UartPutc(unsigned char dat)
{
	S2BUF  = dat; 
	while(S2TI == 0);
	S2TI = 0;    //Clear Tx flag
}

char putchar(char c)
{
	UartPutc(c);
	return c;
}

/**********************************************/
void main(void)
{
	u8	i;

    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x7f;   P0M0 = 0x00;   //Ϊ
    P1M1 = 0xfb;   P1M0 = 0x00;   //Ϊ
    P2M1 = 0x3c;   P2M0 = 0x3c;   //P2.2~P2.5Ϊ©·(ʵ赽3.3V)
    P3M1 = 0x50;   P3M0 = 0x50;   //P3.4P3.6Ϊ©·(ʵ赽3.3V)
    P4M1 = 0x3c;   P4M0 = 0x3c;   //P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    P5M1 = 0x1c;   P5M0 = 0x0c;   //P5.2P5.3Ϊ©·(ʵ赽3.3V)P5.4Ϊ
    P6M1 = 0xff;   P6M0 = 0xff;   //Ϊ©·(ʵ赽3.3V)
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

	ADCTIM = 0x3f;  //ͨѡʱ䡢ʱ䡢ʱ
	ADCCFG = RES_FMT + ADC_SPEED;
	//ADCģԴ򿪺ȴ1msMCUڲADCԴȶٽADת
	ADC_CONTR = 0x80 + 0;	//ADC on + channel

	UartInit();
	EA = 1;
	printf("STC32GϵADCԳ!\r\n");

	while (1)
	{
		for(i=0; i<16; i++)
		{
			delay_ms(200);
			//ADC_convert(3);		//͹̶ͨADֵ

			ADC_convert(i);		//ѯͨADֵ
			if((i & 7) == 7)	//дӡ
			{
				printf("\r\n");
			}
		}
	}
}


//========================================================================
// : u16 Get_ADC12bitResult(u8 channel))	//channel = 0~15
// : ѯһADC.
// : channel: ѡҪתADC, 0~15.
// : 12λADC.
// 汾: V1.0, 2016-4-28
//========================================================================
u16	Get_ADC12bitResult(u8 channel)	//channel = 0~15
{
	ADC_RES = 0;
	ADC_RESL = 0;

    ADC_CONTR = (ADC_CONTR & 0xf0) | channel; //ADCתͨ
    ADC_START = 1;//ADCת
    _nop_();
	_nop_();
	_nop_();
	_nop_();
    while(ADC_FLAG == 0);   //wait for ADC finish
    ADC_FLAG = 0;     //ADC־
	return (((u16)ADC_RES << 8) | ADC_RESL);
}

#define		SUM_LENGTH	16	/* ƽֵ ֵ16 */

/***********************************
ѯʽһADC, chnΪͨ, chn=0~7ӦP1.0~P1.7, chn=8~14ӦP0.0~P0.6, chn=15ӦBandGapѹ.
***********************************/
void ADC_convert(u8 chn)
{
	u16	j;
	u8	k;		//ƽֵ˲ʱʹ

	Get_ADC12bitResult(chn);		//i=0~15,ѯʽһADC, лͨһת. ݵĲдѹӰ.
	Get_ADC12bitResult(chn);		//i=0~15,ѯʽһADC, лͨڶת. ݵĲдѹӰ.
	for(k=0, j=0; k<SUM_LENGTH; k++)	j += Get_ADC12bitResult(chn);	// ۼӺ, 0~15,ѯʽһADC, ֵǽ
	j = j / SUM_LENGTH;		// ƽ

	if(chn == 15)	printf("Bandgap=%04d  ",j);	//ڻ׼ 1.19V
	else		//ADC0~ADC14
	{
		printf("ADC%02d=%04d  ",chn,j);
	}
}

//========================================================================
// : void delay_ms(u8 ms)
// : ʱ
// : ms,Ҫʱms, ֻ֧1~255ms. ԶӦʱ.
// : none.
// 汾: VER1.0
// : 2013-4-1
// ע: 
//========================================================================
void delay_ms(u8 ms)
{
	u16 i;
	do
	{
		i = MAIN_Fosc / 6000;
		while(--i);
	}while(--ms);
}
