/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

/*************    ˵    **************

̻STC32GΪоƬʵбдԡ

ʹKeil C251Memory ModelƼXSmallģʽĬ϶edataʱӴȡٶȿ졣

edata鱣1Kջʹãռ䲻ʱɽ顢ñxdataؼֶ嵽xdataռ䡣

0~7ͨӦP1.0~P1.7, 8~14ͨӦP0.0~P0.6, 15ͨΪڲ1.19V׼ѹADCֵ.

ʼʱȰҪADCתΪ.

(DMA)ܣͨһѭɼԶŵDMAxdataռ.

ͨ1(P3.0 P3.1)DMAxdataռյݷ͸λ115200,N,8,1

ʱ, ѡʱ 22.1184MHz (û޸Ƶ).

******************************************/

#include "..\..\comm\STC32G.h"
#include "intrins.h"
#include "stdio.h"

typedef     unsigned char    u8;
typedef     unsigned int    u16;
typedef     unsigned long    u32;

/*************    س    **************/

#define MAIN_Fosc   22118400L    //ʱ
#define Baudrate    115200L
#define TM          (65536 -(MAIN_Fosc/Baudrate/4))

#define ADC_SPEED   15      /* 0~15, ADCתʱ(CPUʱ) = (n+1)*32  ADCCFG */
#define RES_FMT     (1<<5)  /* ADCʽ 0: , ADC_RES: D11 D10 D9 D8 D7 D6 D5 D4, ADC_RESL: D3 D2 D1 D0 0 0 0 0 */
                            /* ADCCFG     1: Ҷ, ADC_RES: 0 0 0 0 D11 D10 D9 D8, ADC_RESL: D7 D6 D5 D4 D3 D2 D1 D0 */

#define ADC_CH      16      /* ADCתͨ */
#define ADC_TIMES   4       /* ÿͨADCתݴ */

#if (ADC_TIMES == 1)
    #define        CVTIMESEL    0x00
#elif (ADC_TIMES == 2)
    #define        CVTIMESEL    0x08
#elif (ADC_TIMES == 4)
    #define        CVTIMESEL    0x09
#elif (ADC_TIMES == 8)
    #define        CVTIMESEL    0x0a
#elif (ADC_TIMES == 16)
    #define        CVTIMESEL    0x0b
#elif (ADC_TIMES == 32)
    #define        CVTIMESEL    0x0c
#elif (ADC_TIMES == 64)
    #define        CVTIMESEL    0x0d
#elif (ADC_TIMES == 128)
    #define        CVTIMESEL    0x0e
#elif (ADC_TIMES == 256)
    #define        CVTIMESEL    0x0f
#else
    #error "ADC sampling times set error!"
#endif

/*************    ر    **************/

bit DmaFlag;

typedef struct
{
    u16 Data[ADC_TIMES];    //ADC 
    u8  Channel;            //ADC ͨ
    u8  remainder;          //ADC ƽ
    u16 average;            //ADC ƽֵ
} xdata ADC_DMATypeDef;

ADC_DMATypeDef DmaBuffer[ADC_CH];   //ADC DMA 

/*************    غ    **************/

void delay_ms(u8 ms);
void DMA_Config(void);

/******************** ڴӡ ********************/
void UartInit(void)
{
    S1_S1 = 0;      //UART1 switch to, 00: P3.0 P3.1, 01: P3.6 P3.7, 10: P1.6 P1.7, 11: P4.3 P4.4
    S1_S0 = 0;
    SCON = (SCON & 0x3f) | 0x40; 
    T1x12 = 1;      //ʱʱ1Tģʽ
    S1BRT = 0;      //1ѡʱ1Ϊʷ
    TL1  = TM;
    TH1  = TM>>8;
    TR1 = 1;        //ʱ1ʼʱ
}

void UartPutc(unsigned char dat)
{
    SBUF = dat; 
    while(TI == 0);
    TI = 0;
}

char putchar(char c)
{
    UartPutc(c);
    return c;
}

/**********************************************/
void main(void)
{
    u8 i,n;

    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x7f;   P0M0 = 0x00;   //ҪADCIO
    P1M1 = 0xfb;   P1M0 = 0x00;   //ҪADCIO
    P2M1 = 0x3c;   P2M0 = 0x3c;   //P2.2~P2.5Ϊ©·(ʵ赽3.3V)
    P3M1 = 0x50;   P3M0 = 0x50;   //P3.4P3.6Ϊ©·(ʵ赽3.3V)
    P4M1 = 0x3c;   P4M0 = 0x3c;   //P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    P5M1 = 0x1c;   P5M0 = 0x0c;   //P5.2P5.3Ϊ©·(ʵ赽3.3V)P5.4Ϊ
    P6M1 = 0xff;   P6M0 = 0xff;   //Ϊ©·(ʵ赽3.3V)
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫
    
    ADCTIM = 0x3f;  //ͨѡʱ䡢ʱ䡢ʱ
    ADCCFG = RES_FMT + ADC_SPEED;
    //ADCģԴ򿪺ȴ1msMCUڲADCԴȶٽADת
    ADC_CONTR = 0x80 + 0;    //ADC on + channel

    UartInit();
    DMA_Config();
    EA = 1;
    printf("STC32GϵADC DMAԳ!\r\n");

    while (1)
    {
        delay_ms(200);
        if(DmaFlag)     //жADC DMAǷת
        {
            DmaFlag = 0;    //ADC DMAתɱ־
            for(i=0; i<ADC_CH; i++)
            {
                printf("ADC%02d = ",DmaBuffer[i].Channel);   //ڴӡADCͨ
                for(n=0; n<ADC_TIMES; n++)
                {
                    printf("0x%04x ",DmaBuffer[i].Data[n]); //ڴӡǰͨÿβ
                }
                printf(", AVER:0x%04x\r\n",DmaBuffer[i].average);   //ڴӡƽֵ
            }
            DMA_ADC_CR = 0xc0;  //bit7 1:Enable ADC_DMA, bit6 1:Start ADC_DMA
        }
    }
}

//========================================================================
// : void DMA_Config(void)
// : ADC DMA .
// : none.
// : none.
// 汾: V1.0, 2021-5-6
//========================================================================
void DMA_Config(void)
{
    DMA_ADC_STA = 0x00;
    DMA_ADC_CFG = 0x80;     //bit7 1:Enable Interrupt
    DMA_ADC_RXAH = (u8)((u16)&DmaBuffer >> 8);    //ADCתݴ洢ַ
    DMA_ADC_RXAL = (u8)((u16)&DmaBuffer);
    DMA_ADC_CFG2 = CVTIMESEL;   //ÿͨADCת
    DMA_ADC_CHSW0 = 0xff;   //ADCͨʹܼĴ ADC7~ADC0
    DMA_ADC_CHSW1 = 0xff;   //ADCͨʹܼĴ ADC15~ADC8
    DMA_ADC_CR = 0xc0;      //bit7 1:Enable ADC_DMA, bit6 1:Start ADC_DMA
}

//========================================================================
// : void delay_ms(u8 ms)
// : ʱ
// : ms,Ҫʱms, ֻ֧1~255ms. ԶӦʱ.
// : none.
// 汾: VER1.0
// : 2013-4-1
// ע: 
//========================================================================
void delay_ms(u8 ms)
{
    u16 i;
    do
    {
        i = MAIN_Fosc / 6000;
        while(--i);
    }while(--ms);
}

//========================================================================
// : void ADC_DMA_Interrupt (void) interrupt 48
// : ADC DMAжϺ
// : none.
// : none.
// 汾: VER1.0
// : 2021-5-8
// ע: 
//========================================================================
void ADC_DMA_Interrupt(void) interrupt 13
{
    DMA_ADC_STA = 0;
    DmaFlag = 1;
}
