/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻STC32GΪоƬʵбдԡ

ʹKeil C251Memory ModelƼXSmallģʽĬ϶edataʱӴȡٶȿ졣

edata鱣1Kջʹãռ䲻ʱɽ顢ñxdataؼֶ嵽xdataռ䡣

1ȫ˫жϷʽշͨѶ

ͨPCMCU, MCUյԶDMAռ.

DMAռôСݺͨ1DMAԶ͹ܰѴ洢ռԭ.

öʱʷʹ1Tģʽ(ǵͲ12T)ѡɱʱƵʣ߾ȡ

ʱ, ѡʱ 22.1184MHz (û޸Ƶ).

******************************************/

#include "..\..\comm\STC32G.h"
#include "stdio.h"
#include "intrins.h"

typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;

#define MAIN_Fosc       22118400L   //ʱӣȷ115200ʣ
#define Baudrate1       115200L

bit	DmaTxFlag;
bit	DmaRxFlag;

u8 xdata DmaBuffer[256];

void UART1_config(u8 brt);   // ѡ, 2: ʹTimer2, ֵ: ʹTimer1.
void DMA_Config(void);

void UartPutc(unsigned char dat)
{
	SBUF = dat; 
	while(TI == 0); 
	TI = 0;
}
 
char putchar(char c)
{
	UartPutc(c);
	return c;
}

//========================================================================
// : void main(void)
// : 
// : none.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void main(void)
{
	u16 i;
	
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x30;   P0M0 = 0x30;   //P0.4P0.5Ϊ©·(ʵ赽3.3V)
    P1M1 = 0x32;   P1M0 = 0x32;   //P1.1P1.4P1.5Ϊ©·(ʵ赽3.3V), P1.1PWMDAC·ͨ贮P2.3
    P2M1 = 0x3c;   P2M0 = 0x3c;   //P2.2~P2.5Ϊ©·(ʵ赽3.3V)
    P3M1 = 0x50;   P3M0 = 0x50;   //P3.4P3.6Ϊ©·(ʵ赽3.3V)
    P4M1 = 0x3c;   P4M0 = 0x3c;   //P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    P5M1 = 0x0c;   P5M0 = 0x0c;   //P5.2P5.3Ϊ©·(ʵ赽3.3V)
    P6M1 = 0xff;   P6M0 = 0xff;   //Ϊ©·(ʵ赽3.3V)
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

	for(i=0; i<256; i++)
	{
		DmaBuffer[i] = i;
	}

	UART1_config(1);    // ѡ, 2: ʹTimer2, ֵ: ʹTimer1.
	printf("STC32G UART1 DMA Test Programme!\r\n");  //UART1һַ

	DMA_Config();
	EA = 1; //ж

	DmaTxFlag = 0;
	DmaRxFlag = 0;

	while (1)
	{
		if((DmaTxFlag) && (DmaRxFlag))
		{
			DmaTxFlag = 0;
			DMA_UR1T_CR = 0xc0;			//bit7 1:ʹ UART1_DMA, bit6 1:ʼ UART1_DMA Զ
			DmaRxFlag = 0;
			DMA_UR1R_CR = 0xa1;			//bit7 1:ʹ UART1_DMA, bit5 1:ʼ UART1_DMA Զ, bit0 1: FIFO
		}
	}
}

//========================================================================
// : void DMA_Config(void)
// : UART DMA .
// : none.
// : none.
// 汾: V1.0, 2021-5-6
//========================================================================
void DMA_Config(void)
{
	DMA_UR1T_CFG = 0x80;		//bit7 1:Enable Interrupt
	DMA_UR1T_STA = 0x00;
	DMA_UR1T_AMT = 0xff;		//ôֽ(8λ)n+1
	DMA_UR1T_AMTH = 0x00;		//ôֽ(8λ)n+1
	DMA_UR1T_TXAH = (u8)((u16)&DmaBuffer >> 8);
	DMA_UR1T_TXAL = (u8)((u16)&DmaBuffer);
	DMA_UR1T_CR = 0xc0;			//bit7 1:ʹ UART1_DMA, bit6 1:ʼ UART1_DMA Զ

	DMA_UR1R_CFG = 0x80;		//bit7 1:Enable Interrupt
	DMA_UR1R_STA = 0x00;
	DMA_UR1R_AMT = 0xff;		//ôֽ(8λ)n+1
	DMA_UR1R_AMTH = 0x00;		//ôֽ(8λ)n+1
	DMA_UR1R_RXAH = (u8)((u16)&DmaBuffer >> 8);
	DMA_UR1R_RXAL = (u8)((u16)&DmaBuffer);
	DMA_UR1R_CR = 0xa1;			//bit7 1:ʹ UART1_DMA, bit5 1:ʼ UART1_DMA Զ, bit0 1: FIFO
}

//========================================================================
// : SetTimer2Baudraye(u16 dat)
// : Timer2ʷ
// : dat: Timer2װֵ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void SetTimer2Baudraye(u16 dat)  // ѡ, 2: ʹTimer2, ֵ: ʹTimer1.
{
    T2R = 0;	//Timer stop
    T2_CT = 0;	//Timer2 set As Timer
    T2x12 = 1;	//Timer2 set as 1T mode
    T2H = dat / 256;
    T2L = dat % 256;
    ET2 = 0;    //ֹж
    T2R = 1;	//Timer run enable
}

//========================================================================
// : void UART1_config(u8 brt)
// : UART1ʼ
// : brt: ѡ, 2: ʹTimer2, ֵ: ʹTimer1.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART1_config(u8 brt)    // ѡ, 2: ʹTimer2, ֵ: ʹTimer1.
{
	/*********** ʹöʱ2 *****************/
	if(brt == 2)
	{
        S1BRT = 1;	//S1 BRT Use Timer2;
		SetTimer2Baudraye((u16)(65536UL - (MAIN_Fosc / 4) / Baudrate1));
	}

	/*********** ʹöʱ1 *****************/
	else
	{
		TR1 = 0;
        S1BRT = 0;		//S1 BRT Use Timer1;
        T1_CT = 0;		//Timer1 set As Timer
        T1x12 = 1;		//Timer1 set as 1T mode
		TMOD &= ~0x30;  //Timer1_16bitAutoReload;
		TH1 = (u8)((65536UL - (MAIN_Fosc / 4) / Baudrate1) / 256);
		TL1 = (u8)((65536UL - (MAIN_Fosc / 4) / Baudrate1) % 256);
        ET1 = 0;    //ֹж
		TR1  = 1;
	}
	/*************************************************/

	SCON = (SCON & 0x3f) | 0x40;    //UART1ģʽ, 0x00: ͬλ, 0x40: 8λ,ɱ䲨, 0x80: 9λ,̶, 0xc0: 9λ,ɱ䲨
//  PS  = 1;    //ȼж
//	ES  = 1;    //ж
	REN = 1;    //
	P_SW1 &= 0x3f;
	P_SW1 |= 0x00;      //UART1 switch to, 0x00: P3.0 P3.1, 0x40: P3.6 P3.7, 0x80: P1.6 P1.7, 0xC0: P4.3 P4.4
}


//========================================================================
// : void UART1_int (void) interrupt UART1_VECTOR
// : UART1жϺ
// : nine.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
//void UART1_int (void) interrupt 4
//{
//	if(RI)
//	{
//		RI = 0;
//		RX1_Buffer[RX1_Cnt] = SBUF;
//		if(++RX1_Cnt >= UART1_BUF_LENGTH)   RX1_Cnt = 0;    //
//	}

//	if(TI)
//	{
//		TI = 0;
//		B_TX1_Busy = 0;
//	}
//}

//========================================================================
// : void UART1_DMA_Interrupt (void) interrupt 50/51
// : UART1 DMAжϺ
// : none.
// : none.
// 汾: VER1.0
// : 2021-5-8
// ע: 
//========================================================================
void UART1_DMA_Interrupt(void) interrupt 13
{
	if (DMA_UR1T_STA & 0x01)	//
	{
		DMA_UR1T_STA &= ~0x01;
		DmaTxFlag = 1;
	}
	if (DMA_UR1T_STA & 0x04)	//ݸ
	{
		DMA_UR1T_STA &= ~0x04;
	}
	
	if (DMA_UR1R_STA & 0x01)	//
	{
		DMA_UR1R_STA &= ~0x01;
		DmaRxFlag = 1;
	}
	if (DMA_UR1R_STA & 0x02)	//ݶ
	{
		DMA_UR1R_STA &= ~0x02;
	}
}
