/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻STC32GΪоƬʵбдԡ

ʹKeil C251Memory ModelƼXSmallģʽĬ϶edataʱӴȡٶȿ졣

edata鱣1Kջʹãռ䲻ʱɽ顢ñxdataؼֶ嵽xdataռ䡣

2ȫ˫жϷʽշͨѶ

ͨPCMCU, MCUյԶDMAռ.

DMAռôСݺͨ2DMAԶ͹ܰѴ洢ռԭ.

öʱʷʹ1Tģʽ(ǵͲ12T)ѡɱʱƵʣ߾ȡ

ʱ, ѡʱ 22.1184MHz (û޸Ƶ).

******************************************/

#include "..\..\comm\STC32G.h"
#include "stdio.h"
#include "intrins.h"

typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;

#define MAIN_Fosc   22118400L   //ʱӣȷ115200ʣ
#define Baudrate2   115200L

bit	DmaTxFlag;
bit	DmaRxFlag;

u8 xdata DmaBuffer[256];

void UART2_config(u8 brt);   // ѡ, 2: ʹTimer2, ֵ: Ч.
void DMA_Config(void);

void UartPutc(unsigned char dat)
{
	S2BUF = dat; 
	while(S2TI == 0);
	S2TI = 0;
}
 
char putchar(char c)
{
	UartPutc(c);
	return c;
}

//========================================================================
// : void main(void)
// : 
// : none.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void main(void)
{
	u16 i;

    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x30;   P0M0 = 0x30;   //P0.4P0.5Ϊ©·(ʵ赽3.3V)
    P1M1 = 0x32;   P1M0 = 0x32;   //P1.1P1.4P1.5Ϊ©·(ʵ赽3.3V), P1.1PWMDAC·ͨ贮P2.3
    P2M1 = 0x3c;   P2M0 = 0x3c;   //P2.2~P2.5Ϊ©·(ʵ赽3.3V)
    P3M1 = 0x50;   P3M0 = 0x50;   //P3.4P3.6Ϊ©·(ʵ赽3.3V)
    P4M1 = 0x3c;   P4M0 = 0x3c;   //P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    P5M1 = 0x0c;   P5M0 = 0x0c;   //P5.2P5.3Ϊ©·(ʵ赽3.3V)
    P6M1 = 0xff;   P6M0 = 0xff;   //Ϊ©·(ʵ赽3.3V)
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

	for(i=0; i<256; i++)
	{
		DmaBuffer[i] = i;
	}

	UART2_config(2);    // ѡ, 2: ʹTimer2, ֵ: Ч.
	printf("STC32G UART2 DMA Test Programme!\r\n");  //UART2һַ

	DMA_Config();
	EA = 1; //ж

	DmaTxFlag = 0;
	DmaRxFlag = 0;
	
	while (1)
	{
		if((DmaTxFlag) && (DmaRxFlag))
		{
			DmaTxFlag = 0;
			DMA_UR2T_CR = 0xc0;			//bit7 1:ʹ UART2_DMA, bit6 1:ʼ UART2_DMA Զ
			DmaRxFlag = 0;
			DMA_UR2R_CR = 0xa1;			//bit7 1:ʹ UART2_DMA, bit5 1:ʼ UART2_DMA Զ, bit0 1: FIFO
		}
	}
}

//========================================================================
// : void DMA_Config(void)
// : UART DMA .
// : none.
// : none.
// 汾: V1.0, 2021-5-6
//========================================================================
void DMA_Config(void)
{
	DMA_UR2T_CFG = 0x80;		//bit7 1:Enable Interrupt
	DMA_UR2T_STA = 0x00;
	DMA_UR2T_AMT = 0xff;		//ôֽ(8λ)n+1
	DMA_UR2T_AMTH = 0x00;		//ôֽ(8λ)n+1
	DMA_UR2T_TXAH = (u8)((u16)&DmaBuffer >> 8);
	DMA_UR2T_TXAL = (u8)((u16)&DmaBuffer);
	DMA_UR2T_CR = 0xc0;			//bit7 1:ʹ UART2_DMA, bit6 1:ʼ UART2_DMA Զ

	DMA_UR2R_CFG = 0x80;		//bit7 1:Enable Interrupt
	DMA_UR2R_STA = 0x00;
	DMA_UR2R_AMT = 0xff;		//ôֽ(8λ)n+1
	DMA_UR2R_AMTH = 0x00;		//ôֽ(8λ)n+1
	DMA_UR2R_RXAH = (u8)((u16)&DmaBuffer >> 8);
	DMA_UR2R_RXAL = (u8)((u16)&DmaBuffer);
	DMA_UR2R_CR = 0xa1;			//bit7 1:ʹ UART2_DMA, bit5 1:ʼ UART2_DMA Զ, bit0 1: FIFO
}

//========================================================================
// : SetTimer2Baudraye(u16 dat)
// : Timer2ʷ
// : dat: Timer2װֵ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void SetTimer2Baudraye(u16 dat)  // ʹTimer2.
{
    T2R = 0;	//Timer stop
    T2_CT = 0;	//Timer2 set As Timer
    T2x12 = 1;	//Timer2 set as 1T mode
    T2H = dat / 256;
    T2L = dat % 256;
    ET2 = 0;    //ֹж
    T2R = 1;	//Timer run enable
}

//========================================================================
// : void UART2_config(u8 brt)
// : UART2ʼ
// : brt: ѡ, 2: ʹTimer2, ֵ: Ч.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART2_config(u8 brt)    // ѡ, 2: ʹTimer2, ֵ: Ч.
{
    /*********** ʹ̶ʹöʱ2 *****************/
    if(brt == 2)
    {
        SetTimer2Baudraye((u16)(65536UL - (MAIN_Fosc / 4) / Baudrate2));

        S2CFG |= 0x01;     //ʹô2ʱW1λΪ1ܻԤڵĴ
        S2CON = (S2CON & 0x3f) | 0x40;    //UART2ģʽ, 0x00: ͬλ, 0x40: 8λ,ɱ䲨, 0x80: 9λ,̶, 0xc0: 9λ,ɱ䲨
//        ES2   = 1;         //ж
        S2REN = 1;         //
        S2_S  = 1;         //UART2 switch to: 0: P1.0 P1.1,  1: P4.6 P4.7
    }
}


//========================================================================
// : void UART2_int (void) interrupt UART2_VECTOR
// : UART2жϺ
// : nine.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
//void UART2_int (void) interrupt 8
//{
//    if(S2RI)
//    {
//        S2RI = 0;    //Clear Rx flag
//        RX2_Buffer[RX2_Cnt] = S2BUF;
//        if(++RX2_Cnt >= UART2_BUF_LENGTH)   RX2_Cnt = 0;
//    }

//    if(S2TI)
//    {
//        S2TI = 0;    //Clear Tx flag
//        B_TX2_Busy = 0;
//    }
//}

//========================================================================
// : void UART2_DMA_Interrupt (void) interrupt 52/53
// : UART2 DMAжϺ
// : none.
// : none.
// 汾: VER1.0
// : 2021-5-8
// ע: 
//========================================================================
void UART2_DMA_Interrupt(void) interrupt 13
{
	if (DMA_UR2T_STA & 0x01)	//
	{
		DMA_UR2T_STA &= ~0x01;
		DmaTxFlag = 1;
	}
	if (DMA_UR2T_STA & 0x04)	//ݸ
	{
		DMA_UR2T_STA &= ~0x04;
	}
	
	if (DMA_UR2R_STA & 0x01)	//
	{
		DMA_UR2R_STA &= ~0x01;
		DmaRxFlag = 1;
	}
	if (DMA_UR2R_STA & 0x02)	//ݶ
	{
		DMA_UR2R_STA &= ~0x02;
	}
}
