/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

#include "app_MatrixKey.h"

/*************** ˵ ****************

ɨ.

******************************************/

sbit BEEP = P5^4;

//========================================================================
//                               س	
//========================================================================

u8 code T_KeyTable[16] = {0,1,2,0,3,0,0,0,4,0,0,0,0,0,0,0};

//========================================================================
//                               ر
//========================================================================

u8  cntms;

u8  KeyCode;    //ûʹõļ, 1~16Ч
u8  IO_KeyState, IO_KeyState1, IO_KeyHoldCnt;    //м̱
bit IO_KeyHoldFlag; //ѹ/ͷű־

//========================================================================
//                               غ
//========================================================================

void MatrixKeyScan(void);

//========================================================================
//                            ⲿͱ
//========================================================================


/*****************************************************
    мɨ
    ʹXY4x4ķֻܵٶȿ

   Y     P04      P05      P06      P07
          |        |        |        |
X         |        |        |        |
P00 ---- K00 ---- K01 ---- K02 ---- K03 ----
          |        |        |        |
P01 ---- K04 ---- K05 ---- K06 ---- K07 ----
          |        |        |        |
P02 ---- K08 ---- K09 ---- K10 ---- K11 ----
          |        |        |        |
P03 ---- K12 ---- K13 ---- K14 ---- K15 ----
          |        |        |        |
******************************************************/

void IO_KeyDelay(void)
{
    u8 i;
    i = 60;
    while(--i)  ;
}

//========================================================================
// : Sample_MatrixKey
// : ûӦó.
// : None.
// : None.
// 汾: V1.0, 2022-05-26
//========================================================================
void Sample_MatrixKey(void)
{
    if(cntms > 0)
    {
        cntms--;
    }
    else
    {
        BEEP = 1;    //ر
    }

    MatrixKeyScan();
    if(KeyCode > 0)  //м
    {
        KeyCode = 0;
        BEEP = 0;    //
        cntms = 5;   //ʱ 5*10ms
    }
}

//========================================================================
// : Sample_MatrixKey
// : ûӦó.
// : None.
// : None.
// 汾: V1.0, 2022-05-26
//========================================================================
void MatrixKeyScan(void)
{
    u8  j;

    P0 = 0xf0;  //XͣY
    IO_KeyDelay();
    IO_KeyState = P0 & 0xc0;

    P0 = 0x0f;  //YͣX
    IO_KeyDelay();
    IO_KeyState |= (P0 & 0x0f);
    IO_KeyState ^= 0xcf;   //ȡ
    
    if(IO_KeyState == IO_KeyState1)   //ζ
    {
        if(IO_KeyState != 0)    //м
        {
            if(IO_KeyHoldFlag == 0)
            {
                if(IO_KeyHoldCnt >= 3)    //10ms * 5 = 50ms
                {
                    j = T_KeyTable[IO_KeyState >> 4];
                    if((j != 0) && (T_KeyTable[IO_KeyState& 0x0f] != 0)) 
                        KeyCode = (j - 1) * 4 + T_KeyTable[IO_KeyState & 0x0f] + 16;    //룬17~32
                    IO_KeyHoldFlag = 1;
                }
                else if(IO_KeyHoldCnt <= 5)
                    IO_KeyHoldCnt++;
            }
        }
        else
        {
            IO_KeyHoldFlag = 0;
            IO_KeyHoldCnt = 0;
        }
    }
    else
    {
        IO_KeyHoldFlag = 0;
        IO_KeyHoldCnt = 0;
    }
    
    IO_KeyState1 = IO_KeyState;
    P0 = 0xff;
}

