/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

#include "adc.h"
#include "app_ntc.h"
#include "app_display.h"

/*************** ˵ ****************

ұ4λʾ¶ֵ, ֱ0.1.

NTCʹ1%ȵMF52 10K@25.

¶ʱ, ʹ12λADCֵ, ʹöԷֲұ, СһλԲ岹.

******************************************/


//========================================================================
//                               س	
//========================================================================


//========================================================================
//                               ر
//========================================================================


//========================================================================
//                               غ
//========================================================================

u16 get_temperature(u16 adc);

//========================================================================
//                            ⲿͱ
//========================================================================


//========================================================================
// : Sample_NTC
// : ûӦó.
// : None.
// : None.
// 汾: V1.0, 2020-09-23
//========================================================================
void Sample_NTC(void)
{
    u8  i;
    u16 j;

    j = Get_ADC12bitResult(3);  //0~15,ѯʽһADC, ֵǽ, == 4096 Ϊ

    if(j < 4096)
    {
        j = get_temperature(j); //¶ֵ

        if(j >= 400)    F0 = 0, j -= 400;       //¶ >= 0
        else            F0 = 1, j  = 400 - j;   //¶ <  0
        LED8[4] = j / 1000;     //ʾ¶ֵ
        LED8[5] = (j % 1000) / 100;
        LED8[6] = (j % 100) / 10 + DIS_DOT;
        LED8[7] = j % 10;
        if(LED8[4] == 0)    LED8[4] = DIS_BLACK;
        if(F0)  LED8[4] = DIS_;     //ʾ-
    }
    else    //
    {
        for(i=0; i<8; i++)  LED8[i] = DIS_;
    }
}


//  MF52E 10K at 25, B = 3950, ADC = 12 bits
u16 code temp_table[]={
        140,    //;-40  0
        149,    //;-39  1
        159,    //;-38  2
        168,    //;-37  3
        178,    //;-36  4
        188,    //;-35  5
        199,    //;-34  6
        210,    //;-33  7
        222,    //;-32  8
        233,    //;-31  9
        246,    //;-30  10
        259,    //;-29  11
        272,    //;-28  12
        286,    //;-27  13
        301,    //;-26  14
        317,    //;-25  15
        333,    //;-24  16
        349,    //;-23  17
        367,    //;-22  18
        385,    //;-21  19
        403,    //;-20  20
        423,    //;-19  21
        443,    //;-18  22
        464,    //;-17  23
        486,    //;-16  24
        509,    //;-15  25
        533,    //;-14  26
        558,    //;-13  27
        583,    //;-12  28
        610,    //;-11  29
        638,    //;-10  30
        667,    //;-9   31
        696,    //;-8   32
        727,    //;-7   33
        758,    //;-6   34
        791,    //;-5   35
        824,    //;-4   36
        858,    //;-3   37
        893,    //;-2   38
        929,    //;-1   39
        965,    //;0    40
        1003,   //;1    41
        1041,   //;2    42
        1080,   //;3    43
        1119,   //;4    44
        1160,   //;5    45
        1201,   //;6    46
        1243,   //;7    47
        1285,   //;8    48
        1328,   //;9    49
        1371,   //;10   50
        1414,   //;11   51
        1459,   //;12   52
        1503,   //;13   53
        1548,   //;14   54
        1593,   //;15   55
        1638,   //;16   56
        1684,   //;17   57
        1730,   //;18   58
        1775,   //;19   59
        1821,   //;20   60
        1867,   //;21   61
        1912,   //;22   62
        1958,   //;23   63
        2003,   //;24   64
        2048,   //;25   65
        2093,   //;26   66
        2137,   //;27   67
        2182,   //;28   68
        2225,   //;29   69
        2269,   //;30   70
        2312,   //;31   71
        2354,   //;32   72
        2397,   //;33   73
        2438,   //;34   74
        2479,   //;35   75
        2519,   //;36   76
        2559,   //;37   77
        2598,   //;38   78
        2637,   //;39   79
        2675,   //;40   80
        2712,   //;41   81
        2748,   //;42   82
        2784,   //;43   83
        2819,   //;44   84
        2853,   //;45   85
        2887,   //;46   86
        2920,   //;47   87
        2952,   //;48   88
        2984,   //;49   89
        3014,   //;50   90
        3044,   //;51   91
        3073,   //;52   92
        3102,   //;53   93
        3130,   //;54   94
        3157,   //;55   95
        3183,   //;56   96
        3209,   //;57   97
        3234,   //;58   98
        3259,   //;59   99
        3283,   //;60   100
        3306,   //;61   101
        3328,   //;62   102
        3351,   //;63   103
        3372,   //;64   104
        3393,   //;65   105
        3413,   //;66   106
        3432,   //;67   107
        3452,   //;68   108
        3470,   //;69   109
        3488,   //;70   110
        3506,   //;71   111
        3523,   //;72   112
        3539,   //;73   113
        3555,   //;74   114
        3571,   //;75   115
        3586,   //;76   116
        3601,   //;77   117
        3615,   //;78   118
        3628,   //;79   119
        3642,   //;80   120
        3655,   //;81   121
        3667,   //;82   122
        3679,   //;83   123
        3691,   //;84   124
        3702,   //;85   125
        3714,   //;86   126
        3724,   //;87   127
        3735,   //;88   128
        3745,   //;89   129
        3754,   //;90   130
        3764,   //;91   131
        3773,   //;92   132
        3782,   //;93   133
        3791,   //;94   134
        3799,   //;95   135
        3807,   //;96   136
        3815,   //;97   137
        3822,   //;98   138
        3830,   //;99   139
        3837,   //;100  140
        3844,   //;101  141
        3850,   //;102  142
        3857,   //;103  143
        3863,   //;104  144
        3869,   //;105  145
        3875,   //;106  146
        3881,   //;107  147
        3887,   //;108  148
        3892,   //;109  149
        3897,   //;110  150
        3902,   //;111  151
        3907,   //;112  152
        3912,   //;113  153
        3917,   //;114  154
        3921,   //;115  155
        3926,   //;116  156
        3930,   //;117  157
        3934,   //;118  158
        3938,   //;119  159
        3942    //;120  160
};

/********************  ¶ ***********************************************/
// : 0Ӧ-40.0, 400Ӧ0, 625Ӧ25.0, 1600Ӧ120.0. 
// Ϊͨ, ADCΪ12bitADCֵ.
// ·㷨: Coody
/**********************************************/

#define D_SCALE     10      //Ŵ, Ŵ10ǱһλС
u16 get_temperature(u16 adc)
{
    u16 code *p;
    u16 i;
    u8  j,k,min,max;
    
    adc = 4096 - adc;   //Rtӵ
    p = temp_table;
    if(adc < p[0])      return (0xfffe);
    if(adc > p[160])    return (0xffff);
    
    min = 0;        //-40
    max = 160;      //120

    for(j=0; j<5; j++)  //Էֲ
    {
        k = min / 2 + max / 2;
        if(adc <= p[k]) max = k;
        else            min = k;
    }
         if(adc == p[min])  i = min * D_SCALE;
    else if(adc == p[max])  i = max * D_SCALE;
    else    // min < temp < max
    {
        while(min <= max)
        {
            min++;
            if(adc == p[min])   {i = min * D_SCALE; break;}
            else if(adc < p[min])
            {
                min--;
                i = p[min]; //min
                j = (adc - i) * D_SCALE / (p[min+1] - i);
                i = min;
                i *= D_SCALE;
                i += j;
                break;
            }
        }
    }
    return i;
}
