/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻STC32GΪоƬʵбдԡ

ʹKeil C251Memory ModelƼXSmallģʽĬ϶edataʱӴȡٶȿ졣

edata鱣1Kջʹãռ䲻ʱɽ顢ñxdataؼֶ嵽xdataռ䡣

USART1SPIģʽʹDMAͼĴʽʵϵflash.

2(P4.6,P4.7)ԽĬϲ:  115200,8,N,1. 

ʱ, ѡʱ 24MHz (û޸Ƶ).

******************************************/

#include "stc32g.h"
#include "stdio.h"

#define FOSC    24000000UL                      //ϵͳƵ
#define BAUD    (65536 - FOSC/4/115200)         //Դڲ

typedef bit BOOL;
typedef unsigned char BYTE;
typedef unsigned int WORD;
typedef unsigned long DWORD;

sbit S1SS       =   P2^2;
sbit S1MOSI     =   P2^3;
sbit S1MISO     =   P2^4;
sbit S1SCLK     =   P2^5;

void sys_init();
void usart1_spi_init();
void usart1_tx_dma(WORD size, BYTE xdata *pdat);
void usart1_rx_dma(WORD size, BYTE xdata *pdat);
BOOL flash_is_busy();
void flash_read_id();
void flash_read_data(DWORD addr, WORD size, BYTE xdata *pdat);
void flash_write_enable();
void flash_write_data(DWORD addr, WORD size, BYTE xdata *pdat);
void flash_erase_sector(DWORD addr);

BYTE xdata buffer1[256];                        //建
BYTE xdata buffer2[256];                        //ע:ҪʹDMA,򻺳붨xdata

void main()
{
    int i;
    
    sys_init();                                 //ϵͳʼ
    usart1_spi_init();                          //USART1ʹSPIģʽʼ
    
    printf("\r\nUSART_SPI_DMA test !\r\n");
    flash_read_id();
    flash_read_data(0x0000, 0x80, buffer1);     //ʹUSART1SPIģʽȡFLASH
    flash_erase_sector(0x0000);                 //ʹUSART1SPIģʽFLASHһ
    flash_read_data(0x0000, 0x80, buffer1);
    for (i=0; i<128; i++)
        buffer2[i] = i;
    flash_write_data(0x0000, 0x80, buffer2);    //ʹUSART1SPIģʽдݵFLASH
    flash_read_data(0x0000, 0x80, buffer1);
    
    while (1);
}

char putchar(char dat)
{
    while (!S2TI);
    S2TI = 0;
    S2BUF = dat;
    
    return dat;
}

void sys_init()
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ
    
    P0M1 = 0x30;   P0M0 = 0x30;   //P0.4P0.5Ϊ©·(ʵ赽3.3V)
    P1M1 = 0x32;   P1M0 = 0x32;   //P1.1P1.4P1.5Ϊ©·(ʵ赽3.3V), P1.1PWMDAC·ͨ贮P2.3
    P2M1 = 0x3c;   P2M0 = 0x3c;   //P2.2~P2.5Ϊ©·(ʵ赽3.3V)ÿ©ģʽҪϿPWMDAC·еR2
    P3M1 = 0x50;   P3M0 = 0x50;   //P3.4P3.6Ϊ©·(ʵ赽3.3V)
    P4M1 = 0x3c;   P4M0 = 0x3c;   //P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    P5M1 = 0x0c;   P5M0 = 0x0c;   //P5.2P5.3Ϊ©·(ʵ赽3.3V)
    P6M1 = 0xff;   P6M0 = 0xff;   //Ϊ©·(ʵ赽3.3V)
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫
    
    //ʼ2,ڵԳ
    S2_S = 1;       //UART2 switch to: 0: P1.0 P1.1,  1: P4.6 P4.7
    S2CFG |= 0x01;  //ʹô2ʱW1λΪ1ܻԤڵĴ
    S2CON = 0x52;
    T2L = BAUD;
    T2H = BAUD >> 8;
    T2x12 = 1;
    T2R = 1;
}

void usart1_spi_init()
{
    S1SPI_S0 = 1;                       //лS1SPIP2.2/S1SS,P2.3/S1MOSI,P2.4/S1MISO,P2.5/S1SCLK
    S1SPI_S1 = 0;
    SCON = 0x10;                        //ʹܽ,Ϊģʽ0
    
    USARTCR1 = 0x10;                    //ʹUSART1SPIģʽ
//  USARTCR1 |= 0x40;                   //DORD=1
    USARTCR1 &= ~0x40;                  //DORD=0
//  USARTCR1 |= 0x04;                   //ӻģʽ
    USARTCR1 &= ~0x04;                  //ģʽ
    USARTCR1 |= 0x00;                   //CPOL=0, CPHA=0
//  USARTCR1 |= 0x01;                   //CPOL=0, CPHA=1
//  USARTCR1 |= 0x02 ;                  //CPOL=1, CPHA=0
//  USARTCR1 |= 0x03;                   //CPOL=1, CPHA=1
//  USARTCR4 = 0x00;                    //SPIٶΪSYSCLK/4
//  USARTCR4 = 0x01;                    //SPIٶΪSYSCLK/8
    USARTCR4 = 0x02;                    //SPIٶΪSYSCLK/16
//  USARTCR4 = 0x03;                    //SPIٶΪSYSCLK/2
    USARTCR1 |= 0x08;                   //ʹSPI
}

BYTE usart1_spi_shift(BYTE dat)
{
    TI = 0;
    SBUF = dat;                         //
    while (!TI);                        //TI־ģʽ/ɱ־
    
    return SBUF;                        //ȡյ
}

BOOL flash_is_busy()
{
    BYTE dat;

    S1SS = 0;
    
    usart1_spi_shift(0x05);             //Ͷȡ״̬Ĵ
    dat = usart1_spi_shift(0);          //ȡ״̬Ĵ
    
    S1SS = 1;

    return (dat & 0x01);                //FLASHæ־
}

void flash_read_id()
{
    BYTE id[3];
    
    S1SS = 0;
    
    usart1_spi_shift(0x9f);             //ͶȡFLASH ID
    id[0] = usart1_spi_shift(0);       //ȡID1
    id[1] = usart1_spi_shift(0);       //ȡID2
    id[2] = usart1_spi_shift(0);       //ȡID3
    
    S1SS = 1;

    printf("ReadID : ");
    printf("%02bx", id[0]);
    printf("%02bx", id[1]);
    printf("%02bx\r\n", id[2]);
}

void flash_read_data(DWORD addr, WORD size, BYTE xdata *pdat)
{
    WORD sz;
    BYTE *ptr;

    while (flash_is_busy());

    S1SS = 0;
    
    usart1_spi_shift(0x03);             //ͶȡFLASH
    usart1_spi_shift((BYTE)(addr >> 16));
    usart1_spi_shift((BYTE)(addr >> 8));
    usart1_spi_shift((BYTE)(addr));     //Ŀַ
    
//  sz = size;
//  ptr = pdat;
//  while (sz--)
//      *ptr++ = usart1_spi_shift(0);   //Ĵʽ
      
    usart1_rx_dma(size, pdat);          //DMAʽ

    S1SS = 1;

    printf("ReadData : ");
    sz = size;
    ptr = pdat;
    for (sz=0; sz<size; sz++)
    {
        printf("%02bx ", *ptr++);        //ݷ͵,ʹ
        if ((sz % 16) == 15)
        {
            printf("\r\n           ");
        }
    }
    printf("\r\n");
}

void flash_write_enable()
{
    while (flash_is_busy());

    S1SS = 0;
    
    usart1_spi_shift(0x06);             //дʹ
    
    S1SS = 1;
}

void flash_write_data(DWORD addr, WORD size, BYTE xdata *pdat)
{
    WORD sz;

    sz = size;
    while (sz)
    {
        flash_write_enable();

        S1SS = 0;
        
        usart1_spi_shift(0x02);         //д
        usart1_spi_shift((BYTE)(addr >> 16));
        usart1_spi_shift((BYTE)(addr >> 8));
        usart1_spi_shift((BYTE)(addr));
        
//      do
//      {
//          usart1_spi_shift(*pdat++);  //Ĵʽд
//          addr++;
//
//          if ((BYTE)(addr) == 0x00)
//              break;
//      } while (--sz);

        usart1_tx_dma(sz, pdat);        //DMAʽд(ע:ݱһpage֮)
        sz = 0;
        
        S1SS = 1;
    }

    printf("Program !\r\n");
}

void flash_erase_sector(DWORD addr)
{
    flash_write_enable();

    S1SS = 0;
    usart1_spi_shift(0x20);             //Ͳ
    usart1_spi_shift((BYTE)(addr >> 16));
    usart1_spi_shift((BYTE)(addr >> 8));
    usart1_spi_shift((BYTE)(addr));
    S1SS = 1;

    printf("Erase Sector !\r\n");
}

void usart1_tx_dma(WORD size, BYTE xdata *pdat)
{
    size--;                             //DMAֽʵ1
    
    DMA_UR1T_CFG = 0x00;                //رDMAж
    DMA_UR1T_STA = 0x00;                //DMA״̬
    DMA_UR1T_AMT = size;                //DMAֽ
    DMA_UR1T_AMTH = size >> 8;
    DMA_UR1T_TXAL = (BYTE)pdat;         //ûַ(ע:xdata)
    DMA_UR1T_TXAH = (WORD)pdat >> 8;
    DMA_UR1T_CR = 0xc0;                 //ʹDMA,1
    
    while (!(DMA_UR1T_STA & 0x01));     //ȴDMAݴ
    DMA_UR1T_STA = 0x00;                //DMA״̬
    DMA_UR1T_CR = 0x00;                 //رDMA
}

void usart1_rx_dma(WORD size, BYTE xdata *pdat)
{
    size--;                             //DMAֽʵ1
    
    DMA_UR1R_CFG = 0x00;                //رDMAж
    DMA_UR1R_STA = 0x00;                //DMA״̬
    DMA_UR1R_AMT = size;                //DMAֽ
    DMA_UR1R_AMTH = size >> 8;
    DMA_UR1R_RXAL = (BYTE)pdat;         //ûַ(ע:xdata)
    DMA_UR1R_RXAH = (WORD)pdat >> 8;
    DMA_UR1R_CR = 0xa1;                 //ʹDMA,սFIFO,1
    
                                        //!!!!!!!!!!!!!
    usart1_tx_dma(size+1, pdat);        //ע:ʱͬʱDMA
                                        //!!!!!!!!!!!!!
    
    while (!(DMA_UR1R_STA & 0x01));     //ȴDMAݴ
    DMA_UR1R_STA = 0x00;                //DMA״̬
    DMA_UR1R_CR = 0x00;                 //رDMA
}
