/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻STC32GΪоƬʵбдԡ

ʹKeil C251Memory ModelƼXSmallģʽĬ϶edataʱӴȡٶȿ졣

edata鱣1Kջʹãռ䲻ʱɽ顢ñxdataؼֶ嵽xdataռ䡣

USART1SPIUSART2SPI໥ͨš

ͨP6LEDָʾͨŽP6=0x5aʾݴȷ

ʱ, ѡʱ 24MHz (û޸Ƶ).

******************************************/

#include "stc32g.h"
#include "stdio.h"

#define FOSC    24000000UL                      //ϵͳƵ

typedef bit BOOL;
typedef unsigned char BYTE;
typedef unsigned int WORD;
typedef unsigned long DWORD;

sbit S1SS       =   P2^2;
sbit S1MOSI     =   P2^3;
sbit S1MISO     =   P2^4;
sbit S1SCLK     =   P2^5;

sbit S2SS       =   P2^2;
sbit S2MOSI     =   P2^3;
sbit S2MISO     =   P2^4;
sbit S2SCLK     =   P2^5;

void sys_init();
void usart1_spi_init();
void usart2_spi_init();
void test();

BYTE xdata buffer1[256];                        //建
BYTE xdata buffer2[256];                        //建
BYTE rptr;
BYTE wptr;
bit over;

void main()
{
    int i;
    
    sys_init();                                 //ϵͳʼ
    usart1_spi_init();                          //USART1ʹSPIģʽʼ
    usart2_spi_init();                          //USART2ʹSPIģʽʼ
    EA = 1;
    
    for (i=0; i<128; i++)
    {
        buffer1[i] = i;                         //ʼ
        buffer2[i] = 0;
    }
    test();
    
    while (1);
}

void uart1_isr() interrupt UART1_VECTOR
{
    if (TI)
    {
        TI = 0;
        
        if (rptr < 128)
        {
            SBUF = buffer1[rptr++];
        }
        else
        {
            over = 1;
        }
    }
    
    if (RI)
    {
        RI = 0;
    }
}

void uart2_isr() interrupt UART2_VECTOR
{
    if (S2TI)
    {
        S2TI = 0;
    }
    
    if (S2RI)
    {
        S2RI = 0;
        buffer2[wptr++] = S2BUF;
    }
}

void sys_init()
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ
    
    P0M1 = 0x30;   P0M0 = 0x30;   //P0.4P0.5Ϊ©·(ʵ赽3.3V)
    P1M1 = 0x32;   P1M0 = 0x32;   //P1.1P1.4P1.5Ϊ©·(ʵ赽3.3V), P1.1PWMDAC·ͨ贮P2.3
    P2M1 = 0x3c;   P2M0 = 0x3c;   //P2.2~P2.5Ϊ©·(ʵ赽3.3V)ÿ©ģʽҪϿPWMDAC·еR2
    P3M1 = 0x50;   P3M0 = 0x50;   //P3.4P3.6Ϊ©·(ʵ赽3.3V)
    P4M1 = 0x3c;   P4M0 = 0x3c;   //P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    P5M1 = 0x0c;   P5M0 = 0x0c;   //P5.2P5.3Ϊ©·(ʵ赽3.3V)
    P6M1 = 0xff;   P6M0 = 0xff;   //Ϊ©·(ʵ赽3.3V)
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫
    
    P40 = 0;
    P6 = 0xff;
}

void usart1_spi_init()
{
    S1SPI_S0 = 1;                       //лS1SPIP2.2/S1SS,P2.3/S1MOSI,P2.4/S1MISO,P2.5/S1SCLK
    S1SPI_S1 = 0;
    SCON = 0x10;                        //ʹܽ,Ϊģʽ0
    
    USARTCR1 = 0x10;                    //ʹUSART1SPIģʽ
//  USARTCR1 |= 0x40;                   //DORD=1
    USARTCR1 &= ~0x40;                  //DORD=0
//  USARTCR1 |= 0x04;                   //ӻģʽ
    USARTCR1 &= ~0x04;                  //ģʽ
    USARTCR1 |= 0x00;                   //CPOL=0, CPHA=0
//  USARTCR1 |= 0x01;                   //CPOL=0, CPHA=1
//  USARTCR1 |= 0x02 ;                  //CPOL=1, CPHA=0
//  USARTCR1 |= 0x03;                   //CPOL=1, CPHA=1
//  USARTCR4 = 0x00;                    //SPIٶΪSYSCLK/4
//  USARTCR4 = 0x01;                    //SPIٶΪSYSCLK/8
    USARTCR4 = 0x02;                    //SPIٶΪSYSCLK/16
//  USARTCR4 = 0x03;                    //SPIٶΪSYSCLK/2
    USARTCR1 |= 0x08;                   //ʹSPI
 
    ES = 1;
}

void usart2_spi_init()
{
    S2SPI_S0 = 1;                       //лS2SPIP2.2/S2SS,P2.3/S2MOSI,P2.4/S2MISO,P2.5/S2SCLK
    S2SPI_S1 = 0;
    S2CON = 0x10;                       //ʹܽ,Ϊģʽ0
    
    USART2CR1 = 0x10;                   //ʹUSART2SPIģʽ
//  USART2CR1 |= 0x40;                  //DORD=1
    USART2CR1 &= ~0x40;                 //DORD=0
    USART2CR1 |= 0x04;                  //ӻģʽ
//  USART2CR1 &= ~0x04;                 //ģʽ
    USART2CR1 |= 0x00;                  //CPOL=0, CPHA=0
//  USART2CR1 |= 0x01;                  //CPOL=0, CPHA=1
//  USART2CR1 |= 0x02 ;                 //CPOL=1, CPHA=0
//  USART2CR1 |= 0x03;                  //CPOL=1, CPHA=1
//  USART2CR4 = 0x00;                   //SPIٶΪSYSCLK/4
//  USART2CR4 = 0x01;                   //SPIٶΪSYSCLK/8
    USART2CR4 = 0x02;                   //SPIٶΪSYSCLK/16
//  USART2CR4 = 0x03;                   //SPIٶΪSYSCLK/2
    USART2CR1 |= 0x08;                  //ʹSPI

    ES2 = 1;
}

void test()
{
    BYTE i;
    BYTE ret;
    
    wptr = 0;
    rptr = 0;
    over = 0;
    
    S1SS = 0;
    SBUF = buffer1[rptr++];             //ݴ
    while (!over);                      //ȴ128ݴ
    S1SS = 1;
    
    ret = 0x5a;
    for (i=0; i<128; i++)
    {
        if (buffer1[i] != buffer2[i])   //У
        {
            ret = 0xfe;
            break;
        }
    }
    P6 = ret;                           //P6=0x5aʾݴȷ
}

