/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

#include "STC32G.h"
#include "system.h"
#include "intrins.h"
#include "SPI_Flash.h"
#include "stdio.h"
#include "uart.h"
#include "lcm.h"

/*************  س    **************/

//======== PLL ض =========
#define HSCK_MCLK       0
#define HSCK_PLL        1
#define HSCK_SEL        HSCK_PLL

#define PLL_96M         0       //PLLʱ = PLLʱ*8
#define PLL_144M        1       //PLLʱ = PLLʱ*12
#define PLL_SEL         PLL_144M

#define CKMS            0x80
#define HSIOCK          0x40
#define MCK2SEL_MSK     0x0c
#define MCK2SEL_SEL1    0x00
#define MCK2SEL_PLL     0x04
#define MCK2SEL_PLLD2   0x08
#define MCK2SEL_IRC48   0x0c
#define MCKSEL_MSK      0x03
#define MCKSEL_HIRC     0x00
#define MCKSEL_XOSC     0x01
#define MCKSEL_X32K     0x02
#define MCKSEL_IRC32K   0x03

#define ENCKM           0x80
#define PCKI_MSK        0x60
#define PCKI_D1         0x00
#define PCKI_D2         0x20
#define PCKI_D4         0x40
#define PCKI_D8         0x60

/*************  ر    **************/

u32 Flash_addr;
u16 lcdIndex;
u8 xdata DmaBuffer1[DMA_AMT_LEN];
u8 xdata DmaBuffer2[DMA_AMT_LEN];

/*************  FLASHر   **************/
sbit    SPI_CS  = P2^2;     //PIN1
sbit    SPI_MISO = P2^4;    //PIN2
sbit    SPI_MOSI = P2^3;    //PIN5
sbit    SPI_SCK = P2^5;     //PIN6

u8  B_FlashOK;                                //Flash״̬
u8  PM25LV040_ID, PM25LV040_ID1, PM25LV040_ID2;

bit SpiDmaFlag;
bit DmaBufferSW = 0;

void FlashCheckID(void);

//========================================================================
// : void SPI_DMA_Config(void)
// : SPI DMA .
// : none.
// : none.
// 汾: V1.0, 2021-5-6
//========================================================================
void SPI_DMA_Config(void)
{
    //رսDMA´νյ´ʼַλã´νݼš
    DMA_SPI_CR = 0x00;		//bit7 1:ʹ UART1_DMA, bit5 1:ʼ UART1_DMA Զ, bit0 1: FIFO

	DMA_SPI_STA = 0x00;
	DMA_SPI_CFG = 0xE5;		//bit7 1:Enable Interrupt, ṩSPI_DMAȼ
	DMA_SPI_AMT = (u8)(DMA_WR_LEN-1);         //ôֽ(8λ)n+1
	DMA_SPI_AMTH = (u8)((DMA_WR_LEN-1) >> 8); //ôֽ(8λ)n+1

	DMA_SPI_TXAH = (u8)((u16)&DmaBuffer2 >> 8);	//SPIݴ洢ַ
	DMA_SPI_TXAL = (u8)((u16)&DmaBuffer2);
	DMA_SPI_RXAH = (u8)((u16)&DmaBuffer1 >> 8);	//SPIݴ洢ַ
	DMA_SPI_RXAL = (u8)((u16)&DmaBuffer1);

	DMA_SPI_CFG2 = 0x01;	//01:P2.2
	DMA_SPI_CR = 0x81;		//bit7 1:ʹ SPI_DMA, bit6 1:ʼ SPI_DMA ģʽ, bit0 1: SPI_DMA FIFO
}


/******************* FLASHس ************************/
#define SFC_WREN        0x06        //Flash
#define SFC_WRDI        0x04
#define SFC_RDSR        0x05
#define SFC_WRSR        0x01
#define SFC_READ        0x03
#define SFC_FASTREAD    0x0B
#define SFC_RDID        0xAB
#define SFC_PAGEPROG    0x02
#define SFC_RDCR        0xA1
#define SFC_WRCR        0xF1
#define SFC_SECTORER1   0xD7        //PM25LV040 ָ
#define SFC_SECTORER2   0x20        //W25Xxx ָ
#define SFC_BLOCKER     0xD8
#define SFC_CHIPER      0xC7

#define SPI_CE_High()   SPI_CS  = 1     // set CE high
#define SPI_CE_Low()    SPI_CS  = 0     // clear CE low
#define SPI_Hold()      P_SPI_Hold      = 0     // clear Hold pin
#define SPI_UnHold()    P_SPI_Hold      = 1     // set Hold pin
#define SPI_WP()        P_SPI_WP        = 0     // clear WP pin
#define SPI_UnWP()      P_SPI_WP        = 1     // set WP pin

/************************************************************************/
/*
void delay()
{
    int i;
    
    for (i=0; i<100; i++);
}

void PLL_Init(void)
{
    //ѡPLLʱ
#if (PLL_SEL == PLL_96M)
    CLKSEL &= ~CKMS;            //ѡPLL96MΪPLLʱ
#elif (PLL_SEL == PLL_144M)
    CLKSEL |= CKMS;             //ѡPLL144MΪPLLʱ
#else
    CLKSEL &= ~CKMS;            //ĬѡPLL96MΪPLLʱ
#endif
    
    //ѡPLLʱӷƵ,֤ʱΪ12M(Χ8M~16M, 12M +/- 4M)
    USBCLK &= ~PCKI_MSK;
//#if (MAIN_Fosc == 12000000UL)
//    USBCLK |= PCKI_D1;          //PLLʱ1Ƶ
//#elif (MAIN_Fosc == 24000000UL)
//    USBCLK |= PCKI_D2;          //PLLʱ2Ƶ
//#elif (MAIN_Fosc == 48000000UL)
    USBCLK |= PCKI_D4;          //PLLʱ4Ƶ
//#elif (MAIN_Fosc == 96000000UL)
//    USBCLK |= PCKI_D8;          //PLLʱ8Ƶ
//#else
//    USBCLK |= PCKI_D1;          //ĬPLLʱ1Ƶ
//#endif

    //PLL
    USBCLK |= ENCKM;            //ʹPLLƵ
    
    delay();                    //ȴPLLƵ

    //ѡHSPWM/HSSPIʱ
#if (HSCK_SEL == HSCK_MCLK)
    CLKSEL &= ~HSIOCK;          //HSPWM/HSSPIѡʱΪʱԴ
#elif (HSCK_SEL == HSCK_PLL)
    CLKSEL |= HSIOCK;           //HSPWM/HSSPIѡPLLʱΪʱԴ
#else
    CLKSEL &= ~HSIOCK;          //ĬHSPWM/HSSPIѡʱΪʱԴ
#endif

    //Ƶ35MPLL=35M/4*12/2=103.2MHz/2=52.5MHz
    HSCLKDIV = 2;               //HSPWM/HSSPIʱԴ2Ƶ
    
    SPCTL = 0xd3;               //SPIΪģʽ,ٶΪSPIʱ/2(52.5M/2=26.25M)
    HSSPI_CFG2 |= 0x20;         //ʹSPIģʽ

    P2SR = 0x00;                //ƽתٶȿ죨IOڸٷתźţ
    P2DR = 0xff;                //˿ǿ
}
*/
/************************************************************************/
void SPI_init(void)
{
    P_SW1 = (P_SW1 & ~(3<<2)) | (1<<2);     //IOл. 0: P1.2/P5.4 P1.3 P1.4 P1.5, 1: P2.2 P2.3 P2.4 P2.5, 2: P5.4 P4.0 P4.1 P4.3, 3: P3.5 P3.4 P3.3 P3.2

//    PLL_Init();     //SPI ʹPLLʱź(ٶ̫FlashͨŲ)
    
    HSCLKDIV = 0;  //øIOʱӷƵΪ1ƵĬ2ƵʹSPIʱ/2
    SSIG = 1; // SS Źܣʹ MSTR ȷǴӻ
    SPEN = 1; //ʹ SPI 
    DORD = 0; //ȷ/ݵĸλ MSB
    MSTR = 1; //ģʽ
    CPOL = 1; //SCLK ʱΪ͵ƽSCLK ǰʱΪأʱΪ½
    CPHA = 1; // SS ܽΪ͵ƽһλݲ SCLK ĺʱظı
    SPCTL = (SPCTL & ~3) | 0;   //SPI ʱƵѡ, 0: 4T, 1: 8T,  2: 16T,  3: 2T

    SPI_SCK = 0;    // set clock to low initial state
    SPI_MOSI = 1;
    SPIF = 1;   //SPIF־
    WCOL = 1;   //WCOL־

    FlashCheckID();
    FlashCheckID();
    
    if(!B_FlashOK)  printf("δ⵽PM25LV040/W25X40CL/W25Q80BV!\r\n");
    else
    {
        if(B_FlashOK == 1)
        {
            printf("⵽PM25LV040!\r\n");
        }
        else if(B_FlashOK == 2)
        {
            printf("⵽W25X40CL!\r\n");
        }
        else if(B_FlashOK == 3)
        {
            printf("⵽W25Q80BV!\r\n");
        }
        printf("ID1 = 0x%02X",PM25LV040_ID1);
        printf("\r\n      ID2 = 0x%02X",PM25LV040_ID2);
        printf("\r\n   豸ID = 0x%02X\r\n",PM25LV040_ID);
    }
}

/************************************************************************/
void SPI_WriteByte(u8 out)
{
    SPDAT = out;
    while(SPIF == 0);
    SPIF = 1;   //SPIF־
    WCOL = 1;   //WCOL־
}

/************************************************************************/
u8 SPI_ReadByte(void)
{
    SPDAT = 0xff;
    while(SPIF == 0);
    SPIF = 1;   //SPIF־
    WCOL = 1;   //WCOL־
    return (SPDAT);
}

/************************************************
FlashǷ׼
ڲ: 
ڲ:
    0 : ûм⵽ȷFlash
    1 : Flash׼
************************************************/
void FlashCheckID(void)
{
    SPI_CE_Low();
    SPI_WriteByte(SFC_RDID);        //ͶȡID
    SPI_WriteByte(0x00);            //ն3ֽ
    SPI_WriteByte(0x00);
    SPI_WriteByte(0x00);
    PM25LV040_ID1 = SPI_ReadByte();         //ȡID1
    PM25LV040_ID  = SPI_ReadByte();         //ȡ豸ID
    PM25LV040_ID2 = SPI_ReadByte();         //ȡID2
    SPI_CE_High();

//	printf("ID1=%x\r\n",PM25LV040_ID1);
//	printf("ID=%x\r\n",PM25LV040_ID);
//	printf("ID2=%x\r\n",PM25LV040_ID2);
	
    if((PM25LV040_ID1 == 0x9d) && (PM25LV040_ID2 == 0x7f))  B_FlashOK = 1;  //ǷΪPM25LVxxϵеFlash
    else if(PM25LV040_ID == 0x12)  B_FlashOK = 2;                           //ǷΪW25X4xϵеFlash
    else if(PM25LV040_ID == 0x13)  B_FlashOK = 3;                           //ǷΪW25X8xϵеFlash
    else                                                    B_FlashOK = 0;
}

/************************************************
Flashæ״̬
ڲ: 
ڲ:
    0 : Flashڿ״̬
    1 : Flashæ״̬
************************************************/
u8 CheckFlashBusy(void)
{
    u8  dat;

    SPI_CE_Low();
    SPI_WriteByte(SFC_RDSR);        //Ͷȡ״̬
    dat = SPI_ReadByte();           //ȡ״̬
    SPI_CE_High();

    return (dat);                   //״ֵ̬Bit0Ϊæ־
}

/************************************************
ʹFlashд
ڲ: 
ڲ: 
************************************************/
void FlashWriteEnable(void)
{
    while(CheckFlashBusy() > 0);    //Flashæ
    SPI_CE_Low();
    SPI_WriteByte(SFC_WREN);        //дʹ
    SPI_CE_High();
}

/************************************************
ƬFlash
ڲ: 
ڲ: 
************************************************/
void FlashChipErase(void)
{
    if(B_FlashOK)
    {
        FlashWriteEnable();             //ʹFlashд
        SPI_CE_Low();
        SPI_WriteByte(SFC_CHIPER);      //Ƭ
        SPI_CE_High();
    }
}

/************************************************
, һ4KB
ڲ: 
ڲ: 
************************************************/
//void FlashSectorErase(u32 addr)
//{
//    if(B_FlashOK)
//    {
//        FlashWriteEnable();             //ʹFlashд
//        SPI_CE_Low();
//        if(B_FlashOK == 1)
//        {
//            SPI_WriteByte(SFC_SECTORER1);    //
//        }
//        else
//        {
//            SPI_WriteByte(SFC_SECTORER2);    //
//        }
//        SPI_WriteByte(((u8 *)&addr)[1]);     //ʼַ
//        SPI_WriteByte(((u8 *)&addr)[2]);
//        SPI_WriteByte(((u8 *)&addr)[3]);
//        SPI_CE_High();
//    }
//}

/************************************************
Flashжȡ
ڲ:
    addr   : ַ
    buffer : Flashжȡ
    size   : ݿС
ڲ:
    
************************************************/
void SPI_Read_Nbytes(u32 addr, u16 len)
{
    if(len == 0)   return;
    if(!B_FlashOK)  return;
    while(SpiDmaFlag);                     //DMAæ
    while(CheckFlashBusy() > 0);        //Flashæ

    SPI_CE_Low();                       //enable device
    SPI_WriteByte(SFC_READ);            //read command

    SPI_WriteByte(((u8 *)&addr)[1]);    //ʼַ
    SPI_WriteByte(((u8 *)&addr)[2]);
    SPI_WriteByte(((u8 *)&addr)[3]);

    SpiDmaFlag = 1;
	DMA_SPI_AMT = (u8)(len-1);         //ôֽ(8λ)n+1
	DMA_SPI_AMTH = (u8)((len-1) >> 8); //ôֽ(8λ)n+1
    DMA_SPI_CR |= 0x40;     //ʼSPI_DMAģʽ
}

/************************************************
дݵFlash
ڲ:
    addr   : ַ
    size   : ݿС
ڲ: 
************************************************/
void SPI_Write_Nbytes(u32 addr, u16 len)
{
    if(len == 0)   return;
    if(!B_FlashOK)  return;
    while(SpiDmaFlag);                     //DMAæ
    while(CheckFlashBusy() > 0);        //Flashæ

    FlashWriteEnable();                 //ʹFlashд

    SPI_CE_Low();                       // enable device
    SPI_WriteByte(SFC_PAGEPROG);        // ҳ
    SPI_WriteByte(((u8 *)&addr)[1]);    //ʼַ
    SPI_WriteByte(((u8 *)&addr)[2]);
    SPI_WriteByte(((u8 *)&addr)[3]);

    SpiDmaFlag = 1;
	DMA_SPI_AMT = (u8)(len-1);         //ôֽ(8λ)n+1
	DMA_SPI_AMTH = (u8)((len-1) >> 8); //ôֽ(8λ)n+1
    DMA_SPI_CR |= 0x40;     //ʼSPI_DMAģʽ
}

//========================================================================
// : void SPI_DMA_Interrupt (void) interrupt 49
// : SPI DMAжϺ
// : none.
// : none.
// 汾: VER1.0
// : 2021-5-8
// ע: 
//========================================================================
void SPI_DMA_Interrupt(void) interrupt 49   //жų31뱨Ļ谲װ̰Ŀ¼µģKeilжչ
{
	DMA_SPI_STA = 0;
	SpiDmaFlag = 0;
	SPI_CE_High();
}
