/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

#include "STC32G.h"
#include "system.h"
#include "intrins.h"
#include "iap_eeprom.h"

/****************************** û ***********************************/

#define     Tip_Delay   (MAIN_Fosc / 1000000)

/*****************************************************************************/


/*************  س    **************/

//void    DisableEEPROM(void);
//void    EEPROM_read_n(u32 EE_address,u8 *DataAddress,u16 number);
//void    EEPROM_write_n(u32 EE_address,u8 *DataAddress,u16 number);
//void    EEPROM_SectorErase(u32 EE_address);

//========================================================================
// : void   ISP_Disable(void)
// : ֹISP/IAP.
// : non.
// : non.
// 汾: V1.0, 2012-10-22
//========================================================================
void DisableEEPROM(void)
{
    IAP_CONTR = 0;          //ر IAP 
    IAP_CMD = 0;            //Ĵ
    IAP_TRIG = 0;           //Ĵ
    IAP_ADDRE = 0xff;       //ַõ IAP 
    IAP_ADDRH = 0xff;       //ַõ IAP 
    IAP_ADDRL = 0xff;
}

//========================================================================
// : void EEPROM_read_n(u32 EE_address,u8 *DataAddress,u16 number)
// : ָEEPROM׵ַnֽڷָĻ.
// : EE_address:  EEPROM׵ַ.
//       DataAddress: ݷŻ׵ַ.
//       number:      ֽڳ.
// : non.
// 汾: V1.0, 2012-10-22
//========================================================================
void EEPROM_read_n(u32 EE_address,u8 *DataAddress,u16 number)
{
    EA = 0;     //ֹж

    IAP_CONTR = 0x80; //ʹ IAP
    IAP_TPS = Tip_Delay; //òȴ 24MHz
    IAP_CMD = 1;  // IAP 
    do
    {
        IAP_ADDRE = (u8)(EE_address >> 16); //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRH = (u8)(EE_address >> 8);  //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRL = (u8)EE_address;         //͵ַֽڣַҪıʱ͵ַ
        IAP_TRIG = 0x5a; //д(0x5a)
        IAP_TRIG = 0xa5; //д(0xa5)
        _nop_();   //STC32GǶ༶ˮߵָϵͳ4NOP֤IAP_DATA׼
        _nop_();
        _nop_();
        _nop_();
        *DataAddress = IAP_DATA; // IAP 
        EE_address++;
        DataAddress++;
    }while(--number);
    DisableEEPROM();
    EA = 1;     //ж
}

//========================================================================
// : void EEPROM_SectorErase(u32 EE_address)
// : ַָEEPROM.
// : EE_address:  ҪEEPROMĵַ.
// : non.
// 汾: V1.0, 2013-5-10
//========================================================================
void EEPROM_SectorErase(u32 EE_address)
{
    EA = 0;     //ֹж

    IAP_CONTR = 0x80; //ʹ IAP
    IAP_TPS = Tip_Delay; //òȴ 24MHz
    IAP_CMD = 3;      // IAP 
    IAP_ADDRE = (u8)(EE_address >> 16); //ַֽڣַҪıʱ͵ַ
    IAP_ADDRH = (u8)(EE_address >> 8);  //ַֽڣַҪıʱ͵ַ
    IAP_ADDRL = (u8)EE_address;         //ַֽڣַҪıʱ͵ַ
    IAP_TRIG = 0x5a; //д(0x5a)
    IAP_TRIG = 0xa5; //д(0xa5)
    _nop_();   //STC32GǶ༶ˮߵָϵͳ4NOP֤IAP_DATA׼
    _nop_();
    _nop_();
    _nop_();
    DisableEEPROM();
    EA = 1;     //ж
}

//========================================================================
// : void EEPROM_write_n(u32 EE_address,u8 *DataAddress,u16 number)
// : ѻnֽдָ׵ַEEPROM.
// : EE_address:  дEEPROM׵ַ.
//       DataAddress: дԴݵĻ׵ַ.
//       number:      дֽڳ.
// : non.
// 汾: V1.0, 2012-10-22
//========================================================================
void EEPROM_write_n(u32 EE_address,u8 *DataAddress,u16 number)
{
    EA = 0;     //ֹж

    IAP_CONTR = 0x80; //ʹ IAP
    IAP_TPS = Tip_Delay; //òȴ 24MHz
    IAP_CMD = 2;  // IAP д
    do
    {
        IAP_ADDRE = (u8)(EE_address >> 16); //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRH = (u8)(EE_address >> 8);  //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRL = (u8)EE_address;         //͵ַֽڣַҪıʱ͵ַ
        IAP_DATA = *DataAddress; //д IAP 
        IAP_TRIG = 0x5a; //д(0x5a)
        IAP_TRIG = 0xa5; //д(0xa5)
        _nop_();   //STC32GǶ༶ˮߵָϵͳ4NOP֤IAP_DATA׼
        _nop_();
        _nop_();
        _nop_();
        EE_address++;
        DataAddress++;
    }while(--number);

    DisableEEPROM();
    EA = 1;     //ж
}
