/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻STC32GΪоƬʵбдԡ

߼PWMʱʵָPWM.

/ռձȿɵ, ͨȽ/жϽ.

ͨP6ʾ,ÿ10msһPWM,10ֹͣ.

ʹõģʽظĴӲ.

ʱÿ1msPWM.

ʱ, ѡʱ 24MHZ (û޸Ƶ).

******************************************/

#include "stc32g.h"
#include "intrins.h"

#define MAIN_Fosc			24000000L	//ʱ

typedef     unsigned char   u8;
typedef     unsigned int    u16;
typedef     unsigned long   u32;    //1:printf ʹ UART1; 2:printf ʹ UART2

/****************************** û ***********************************/

#define Timer0_Reload   (65536UL -(MAIN_Fosc / 1000))       //Timer 0 жƵ, 1000/

#define PWM1_0      0x00	//P:P1.0  N:P1.1
#define PWM1_1      0x01	//P:P2.0  N:P2.1
#define PWM1_2      0x02	//P:P6.0  N:P6.1

#define PWM2_0      0x00	//P:P1.2/P5.4  N:P1.3
#define PWM2_1      0x04	//P:P2.2  N:P2.3
#define PWM2_2      0x08	//P:P6.2  N:P6.3

#define PWM3_0      0x00	//P:P1.4  N:P1.5
#define PWM3_1      0x10	//P:P2.4  N:P2.5
#define PWM3_2      0x20	//P:P6.4  N:P6.5

#define PWM4_0      0x00	//P:P1.6  N:P1.7
#define PWM4_1      0x40	//P:P2.6  N:P2.7
#define PWM4_2      0x80	//P:P6.6  N:P6.7
#define PWM4_3      0xC0	//P:P3.4  N:P3.3

#define ENO1P       0x01
#define ENO1N       0x02
#define ENO2P       0x04
#define ENO2N       0x08
#define ENO3P       0x10
#define ENO3N       0x20
#define ENO4P       0x40
#define ENO4N       0x80

/*****************************************************************************/

/*************  ر    **************/
bit B_1ms;          //1ms־
bit PWM1_Flag;

u16 Period;
u8 msSecond;

void UpdatePwm(void);
void TxPulse(u8 rep);

/********************  **************************/
void main(void)
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x30;   P0M0 = 0x30;   //P0.4P0.5Ϊ©·(ʵ赽3.3V)
    P1M1 = 0x32;   P1M0 = 0x32;   //P1.1P1.4P1.5Ϊ©·(ʵ赽3.3V), P1.1PWMDAC·ͨ贮P2.3
    P2M1 = 0x3c;   P2M0 = 0x3c;   //P2.2~P2.5Ϊ©·(ʵ赽3.3V)
    P3M1 = 0x50;   P3M0 = 0x50;   //P3.4P3.6Ϊ©·(ʵ赽3.3V)
    P4M1 = 0x3c;   P4M0 = 0x3c;   //P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    P5M1 = 0x0c;   P5M0 = 0x0c;   //P5.2P5.3Ϊ©·(ʵ赽3.3V)
    P6M1 = 0xff;   P6M0 = 0xff;   //Ϊ©·(ʵ赽3.3V)
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    PWM1_Flag = 0;
    Period = 0x1000;

    //  Timer0ʼ
    AUXR = 0x80;    //Timer0 set as 1T, 16 bits timer auto-reload, 
    TH0 = (u8)(Timer0_Reload / 256);
    TL0 = (u8)(Timer0_Reload % 256);
    ET0 = 1;    //Timer0 interrupt enable
    TR0 = 1;    //Tiner0 run

    PWMA_ENO = 0x00;
    PWMA_ENO |= ENO1P; //ʹ

    PWMA_CCER1 = 0x00; //д CCMRx ǰ CCxE رͨ
    PWMA_CCMR1 = 0x60; // PWM1 ģʽ1 
//    PWMA_CCER1 = 0x01; //ʹ CC1E ͨ, ߵƽЧ
    PWMA_CCER1 = 0x03; //ʹ CC1E ͨ, ͵ƽЧ

    PWMA_CCMR1 |= 0x08; //PWMA_CCR1Ԥתع(ҪCC1E=1ſд)

    PWMA_PS = 0x00;    //߼ PWM ͨѡλ
    PWMA_PS |= PWM1_2; //ѡ PWM1_2 ͨ

    UpdatePwm();
    PWMA_BKR = 0x80;   //ʹ
//    PWMA_CR1 |= 0x89;  //ʹARRԤװأģʽʼʱ

    P40 = 0;    //LED
    EA = 1;     //ж

    while (1)
    {
        if(B_1ms)
        {
            B_1ms = 0;
            msSecond++;
            if(msSecond >= 10)  //10msһPWM
            {
                msSecond = 0;
                TxPulse(10);    //10
            }
        }
    }
}

/************* 庯 **************/
void TxPulse(u8 rep)
{
    if(rep == 0) return;
    rep -= 1;

    PWMA_RCR = rep;    //ظĴ rep ¼
    PWMA_CR1 |= 0x89;  //ʹARRԤװأģʽʼʱ
}

/********************** Timer0 1msжϺ ************************/
void timer0(void) interrupt 1
{
    B_1ms = 1;
    if(PWM1_Flag)
    {
        Period++;  //ڵ
        if(Period >= 0x1000) PWM1_Flag = 0;
    }
    else
    {
        Period--;  //ڵݼ
        if(Period <= 0x0100) PWM1_Flag = 1;
    }
    UpdatePwm();	//ڡռձ
}

/******************* PWMжϺ ********************/
//void PWMA_ISR() interrupt 26
//{
//    if(PWMA_SR1 & 0X01)
//    {
//        PWMA_SR1 &=~0X01;    //־λ
//    }
//}

//========================================================================
// : UpdatePwm(void)
// : PWMռձ.
// : none.
// : none.
// 汾: V1.0, 2012-11-22
//========================================================================
void UpdatePwm(void)
{
    PWMA_ARRH = (u8)(Period >> 8); //ʱ
    PWMA_ARRL = (u8)Period;
    PWMA_CCR1H = (u8)((Period >> 1) >> 8); //ռձʱ: Period/2
    PWMA_CCR1L = (u8)((Period >> 1));
}
