/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/


/*************  ˵  **************

̻STC32GΪоƬʵбдԡ

ʹKeil C251Memory ModelƼXSmallģʽĬ϶edataʱӴȡٶȿ졣

edata鱣1Kջʹãռ䲻ʱɽ顢ñxdataؼֶ嵽xdataռ䡣

доƬڲɵRTCģ.

·ӲοRTC½-RTCʵս·ͼ.

RTCʱMCU1뻽1ΣѺñȽжⲿѹ12ѹƫͣߣʱֹͣ𵴣RTC.

Ƚͨɵѹ뵽P3.7ڣȽʹڲ1.19Vοѹ.

÷ѹ·ĵI/O(P3.5)ƣI/OΪ©ȽʱΪ1I/Oڸգʡ磻Ƚʱ0ǵأ

ʱ, ѡʱ 24MHZ (û޸Ƶ).

******************************************/

#include "..\comm\STC32G.h"
#include "stdio.h"
#include "intrins.h"

typedef     unsigned char   u8;
typedef     unsigned int    u16;
typedef     unsigned long   u32;

/****************************** û ***********************************/

#define MAIN_Fosc     24000000L   //ʱ
#define PrintUart     2        //1:printf ʹ UART1; 2:printf ʹ UART2
#define Baudrate      115200L
#define TM            (65536 -(MAIN_Fosc/Baudrate/4))

/*****************************************************************************/


/*************  س    **************/

u8 code ledNum[]={0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80};

/*************  ر    **************/

bit B_1s;
bit B_Alarm;        //ӱ־
u8  ledIndex;

/*************  غ    **************/

void RTC_config(void);
void CMP_config(void);
void Ext_Vcc_Det(void);

/******************** ڴӡ ********************/
void UartInit(void)
{
#if(PrintUart == 1)
	SCON = (SCON & 0x3f) | 0x40; 
	T1x12 = 1;          //ʱʱ1Tģʽ
	S1BRT = 0;          //1ѡʱ1Ϊʷ
	TL1  = TM;
	TH1  = TM>>8;
	TR1 = 1;				//ʱ1ʼʱ

//	SCON = (SCON & 0x3f) | 0x40; 
//	T2L  = TM;
//	T2H  = TM>>8;
//	AUXR |= 0x15;   //1ѡʱ2Ϊʷ
#else
	S2_S = 1;       //UART2 switch to: 0: P1.0 P1.1,  1: P4.6 P4.7
    S2CFG |= 0x01;  //ʹô2ʱW1λΪ1ܻԤڵĴ
	S2CON = (SCON & 0x3f) | 0x40; 
	T2L  = TM;
	T2H  = TM>>8;
	AUXR |= 0x14;	      //ʱ2ʱ1Tģʽ,ʼʱ
#endif
}

void UartPutc(unsigned char dat)
{
#if(PrintUart == 1)
	SBUF = dat; 
	while(TI == 0);
	TI = 0;
#else
	S2BUF  = dat; 
	while(S2TI == 0);
	S2TI = 0;    //Clear Tx flag
#endif
}

char putchar(char c)
{
	UartPutc(c);
	return c;
}

/**********************************************/
void main(void)
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x30;   P0M0 = 0x30;   //P0.4P0.5Ϊ©·(ʵ赽3.3V)
    P1M1 = 0x32;   P1M0 = 0x32;   //P1.1P1.4P1.5Ϊ©·(ʵ赽3.3V), P1.1PWMDAC·ͨ贮P2.3
    P2M1 = 0x3c;   P2M0 = 0x3c;   //P2.2~P2.5Ϊ©·(ʵ赽3.3V)
    P3M1 = 0xf0;   P3M0 = 0x70;   //P3.4P3.6Ϊ©·(ʵ赽3.3V), P3.5ÿ©, P3.7ø
    P4M1 = 0x3c;   P4M0 = 0x3c;   //P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    P5M1 = 0x0c;   P5M0 = 0x0c;   //P5.2P5.3Ϊ©·(ʵ赽3.3V)
    P6M1 = 0xff;   P6M0 = 0xff;   //Ϊ©·(ʵ赽3.3V)
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    UartInit();
    CMP_config();
    RTC_config();
    EA = 1;     //ж
    
    while(1)
    {
        if(B_1s)
        {
            B_1s = 0;
            printf("Year=20%d,Month=%d,Day=%d,Hour=%d,Minute=%d,Second=%d\r\n",YEAR,MONTH,DAY,HOUR,MIN,SEC);

            Ext_Vcc_Det();  //ÿӼһⲿԴⲿԴⲿԴϿģʽ
        }

        if(B_Alarm)
        {
            B_Alarm = 0;
            printf("RTC Alarm!\r\n");
        }
    }
} 

//========================================================================
// : void Ext_Vcc_Det(void)
// : ⲿԴ⺯
// : .
// : .
// 汾: V1.0, 2022-10-10
//========================================================================
void Ext_Vcc_Det(void)
{
    P35 = 0;        //Ƚʱ0Ƚϵ·ĵ
    CMPEN = 1;     //ʹܱȽģ
    _nop_();
    _nop_();
    _nop_();
    if(CMPRES)     //жǷCMP+ƽCMP-ⲿԴ
    {
        P40 = 0;		//LED Power On
        P6 = ~ledNum[ledIndex];	//
        ledIndex++;
        if(ledIndex > 7)
        {
            ledIndex = 0;
        }
    }
    else
    {
        CMPEN = 0;      //رձȽģ
        P35 = 1;        //ȽʱΪ1I/Oڸգʡ
        P40 = 1;		//LED Power Off
        _nop_();
        _nop_();
        PCON = 0x02;  //STC32G оƬʹڲ32Kʱӣ޷
        _nop_();
        _nop_();
        _nop_();
        _nop_();
        _nop_();
        _nop_();
    }
}

//========================================================================
// : void CMP_config(void)
// : Ƚʼ
// : .
// : .
// 汾: V1.0, 2022-10-10
//========================================================================
void CMP_config(void)
{
    CMPEXCFG = 0x00;
//  CMPEXCFG |= 0x40;                           //ȽDCѡ0:0mV; 0x40:10mV; 0x80:20mV; 0xc0:30mV

//  CMPEXCFG &= ~0x04;                          //P3.6ΪCMP-
    CMPEXCFG |= 0x04;                           //ڲ1.19VοѹΪCMP-

    CMPEXCFG &= ~0x03;                          //P3.7ΪCMP+
//  CMPEXCFG |= 0x01;                           //P5.0ΪCMP+
//  CMPEXCFG |= 0x02;                           //P5.1ΪCMP+
//  CMPEXCFG |= 0x03;                           //ADCΪCMP+


    CMPCR2 = 0x00;
    INVCMPO = 0;                                //Ƚ
//  INVCMPO = 1;                                //Ƚ
    DISFLT = 0;                                 //ʹ0.1us˲
//  DISFLT = 1;                                 //ֹ0.1us˲
    CMPCR2 &= ~0x3f;                            //Ƚֱ
//  CMPCR2 |= 0x10;                             //Ƚ16ȥʱӺ

    CMPCR1 = 0x00;
    PIE = 0;                                    //ֹȽж
//  PIE = 1;                                    //ʹܱȽж
    NIE = 0;                                    //ֹȽ½ж
//  NIE = 1;                                    //ʹܱȽ½ж

    CMPOE = 0;                                  //ֹȽ
//  CMPOE = 1;                                  //ʹܱȽ

    CMPO_S = 0;                                 //ѡP3.4ΪȽ
//  CMPO_S = 1;                                 //ѡP4.1ΪȽ
    CMPEN = 1;                                  //ʹܱȽģ
}

//========================================================================
// : void RTC_config(void)
// : RTCʼ
// : .
// : .
// 汾: V1.0, 2022-10-10
//========================================================================
void RTC_config(void)
{
    INIYEAR = 21;     //Y:2021
    INIMONTH = 12;    //M:12
    INIDAY = 31;      //D:31
    INIHOUR = 23;     //H:23
    INIMIN = 59;      //M:59
    INISEC = 50;      //S:50
    INISSEC = 0;      //S/128:0

    ALAHOUR = 0;	//Сʱ
    ALAMIN  = 0;	//ӷ
    ALASEC  = 0;	//
    ALASSEC = 0;	//1/128

    //STC32G оƬʹڲ32Kʱӣ޷
//    IRC32KCR = 0x80;   //ڲ32K.
//    while (!(IRC32KCR & 1));  //ȴʱȶ
//    RTCCFG = 0x03;    //ѡڲ32KʱԴRTCĴʼ

    X32KCR = 0x80 + 0x40;   //ⲿ32K, +0x00, +0x40.
    while (!(X32KCR & 1));  //ȴʱȶ
    RTCCFG = 0x01;    //ѡⲿ32KʱԴRTCĴʼ

    RTCIF = 0x00;     //жϱ־
    RTCIEN = 0x88;    //жʹ, 0x80:ж, 0x40:ж, 0x20:Сʱж, 0x10:ж, 0x08:ж, 0x04:1/2ж, 0x02:1/8ж, 0x01:1/32ж
    RTCCR = 0x01;     //RTCʹ

    while(RTCCFG & 0x01);	//ȴʼ,Ҫ "RTCʹ" ֮ж. 
    //RTCʱҪ32768Hz1ʱ,Լ30.5us. ͬ, ʵʵȴʱ0~30.5us.
    //ȴɾ˯, RTCû, ֹͣ, Ѻżò.
}

/******************** RTCжϺ *********************/
void RTC_Isr() interrupt 13
{
	if(RTCIF & 0x80)    //ж
	{
//		P01 = !P01;
		RTCIF &= ~0x80;
		B_Alarm = 1;
	}

	if(RTCIF & 0x08)    //ж
	{
//		P00 = !P00;
		RTCIF &= ~0x08;
		B_1s = 1;
	}
}

/*****************************************************************************/
//˱ȽжϾҪдӦжϺ
void CMP_Isr() interrupt 21
{
    CMPIF = 0;                        //жϱ־
//  P10 = CMPRES;                     //жϷʽȡȽȽϽ
}
