/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/* ΪӦó, Ѳͨ, û, ṩ֧      */
/*---------------------------------------------------------------------*/

//	STC32GϵеEEPROMд

#include "eeprom.h"

#define     IAP_STANDBY()   IAP_CMD = 0     //IAPֹ
#define     IAP_READ()      IAP_CMD = 1     //IAP
#define     IAP_WRITE()     IAP_CMD = 2     //IAPд
#define     IAP_ERASE()     IAP_CMD = 3     //IAP

#define     IAP_ENABLE()    IAP_CONTR = IAP_EN; IAP_TPS = MAIN_Fosc / 1000000
#define     IAP_DISABLE()   IAP_CONTR = 0; IAP_CMD = 0; IAP_TRIG = 0; IAP_ADDRE = 0xff; IAP_ADDRH = 0xff; IAP_ADDRL = 0xff

#define IAP_EN          (1<<7)
#define IAP_SWBS        (1<<6)
#define IAP_SWRST       (1<<5)
#define IAP_CMD_FAIL    (1<<4)


//========================================================================
// : void	ISP_Disable(void)
// : ֹISP/IAP.
// : non.
// : non.
// 汾: V1.0, 2012-10-22
//========================================================================
void	DisableEEPROM(void)	//ֹEEPROM
{
	IAP_CONTR = 0;			//ֹISP/IAP
	IAP_CMD   = 0;			//ȥISP/IAP
	IAP_TRIG  = 0;			//ֹISP/IAP󴥷
	IAP_ADDRE = 0xff;       //ַõ IAP 
	IAP_ADDRH = 0xff;		//0ַֽ
	IAP_ADDRL = 0xff;		//0ַֽڣָEEPROMֹ
}

//========================================================================
// : void EEPROM_Trig(void)
// : EEPROM.
// : none.
// : none.
// 汾: V1.0, 2014-6-30
//========================================================================
void EEPROM_Trig(void)
{
    F0 = EA;    //ȫж
    EA = 0;     //ֹж, ⴥЧ
    IAP_TRIG = 0x5A;
    IAP_TRIG = 0xA5;                    //5AHA5HIAPĴÿζҪ
                                        //A5HIAP
                                        //CPUȴIAPɺ󣬲Żִг
    _nop_();   //STC32GǶ༶ˮߵָϵͳ4NOP֤IAP_DATA׼
    _nop_();
    _nop_();
    _nop_();
    EA = F0;    //ָȫж
}

//========================================================================
// : void EEPROM_SectorErase(u32 EE_address)
// : һ.
// : EE_address:  ҪEEPROMеһֽڵַ.
// : none.
// 汾: V1.0, 2014-6-30
//========================================================================
void EEPROM_SectorErase(u32 EE_address)
{
    IAP_ENABLE();                       //õȴʱ䣬IAPһξ͹
    IAP_ERASE();                        //, ıʱ
                                        //ֻûֽڲ512ֽ/
                                        //һֽڵַַ
    IAP_ADDRE = (u8)(EE_address >> 16); //ַֽڣַҪıʱ͵ַ
    IAP_ADDRH = (u8)(EE_address >> 8);  //ַֽڣַҪıʱ͵ַ
    IAP_ADDRL = (u8)EE_address;         //ַֽڣַҪıʱ͵ַ
    EEPROM_Trig();                      //EEPROM
    DisableEEPROM();                    //ֹEEPROM
}

//========================================================================
// : void EEPROM_read_n(u32 EE_address,u8 *DataAddress,u8 lenth)
// : Nֽں.
// : EE_address:  ҪEEPROM׵ַ.
//       DataAddress: Ҫݵָ.
//       length:      Ҫĳ
// : 0: дȷ.  1: д볤Ϊ0.  2: дݴ.
// 汾: V1.0, 2014-6-30
//========================================================================
void EEPROM_read_n(u32 EE_address,u8 *DataAddress,u8 length)
{
    IAP_ENABLE();                           //õȴʱ䣬IAPһξ͹
    IAP_READ();                             //ֽڶıʱ
    do
    {
        IAP_ADDRE = (u8)(EE_address >> 16); //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRH = (u8)(EE_address >> 8);  //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRL = (u8)EE_address;         //͵ַֽڣַҪıʱ͵ַ
        EEPROM_Trig();                      //EEPROM
        *DataAddress = IAP_DATA;            //
        EE_address++;
        DataAddress++;
    }while(--length);

    DisableEEPROM();
}


//========================================================================
// : u8 EEPROM_write_n(u32 EE_address,u8 *DataAddress,u8 length)
// : дNֽں.
// : EE_address:  ҪдEEPROM׵ַ.
//       DataAddress: Ҫдݵָ.
//       length:      Ҫдĳ
// : 0: дȷ.  1: д볤Ϊ0.  2: дݴ.
// 汾: V1.0, 2014-6-30
//========================================================================
u8 EEPROM_write_n(u32 EE_address,u8 *DataAddress,u8 length)
{
    u8  i;
    u16 j;
    u8  *p;
    
    if(length == 0) return 1;   //Ϊ0

    IAP_ENABLE();                       //õȴʱ䣬IAPһξ͹
    i = length;
    j = EE_address;
    p = DataAddress;
    IAP_WRITE();                            //, ֽд
    do
    {
        IAP_ADDRE = (u8)(EE_address >> 16); //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRH = (u8)(EE_address >> 8);  //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRL = (u8)EE_address;         //͵ַֽڣַҪıʱ͵ַ
        IAP_DATA  = *DataAddress;           //ݵIAP_DATAֻݸıʱ
        EEPROM_Trig();                      //EEPROM
        EE_address++;                       //һַ
        DataAddress++;                      //һ
    }while(--length);                       //ֱ

    EE_address = j;
    length = i;
    DataAddress = p;
    i = 0;
    IAP_READ();                             //NֽڲȽ
    do
    {
        IAP_ADDRE = (u8)(EE_address >> 16); //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRH = (u8)(EE_address >> 8);  //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRL = (u8)EE_address;         //͵ַֽڣַҪıʱ͵ַ
        EEPROM_Trig();                      //EEPROM
        if(*DataAddress != IAP_DATA)        //ԴݱȽ
        {
            i = 2;
            break;
        }
        EE_address++;
        DataAddress++;
    }while(--length);

    DisableEEPROM();
    return i;
}

