/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/* ΪӦó, Ѳͨ, û, ṩ֧      */
/*---------------------------------------------------------------------*/

/*************	˵	**************

̻STC32GΪоƬбдԡ

ʹKeil C251Memory ModelƼXSmallģʽĬ϶edataʱӴȡٶȿ졣

ʾ

	ʵV9.6 2022-12-16.
	ѧϰ塢MCU;: 0513-5501292855012929
	1www.STCMCUDATA.com
	2www.STCAI.com
	̳ www.STCAIMCU.com

ʾ:
ѹ: 5.0V
MCU:      STC32G12K128.
Ƶ:     35MHz
ADC:      ߲800KHz 12λʾʹ߲500KHz
ģ: ̽ͷx1ڵ250mV/DIV̽ͷx10ڵ2.5V/DIV100KHz
ʾ:   ʾ, ͨŷʽ USB-CDC
          ˮƽ16һ25㣬һ400㣬洢4000㡣
          ֱ10ÿ25㣬һ250㡣
ʱ:     1-2-550us 100us 200us 500us 1ms 2ms 5ms 10ms 20ms 50ms
                     100ms 200ms 500ms 1s 2s 5s 10s 20s 50s
ֱ: ̽ͷx1:   50mV  100mV  250mV  500mV   1V  2.5V   5V  10V/DIV
          ̽ͷx10: 500mV     1V   2.5V     5V  10V   25V  50V  100V/DIV
ѹ: ̽ͷx1 +-50V̽ͷx10+-500V
ģʽ: ش½ش
ʽ: Զ׼Ρ

******************************************/


#include	"inc\stc.h"
#include	"EEPROM.h"
#include	"stc.h"
#include	"usb.h"
#include	"uart.h"


/*************	س	**************/
#define		K_BaseTimeUp	0x01
#define		K_BaseTimeDn	0x02
#define		K_VoltageUp		0x03
#define		K_VoltageDn		0x04
#define		K_RUN_STOP 		0x05
#define		K_TrigPhase		0x06
#define		K_TrigMode		0x07
#define		K_ShiftLeft		0x08
#define		K_ShiftRight	0x09
#define		K_WaveUp		0x0A
#define		K_WaveDown		0x0B
#define		K_RtnMssage		0x0C

#define		EE_ADDR		0x000000


/*************	IO	**************/

sbit	P_V_A    = P0^0;	//ѡ
sbit	P_V_B    = P0^1;	//ѡ, CBA   000 001 010 011 100 101 110 111
sbit	P_V_C    = P0^2;	//ѡ,    2   4   10  1   20 200  40 100  
//P0.7--T4CLKO: 1000Hz
//P1.3--ADC12: 
//P1.1--PWM1N: ֱλPWM
//P2.3--PWM8:  SPWM, 100HzҲ.

	

/*************	ر	**************/
u8	KeyCode;

u8	xdata adc_sample[4008];
u8	edata	tmp[32];
u8	edata	adc_tmp[410];
bit	B_ADC_Busy, B_Sample_OK;
u16	adc_wr, adc_rd;
u8	adc;
u8	SampleIndex;
u16	sample_cnt;
bit	B_sample_ms;
u16	SampleTime;
bit	B_Run;
u16	LastDot;
u8	TimeScale;		//ʱϵ, 10: 10ȡ1, 5: 5ȡ1, 2: 2ȡ1, 1: 1ȡ1
u8	TimeScaleIndex;	//ʱϵ, 0-->10, 1-->5, 2-->2, 3-->1
bit	B_RUN_REQ;		//ֹͣ

bit	B_TrigPhase;	//Ĭش
u8	TrigMode;

u8	InputIndex;		//ȵλ
u8	AutoTimeCnt;
u8	AutoTime;
u8	pwm1_voltage;

bit	B_Shift;	//λ־, ֹͣʱлʱλ
u16	Shift;		//λ
u8	Current_TimeBase;
u8	WriteDelay;	//дʱ

u8	cnt_1ms, cnt_8ms, cnt_32ms;
bit	B_8ms, B_32ms;
bit	B_32ms_rtn;

u16 	TxCnt;


/*************	غ	**************/
void	ShowOscope(void);
void	RealShowOscope(void);
void	Timer0_config(void);
void	Timer4_Config(void);
void	SetSampleTime(void);
void	ShowVoltage(void);

void	ShowTimeBase(void);	//ʾʱ
void	ShowPhase(void);
void	ShowRunStop(void);	//ʾ״̬
void	ShowStartTime(void);

void	ADC_config(void);
void	Compare_Config(void);	//Ƚʼ
void	PWMA_config(void);
void	PWMB_config(void);
void	AutoCheck(void);
void 	ShowTrigMode(void);
void	ShowRunStop(void);
void	OscStop(void);

void	TxData255(u8 dat);	//תַ
void	TX_write2buff(u8 dat);	//д뷢ͻ壬ָ+1
void	TrigTx(void);	//


/****************  ⲿⲿ *****************/

/**************************************************************/

// SampleIndex   0     1      2      3      4     5      6     7      8     9     10     11     12     13     14   15   16    17    18    19    20
//ʱ/DIV         10us  20us   50us  100us  200us  500us   1ms   2ms    5ms  10ms   20ms   50ms  100ms  200ms  500ms  1s   2s    5s   10s   20s   50s
//һά3, (SampleIndex % 3), ڶάϵ, ΪÿNȡһ, ָ2.5ȡһ, зÿ5ȡ0 2.
u8	const 	T_TimeScale[3][4]={	{10,5,2,1},
								{10,5,3,1},
								{10,4,2,1}};

//========================================================================
void  delay_ms(u16 ms)
{
     u16 i;
	 do
	 {
	 	i = MAIN_Fosc / 6000;
		while(--i)	;
     }while(--ms);
}

/****************   *****************/
void	main(void)
{
	u16	j;

	WTST  = 0;
	CKCON = 0;
    EAXFR = 1;	//չĴ

	P0M1 = 0;	P0M0 = 0;	//Ϊ׼˫
	P1M1 = 0;	P1M0 = 0;	//Ϊ׼˫
	P2M1 = 0;	P2M0 = 0;	//Ϊ׼˫
	P3M1 = 0;	P3M0 = 0;	//Ϊ׼˫
	P4M1 = 0;	P4M0 = 0;	//Ϊ׼˫
	P5M1 = 0;	P5M0 = 0;	//Ϊ׼˫
	P6M1 = 0;	P6M0 = 0;	//Ϊ׼˫
	P7M1 = 0;	P7M0 = 0;	//Ϊ׼˫
	
	P0n_push_pull(0x80);	//P0.7 T4CLKO 1000Hz

	uart_init();
	usb_init();
	EA = 1;

	delay_ms(1500);
//	while(DeviceState != DEVSTATE_CONFIGURED)	{	NOP(3);	}
	
	ADC_config();		//ADCʼ
	Compare_Config();	//ģȽʼ
	Timer0_config();	//Timer0ʼ, 
	Timer4_Config();	//Timer4ʼ, 1000Hz.
	PWMA_config();		//PWMƴֱλ
	PWMB_config();		//1000HzҲ
	
	EX1 = 1;	//ж
	IT1 = 1;	//½ж

	WriteDelay = 0;
	EEPROM_read_n(EE_ADDR, tmp, 6);
	if(tmp[4] == (tmp[0]+tmp[1]+tmp[2]+tmp[3]) ^ 0x55)	//У
	{
		pwm1_voltage = tmp[0];
		SampleIndex = tmp[1];	InputIndex = tmp[2];	TrigMode = tmp[3];
		if(TrigMode & 0x80)	B_TrigPhase = 1;
		else				B_TrigPhase = 0;
		TrigMode &= 0x03;
		if(pwm1_voltage > 250)	pwm1_voltage = 128;	//Ĭе
		if(SampleIndex > 20)	SampleIndex  = 6;	//Ĭ1ms/div
		if(SampleIndex < 2)		SampleIndex  = 6;	//Ĭ1ms/div
		if(InputIndex >= 8)		InputIndex   = 3;	//Ĭ1V/div
		if(TrigMode >= 3)		TrigMode     = 0;	//ĬԶ
		WriteDelay = 0;		//дʱ
	}
	else	//Уûͨ
	{
		B_TrigPhase = 0;	//Ĭش
		pwm1_voltage = 128;	//Ĭе
		SampleIndex  = 6;	//Ĭ1ms/div
		InputIndex   = 3;	//Ĭ1V/div
		TrigMode     = 0;	//ĬԶ
		WriteDelay   = 250;	//дʱ
	}
	PWMA_CCR1L = pwm1_voltage;
	

	B_Shift = 0;
	Shift  = 0;
	B_ADC_Busy = 0;
	B_Run = 1;

	ShowTimeBase();		//ʾˮƽʱ
	ShowVoltage();		//ʾֱѹ
	ShowRunStop();		//ʾֹͣ/
	ShowPhase();		//ʾģʽ()
	ShowTrigMode();		//ʾʽ
	
	KeyCode = 0;

	while (1)
	{
		if(B_8ms)	//8ms
		{
			B_8ms = 0;
			AutoCheck();	// ʱ
		}

		if(B_32ms)
		{
			B_32ms = 0;
			if(WriteDelay != 0)		//ʱд
			{
				if(--WriteDelay == 0)
				{
					tmp[0] = pwm1_voltage;
					tmp[1] = SampleIndex;
					tmp[2] = InputIndex;
					tmp[3] = TrigMode;
					if(B_TrigPhase)	tmp[3] |= 0x80;
					tmp[4] = (tmp[0]+tmp[1]+tmp[2]+tmp[3]) ^ 0x55;	//У
					EEPROM_SectorErase(EE_ADDR);
					EEPROM_write_n(EE_ADDR,tmp,6);
				}
			}
		}
				
		if(B_Run)
		{
			if(!B_ADC_Busy)		//һβ
			{
				B_Sample_OK = 0;
				adc_wr = 0;
				adc_rd = 0;
					 if(SampleIndex <= 2)	TimeScale = 1,	TimeScaleIndex = 3;	// 50us/DIV		ȡ	ֹͣʱ2ڲ910
				else if(SampleIndex == 3)	TimeScale = 2,	TimeScaleIndex = 2;	// 100us/DIV	2ȡ1	ֹͣʱ2ڲ45
				else if(SampleIndex == 4)	TimeScale = 4,	TimeScaleIndex = 1;	// 200us/DIV	4ȡ1	ֹͣʱ2ڲ2.52.5
				else 						TimeScale = 10,	TimeScaleIndex = 0;	// >=500us/DIV	10ȡ1
				Current_TimeBase = SampleIndex;
				B_ADC_Busy = 1;
				SetSampleTime();	//òʱ
				if(!B_TrigPhase)	CMPCR1 = 0x80 + 0x20;	// Ƚжϴ, ڵ·ԭ,ʵλ෴
				else				CMPCR1 = 0x80 + 0x10;	// Ƚ½жϴ, ڵ·ԭ,ʵλ෴
					 if(SampleIndex <= 6)	CMPCR2 = 10;	// <=1ms/DIV (<=4us/sample)			Ƚûлͷʱ3, ٶ
				else if(SampleIndex <= 8)	CMPCR2 = 30;	// 2ms 5ms/DIV (8us 20us/sample)	Ƚлͷʱע͵3.
				else 						CMPCR2 = 63;	// 2ms 5ms/DIV (8us 20us/sample)
			}
			else if(SampleIndex <= 10)	// <=20ms/DIV
			{
				if(B_Sample_OK)		//
				{
					B_Sample_OK = 0;
					B_ADC_Busy  = 0;
					while(!B_32ms_rtn)	{	NOP(5);	}	//USBϴٶ̫죬ϴٶ
					B_32ms_rtn = 0;
					ShowOscope();	//ʾ
					if(B_RUN_REQ || (TrigMode == 2))	OscStop();	//ֹͣ  ģʽ ֹͣ
				}
			}

			else if(B_Sample_OK)	//50ms/DIVϲ, ʵʱˢ
			{
				B_Sample_OK = 0;
				RealShowOscope();	//ʵʱʾ
				if(adc_rd >= 4000)	//
				{
					B_ADC_Busy = 0;
					if(B_RUN_REQ || (TrigMode == 2))	OscStop();	//ֹͣ  ģʽ ֹͣ
				}
			}
		}
		else	B_ADC_Busy = 0;

		if (RxFlag)                         //RxFlagΪ1ʱ,ʾѽյCDC
											//յݴСRxCount,ÿ64ֽ
											//ݱRxBuffer
		{
			if((RxCount == 4) && (RxBuffer[0]==0xfe) &&(RxBuffer[1] == 0x01) && (RxBuffer[3] == 0xff))
			KeyCode = RxBuffer[2];			//PC´룺FE 01 DAT0 FF
			uart_recv_done();               //Խյݴɺ,һҪһ,ԱCDCһʴ
		}

		if(KeyCode)	//м
		{
			if(KeyCode == K_RUN_STOP)		///ֹͣ
			{
				if(!B_Run)			//ֹͣ
				{
					if(InputIndex >= 8)	InputIndex = 7;
					ShowVoltage();
					B_Run = 1;		//
					B_RUN_REQ = 0;
					ShowRunStop();
					B_Shift = 0;
					Shift  = 0;
				}
				else	//
				{
					if(TrigMode != 0)			OscStop();	//׼ģʽ ģʽ, ֱֹͣ
					else if(SampleIndex >= 11)	OscStop();	//ɨģʽ, ֱֹͣ
					else	B_RUN_REQ = 1;	//, ֹͣ, ֹͣ
				}
			}

			else if(KeyCode == K_TrigPhase)	//л ½ش
			{
				B_TrigPhase = ~B_TrigPhase;
				ShowPhase();
				B_ADC_Busy = 0;		//лģʽ(ûֹͣĻ)
				WriteDelay = 250;	//дʱ8
			}

			else if(KeyCode == K_TrigMode)	//лʽ
			{
				if(++TrigMode >= 3)	TrigMode = 0;	//0: Զ, 1:ͨ(׼), 2:
				ShowTrigMode();
				B_ADC_Busy = 0;		//лģʽ(ûֹͣĻ)
				WriteDelay = 250;	//дʱ8
			}

			else if(KeyCode == K_BaseTimeUp)	// ʱ+
			{
				if(SampleIndex < 20)
				{
					if(B_Run)	//иıʱ, ı
					{
						SampleIndex++;
						B_ADC_Busy = 0;
						ShowTimeBase();	//ʾʱ
						WriteDelay = 250;	//дʱ8
					}
					else if(TimeScaleIndex != 0)	//ֹͣʱʱˢ²
					{
						SampleIndex++;
						TimeScaleIndex--;	//ֹͣʱ
						Shift = Shift * TimeScale;
						TimeScale = T_TimeScale[Current_TimeBase%3][TimeScaleIndex];	//ʱϵ, 0-->10, 1-->5, 2-->2, 3-->1
						Shift = Shift / TimeScale;
						if(TimeScaleIndex == 0)	Shift = 0;
						ShowTimeBase();	//ʾʱ
						ShowStartTime();	//ʾʼʱ
						ShowOscope();		//ֹͣˢ²
						WriteDelay = 250;	//дʱ8
					}
				}
			}

			else if(KeyCode == K_BaseTimeDn)		// ʱ-
			{
				if(SampleIndex > 2)
				{
					if(B_Run)	//иıʱ, ı
					{
						SampleIndex--;
						B_ADC_Busy = 0;
						ShowTimeBase();	//ʾʱ
						WriteDelay = 250;	//дʱ8
					}
					else if(TimeScaleIndex < 3)	//ֹͣʱʱˢ²
					{
						SampleIndex--;
						TimeScaleIndex++;	//ֹͣʱ
						Shift = Shift * TimeScale;
						TimeScale = T_TimeScale[Current_TimeBase%3][TimeScaleIndex];	//ʱϵ, 0-->10, 1-->5, 2-->2, 3-->1
						Shift = Shift / TimeScale;
						ShowTimeBase();	//ʾʱ
						ShowStartTime();	//ʾʼʱ
						ShowOscope();		//ֹͣˢ²
						WriteDelay = 250;	//дʱ8
					}
				}
			}

			else if(KeyCode == K_VoltageUp)	//ֱ +
			{
				if(B_Run)	//
				{
					if(InputIndex != 0)	//ֱ
					{
						InputIndex--;
						ShowVoltage();
						WriteDelay = 250;	//дʱ8
					}
				}
			}
			else if(KeyCode == K_VoltageDn)	// ֱ -
			{
				if(B_Run)	//
				{
					if(InputIndex < 7)	//ֱ
					{
						InputIndex++;
						ShowVoltage();
						WriteDelay = 250;	//дʱ8
					}
				}
			}

			else if(KeyCode == K_WaveUp)	//
			{
				if(B_Run)	//
				{
					if(pwm1_voltage != 0)	pwm1_voltage--;
					PWMA_CCR1L = pwm1_voltage;
					WriteDelay = 250;	//дʱ8
				}
			}
			else if(KeyCode == K_WaveDown)	//
			{
				if(B_Run)	//
				{
					if(pwm1_voltage < 250)	pwm1_voltage++;
					PWMA_CCR1L = pwm1_voltage;
					WriteDelay = 250;	//дʱ8
				}
			}

			else if(KeyCode == K_ShiftLeft)	//
			{
				if(!B_Run)	//ֹͣʱ, ƶ
				{
					Shift++;
					TimeScale = T_TimeScale[Current_TimeBase%3][TimeScaleIndex];	//ʱϵ, 0-->10, 1-->5, 2-->2, 3-->1
					if(TimeScale == 3)	j = 8000/5 - 400;
					else				j = 4000/TimeScale - 400;
					if(Shift >= j)	Shift = j;
					ShowStartTime();	//ʾʼʱ
					ShowOscope();		//ֹͣˢ²
				}
			}
			else if(KeyCode == K_ShiftRight)	//
			{
				if(!B_Run)	//ֹͣʱ, ƶ
				{
					if(Shift != 0)	Shift--;
					TimeScale = T_TimeScale[Current_TimeBase%3][TimeScaleIndex];	//ʱϵ, 0-->10, 1-->5, 2-->2, 3-->1
					if(TimeScale == 3)	j = 8000/5 - 400;
					else				j = 4000/TimeScale - 400;
					if(Shift >= j)	Shift = j;
					ShowStartTime();	//ʾʼʱ
					ShowOscope();		//ֹͣˢ²
				}
			}
			
			else if(KeyCode == K_RtnMssage)	//ز
			{
				ShowTimeBase();		//ʾˮƽʱ
				ShowVoltage();		//ʾֱѹ
				ShowRunStop();		//ʾֹͣ/
				ShowPhase();		//ʾģʽ()
				ShowTrigMode();		//ʾʽ
			}	

			KeyCode = 0;
		}
	}
}
/**********************************************/



/*************** תַ *******************************/
void	TxData255(u8 dat)
{
	if(dat >= 0xfb)
	{
		TX_write2buff(0xfd);	//תַ
		TX_write2buff(dat & 0x7f);
	}
	else	TX_write2buff(dat);
}


/*************** װشڷͻ *******************************/
void TX_write2buff(u8 dat)	//д뷢ͻ壬ָ+1
{
	TxBuffer[TxCnt++] = dat;
}

/***************  *******************************/
void	TrigTx(void)	//
{
	uart_send(TxCnt);	//Ҫ͵ݱTxBuffer, Ȼuart_send(n)ݷ,Ϊ͵ֽ. һɷ64K,ڲԶUSBְ.
}

/***************** ʾʽ *****************************/
void ShowTrigMode(void)
{
	TxCnt = 0;
	TX_write2buff(0xfe);		//ʼ
	TX_write2buff(0x06);		//ϴʽFE 06 DATA0 FF
	TX_write2buff(TrigMode);	//ʽ0--Զ1--ͨ׼2--Ρ
	TX_write2buff(0xff);		//
	TrigTx();	//
}

/***************** ʾ״̬ *****************************/
void	ShowRunStop(void)
{
	TxCnt = 0;
	TX_write2buff(0xfe);		//ʼ
	TX_write2buff(0x04);		//ϴģʽFE 04 DATA0 FF
	TX_write2buff((u8)B_Run);	//ģʽ0--ֹͣ1--С
	TX_write2buff(0xff);		//
	TrigTx();	//
}


/***************** ֹͣк *****************************/
void	OscStop(void)
{
	CMPCR1 = 0x80;		// رȽж
	TR0    = 0;			//رղʱ1
	B_ADC_Busy = 0;
	B_Run = 0;
	B_RUN_REQ = 0;
	AutoTimeCnt = 0;
	ShowRunStop();
	Shift = 0;			//ֹͣλ
	ShowStartTime();	//ʾʼʱ

	if(Current_TimeBase == 4)	//200us/DIV
	{
		Current_TimeBase = 5;
		TimeScaleIndex   = 1;
	}
	else if(Current_TimeBase == 3)	//100us/DIV
	{
		Current_TimeBase = 5;
		TimeScaleIndex   = 2;
	}
	else if(Current_TimeBase == 2)	//50us/DIV
	{
		Current_TimeBase = 5;
		TimeScaleIndex   = 3;
	}
}


          // SampleIndex   0     1      2      3      4     5     6     7      8     9     10     11     12     13   14    15    16    17    18    19    20
          //ʱ䵥λ       0.1us 0.1us     us     us     us   10us  10us  10us   0.1ms 0.1ms  0.1ms   1ms   1ms    1ms  10ms  10ms  10ms  0.1s  0.1s  0.1s   1s 
u16 const   StartTimeTable[]= {   4,    8,     2,     4,     8,    2,     4,    8,    2,    4,     8,     2,     4,     8,    2,    4,    8,    2,    4,    8,   2};
          //ʱ/DIV        10us  20us   50us  100us  200us  500us   1ms   2ms    5ms  10ms   20ms   50ms  100ms  200ms  500ms   1s   2s    5s   10s   20s   50s
u8	const	StartTimeDanWei[]={   2,    2,     3,     3,     3,    4,     4,    4,    5,    5,     5,     6,     6,     6,    7,    7,    7,    8,    8,    8,   9};
//    DAT2ʱ䵥λ0--1ns1--10ns, 2--100ns, 3--1us4--10us, 5--100us, 6--1ms7--10ms, 8--100ms, 9--1s

/***************** ʾʼʱ亯 *****************************/
void ShowStartTime(void)
{
	u16	j;

	TxCnt = 0;
	j = StartTimeTable[SampleIndex] * Shift;
	TX_write2buff(0xfe);	//ʼ
	TX_write2buff(0x08);	//ϴʱ䣺FE 08 DATA0 DATA1 DATA2 FF
	TxData255((u8)(j >> 8));
	TxData255((u8)j);
	TX_write2buff(StartTimeDanWei[SampleIndex]);	//ʱ䵥λ: ʱ䵥λ0--1ns1--10ns, 2--100ns, 3--1us4--10us, 5--100us, 6--1ms7--10ms, 8--100ms, 9--1s
	TX_write2buff(0xff);	//
	TrigTx();	//
}



	#define	X_START		40
	#define	Y_START		25
	#define	GridColor	GREEN	//ɫ
	#define	WaveColor	YELLOW	//ɫ


//	P_V_C = 0;	P_V_B = 1;	P_V_A = 1;	//ѡ, CBA   000 001 010 011 100 101 110 111
										//				   2   4   10  1   20 200  40 100
  //InputIndex      0   1    2    3   4    5    6    7    8   9   10
			//      1   2    4   10  20   40   100  200  200 200 200
u8	const T_V_GAIN[14]={ 3,  0,   1,   2,  4,   6,   7,   5,   5,  5,  5};	//ѹ
			//     1V 500m 250m 100m 50m  25m  10m  5m  2.5m  1m 0.5m
			//    10V  5V  2.5V  1V  500m 250m 100m 50m  25m 10m  5m

/************** ʾκ ( 50us<  <=20ms/DIV ֹͣʱ) ********************/
void	ShowOscope(void)
{
	u16	x,j;
	u8	i;

	if(TimeScale == 3)
	{
		j = 8000/5 - 400;	//λ
		if(Shift >= j)	Shift = j;
		for(j=(Shift*5)/2,x=0; x<400; x++)
		{
			i = adc_sample[j];	//һ
			if(i > 250)	i = 250;
			adc_tmp[x] = i;
			j = j + 2;
			x++;
			i = adc_sample[j];	//һ
			if(i > 250)	i = 250;
			adc_tmp[x] = i;
			j = j + 3;
		}
	}
	else
	{
		j = 4000/TimeScale - 400;	//λ
		if(Shift >= j)	Shift = j;
		for(j=Shift*TimeScale,x=0; x<400; x++)
		{
			i = adc_sample[j];	//һ
			if(i > 250)	i = 250;
			adc_tmp[x] = i;
			j = j + TimeScale;
		}
	}
	
	TxCnt = 0;
	TX_write2buff(0xfb);	//ϴһ֡ݣFB DAT0 DAT1 ..... DAT399 FF
	for(x=0; x<400; x++)	TX_write2buff(adc_tmp[x]);
	TX_write2buff(0xff);	//
	TrigTx();	//
}


/************** ʵʱʾκ(>=50ms/DIV) ********************/
void	RealShowOscope(void)
{
	u16	x;
	u8	i;

	x = adc_rd/10;
	if(x >= 400)	return;	

	i = adc_sample[adc_rd];
	if(i > 250)	i = 250;	//ж, жϲж
	TxCnt = 0;
	TX_write2buff(0xfc);	//ϴһݣFC DAT0 DAT1 DAT2 FF
	TxData255((u8)(x>>8));	//Xλøֽ
	TxData255((u8)x);		//Xλõֽ
	TX_write2buff(i);			//Yֵ(0~250)
	TX_write2buff(0xff);	//
	TrigTx();	//
	adc_rd += 10;
}


/***************** ADCú *****************************/
#define ADC_START	(1<<6)	/* Զ0 */
#define ADC_FLAG	(1<<5)	/* 0 */

#define	ADC_SPEED	0		/* 0~15, ADCʱ = SYSclk/2/(n+1) */
#define	RES_FMT		(0<<5)	/* ADCʽ 0: , ADC_RES: D9 D8 D7 D6 D5 D4 D3 D2, ADC_RESL: D1 D0 0  0  0  0  0  0 */
							/*             1: Ҷ, ADC_RES: 0  0  0  0  0  0  D9 D8, ADC_RESL: D7 D6 D5 D4 D3 D2 D1 D0 */

#define CSSETUP		(0<<7)	/* 0~1,  ADCͨѡʱ      0: 1ADCʱ, 1: 2ADCʱ,  Ĭ0(Ĭ1ADCʱ)	*/
#define CSHOLD		(0<<5)	/* 0~3,  ADCͨѡ񱣳ʱ  (n+1)ADCʱ, Ĭ1(Ĭ2ADCʱ)					*/
#define SMPDUTY		10		/* 10~31, ADCģźŲʱ  (n+1)ADCʱ, Ĭ10(Ĭ11ADCʱ)				*/
							/* ADCתʱ: 10λADC̶Ϊ10ADCʱ, 12λADC̶Ϊ12ADCʱ. 				*/

void	ADC_config(void)
{
	P1n_pure_input(0x08);	//ҪADCIO
	ADC_CONTR = 0x80 + 3;	//ADC on + channel
	ADCCFG = RES_FMT + ADC_SPEED;
	P_SW2 |=  0x80;	//XSFR
	ADCTIM = CSSETUP + CSHOLD + SMPDUTY;	//28 ADC CLOCK
}
//***********************************************************************************************

//========================================================================
// : void Timer4_Config(void)
// : timer3ʼ.
// : none.
// : none.
// 汾: V1.0, 2018-12-20
//========================================================================
void Timer4_Config(void)
{
	P_SW2 |= 0x80;		//SFR enable   
	T4T3M &= 0x0f;		//ֹͣ, ʱģʽ, 12Tģʽ, ʱ

	T4T3M |=  (1<<5);	//1T mode
	T4H = (u8)((65536UL - MAIN_Fosc/2000) /256);
	T4L = (u8)((65536UL - MAIN_Fosc/2000) %256);

	T3T4PIN = 0x00;		//ѡIO, 0x00: T3--P0.4, T3CLKO--P0.5, T4--P0.6, T4CLKO--P0.7;    0x01: T3--P0.0, T3CLKO--P0.1, T4--P0.2, T4CLKO--P0.3;
	T4T3M |=  (1<<4);	//ʱ
	T4T3M |=  (1<<7);	//ʼ
}

/************************ Ƚú ****************************/
void	Compare_Config(void)	//Ƚʼ
{
	CMPCR1 = 0;
	CMPCR2 = 63;		//ȽϽ仯ʱ, 0~63
	CMPCR1 |= (1<<7);	//1: Ƚ,     0:رձȽ
	CMPCR1 |= (0<<5);	//1: ж, 0: ֹ
	CMPCR1 |= (0<<4);	//1: ½ж, 0: ֹ
	CMPCR1 |= (0<<1);	//1: ȽϽIO(P3.4P4.1),  0: ȽϽֹIO
	CMPCR2 |= (0<<7);	//1: ȽIOȡ, 0: ȡ
	CMPCR2 |= (0<<6);	//0: ڲ0.1uF˲,    1: ر

	P_SW2 |=  0x80;	//XSFR
	CMPEXCFG = (3<<6) | (1<<2) | 3;	// bit7 bi6(ȽDCѡ): 0--0mV, 1--10mV, 2--20mV, 3--30mV,  
									// bit2(ѡ): 1: ѡڲBandGapѹBGv, 0: ѡⲿP3.6
									// bit1 bit0(ѡ): 0--P3.7, 1--P5.0, 2--P5.1, 3--ADCIN(ADC_CONTRbit3:0ѡ, ADC_CONTRλ1)

	IP2  |= (1<<5);	//Ƚжȼ
	IP2H |= (1<<5);

	CMPCR1 = 0x80;			// رȽж
//	CMPCR1 = 0x80 + 0x20;	// Ƚж
//	CMPCR1 = 0x80 + 0x10;	// Ƚ½ж
}

/***************** ȽжϺ *****************************/
void CMP_ISR(void) interrupt CMP_VECTOR		//ȽжϺ, ⵽綯ƹ0¼
{
	ADC_RES = 0;
//	ADC_RESL = 0;
	ADC_CONTR = 0x80 + ADC_START + 3;	//ADC on + channel
	TR0 = 1;		//ʼTimer1.

	AutoTimeCnt = 0;	//ͬź, ȡʱ
	adc_wr  = 0;
	adc_rd  = 0;

	CMPCR1 = 0x80;		// رȽж жϱ־λ
}

//================= ʱ ========================
void	AutoCheck(void)
{
	if(AutoTimeCnt != 0)		//8ms call
	{
		if(--AutoTimeCnt == 0)	//ͬʱ, ǿ
		{
			ADC_RES = 0;
			ADC_RESL = 0;
			ADC_CONTR = 0x80 + ADC_START + 3;	//ADC on + channel
			TR0 = 1;		//ʼTimer1.

			CMPCR1 = 0x80;		// رȽж
			adc_wr  = 0;
			adc_rd  = 0;
		}
	}
}


//========================================================================
// : void PWMA_config(void)
// : PWMAʼ.
// : none.
// : none.
// 汾: V1.0, 2022-6-25
//========================================================================
void PWMA_config(void)
{
	u8	ccer1;
	u8	ccer2;
	u8	ps;
	u8	eno;
	u8	PWMA_ISR_En;

	P_SW2 |= 0x80;		//SFR enable   
	PWMA_ENO    = 0;	// IOֹ
	PWMA_IER    = 0;	// ֹж
	PWMA_SR1    = 0;	// ״̬
	PWMA_SR2    = 0;	// ״̬
	ccer1 = 0;
	ccer2 = 0;
	ps    = 0;
	eno   = 0;
	PWMA_ISR_En = 0;

	PWMA_PSCRH = 0x00;		// ԤƵĴ, Ƶ Fck_cnt = Fck_psc/(PSCR[15:0}+1), ضPWMƵ = SYSclk/((PSCR+1)*(AAR+1)), PWMƵ = SYSclk/((PSCR+1)*(AAR+1)*2).
	PWMA_PSCRL = 0x00;
	PWMA_DTR   = 0;			// ʱ, n=0~127: DTR= n T,   0x80 ~(0x80+n), n=0~63: DTR=(64+n)*2T,  
							//				0xc0 ~(0xc0+n), n=0~31: DTR=(32+n)*8T,   0xE0 ~(0xE0+n), n=0~31: DTR=(32+n)*16T,
	PWMA_ARRH   = 256/256;	// ԶװؼĴ,  PWM
	PWMA_ARRL   = 256%256;

	PWMA_CCMR1  = 0x68;		// ͨģʽ, PWMģʽ1, Ԥװ
	PWMA_CCR1H  = 128/256;	// Ƚֵ, ռձ(ߵƽʱ)
	PWMA_CCR1L  = 128%256;
	ccer1 |= 0x07;			// Ƚ, ͵ƽЧ
	ps    |= 0;				// ѡIO, 0:ѡP1.0 P1.1, 1:ѡP2.0 P2.1, 2:ѡP6.0 P6.1, 
	eno   |= 0x02;			// IO,  bit7: ENO4N, bit6: ENO4P, bit5: ENO3N, bit4: ENO3P,  bit3: ENO2N,  bit2: ENO2P,  bit1: ENO1N,  bit0: ENO1P
//	PWMA_ISR_En|= 0x02;		// ʹж

	PWMA_CCER1  = ccer1;	// /ȽʹܼĴ1
	PWMA_CCER2  = ccer2;	// /ȽʹܼĴ2
	PWMA_PS     = ps;		// ѡIO
	PWMA_IER    = PWMA_ISR_En;	//ͨ1~4жϴ

	PWMA_BKR    = 0x80;		// ʹ ൱ܿ
	PWMA_CR1    = 0x81;		// ʹܼ, ԶװؼĴ, ضģʽ, ϼ,  bit7=1:дԶװؼĴ(ڲᱻ), =0:ֱдԶװؼĴ(ڿܻҵ)
	PWMA_EGR    = 0x01;		//һθ¼, ԤƵ, װԤƵĴֵ
	PWMA_ENO    = eno;		// IO

	P1n_push_pull(1<<1);	//P1.1 Ϊ
}
//	PWMA_PS   = (0<<6)+(0<<4)+(0<<2)+0;	//ѡIO, 4Ӹߵ()ӦPWM1 PWM2 PWM3 PWM4, 0:ѡP1.x, 1:ѡP2.x, 2:ѡP6.x, 
//  PWMA_PS    PWM4N PWM4P    PWM3N PWM3P    PWM2N PWM2P    PWM1N PWM1P
//    00       P1.7  P1.6     P1.5  P1.4     P1.3  P5.4     P1.1  P1.0
//    01       P2.7  P2.6     P2.5  P2.4     P2.3  P2.2     P2.1  P2.0
//    02       P6.7  P6.6     P6.5  P6.4     P6.3  P6.2     P6.1  P6.0
//    03       P3.3  P3.4      --    --       --    --       --    --

//========================================================================
// : void PWMB_config(void)
// : PWMAʼ.
// : none.
// : none.
// 汾: V1.0, 2022-6-25
//========================================================================
void PWMB_config(void)
{
	u8	ccer1;
	u8	ccer2;
	u8	ps;
	u8	eno;
	u8	PWMB_ISR_En;

	P_SW2 |= 0x80;		//SFR enable   
	PWMB_ENO    = 0;	// IOֹ
	PWMB_IER    = 0;	// ֹж
	PWMB_SR1    = 0;	// ״̬
	PWMB_SR2    = 0;	// ״̬
	ccer1 = 0;
	ccer2 = 0;
	ps    = 0;
	eno   = 0;
	PWMB_ISR_En = 0;

	PWMB_PSCRH = 0x00;		// ԤƵĴ, Ƶ Fck_cnt = Fck_psc/(PSCR[15:0}+1), ضPWMƵ = SYSclk/((PSCR+1)*(AAR+1)), PWMƵ = SYSclk/((PSCR+1)*(AAR+1)*2).
	PWMB_PSCRL = 6;
	PWMB_ARRH  = 0;			// ԶװؼĴ,  PWM, PWMƵ = 35000000/(6+1)/250=20000
	PWMB_ARRL  = 250-1;

	PWMB_CCMR4  = 0x68;		// ͨģʽ, PWMģʽ1, Ԥװ
	PWMB_CCR4H  = 0;		// Ƚֵ, ռձ(ߵƽʱ)
	PWMB_CCR4L  = 87;
	ccer2 |= 0x50;			// Ƚ, ߵƽЧ
	ps    |= (0<<6);		// ѡIO, 0:ѡP2.3, 1:ѡP3.4, 2:ѡP0.3, 3:ѡP7.7, 
	eno   |= 0x40;			// IO,  bit6: ENO8P, bit4: ENO7P,  bit2: ENO6P,  bit0: ENO5P
//	PWMB_ISR_En|= 0x10;		// ʹж

	PWMB_ISR_En = 0x01;		// ʹܸж

	PWMB_CCER1  = ccer1;	// /ȽʹܼĴ1
	PWMB_CCER2  = ccer2;	// /ȽʹܼĴ2
	PWMB_PS     = ps;		// ѡIO
	PWMB_IER    = PWMB_ISR_En;	//ͨ1~4жϴ

	PWMB_BKR    = 0x80;		// ʹ ൱ܿ
	PWMB_CR1    = 0x81;		// ʹܼ, ԶװؼĴ, ضģʽ, ϼ,  bit7=1:дԶװؼĴ(ڲᱻ), =0:ֱдԶװؼĴ(ڿܻҵ)
	PWMB_EGR    = 0x01;		//һθ¼, ԤƵ, װԤƵĴֵ
	PWMB_ENO    = eno;		// IO

	P2n_push_pull(1<<3);	//P2.3Ϊ
}
//	PWMB_PS   = (0<<6)+(0<<4)+(0<<2)+0;	//ѡIO, 4Ӹߵ()ӦPWM8 PWM7 PWM6 PWM5
//  PWMB_PS    PWM8    PWM7    PWM6    PWM5
//    00       P2.3    P2.2    P2.1    P2.0
//    01       P3.4    P3.3    P5.4    P1.7
//    02       P0.3    P0.2    P0.1    P0.0
//    03       P7.7    P7.6    P7.5    P7.4

//========================================================================
// : void PWMA_ISR(void) interrupt PWMA_VECTOR
// : PWMAжϴ. ͨ TIM1-> CCRnH / TIM1-> CCRnL ȡ
// : None
// : none.
// 汾: V1.0, 2021-6-1
//========================================================================
#include	"SineTable.h"
u8	SineIndex;
void PWMB_ISR(void) interrupt PWMB_VECTOR
{
	u8	sr1;

	sr1 = PWMB_SR1;	//Ϊ˿, жϱ־һֲ
	PWMB_SR1 = 0;	//жϱ־
	PWMB_SR2 = 0;	//жϱ־
//	sr1 &= PWMB_ISR_En;	//ÿͨԵжϴ
	if(sr1 & 0x01)	//жϱ־
	{
		PWMB_CCR4L = T_SIN[SineIndex];		//P1.11000HzҲ
		if(++SineIndex == 20)	SineIndex = 0;

		if(++cnt_1ms == 20)
		{
			cnt_1ms = 0;
			if(++cnt_8ms == 8)
			{
				cnt_8ms = 0;
				B_8ms = 1;
			}
			if(++cnt_32ms == 32)
			{
				cnt_32ms = 0;
				B_32ms = 1;
				B_32ms_rtn = 1;
			}
		}
	}

}

//========================================================================
// :void	Timer0_config(void)
// : timer0ʼ.
// : noe.
// : none.
// 汾: V1.0, 2018-12-20
//========================================================================
void	Timer0_config(void)
{
	TR0 = 0;	//ֹͣ
	ET0 = 1;	//ж
	PT0 = 1;	//ȼж
	TMOD &= ~0x03;
//	TMOD |= 0;	//ģʽ, 0: 16λԶװ, 1: 16λʱ/, 2: 8λԶװ
	Timer0_1T();	//1T mode
//	TR0 = 1;	//ʼ
}

//========================================================================
void timer0_ISR (void) interrupt TMR0_VECTOR
{
	adc = ~ADC_RES;
	ADC_RES = 0;
//	ADC_RESL = 0;
	ADC_CONTR = 0x80 + ADC_START + 3;	//ADC on + channel

	if(!B_sample_ms)	//  <=20ms/DIV, һʾ
	{
		adc_sample[adc_wr] = adc;
		if(++adc_wr >= 4000)	B_Sample_OK = 1, TR0 = 0;
	}

	else if(--sample_cnt == 0)	// >=50ms/DIV ʵʱɨʾ
	{
		sample_cnt = SampleTime;
		adc_sample[adc_wr] = adc;
		if((adc_wr%10) == 0)	B_Sample_OK = 1;
		if(++adc_wr >= 4000)	B_Sample_OK = 1, TR0 = 0;
	}
}




#define	D_MAIN_CLOCK	(MAIN_Fosc/1000000UL)

          // SampleIndex   0     1      2      3      4     5      6     7      8     9     10     11     12     13     14   15   16    17    18    19    20
          //ʱ䵥λ          us    us     us     us     us    us     us    us     us    us     us     ms     ms     ms     ms   ms   ms    ms    ms    ms    ms 
u16	const   SampleTimeTable[]={   2,    2,     2,     2,     2,     2,    4,    8,    20,   40,    80,   200,   400,   800,     2,   4,    8,   20,   40,   80,  200};
          //ʱ/DIV        10us  20us   50us  100us  200us  500us   1ms   2ms    5ms  10ms   20ms   50ms  100ms  200ms  500ms   1s   2s    5s   10s   20s   50s
u16	const   T_Time_div[]=     {  10,   20,    50,   100,   200,   500,    1,    2,     5,   10,    20,    50,   100,   200,   500,   1,    2,    5,   10,   20,   50};
u8	const   T_Time_DanWei[]=  {   1,    1,     1,     1,     1,     1,    2,    2,     2,    2,     2,     2,     2,     2,     2,   3,    3,    3,    3,    3,    3};

/***************** òʱ亯 *****************************/
void	SetSampleTime(void)
{
	u16	j;

		 if(SampleIndex <= 5)	ADCCFG = RES_FMT + 0;	// ADC CLOCK = 20MHz @2us/sample,  ADC CLOCK = SYSclk/2/(n+1), תҪ 28 ADC CLOCK
	else if(SampleIndex == 6)	ADCCFG = RES_FMT + 1;	// ADC CLOCK = 10MHz @4us/sample,  ADC CLOCK = SYSclk/2/(n+1)
	else if(SampleIndex == 7)	ADCCFG = RES_FMT + 3;	// ADC CLOCK =  5MHz @8us/sample,  ADC CLOCK = SYSclk/2/(n+1)
	else 						ADCCFG = RES_FMT + 9;	// ADC CLOCK =  2MHz >=20us/sample, ADC CLOCK = SYSclk/2/(n+1)

		 if(SampleIndex <= 8)	AutoTime = 100/8;	//ͬʱ100ms	   <=5ms/div		<=60ms/frme
	else if(SampleIndex == 9)	AutoTime = 200/8;	//ͬʱ200ms	   10ms/div			==120ms/frme
	else if(SampleIndex == 10)	AutoTime = 400/8;	//ͬʱ500ms	   20ms/div			==240ms/frme
	else if(SampleIndex == 11)	AutoTime = 800/8;	//ͬʱ800ms	   50ms/div			==600ms/frme
	else if(SampleIndex == 12)	AutoTime = 1600/8;	//ͬʱ800ms	   100ms/div		==600ms/frme
	else 						AutoTime = 2000/8;	//ͬʱ1200ms   >=200ms/div		>=1200ms/frme

	if(TrigMode == 0)	AutoTimeCnt = AutoTime;	//Զģʽ

	if(SampleIndex <= 10)	//50us 100us 200us/DIV2us, 500us~20ms/DIVʹ10
	{
		j = SampleTimeTable[SampleIndex];
		TR0 = 0;	//ֹͣ
		B_sample_ms = 0;
		TH0 = (u8)((65536UL - j*D_MAIN_CLOCK) / 256);
		TL0 = (u8)((65536UL - j*D_MAIN_CLOCK) % 256);
	}
	
	else if(SampleIndex <= 13)	// 50ms 100ms 200ms/DIVʹ10
	{
		j = SampleTimeTable[SampleIndex];
		TR0 = 0;	//ֹͣ
		SampleTime  = 1;	//һжϲһ
		sample_cnt  = 1;
		B_sample_ms = 1;	//ʵʱɨʾ
		TH0 = (u8)((65536UL - j*D_MAIN_CLOCK) / 256);
		TL0 = (u8)((65536UL - j*D_MAIN_CLOCK) % 256);
	}

	else 		// >=500ms/DIV, ʵʱɨ, ʱжϹ̶Ϊ1ms
	{
		j = SampleTimeTable[SampleIndex];
		TR0 = 0;	//ֹͣ
		SampleTime  = j;	//һӦжϴ
		sample_cnt  = j;
		B_sample_ms = 1;	//ʵʱɨʾ
		TH0 = (u8)((65536UL - 1000*D_MAIN_CLOCK) / 256);	//1msж
		TL0 = (u8)((65536UL - 1000*D_MAIN_CLOCK) % 256);
	}
}

/***************** ʾʱ *****************************/
void	ShowTimeBase(void)
{
	TxCnt = 0;
	TX_write2buff(0xfe);	//ʼ
	TX_write2buff(0x02);	//ϴʱ: FE 02 DATA0 DATA1 DATA2 FF
	TX_write2buff((u8)(T_Time_div[SampleIndex] >> 8));
	TxData255((u8)T_Time_div[SampleIndex]);
	TX_write2buff(T_Time_DanWei[SampleIndex]);	//ʱ䵥λ: 0--ns, 1--us, 2--ms, 3--s
	TX_write2buff(0xff);	//
	TrigTx();	//
}


	//InputIndex     0   1    2    3     4    5      6    7
	//InputIndex+3                 3     4    5      6    7      8    9  10   11   12   13
	// V/DIV        10V  5V  2.5V  1V  500mV 250mV 100mV 50mV
u16 const T_VOLTAGE[]={ 10000, 5000, 2500, 1000, 500, 250, 100, 50};

/***************** ʾֱѹλ V/DIV  *****************************/
void	ShowVoltage(void)
{
	u8	i;
	TxCnt = 0;
	TX_write2buff(0xfe);	//ʼ
	TX_write2buff(0x03);	//ϴֱȲ: FE 03 DATA0 DATA1 DATA2 FF
	TX_write2buff((u8)(T_VOLTAGE[InputIndex] >> 8));
	TxData255((u8)T_VOLTAGE[InputIndex]);
	TX_write2buff(0x01);	//ѹλ: mV
	TX_write2buff(0xff);	//
	TrigTx();	//

	i = T_V_GAIN[InputIndex];
	if(i & 0x04)	P_V_C = 1;	else P_V_C = 0;
	if(i & 0x02)	P_V_B = 1;	else P_V_B = 0;
	if(i & 0x01)	P_V_A = 1;	else P_V_A = 0;
}

/***************** ʾģʽ *****************************/
void	ShowPhase(void)
{
	TxCnt = 0;
	TX_write2buff(0xfe);	//ʼ
	TX_write2buff(0x05);	//ϴʽ: FE 05 DATA0 FF
	if(B_TrigPhase)	TX_write2buff(0x00);	//  B_TrigPhase=1:, 0:½.
	else			TX_write2buff(0x01);	//  DAT0ģʽ0--أ1--½ء
	TX_write2buff(0xff);	//
	TrigTx();	//
}

