/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ            */
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻STC32GΪоƬʵбдԡ

ʾSTC-ISP(V6.91P)ƳĴڻͼܡ

ͨ1ݸڻͼԽӿڣ1(P3.0, P3.1)115200,N,8,1

ʱ, ѡĬʱ 22.1184MHz (û޸Ƶ)

̣
1.¼ʾʵ䣬ʹUSBתڹӵʵJ17ӿڡ
2.STC-ISPѡSTCԽӿڡ˵ġӿáѡѡ񡰽еԽӿڰ󶨵USB-CDC/֡
3.򿪡USB-CDC/֡ǩҳ棬ѡ񴮿ڹ߶ӦĴںţúòʣ򿪴ڡ
4.STC-ISPѡSTCԽӿڡ˵ġڻͼܣͨò˵ѡͨ1ͨ2ݸʽáֽڡ
ͿԿͨ1ͨ2ͼ

******************************************/

#include "stc32g.h"
#include "stdio.h"

#define FOSC        22118400UL
#define BAUD        (65536 - FOSC/4/115200)
#define T5MS        (65536 - FOSC/200)

typedef unsigned char uchar;
typedef unsigned int uint;

uchar code SIN_TAB[256] = 
{
    100, 102, 105, 107, 110, 112, 115, 117, 120, 122, 124, 127, 129, 131, 134, 136,    
    138, 141, 143, 145, 147, 149, 151, 153, 156, 158, 160, 162, 163, 165, 167, 169,    
    171, 172, 174, 176, 177, 179, 180, 182, 183, 184, 186, 187, 188, 189, 190, 191,    
    192, 193, 194, 195, 196, 196, 197, 198, 198, 199, 199, 199, 200, 200, 200, 200,    
    200, 200, 200, 200, 200, 199, 199, 199, 198, 198, 197, 196, 196, 195, 194, 193,    
    192, 191, 190, 189, 188, 187, 186, 184, 183, 182, 180, 179, 177, 176, 174, 172,    
    171, 169, 167, 165, 163, 162, 160, 158, 156, 153, 151, 149, 147, 145, 143, 141,    
    138, 136, 134, 131, 129, 127, 124, 122, 120, 117, 115, 112, 110, 107, 105, 102,    
    100, 98,  95,  93,  90,  88,  85,  83,  80,  78,  76,  73,  71,  69,  66,  64, 
    62,  59,  57,  55,  53,  51,  49,  47,  44,  42,  40,  38,  37,  35,  33,  31, 
    29,  28,  26,  24,  23,  21,  20,  18,  17,  16,  14,  13,  12,  11,  10,  9,  
    8,   7,   6,   5,   4,   4,   3,   2,   2,   1,   1,   1,   0,   0,   0,   0,  
    0,   0,   0,   0,   0,   1,   1,   1,   2,   2,   3,   4,   4,   5,   6,   7,  
    8,   9,   10,  11,  12,  13,  14,  16,  17,  18,  20,  21,  23,  24,  26,  28, 
    29,  31,  33,  35,  37,  38,  40,  42,  44,  47,  49,  51,  53,  55,  57,  59, 
    62,  64,  66,  69,  71,  73,  76,  78,  80,  83,  85,  88,  90,  93,  95,  98, 
};

bit f1ms;
uchar dat;

void main()
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ
    
    P0M0 = 0x00; P0M1 = 0x00;
    P1M0 = 0x00; P1M1 = 0x00;
    P2M0 = 0x00; P2M1 = 0x00;
    P3M0 = 0x00; P3M1 = 0x00;
    P4M0 = 0x00; P4M1 = 0x00;
    P5M0 = 0x00; P5M1 = 0x00;
    P6M0 = 0x00; P6M1 = 0x00;
    P7M0 = 0x00; P7M1 = 0x00;
    
    SCON = 0x52;
    AUXR = 0xC0;
    TMOD = 0x00;
    TL1 = BAUD;
    TH1 = BAUD >> 8;
    TR1 = 1;
    TL0 = T5MS;
    TH0 = T5MS >> 8;
    TR0 = 1;
    ET0 = 1;
    EA = 1;
    
    f1ms = 0;
    dat = 0;
    
    while (1)
    {
        if (f1ms)
        {
            f1ms = 0;
            putchar((uchar)(dat));  //ͨ1
            putchar((uchar)(SIN_TAB[dat]));  //ͨ2
            
            dat++;
        }
    }
}

void tm0_isr() interrupt 1
{
    f1ms = 1;
}

char putchar(char dat)
{
    while (!TI);
    TI = 0;
    SBUF = dat;
    
    return dat;
}
