/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ        */
/*---------------------------------------------------------------------*/


/*************  ˵    **************

̻STC32G12K128ΪоƬʵ9бд.

ø߼PWMA/PWMBжʵֶʱ.

ʱ = ((PWMx_PSCR + 1) * (PWMx_ARR + 1)) / SYSclk.

ʱ, ѡʱ 24MHZ (û޸Ƶ).

******************************************/

#include "..\comm\STC32G.h"
#include "intrins.h"

#define     MAIN_Fosc       24000000L   //ʱ

typedef     unsigned char   u8;
typedef     unsigned int    u16;
typedef     unsigned long   u32;

/****************************** û ***********************************/


/*****************************************************************************/

void PWMA_Timer(u32 timer);
void PWMB_Timer(u32 timer);

/********************  **************************/
void main(void)
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x30;   P0M0 = 0x30;   //P0.4P0.5Ϊ©·(ʵ赽3.3V)
    P1M1 = 0x30;   P1M0 = 0x30;   //P1.4P1.5Ϊ©·(ʵ赽3.3V)
    P2M1 = 0x3c;   P2M0 = 0x3c;   //P2.2~P2.5Ϊ©·(ʵ赽3.3V)
    P3M1 = 0x50;   P3M0 = 0x50;   //P3.4P3.6Ϊ©·(ʵ赽3.3V)
    P4M1 = 0x3c;   P4M0 = 0x3c;   //P4.2~P4.5Ϊ©·(ʵ赽3.3V)
    P5M1 = 0x0c;   P5M0 = 0x0c;   //P5.2P5.3Ϊ©·(ʵ赽3.3V)
    P6M1 = 0xff;   P6M0 = 0xff;   //Ϊ©·(ʵ赽3.3V)
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    PWMA_Timer(1000);		//1ms
    PWMB_Timer(5000000);	//5s

    P40 = 0;		//LED
    EA = 1;     //ж

    while (1);
}

//========================================================================
// : void PWMA_Timer(u32 timer)
// : PWMAú.
// : None
// : none.
// 汾: V1.0, 2021-02-08
//========================================================================
void PWMA_Timer(u32 timer)
{
	u16 psc=1;
		
	timer *= (MAIN_Fosc / 1000000);	//timer us
	while(timer > 65535L)
	{
		psc *= 2;
		timer >>= 1;
	}
	timer--;
	psc--;
	
	//ʱ = ((PWMx_PSCR + 1) * (PWMx_ARR + 1)) / SYSclk
    PWMA_ARRH = (u8)(timer >> 8); //ʱ
    PWMA_ARRL = (u8)(timer);
    PWMA_PSCRH = (u8)(psc >> 8);  //ԤƵ
    PWMA_PSCRL = (u8)(psc);

	PWMA_IER = 0x01; // ʹж
	PWMA_CR1 |= 0x81; //ʹARRԤװأʼʱ
}

//========================================================================
// : void PWMB_Timer(u32 timer)
// : PWMBú.
// : None
// : none.
// 汾: V1.0, 2021-02-08
//========================================================================
void PWMB_Timer(u32 timer)
{
	u16 psc=1;
	
	timer *= (MAIN_Fosc / 1000000);	//timer us
	while(timer > 65535L)
	{
		psc *= 2;
		timer >>= 1;
	}
	timer--;
	psc--;
	
	//ʱ = ((PWMx_PSCR + 1) * (PWMx_ARR + 1)) / SYSclk
    PWMB_ARRH = (u8)(timer >> 8); //ʱ
    PWMB_ARRL = (u8)(timer);
    PWMB_PSCRH = (u8)(psc >> 8);  //ԤƵ
    PWMB_PSCRL = (u8)(psc);

	PWMB_IER = 0x01; // ʹж
	PWMB_CR1 |= 0x81; //ʹARRԤװأʼʱ
}

//========================================================================
// : PWMA_ISR() interrupt 26
// : PWMAжϺ.
// : None
// : none.
// 汾: V1.0, 2020-12-04
//========================================================================
void PWMA_ISR() interrupt 26
{
	PWMA_SR1 = 0;
	P60 = ~P60;
}

//========================================================================
// : PWMB_ISR() interrupt 27
// : PWMBжϺ.
// : None
// : none.
// 汾: V1.0, 2020-12-04
//========================================================================
void PWMB_ISR() interrupt 27
{
	PWMB_SR1 = 0;
	P64 = ~P64;
}

