/*---------------------------------------------------------------------*/
/* --- STC MCU Limited ------------------------------------------------*/
/* --- STC 1T Series MCU Demo Programme -------------------------------*/
/* --- Mobile: (86)13922805190 ----------------------------------------*/
/* --- Fax: 86-0513-55012956,55012947,55012969 ------------------------*/
/* --- Tel: 86-0513-55012928,55012929,55012966 ------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/* --- BBS: www.STCAIMCU.com  -----------------------------------------*/
/* --- QQ:  800003751 -------------------------------------------------*/
/* Ҫڳʹô˴,ڳעʹSTCϼ        */
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻STC32G12K128ΪоƬʵбд.

ʹUSBӺİUSBӿ;

MCUͨUSB CDC(Communication Device Class)ЭʶΪ2豸;

CDC1⴮ڣͨTXD3_2(P5.1), RXD3_2(P5.0)ӿշ; CDC2⴮ڣͨTXD2_2(P4.7), RXD2_2(P4.6)ӿշ
̽ʵϵJ7J8߼ɽUSBת˫ڼ໥ͨš

ͨconfig.hġDynamic_FrequencyݴͨŲʶ̬IRCƵٲʼ
ʹܺɸݴڲʶ̬Ƶߴͨžȷȣ
һͨʵƵ仯һͨĲʼͻӰ죻
Ҫ˹ܿ塣

߲ͨʿɴ10Mbps.

P3.2ڰֶϿ(ԴʵQ11Cȡ)ɿָ硣

ʱ, ѡʱ 24MHZ (û޸Ƶ)

******************************************/

#include "stc.h"
#include "usb.h"
#include "uart.h"
#include "timer.h"

unsigned long MAIN_Fosc = 24000000L;    //Ĭʱ

bit Key_Flag;
u8  Key_cnt;

void sys_init();
void KeyResetScan(void);

void main()
{
    sys_init();
    uart_init();
    timer_init();
    usb_init();
    EA = 1;
    
    while (1)
    {
        uart_polling();
        if(f1ms)
        {
            f1ms = 0;
            KeyResetScan();
        }
    }
}

void sys_init()
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x00;   P0M0 = 0x00;   //Ϊ׼˫
    P1M1 = 0x00;   P1M0 = 0x00;   //Ϊ׼˫
//    P1M1 = 0x00;   P1M0 = 0x40;   //Ϊ׼˫, P1.6λ(IRCƵ֤)
    P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
    P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
    P4M1 = 0x00;   P4M0 = 0x00;   //Ϊ׼˫
    P5M1 = 0x00;   P5M0 = 0x00;   //Ϊ׼˫
    P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫
    
//    MCLKOCR = 0x81; //ʱƵ1ƵP1.6(IRCƵ֤)

    S3_S = 1;       //UART3(RxD3_2/P5.0, TxD3_2/P5.1)
    S2_S = 1;       //UART2(RxD2_2/P4.6, TxD2_2/P4.7)
    
    DOWNLOAD = 1;       //P3.2
    SVCC_E = 0;         //SVCCʹ(P4.0)
    LED_POWER = 0;      //ָʾ(P6.7)
}

#define SVCC_ON()           SVCC_E = 0; P5M1 &= ~0x03   //P5.0,P5.1׼˫ģʽ
#define SVCC_OFF()          SVCC_E = 1; P5M1 |= 0x03   //P5.0,P5.1øģʽ

//========================================================================
// : void KeyResetScan(void)
// : P3.2ڰS-VCCϵ硣
// : none.
// : none.
// 汾: VER1.0
// : 2022-12-06
// ע: 
//========================================================================
void KeyResetScan(void)
{
    if(!P32)
    {
        if(!Key_Flag)
        {
            Key_cnt++;
            if(Key_cnt >= 50)		//50msЧ
            {
                Key_Flag = 1;		//ð״ֹ̬ظ

                SVCC_OFF();
            }
        }
    }
    else
    {
        Key_cnt = 0;
        if(Key_Flag)
        {
            SVCC_ON();
            Key_Flag = 0;
        }
    }
}
