/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻AI8051UΪоƬʵбдԡ

ʹKeil C51,Ϊ˴ﵽȽϸߵЧ,һ㽨ѡ"Small"ģʽ

 "error C249: 'DATA': SEGMENT TOO LARGE" ʱҪֱֶȽϴͨ"xdata" ǿƷ䵽 XDATA (: char xdata buffer [256];)

ʾЧΪ: ϵʾ2, Ȼ˯2, ʾ2,һֱظ.

ʱ, ѡʱ 24MHZ (û޸Ƶ).

******************************************/

#include "../comm/AI8051U.h"
#include "stdio.h"
#include "intrins.h"

typedef     unsigned char    u8;
typedef     unsigned int    u16;
typedef     unsigned long    u32;

/*************  س    **************/

#define MAIN_Fosc        24000000UL

u8 code ledNum[]={0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80};

/*************  ر    **************/

u8 ledIndex;
u16 msecond;        //1000ms

/*************  غ    **************/

void delay_ms(u8 ms);
void SetWakeUpTime(u16 SetTime);

/****************  ⲿⲿ *****************/


/********************  **************************/
void main(void)
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    P_SW2 |= EAXFR; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x00;   P0M0 = 0x00;   //Ϊ׼˫
    P1M1 = 0x00;   P1M0 = 0x00;   //Ϊ׼˫
    P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
    P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
    P4M1 = 0x00;   P4M0 = 0x00;   //Ϊ׼˫
    P5M1 = 0x00;   P5M0 = 0x00;   //Ϊ׼˫
    P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    SetWakeUpTime(2000);    //2
    P40 = 0;        //LED Power On

    while(1)
    {
        delay_ms(100);    //ʱ100ms

        //ָʾ״̬
        P0 = ~ledNum[ledIndex];    //
        ledIndex++;
        if(ledIndex > 7)
        {
            ledIndex = 0;
        }

        //2MCU״̬
        if(++msecond >= 20)
        {
            msecond = 0;    //
            P0 = 0xff;      //ȹرʾʡ

            PCON |= PD;         //Sleep
            _nop_();
            _nop_();
            _nop_();
            _nop_();
            _nop_();
            _nop_();
            _nop_();
        }
    }
}

//========================================================================
// : void SetWakeUpTime(u16 SetTime)
// : Ѷʱʱֵ
// : SetTime: Ҫõʱֵ(˯ߵʱ), λΪms.
// : none.
// 汾: VER1.0
// : 2024-7-15
// ע: 
//========================================================================
void SetWakeUpTime(u16 SetTime)
{
    SetTime = (u16)((32768UL * (u32)SetTime) / 16000);  //װֵ = Fwkt/16 * SetTime/1000 = Fwkt * SetTime / 16000
    if(SetTime > 0) SetTime--;
    WKTCL = (u8)SetTime;
    WKTCH = (u8)(SetTime >> 8) | 0x80;
}

//========================================================================
// : void delay_ms(unsigned char ms)
// : ʱ
// : ms,Ҫʱms, ֻ֧1~255ms. ԶӦʱ.
// : none.
// 汾: VER1.0
// : 2023-4-1
// ע: 
//========================================================================
void delay_ms(u8 ms)
{
    u16 i;
    do{
        i = MAIN_Fosc / 6000;
        while(--i);
    }while(--ms);
}
