/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻AI8051UΪоƬʵбдԡ

ʹKeil C51,Ϊ˴ﵽȽϸߵЧ,һ㽨ѡ"Small"ģʽ

 "error C249: 'DATA': SEGMENT TOO LARGE" ʱҪֱֶȽϴͨ"xdata" ǿƷ䵽 XDATA (: char xdata buffer [256];)

ʵϵS2ز"ͨ"в.

1(P3.6,P3.7)ʱһݸ2(P4.2,P4.3).

2(P4.2,P4.3)Ӵ1(P3.6,P3.7)յ.

ʱ, ѡʱ 22.1184MHZ (û޸Ƶ).

******************************************/

#include    "..\comm\AI8051U.h"
#include    "intrins.h"

#define     MAIN_Fosc       22118400L   //ʱ

typedef     unsigned char   u8;
typedef     unsigned int    u16;
typedef     unsigned long   u32;

/****************************** û ***********************************/

#define Timer0_Reload   (65536UL -(MAIN_Fosc / 1000))       //Timer 0 жƵ, 1000/

#define Baudrate2   115200UL
#define Baudrate1   115200UL

#define UART2_BUF_LENGTH    128
#define UART1_BUF_LENGTH    128

/*****************************************************************************/

/*************  ر    **************/
bit B_1ms;      //1ms־
u16 Sec_Cnt;    //1

u8  TX2_Cnt;    //ͼ
u8  RX2_Cnt;    //ռ
u8  TX1_Cnt;    //ͼ
u8  RX1_Cnt;    //ռ
bit B_TX2_Busy; //æ־
bit B_TX1_Busy; //æ־
u8 RX2_TimeOut;
u8 RX1_TimeOut;

u8  xdata RX2_Buffer[UART2_BUF_LENGTH]; //ջ
u8  xdata RX1_Buffer[UART1_BUF_LENGTH]; //ջ

void UART2_config(u8 brt);   // ѡ, 2: ʹTimer2, ֵ: Ч.
void UART1_config(u8 brt);   // ѡ, 2: ʹTimer2, ֵ: ʹTimer1.
void UART2_TxByte(u8 dat);
void UART1_TxByte(u8 dat);
void PrintString2(u8 *puts);
void PrintString1(u8 *puts);
/********************  **************************/
void main(void)
{
    u8 i;
	
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXSFR(); //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x00;   P0M0 = 0x00;   //Ϊ׼˫
    P1M1 = 0x00;   P1M0 = 0x00;   //Ϊ׼˫
    P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
    P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
    P4M1 = 0x00;   P4M0 = 0x00;   //Ϊ׼˫
    P5M1 = 0x00;   P5M0 = 0x00;   //Ϊ׼˫
    P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    //  Timer0ʼ
    AUXR = 0x80;    //Timer0 set as 1T, 16 bits timer auto-reload, 
    TH0 = (u8)(Timer0_Reload / 256);
    TL0 = (u8)(Timer0_Reload % 256);
    ET0 = 1;    //Timer0 interrupt enable
    TR0 = 1;    //Tiner0 run

    UART2_config(2);    // ѡ, 2: ʹTimer2, ֵ: Ч.
    UART1_config(1);    // ѡ, 2: ʹTimer2, ֵ: ʹTimer1.
    EA = 1;     //ж

    PrintString2("AI8051U UART2 Test Programme!\r\n");  //UART2һַ
    PrintString1("AI8051U UART1 Test Programme!\r\n");  //UART1һַ

    while (1)
    {
        if(B_1ms)
        {
            B_1ms = 0;
            Sec_Cnt++;
            if(Sec_Cnt>=1000)
            {
                Sec_Cnt = 0;
                PrintString1("AI8051U UART1-UART2 Test Programme!\r\n");  //UART1һַ
            }
//            if(RX1_TimeOut > 0)     //ʱ
//            {
//                if(--RX1_TimeOut == 0)
//                {
//                    for(i=0; i<RX1_Cnt; i++)    UART1_TxByte(RX1_Buffer[i]);    //3յԭ
//                    RX1_Cnt  = 0;   //ֽ
//                }
//            }

            if(RX2_TimeOut > 0)     //ʱ
            {
                if(--RX2_TimeOut == 0)
                {
                    for(i=0; i<RX2_Cnt; i++)    UART2_TxByte(RX2_Buffer[i]);    //յͨ2
                    RX2_Cnt  = 0;   //ֽ
                }
            }
        }
    }
}


/********************** Timer0 1msжϺ ************************/
void timer0(void) interrupt 1
{
	B_1ms = 1;
}

//========================================================================
// : void UART2_TxByte(u8 dat)
// : һֽ.
// : .
// : .
// 汾: V1.0, 2014-6-30
//========================================================================
void UART2_TxByte(u8 dat)
{
    B_TX2_Busy = 1;
    S2BUF = dat;
    while(B_TX2_Busy);
}

//========================================================================
// : void UART1_TxByte(u8 dat)
// : һֽ.
// : .
// : .
// 汾: V1.0, 2014-6-30
//========================================================================
void UART1_TxByte(u8 dat)
{
    B_TX1_Busy = 1;
    SBUF = dat;
    while(B_TX1_Busy);
}

//========================================================================
// : void PrintString2(u8 *puts)
// : 2ַ
// : puts:  ַָ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void PrintString2(u8 *puts)
{
    for (; *puts != 0;  puts++)     //ֹͣ0
    {
        UART2_TxByte(*puts);
    }
}

//========================================================================
// : void PrintString1(u8 *puts)
// : 3ַ
// : puts:  ַָ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void PrintString1(u8 *puts)
{
    for (; *puts != 0;  puts++)     //ֹͣ0
    {
        UART1_TxByte(*puts);
    }
}

//========================================================================
// : SetTimer2Baudraye(u32 dat)
// : Timer2ʷ
// : dat: Timer2װֵ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void SetTimer2Baudraye(u32 dat)
{
    AUXR &= ~(1<<4);		//Timer stop
    AUXR &= ~(1<<3);	//Timer2 set As Timer
    AUXR |= (1<<2);	//Timer2 set as 1T mode
    T2H = (u8)(dat / 256);
    T2L = (u8)(dat % 256);
    IE2 = (IE2 & ~0x04) | (0 << 2);    //ֹж
    AUXR = (AUXR & ~0x10) | (1 << 4);		//Timer run enable
}

//========================================================================
// : void UART1_config(u8 brt)
// : UART1ʼ
// : brt: ѡ, 2: ʹTimer2, ֵ: ʹTimer1.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART1_config(u8 brt)    // ѡ, 2: ʹTimer2, ֵ: ʹTimer1.
{
    /*********** ʹöʱ2 *****************/
    if(brt == 2)
    {
        AUXR |= S1BRT;	//S1 BRT Use Timer2;
        SetTimer2Baudraye(65536UL - (MAIN_Fosc / 4) / Baudrate1);
    }

    /*********** ʹöʱ1 *****************/
    else
    {
        TR1 = 0;
        AUXR &= ~S1BRT;		//S1 BRT Use Timer1;
        TMOD &= ~(1<<6);		//Timer1 set As Timer
        AUXR |= (1<<6);		//Timer1 set as 1T mode
        TMOD &= ~0x30;//Timer1_16bitAutoReload;
        TH1 = (u8)((65536UL - (MAIN_Fosc / 4) / Baudrate1) / 256);
        TL1 = (u8)((65536UL - (MAIN_Fosc / 4) / Baudrate1) % 256);
        ET1 = 0;    //ֹж
        TR1 = 1;
    }
    /*************************************************/

    SCON = (SCON & 0x3f) | 0x40;    //UART1ģʽ, 0x00: ͬλ, 0x40: 8λ,ɱ䲨, 0x80: 9λ,̶, 0xc0: 9λ,ɱ䲨
//  PS  = 1;    //ȼж
    ES  = 1;    //ж
    REN = 1;    //
    P_SW1 &= 0x3f;
    P_SW1 |= 0x40;      //UART1 switch to, 0x00: P3.0 P3.1, 0x40: P3.6 P3.7, 0x80: P1.6 P1.7, 0xC0: P4.3 P4.4

    B_TX1_Busy = 0;
    TX1_Cnt = 0;
    RX1_Cnt = 0;

}

//========================================================================
// : void UART2_config(u8 brt)
// : UART2ʼ
// : brt: ѡ, 2: ʹTimer2, ֵ: Ч.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART2_config(u8 brt)    // ѡ, 2: ʹTimer2, ֵ: Ч.
{
    if(brt == 2)
    {
        SetTimer2Baudraye(65536UL - (MAIN_Fosc / 4) / Baudrate2);

        S2CFG |= 0x01;     //ʹô2ʱW1λΪ1ܻԤڵĴ
        S2CON = (S2CON & 0x3f) | 0x40;    //UART2ģʽ, 0x00: ͬλ, 0x40: 8λ,ɱ䲨, 0x80: 9λ,̶, 0xc0: 9λ,ɱ䲨
        IE2 |= ES2;         //ж
        S2CON |= S2REN;         //
        P_SW2 |= S2_S;         //UART2 switch to: 0: P1.2 P1.3,  1: P4.2 P4.3

        B_TX2_Busy = 0;
        TX2_Cnt = 0;
        RX2_Cnt = 0;
    }
}

//========================================================================
// : void UART2_int (void) interrupt UART2_VECTOR
// : UART2жϺ
// : nine.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART2_int (void) interrupt 8
{
    if(S2CON & S2RI)
    {
        S2CON &= ~S2RI;    //Clear Rx flag
        if(RX2_Cnt >= UART2_BUF_LENGTH)   RX2_Cnt = 0;
        RX2_Buffer[RX2_Cnt] = S2BUF;
        RX2_Cnt++;
        RX2_TimeOut = 5;
    }

    if(S2CON & S2TI)
    {
        S2CON &= ~S2TI;    //Clear Tx flag
        B_TX2_Busy = 0;
    }
}

//========================================================================
// : void UART1_int (void) interrupt UART1_VECTOR
// : UART1жϺ
// : nine.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART1_int (void) interrupt 4
{
    if(RI)
    {
        RI = 0;    //Clear Rx flag
        RX1_Buffer[RX1_Cnt] = SBUF;
        if(++RX1_Cnt >= UART1_BUF_LENGTH)   RX1_Cnt = 0;
        RX1_TimeOut = 5;
    }

    if(TI)
    {
        TI = 0;   //Clear Tx flag
        B_TX1_Busy = 0;
    }
}
