/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

/*************  ˵  **************

̻AI8051UΪоƬʵбдԡ

ʹKeil C51,Ϊ˴ﵽȽϸߵЧ,һ㽨ѡ"Small"ģʽ

 "error C249: 'DATA': SEGMENT TOO LARGE" ʱҪֱֶȽϴͨ"xdata" ǿƷ䵽 XDATA (: char xdata buffer [256];)

ͨ1(P3.0 P3.1)STCڲԴEEPROM(FLASH)ждԡ

FLASHд롢Ĳַָ

Ĭϲ:  115200,8,N,1. 
Ĭʱ:  22.1184MHz.

: (ĸִСд)
    W 0x000040 1234567890  --> 0x000040ַдַ1234567890.
    R 0x000040 10          --> 0x000040ַ10ֽ. 

ע⣺ʱؽ"Ӳѡ"ûEEPROMСEEPROMСûϵͳ
Ҫûϵͳ4KEEPROM8KôûEEPROMСҪ12K

ȷеĵַEEPROMõĴСΧ֮ڡ

******************************************/

#include "..\comm\AI8051U.h"
#include "intrins.h"

#define     MAIN_Fosc       22118400L   //ʱӣȷ115200ʣ

typedef     unsigned char   u8;
typedef     unsigned int    u16;
typedef     unsigned long   u32;

#define Baudrate1   (65536 - MAIN_Fosc / 115200 / 4)
#define Tmp_Length  100      //дEEPROM峤

#define UART1_BUF_LENGTH    (Tmp_Length+11)  //ڻ峤

u8  RX1_TimeOut;
u8  TX1_Cnt;    //ͼ
u8  RX1_Cnt;    //ռ
bit B_TX1_Busy; //æ־

u8  RX1_Buffer[UART1_BUF_LENGTH];   //ջ
u8  tmp[Tmp_Length];        //EEPROM


void    UART1_config(u8 brt);   // ѡ, 2: ʹTimer2, ֵ: Ч.
void    PrintString1(u8 *puts);
void    UART1_TxByte(u8 dat);
void    delay_ms(u8 ms);
u8      CheckData(u8 dat);
u32     GetAddress(void);
u8      GetDataLength(void);
void    EEPROM_SectorErase(u32 EE_address);
void    EEPROM_read_n(u32 EE_address,u8 *DataAddress,u8 length);
u8      EEPROM_write_n(u32 EE_address,u8 *DataAddress,u8 length);


/*********************  *************************/
void main(void)
{
    u8  i,j;
    u32 addr;
    u8  status;

    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXSFR(); //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x00;   P0M0 = 0x00;   //Ϊ׼˫
    P1M1 = 0x00;   P1M0 = 0x00;   //Ϊ׼˫
    P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
    P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
    P4M1 = 0x00;   P4M0 = 0x00;   //Ϊ׼˫
    P5M1 = 0x00;   P5M0 = 0x00;   //Ϊ׼˫
    P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    UART1_config(1);    // ѡ, 2: ʹTimer2, ֵ: ʹTimer1.
    EA = 1; //ж

    PrintString1("AI8051UϵеƬEEPROMԳ򣬴:\r\n");    //UART1һַ
    PrintString1("W 0x000040 1234567890  --> 0x000040ַдַ1234567890.\r\n");   //UART1һַ
    PrintString1("R 0x000040 10          --> 0x000040ַ10ֽ.\r\n"); //UART1һַ

    while(1)
    {
        delay_ms(1);
        if(RX1_TimeOut > 0)     //ʱ
        {
            if(--RX1_TimeOut == 0)
            {
              for(i=0; i<RX1_Cnt; i++)    UART1_TxByte(RX1_Buffer[i]);    //յԭ,ڲ

                status = 0xff;  //״̬һ0ֵ
                if((RX1_Cnt >= 12) && (RX1_Buffer[1] == ' ') && (RX1_Buffer[10] == ' ')) //Ϊ10ֽ
                {
                    for(i=0; i<10; i++)
                    {
                        if((RX1_Buffer[i] >= 'a') && (RX1_Buffer[i] <= 'z'))    RX1_Buffer[i] = RX1_Buffer[i] - 'a' + 'A';  //Сдתд
                    }
                    addr = GetAddress();
                    if(addr < 0x00ffffff)
                    {
                        if(RX1_Buffer[0] == 'W')    //дNֽ
                        {
                            j = RX1_Cnt - 11;
                            if(j > Tmp_Length)  j = Tmp_Length; //Խ
                            EEPROM_SectorErase(addr);           //
                            i = EEPROM_write_n(addr,&RX1_Buffer[11],j);      //дNֽ
                            if(i == 0)
                            {
                                PrintString1("\r\nд");
                                if(j >= 100)    {UART1_TxByte((u8)(j/100+'0'));   j = j % 100;}
                                if(j >= 10)     {UART1_TxByte((u8)(j/10+'0'));    j = j % 10;}
                                UART1_TxByte((u8)(j%10+'0'));
                                PrintString1("ֽڣ\r\n");
                            }
                            else    PrintString1("\r\nд\r\n");
                            status = 0; //ȷ
                        }

                        else if(RX1_Buffer[0] == 'R')   //PC󷵻NֽEEPROM
                        {
                            j = GetDataLength();
                            if(j > Tmp_Length)  j = Tmp_Length; //Խ
                            if(j > 0)
                            {
                                PrintString1("\r\n");
                                UART1_TxByte((u8)(j/10+'0'));
                                UART1_TxByte((u8)(j%10+'0'));
                                PrintString1("ֽ:\r\n");
                                EEPROM_read_n(addr,tmp,j);
                                for(i=0; i<j; i++)  UART1_TxByte(tmp[i]);
                                UART1_TxByte(0x0d);
                                UART1_TxByte(0x0a);
                                status = 0; //ȷ
                            }
                        }
                    }
                }
                if(status != 0) PrintString1("\r\n\r\n");
                RX1_Cnt  = 0;   //ֽ
            }
        }
    }
}

//========================================================================
// : void delay_ms(u8 ms)
// : ʱ
// : ms,Ҫʱms, ֻ֧1~255ms. ԶӦʱ.
// : none.
// 汾: VER1.0
// : 2021-3-9
// ע: 
//========================================================================
void delay_ms(u8 ms)
{
     u16 i;
     do{
          i = MAIN_Fosc / 6000;
          while(--i);
     }while(--ms);
}

//========================================================================
// : u8 CheckData(u8 dat)
// : ַ"0~9,A~Fa~f"תʮ.
// : dat: Ҫַ.
// : 0x00~0x0FΪȷ. 0xFFΪ.
// 汾: V1.0, 2012-10-22
//========================================================================
u8 CheckData(u8 dat)
{
    if((dat >= '0') && (dat <= '9'))        return (dat-'0');
    if((dat >= 'A') && (dat <= 'F'))        return (dat-'A'+10);
    return 0xff;
}

//========================================================================
// : u32 GetAddress(void)
// : 뷽ʽĵַ.
// : .
// : 24λEEPROMַ.
// 汾: V1.0, 2013-6-6
//========================================================================
u32 GetAddress(void)
{
    u32 address;
    u8  i,j;
    
    address = 0;
    if((RX1_Buffer[2] == '0') && (RX1_Buffer[3] == 'X'))
    {
        for(i=4; i<10; i++)
        {
            j = CheckData(RX1_Buffer[i]);
            if(j >= 0x10)   return 0xffffffff;   //error
            address = (address << 4) + j;
        }
        return (address);
    }
    return  0xffffffff;  //error
}

/**************** ȡҪݵֽ ****************************/
u8 GetDataLength(void)
{
    u8  i;
    u8  length;
    
    length = 0;
    for(i=11; i<RX1_Cnt; i++)
    {
        if(CheckData(RX1_Buffer[i]) >= 10)  break;
        length = length * 10 + CheckData(RX1_Buffer[i]);
    }
    return (length);
}


//========================================================================
// : void UART1_TxByte(u8 dat)
// : һֽ.
// : .
// : .
// 汾: V1.0, 2014-6-30
//========================================================================
void UART1_TxByte(u8 dat)
{
    SBUF = dat;
    B_TX1_Busy = 1;
    while(B_TX1_Busy);
}


//========================================================================
// : void PrintString1(u8 *puts)
// : 2ַ
// : puts:  ַָ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void PrintString1(u8 *puts) //һַ
{
    for (; *puts != 0;  puts++) UART1_TxByte(*puts);    //ֹͣ0
}

//========================================================================
// : void SetTimer2Baudraye(u16 dat)
// : Timer2ʷ
// : dat: Timer2װֵ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void SetTimer2Baudraye(u16 dat)  // ѡ, 2: ʹTimer2, ֵ: Ч.
{
    AUXR &= ~(1<<4);    //Timer stop
    AUXR &= ~(1<<3);  //Timer2 set As Timer
    AUXR |= (1<<2);  //Timer2 set as 1T mode
    T2H = (u8)(dat / 256);
    T2L = (u8)(dat % 256);
    IE2 = (IE2 & ~0x04) | (0 << 2);    //ֹж
    AUXR = (AUXR & ~0x10) | (1 << 4);    //Timer run enable
}

//========================================================================
// : void UART1_config(u8 brt)
// : UART1ʼ
// : brt: ѡ, 2: ʹTimer2, ֵ: ʹTimer1.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART1_config(u8 brt)    // ѡ, 2: ʹTimer2, ֵ: ʹTimer1.
{
    /*********** ʹöʱ2 *****************/
    if(brt == 2)
    {
        AUXR |= S1BRT;	//S1 BRT Use Timer2;
        SetTimer2Baudraye((u16)Baudrate1);
    }

    /*********** ʹöʱ1 *****************/
    else
    {
        TR1 = 0;
        AUXR &= ~S1BRT;		//S1 BRT Use Timer1;
        TMOD &= ~(1<<6);		//Timer1 set As Timer
        AUXR |= (1<<6);		//Timer1 set as 1T mode
        TMOD &= ~0x30;//Timer1_16bitAutoReload;
        TH1 = (u8)(Baudrate1 / 256);
        TL1 = (u8)(Baudrate1 % 256);
        ET1 = 0;    //ֹж
        TR1 = 1;
    }
    /*************************************************/

    SCON = (SCON & 0x3f) | 0x40;    //UART1ģʽ, 0x00: ͬλ, 0x40: 8λ,ɱ䲨, 0x80: 9λ,̶, 0xc0: 9λ,ɱ䲨
//  PS  = 1;    //ȼж
    ES  = 1;    //ж
    REN = 1;    //
    P_SW1 &= 0x3f;
    P_SW1 |= 0x00;      //UART1 switch to, 0x00: P3.0 P3.1, 0x40: P3.6 P3.7, 0x80: P1.6 P1.7, 0xC0: P4.3 P4.4

    B_TX1_Busy = 0;
    TX1_Cnt = 0;
    RX1_Cnt = 0;
}


//========================================================================
// : void UART1_int (void) interrupt UART1_VECTOR
// : UART1жϺ
// : nine.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART1_int (void) interrupt 4
{
    if(RI)
    {
        RI = 0;     //Clear Rx flag
        RX1_Buffer[RX1_Cnt] = SBUF;
        if(++RX1_Cnt >= UART1_BUF_LENGTH)   RX1_Cnt = 0;
        RX1_TimeOut = 5;
    }

    if(TI)
    {
        TI = 0;     //Clear Tx flag
        B_TX1_Busy = 0;
    }
}


#define     IAP_STANDBY()   IAP_CMD = 0     //IAPֹ
#define     IAP_READ()      IAP_CMD = 1     //IAP
#define     IAP_WRITE()     IAP_CMD = 2     //IAPд
#define     IAP_ERASE()     IAP_CMD = 3     //IAP

#define     IAP_ENABLE()    IAP_CONTR = IAP_EN; IAP_TPS = MAIN_Fosc / 1000000
#define     IAP_DISABLE()   IAP_CONTR = 0; IAP_CMD = 0; IAP_TRIG = 0; IAP_ADDRE = 0xff; IAP_ADDRH = 0xff; IAP_ADDRL = 0xff

#define IAP_EN          (1<<7)
#define IAP_SWBS        (1<<6)
#define IAP_SWRST       (1<<5)
#define IAP_CMD_FAIL    (1<<4)


//========================================================================
// : void DisableEEPROM(void)
// : ֹEEPROM.
// : none.
// : none.
// 汾: V1.0, 2014-6-30
//========================================================================
void DisableEEPROM(void)        //ֹEEPROM
{
    IAP_CONTR = 0;          //ر IAP 
    IAP_CMD = 0;            //Ĵ
    IAP_TRIG = 0;           //Ĵ
    IAP_ADDRE = 0xff;       //ַõ IAP 
    IAP_ADDRH = 0xff;       //ַõ IAP 
    IAP_ADDRL = 0xff;
}

//========================================================================
// : void EEPROM_Trig(void)
// : EEPROM.
// : none.
// : none.
// 汾: V1.0, 2014-6-30
//========================================================================
void EEPROM_Trig(void)
{
    F0 = EA;    //ȫж
    EA = 0;     //ֹж, ⴥЧ
    IAP_TRIG = 0x5A;
    IAP_TRIG = 0xA5;    //5AHA5HIAPĴÿζҪ
                        //A5HIAP
                        //CPUȴIAPɺ󣬲Żִг
    _nop_();   //༶ˮߵָϵͳ4NOP֤IAP_DATA׼
    _nop_();
    _nop_();
    _nop_();
    EA = F0;    //ָȫж
}

//========================================================================
// : void EEPROM_SectorErase(u32 EE_address)
// : һ.
// : EE_address:  ҪEEPROMеһֽڵַ.
// : none.
// 汾: V1.0, 2014-6-30
//========================================================================
void EEPROM_SectorErase(u32 EE_address)
{
    IAP_ENABLE();                       //õȴʱ䣬IAPһξ͹
    IAP_ERASE();                        //, ıʱ
                                        //ֻûֽڲ512ֽ/
                                        //һֽڵַַ
    IAP_ADDRE = (u8)(EE_address >> 16); //ַֽڣַҪıʱ͵ַ
    IAP_ADDRH = (u8)(EE_address >> 8);  //ַֽڣַҪıʱ͵ַ
    IAP_ADDRL = (u8)EE_address;         //ַֽڣַҪıʱ͵ַ
    EEPROM_Trig();                      //EEPROM
    DisableEEPROM();                    //ֹEEPROM
}

//========================================================================
// : void EEPROM_read_n(u32 EE_address,u8 *DataAddress,u8 lenth)
// : Nֽں.
// : EE_address:  ҪEEPROM׵ַ.
//       DataAddress: Ҫݵָ.
//       length:      Ҫĳ
// : 0: дȷ.  1: д볤Ϊ0.  2: дݴ.
// 汾: V1.0, 2014-6-30
//========================================================================
void EEPROM_read_n(u32 EE_address,u8 *DataAddress,u8 length)
{
    IAP_ENABLE();                           //õȴʱ䣬IAPһξ͹
    IAP_READ();                             //ֽڶıʱ
    do
    {
        IAP_ADDRE = (u8)(EE_address >> 16); //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRH = (u8)(EE_address >> 8);  //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRL = (u8)EE_address;         //͵ַֽڣַҪıʱ͵ַ
        EEPROM_Trig();                      //EEPROM
        *DataAddress = IAP_DATA;            //
        EE_address++;
        DataAddress++;
    }while(--length);

    DisableEEPROM();
}


//========================================================================
// : u8 EEPROM_write_n(u32 EE_address,u8 *DataAddress,u8 length)
// : дNֽں.
// : EE_address:  ҪдEEPROM׵ַ.
//       DataAddress: Ҫдݵָ.
//       length:      Ҫдĳ
// : 0: дȷ.  1: д볤Ϊ0.  2: дݴ.
// 汾: V1.0, 2014-6-30
//========================================================================
u8 EEPROM_write_n(u32 EE_address,u8 *DataAddress,u8 length)
{
    u8  i;
    u16 j;
    u8  *p;
    
    if(length == 0) return 1;   //Ϊ0

    IAP_ENABLE();                       //õȴʱ䣬IAPһξ͹
    i = length;
    j = EE_address;
    p = DataAddress;
    IAP_WRITE();                            //, ֽд
    do
    {
        IAP_ADDRE = (u8)(EE_address >> 16); //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRH = (u8)(EE_address >> 8);  //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRL = (u8)EE_address;         //͵ַֽڣַҪıʱ͵ַ
        IAP_DATA  = *DataAddress;           //ݵIAP_DATAֻݸıʱ
        EEPROM_Trig();                      //EEPROM
        EE_address++;                       //һַ
        DataAddress++;                      //һ
    }while(--length);                       //ֱ

    EE_address = j;
    length = i;
    DataAddress = p;
    i = 0;
    IAP_READ();                             //NֽڲȽ
    do
    {
        IAP_ADDRE = (u8)(EE_address >> 16); //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRH = (u8)(EE_address >> 8);  //͵ַֽڣַҪıʱ͵ַ
        IAP_ADDRL = (u8)EE_address;         //͵ַֽڣַҪıʱ͵ַ
        EEPROM_Trig();                      //EEPROM
        if(*DataAddress != IAP_DATA)        //ԴݱȽ
        {
            i = 2;
            break;
        }
        EE_address++;
        DataAddress++;
    }while(--length);

    DisableEEPROM();
    return i;
}

