/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

/*************  ˵  **************

̻AI8051UΪоƬʵбдԡ

ʹKeil C51,Ϊ˴ﵽȽϸߵЧ,һ㽨ѡ"Small"ģʽ

 "error C249: 'DATA': SEGMENT TOO LARGE" ʱҪֱֶȽϴͨ"xdata" ǿƷ䵽 XDATA (: char xdata buffer [256];)

ͨӲI2CӿڶȡAT24C02ǰ8ֽݣͨڴӡȡ.

ȡݼ1дAT24C02ǰ8ֽ.

¶ȡAT24C02ǰ8ֽݣͨڴӡȡ.

MCUϵִ1϶ظϵ/ϵAT24C02ǰ8ֽڵ.

UART1(P3.0,P3.1): 115200,N,8,1.

ʱ, ѡʱ 24MHZ (û޸Ƶ).

******************************************/

#include "..\comm\AI8051U.h"
#include "stdio.h"
#include "intrins.h"

/***********************************************************/

typedef     unsigned char   u8;
typedef     unsigned int    u16;
typedef     unsigned long   u32;

/****************************** û ***********************************/

#define MAIN_Fosc       24000000L   //ʱ
#define Baudrate        115200L
#define TM              (65536 -(MAIN_Fosc/Baudrate/4))
#define PrintUart       1        //1:printf ʹ UART1; 2:printf ʹ UART2
#define Timer0_Reload   (65536UL -(MAIN_Fosc / 1000))       //Timer 0 жƵ, 1000/

/*****************************************************************************/

sbit SDA = P3^3;
sbit SCL = P3^2;

/*************  س    **************/

#define SLAW        0xA0
#define SLAR        0xA1

/*************  ر    **************/


/*************  غ    **************/
void WriteNbyte(u8 addr, u8 *p, u8 number);
void ReadNbyte( u8 addr, u8 *p, u8 number);
void delay_ms(u8 ms);
void UartInit(void);

/**********************************************/
void main(void)
{
    u8  i;
    u8  tmp[8];

    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXSFR(); //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x00;   P0M0 = 0x00;   //Ϊ׼˫
    P1M1 = 0x00;   P1M0 = 0x00;   //Ϊ׼˫
    P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
    P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
    P4M1 = 0x00;   P4M0 = 0x00;   //Ϊ׼˫
    P5M1 = 0x00;   P5M0 = 0x00;   //Ϊ׼˫
    P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫
    
    UartInit();

    P_SW2 |= I2C_S1;//I2Cܽѡ00:P2.4,P2.3;01:P1.5,P1.4;11:P3.2,P3.3
    P_SW2 |= I2C_S0;
    I2CCFG = 0xc2;  //ʹI2Cģʽ
    I2CPSCR = 0x00; //MSSPEED[13:6]
    I2CMSST = 0x00;

    EA = 1;         //ж
    
    ReadNbyte(0, tmp, 8);
    printf("Read1 = ");     //ӡһζȡ
    for(i=0; i<8; i++)
    {
        printf("%02x ",tmp[i]);
        tmp[i]++;
    }
    printf("\r\n");

    WriteNbyte(0, tmp, 8);  //дµ
    delay_ms(250);
    delay_ms(250);

    ReadNbyte(0, tmp, 8);
    printf("Read2 = ");     //ӡڶζȡ
    for(i=0; i<8; i++)
    {
        printf("%02x ",tmp[i]);
    }
    printf("\r\n");

    while(1);
}

//========================================================================
// : void delay_ms(u8 ms)
// : ʱ
// : ms,Ҫʱms, ֻ֧1~255ms. ԶӦʱ.
// : none.
// 汾: VER1.0
// : 2021-3-9
// ע: 
//========================================================================
void delay_ms(u8 ms)
{
     u16 i;
     do{
          i = MAIN_Fosc / 6000;
          while(--i);
     }while(--ms);
}

/********************** I2C ************************/
void Wait()
{
    while (!(I2CMSST & 0x40));
    I2CMSST &= ~0x40;
}

void Start()
{
    I2CMSCR = 0x01;                         //START
    Wait();
}

void SendData(char dat)
{
    I2CTXD = dat;                           //дݵݻ
    I2CMSCR = 0x02;                         //SEND
    Wait();
}

void RecvACK()
{
    I2CMSCR = 0x03;                         //ͶACK
    Wait();
}

char RecvData()
{
    I2CMSCR = 0x04;                         //RECV
    Wait();
    return I2CRXD;
}

void SendACK()
{
    I2CMSST = 0x00;                         //ACKź
    I2CMSCR = 0x05;                         //ACK
    Wait();
}

void SendNAK()
{
    I2CMSST = 0x01;                         //NAKź
    I2CMSCR = 0x05;                         //ACK
    Wait();
}

void Stop()
{
    I2CMSCR = 0x06;                         //STOP
    Wait();
}

void WriteNbyte(u8 addr, u8 *p, u8 number)  /*  WordAddress,First Data Address,Byte lenth   */
{
    Start();                                //ʼ
    SendData(SLAW);                         //豸ַ+д
    RecvACK();
    SendData(addr);                         //ʹ洢ַ
    RecvACK();
    do
    {
        SendData(*p++);
        RecvACK();
    }
    while(--number);
    Stop();                                 //ֹͣ
}

void ReadNbyte(u8 addr, u8 *p, u8 number)   /*  WordAddress,First Data Address,Byte lenth   */
{
    Start();                                //ʼ
    SendData(SLAW);                         //豸ַ+д
    RecvACK();
    SendData(addr);                         //ʹ洢ַ
    RecvACK();
    Start();                                //ʼ
    SendData(SLAR);                         //豸ַ+
    RecvACK();
    do
    {
        *p = RecvData();
        p++;
        if(number != 1) SendACK();          //send ACK
    }
    while(--number);
    SendNAK();                              //send no ACK	
    Stop();                                 //ֹͣ
}

/******************** ڴӡ ********************/
void UartInit(void)
{
#if(PrintUart == 1)
    P_SW1 &= ~S1_S1;      //UART1 switch to, 0x00: P3.0 P3.1, 0x40: P3.6 P3.7, 0x80: P1.6 P1.7, 0xC0: P4.3 P4.4
    P_SW1 &= ~S1_S0;
	SCON = (SCON & 0x3f) | 0x40; 
	AUXR |= (1<<6);      //ʱʱ1Tģʽ
	AUXR &= ~S1BRT;      //1ѡʱ1Ϊʷ
	TL1  = TM;
	TH1  = TM>>8;
	TR1 = 1;        //ʱ1ʼʱ

//	SCON = (SCON & 0x3f) | 0x40; 
//	T2L  = TM;
//	T2H  = TM>>8;
//	AUXR |= 0x15;   //1ѡʱ2Ϊʷ
#else
	P_SW2 |= S2_S;       //UART2 switch to: 0: P1.2 P1.3,  1: P4.2 P4.3
    S2CFG |= 0x01;  //ʹô2ʱW1λΪ1ܻԤڵĴ
	S2CON = (S2CON & 0x3f) | 0x40; 
	T2L  = TM;
	T2H  = TM>>8;
	AUXR |= 0x14;	      //ʱ2ʱ1Tģʽ,ʼʱ
#endif
}

void UartPutc(unsigned char dat)
{
#if(PrintUart == 1)
	SBUF = dat; 
	while(TI==0);
	TI = 0;
#else
	S2BUF  = dat; 
	while((S2CON & S2TI)==0);
	S2CON &= ~S2TI;    //Clear Tx flag
#endif
}

char putchar(char c)
{
	UartPutc(c);
	return c;
}
