/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻AI8051UΪоƬʵбдԡ

ʹKeil C51,Ϊ˴ﵽȽϸߵЧ,һ㽨ѡ"Small"ģʽ

 "error C249: 'DATA': SEGMENT TOO LARGE" ʱҪֱֶȽϴͨ"xdata" ǿƷ䵽 XDATA (: char xdata buffer [256];)

ûں궨иıMCUʱƵ. Χ 8MHZ ~ 33MHZ.

ճģгNECı롣

ûں궨ָû.

ʹPWM438KHZز, 1/3ռձ, ÿ38KHZڷܷ9us,ر16.3us.

ʹÿϵ16IOɨ谴, MCU˯, ɨ谴.

, һ֡Ϊ, ֡Ϊظ֡,, 嶨вοNECı.

ͷź, ֹͣ.

ʱ, ѡʱ 24MHz (û޸Ƶ).

******************************************/

#include "..\comm\AI8051U.h"
#include "stdio.h"
#include "intrins.h"

typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;

/****************************** û ***********************************/

#define MAIN_Fosc       24000000UL
#define Baudrate        115200L
#define TM              (65536 -(MAIN_Fosc/Baudrate/4))
#define PrintUart       1        //1:printf ʹ UART1; 2:printf ʹ UART2

/*****************************************************************************/


/*************  س    **************/


/*************  IO̱  **************/

u8  IO_KeyState, IO_KeyState1, IO_KeyHoldCnt;   //м̱
u8  KeyHoldCnt; //¼ʱ
u8  KeyCode;    //ûʹõļ, 1~16Ч

/*************  ⷢر    **************/

#define User_code   0xFF00      //û

sbit    P_IR_TX   = P2^7;   //ⷢͶ˿
#define IR_TX_ON    0
#define IR_TX_OFF   1

static u16 tx_cnt;     //ͻе(38KHZӦʱ), ƵΪ38KHZ, 26.3us
u8 TxTime;     //ʱ

/************* غ **************/

void delay_ms(u8 ms);
void IO_KeyScan(void);
void PWM_config(void);
void IR_TxPulse(u16 pulse);
void IR_TxSpace(u16 pulse);
void IR_TxByte(u8 dat);
void UartInit(void);

/*********************  *************************/
void main(void)
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXSFR(); //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x00;   P0M0 = 0x00;   //Ϊ׼˫
    P1M1 = 0x00;   P1M0 = 0x00;   //Ϊ׼˫
    P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
    P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
    P4M1 = 0x00;   P4M0 = 0x00;   //Ϊ׼˫
    P5M1 = 0x00;   P5M0 = 0x00;   //Ϊ׼˫
    P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    UartInit();
    PWM_config();
    P_IR_TX = IR_TX_OFF;
    EA = 1;                     //ж
    
    while(1)
    {
        delay_ms(30);       //30ms
        IO_KeyScan();

        if(KeyCode != 0)        //⵽
        {
            TxTime = 0;
                                //һ֡С = 9 + 4.5 + 0.5625 + 24 * 1.125 + 8 * 2.25 = 59.0625 ms
                                //һ֡󳤶 = 9 + 4.5 + 0.5625 + 8 * 1.125 + 24 * 2.25 = 77.0625 ms
            IR_TxPulse(342);    //Ӧ9msͬͷ       9ms
            IR_TxSpace(171);    //Ӧ4.5msͬͷ 4.5ms
            IR_TxPulse(21);     //ʼ          0.5625ms

            IR_TxByte(User_code%256);   //ûֽ
            IR_TxByte(User_code/256);   //ûֽ
            IR_TxByte(KeyCode);         //
            IR_TxByte(~KeyCode);        //ݷ
            
            if(TxTime < 56)     //һ֡77ms, Ļ,ʱ     108ms
            {
                TxTime = 56 - TxTime;
                TxTime = TxTime + TxTime / 8;
                delay_ms(TxTime);
            }
            delay_ms(31);

            while(IO_KeyState != 0) //δͷ
            {
                IR_TxPulse(342);    //Ӧ9ms   ͬͷ        9ms
                IR_TxSpace(86);     //Ӧ2.25msͬͷ    2.25ms
                IR_TxPulse(21);     //ʼ              0.5625ms
                delay_ms(96);
                IO_KeyScan();
            }

            printf("KeyCode = %u\r\n",KeyCode);
            KeyCode = 0;
        }
    }
}

//========================================================================
// : void delay_ms(unsigned char ms)
// : ʱ
// : ms,Ҫʱms, ֻ֧1~255ms. ԶӦʱ.
// : none.
// 汾: VER1.0
// : 2013-4-1
// ע: 
//========================================================================
void delay_ms(u8 ms)
{
    u16 i;
    do{
        i = MAIN_Fosc / 6000;
        while(--i);
    }while(--ms);
}

/*****************************************************
    мɨ
    ʹXY4x4ķֻܵٶȿ

   Y     P04      P05      P06      P07
          |        |        |        |
X         |        |        |        |
P00 ---- K00 ---- K01 ---- K02 ---- K03 ----
          |        |        |        |
P01 ---- K04 ---- K05 ---- K06 ---- K07 ----
          |        |        |        |
P02 ---- K08 ---- K09 ---- K10 ---- K11 ----
          |        |        |        |
P03 ---- K12 ---- K13 ---- K14 ---- K15 ----
          |        |        |        |
******************************************************/


u8 code T_KeyTable[16] = {0,1,2,0,3,0,0,0,4,0,0,0,0,0,0,0};

void IO_KeyDelay(void)
{
    u8 i;
    i = 60;
    while(--i)  ;
}

void IO_KeyScan(void)    //50ms call
{
    u8  j;

    j = IO_KeyState1;   //һ״̬

    P0 = 0xf0;  //XͣY
    IO_KeyDelay();
    IO_KeyState1 = P0 & 0xf0;

    P0 = 0x0f;  //YͣX
    IO_KeyDelay();
    IO_KeyState1 |= (P0 & 0x0f);
    IO_KeyState1 ^= 0xff;   //ȡ
    
    if(j == IO_KeyState1)   //ζ
    {
        j = IO_KeyState;
        IO_KeyState = IO_KeyState1;
        if(IO_KeyState != 0)    //м
        {
            F0 = 0;
            if(j == 0)  F0 = 1; //һΰ
            else if(j == IO_KeyState)
            {
                if(++IO_KeyHoldCnt >= 20)   //1ؼ
                {
                    IO_KeyHoldCnt = 18;
                    F0 = 1;
                }
            }
            if(F0)
            {
                j = T_KeyTable[IO_KeyState >> 4];
                if((j != 0) && (T_KeyTable[IO_KeyState& 0x0f] != 0)) 
                    KeyCode = (j - 1) * 4 + T_KeyTable[IO_KeyState & 0x0f] + 16;    //룬17~32
            }
        }
        else    IO_KeyHoldCnt = 0;
    }
    P0 = 0xff;
}


/************* 庯 **************/
void IR_TxPulse(u16 pulse)
{
    tx_cnt = pulse;
    PWMA_CCER2 = 0x00; //д CCMRx ǰ CCxE رͨ
    PWMA_CCMR4 = 0x60; // PWM4 ģʽ1 
    PWMA_CCER2 = 0x70; //ʹ CC4NE ͨ, ͵ƽЧ
    PWMA_IER = 0x10;   //ʹܲ/Ƚ 4 ж
    while(tx_cnt);
}

/************* Ϳк **************/
void IR_TxSpace(u16 pulse)
{
    tx_cnt = pulse;
    PWMA_CCER2 = 0x00; //д CCMRx ǰ CCxE رͨ
    PWMA_CCMR4 = 0x40; // PWM4 ǿΪЧƽ
    PWMA_CCER2 = 0x70; //ʹ CC4NE ͨ, ͵ƽЧ
    PWMA_IER = 0x10;   //ʹܲ/Ƚ 4 ж
    while(tx_cnt);
}


/************* һֽں **************/
void IR_TxByte(u8 dat)
{
    u8 i;
    for(i=0; i<8; i++)
    {
        if(dat & 1)     IR_TxSpace(63), TxTime += 2;    //1Ӧ 1.6875 + 0.5625 ms 
        else            IR_TxSpace(21), TxTime++;       //0Ӧ 0.5625 + 0.5625 ms
        IR_TxPulse(21);         //嶼0.5625ms
        dat >>= 1;              //һλ
    }
}

//========================================================================
// : void   PWM_config(void)
// : PCAú.
// : None
// : none.
// 汾: V1.0, 2012-11-22
//========================================================================
void PWM_config(void)
{
    PWMA_CCER2 = 0x00; //д CCMRx ǰ CCxE رͨ
    PWMA_CCMR4 = 0x60; // PWM4 ģʽ1 
    //PWMA_CCER2 = 0xB0; //ʹ CC4E ͨ, ͵ƽЧ

    PWMA_ARRH = 0x02; //ʱ
    PWMA_ARRL = 0x77;
    PWMA_CCR4H = 0;
    PWMA_CCR4L = 210; //ռձʱ

    PWMA_PS = 0x80;  //߼ PWM ͨ 4N ѡλ, 0x00:P1.7, 0x40:P0.7, 0x80:P2.7
//  PWMA_PS = 0x80;  //߼ PWM ͨ 4P ѡλ, 0x00:P1.6, 0x40:P0.6, 0x80:P2.6
    PWMA_ENO = 0x80; //ʹ PWM4N 
//  PWMA_ENO = 0x40; //ʹ PWM4P 
    PWMA_BKR = 0x80; //ʹ
//    PWMA_IER = 0x10; //ʹж
    PWMA_CR1 |= 0x81;  //ʹARRԤװأʼʱ
}

/******************* PWMжϺ ********************/
void PWMA_ISR() interrupt PWMA_VECTOR
{
    if(PWMA_SR1 & 0X10)
    {
        PWMA_SR1 &=~0X10;
        //PWMA_SR1 = 0;
        if(--tx_cnt == 0)
        {
            PWMA_CCER2 = 0x00; //д CCMRx ǰ CCxE رͨ
            PWMA_CCMR4 = 0x40; // PWM4 ǿΪЧƽ
            PWMA_CCER2 = 0x70; //ʹ CC4NE ͨ, ͵ƽЧ
            PWMA_IER = 0x00;   // رж
        }
    }
}

/******************** ڴӡ ********************/
void UartInit(void)
{
#if(PrintUart == 1)
    P_SW1 &= ~S1_S1;      //UART1 switch to, 0x00: P3.0 P3.1, 0x40: P3.6 P3.7, 0x80: P1.6 P1.7, 0xC0: P4.3 P4.4
    P_SW1 &= ~S1_S0;
	SCON = (SCON & 0x3f) | 0x40; 
	AUXR |= (1<<6);      //ʱʱ1Tģʽ
	AUXR &= ~S1BRT;      //1ѡʱ1Ϊʷ
	TL1  = TM;
	TH1  = TM>>8;
	TR1 = 1;        //ʱ1ʼʱ

//	SCON = (SCON & 0x3f) | 0x40; 
//	T2L  = TM;
//	T2H  = TM>>8;
//	AUXR |= 0x15;   //1ѡʱ2Ϊʷ
#else
	P_SW2 |= S2_S;       //UART2 switch to: 0: P1.2 P1.3,  1: P4.2 P4.3
    S2CFG |= 0x01;  //ʹô2ʱW1λΪ1ܻԤڵĴ
	S2CON = (S2CON & 0x3f) | 0x40; 
	T2L  = TM;
	T2H  = TM>>8;
	AUXR |= 0x14;   //ʱ2ʱ1Tģʽ,ʼʱ
#endif
}

void UartPutc(unsigned char dat)
{
#if(PrintUart == 1)
	SBUF = dat; 
	while(TI==0);
	TI = 0;
#else
	S2BUF  = dat; 
	while((S2CON & S2TI)==0);
	S2CON &= ~S2TI;    //Clear Tx flag
#endif
}

char putchar(char c)
{
	UartPutc(c);
	return c;
}
