/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻AI8051UΪоƬʵбдԡ

ʹKeil C51,Ϊ˴ﵽȽϸߵЧ,һ㽨ѡ"Small"ģʽ

 "error C249: 'DATA': SEGMENT TOO LARGE" ʱҪֱֶȽϴͨ"xdata" ǿƷ䵽 XDATA (: char xdata buffer [256];)

IOLCD1602ַ.

ʾЧΪ: LCDʾʱ.

һʾ ---Clock demo---
ڶʾ     12-00-00

LCD1602ַ12864ģӿ1~16PIN.

R1200ŷ裬16PIN̽ӵGND.

ʱ, ѡʱ 24MHz (û޸Ƶ).

******************************************/

#include "../comm/AI8051U.h"     //ͷļ󣬲Ҫٰ"reg51.h"ͷļ
#include    "intrins.h"

#define     MAIN_Fosc       24000000L   //ʱ

typedef     unsigned char   u8;
typedef     unsigned int    u16;
typedef     unsigned long   u32;

/*************	Pin define	*****************************************************/

sbit	LCD_B7  = P2^7;	//D7 -- Pin 14		LED- -- Pin 16 
sbit	LCD_B6  = P2^6;	//D6 -- Pin 13		LED+ -- Pin 15
sbit	LCD_B5  = P2^5;	//D5 -- Pin 12		Vo   -- Pin 3
sbit	LCD_B4  = P2^4;	//D4 -- Pin 11		VDD  -- Pin 2
sbit	LCD_B3  = P2^3;	//D3 -- Pin 10		VSS  -- Pin 1
sbit	LCD_B2  = P2^2;	//D2 -- Pin  9
sbit	LCD_B1  = P2^1;	//D1 -- Pin  8
sbit	LCD_B0  = P2^0;	//D0 -- Pin  7

sbit	LCD_ENA	= P3^7;	//Pin 6
sbit	LCD_RW	= P3^6;	//Pin 5	//LCD_RS   R/W   DB7--DB0        FOUNCTION
sbit	LCD_RS	= P4^5;	//Pin 4	//	0		0	  INPUT      write the command to LCD model
								//	0		1     OUTPUT     read BF and AC pointer from LCD model
								//	1		0     INPUT      write the data to LCD  model
								//	1		1     OUTPUT     read the data from LCD model

#define LCD_BusData(dat)	P2 = dat

u8	hour,minute,second;

void RTC(void);
void ClearLine(u8 row);
void Initialize_LCD(void);
void PutString(u8 row, u8 column, u8 *puts);
void DisplayRTC(void);
void delay_ms(u16 ms);
void WriteChar(u8 row, u8 column, u8 dat);

void main(void)
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXSFR(); //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x00;   P0M0 = 0x00;   //Ϊ׼˫
    P1M1 = 0x00;   P1M0 = 0x00;   //Ϊ׼˫
    P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
    P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
    P4M1 = 0x00;   P4M0 = 0x00;   //Ϊ׼˫
    P5M1 = 0x00;   P5M0 = 0x00;   //Ϊ׼˫
    P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    Initialize_LCD();
    ClearLine(0);
    ClearLine(1);

    PutString(0,0,"---Clock demo---");
	
    hour   = 12;	//ʼʱֵ
    minute = 0;
    second = 0;
    DisplayRTC();

    while(1)
    {
        delay_ms(1000);
        RTC();
        DisplayRTC();
    }
}


//========================================================================
// : void delay_ms(u16 ms)
// : ʱ
// : ms,Ҫʱms, ֻ֧1~65535ms. ԶӦʱ.
// : none.
// 汾: VER1.0
// : 2013-4-1
// ע: 
//========================================================================
void delay_ms(u16 ms)
{
     u16 i;
     do{
          i = MAIN_Fosc / 6000;
          while(--i);
     }while(--ms);
}

//========================================================================
// : void DisplayRTC(void)
// : ʾʱӺ
// : none.
// : none.
// 汾: VER1.0
// : 2013-4-1
// ע: 
//========================================================================
void DisplayRTC(void)
{
	if(hour >= 10)	WriteChar(1,4,(u8)(hour / 10 + '0'));
	else			WriteChar(1,4,' ');
	WriteChar(1,5,(u8)(hour % 10 +'0'));
	WriteChar(1,6,'-');
	WriteChar(1,7,(u8)(minute / 10+'0'));
	WriteChar(1,8,(u8)(minute % 10+'0'));
	WriteChar(1,9,'-');
	WriteChar(1,10,(u8)(second / 10 +'0'));
	WriteChar(1,11,(u8)(second % 10 +'0'));
}

//========================================================================
// : void RTC(void)
// : RTCʾ
// : none.
// : none.
// 汾: VER1.0
// : 2013-4-1
// ע: 
//========================================================================
void RTC(void)
{
	if(++second >= 60)
	{
		second = 0;
		if(++minute >= 60)
		{
			minute = 0;
			if(++hour >= 24)	hour = 0;
		}
	}
}

/************* LCD1602س	*****************************************************/
//8λݷʷʽ	LCD1602		׼	д	2014-2-21

#define LineLength	16		//16x2

/*
total 2 lines, 16x2= 32
first line address:  0~15
second line address: 64~79

*/

#define C_CLEAR			0x01		//clear LCD
#define C_HOME 			0x02		//cursor go home
#define C_CUR_L			0x04		//cursor shift left after input
#define C_RIGHT			0x05		//picture shift right after input
#define C_CUR_R			0x06		//cursor shift right after input
#define C_LEFT 			0x07		//picture shift left after input
#define C_OFF  			0x08		//turn off LCD
#define C_ON   			0x0C		//turn on  LCD
#define C_FLASH			0x0D		//turn on  LCD, flash 
#define C_CURSOR		0x0E		//turn on  LCD and cursor
#define C_FLASH_ALL		0x0F		//turn on  LCD and cursor, flash
#define C_CURSOR_LEFT	0x10		//single cursor shift left
#define C_CURSOR_RIGHT	0x10		//single cursor shift right
#define C_PICTURE_LEFT	0x10		//single picture shift left
#define C_PICTURE_RIGHT	0x10		//single picture shift right
#define C_BIT8			0x30		//set the data is 8 bits
#define C_BIT4			0x20		//set the data is 4 bits
#define C_L1DOT7		0x30		//8 bits,one line 5*7  dots
#define C_L1DOT10		0x34		//8 bits,one line 5*10 dots
#define C_L2DOT7		0x38		//8 bits,tow lines 5*7 dots
#define C_4bitL2DOT7	0x28		//4 bits,tow lines 5*7 dots
#define C_CGADDRESS0	0x40		//CGRAM address0 (addr=40H+x)
#define C_DDADDRESS0	0x80		//DDRAM address0 (addr=80H+x)


void LCD_DelayNop(void)
{
	_nop_();_nop_();_nop_();
	_nop_();_nop_();_nop_();
	_nop_();_nop_();_nop_();
	_nop_();_nop_();_nop_();
	_nop_();_nop_();_nop_();
}

//========================================================================
// : void CheckBusy(void)
// : æ
// : none.
// : none.
// 汾: VER1.0
// : 2013-4-1
// ע: 
//========================================================================
void CheckBusy(void)
{
	u16	i;
	for(i=0; i<5000; i++)	{if(!LCD_B7)	break;}		//check the LCD busy or not. With time out
//	while(LCD_B7);			//check the LCD busy or not. Without time out
}

//========================================================================
// : void IniSendCMD(u8 cmd)
// : ʼд(æ)
// : cmd: Ҫд.
// : none.
// 汾: VER1.0
// : 2013-4-1
// ע: 
//========================================================================
void IniSendCMD(u8 cmd)
{
	LCD_RW = 0;
	LCD_BusData(cmd);
	LCD_DelayNop();
	LCD_ENA = 1;
	LCD_DelayNop();
	LCD_ENA = 0;
	LCD_BusData(0xff);
}

//========================================================================
// : void Write_CMD(u8 cmd)
// : д(æ)
// : cmd: Ҫд.
// : none.
// 汾: VER1.0
// : 2013-4-1
// ע: 
//========================================================================
void Write_CMD(u8 cmd)
{
	LCD_RS  = 0;
	LCD_RW = 1;
	LCD_BusData(0xff);
	LCD_DelayNop();
	LCD_ENA = 1;
	CheckBusy();			//check the LCD busy or not.
	LCD_ENA = 0;
	LCD_RW = 0;
	
	LCD_BusData(cmd);
	LCD_DelayNop();
	LCD_ENA = 1;
	LCD_DelayNop();
	LCD_ENA = 0;
	LCD_BusData(0xff);
}

//========================================================================
// : void Write_DIS_Data(u8 dat)
// : дʾ(æ)
// : dat: Ҫд.
// : none.
// 汾: VER1.0
// : 2013-4-1
// ע: 
//========================================================================
void Write_DIS_Data(u8 dat)
{
	LCD_RS = 0;
	LCD_RW = 1;

	LCD_BusData(0xff);
	LCD_DelayNop();
	LCD_ENA = 1;
	CheckBusy();			//check the LCD busy or not.
	LCD_ENA = 0;
	LCD_RW = 0;
	LCD_RS  = 1;

	LCD_BusData(dat);
	LCD_DelayNop();
	LCD_ENA = 1;
	LCD_DelayNop();
	LCD_ENA = 0;
	LCD_BusData(0xff);
}

//========================================================================
// : void Initialize_LCD(void)
// : ʼ
// : none.
// : none.
// 汾: VER1.0
// : 2013-4-1
// ע: 
//========================================================================
void Initialize_LCD(void)
{
	LCD_ENA = 0;
	LCD_RS  = 0;
	LCD_RW = 0;

	delay_ms(100);
	IniSendCMD(C_BIT8);		//set the data is 8 bits

	delay_ms(10);
	Write_CMD(C_L2DOT7);		//tow lines 5*7 dots

	delay_ms(6);
	Write_CMD(C_CLEAR);		//clear LCD RAM
	Write_CMD(C_CUR_R);		//Curror Shift Right
	Write_CMD(C_ON);		//turn on  LCD
}

//========================================================================
// : void ClearLine(u8 row)
// : 1
// : row: (01)
// : none.
// 汾: VER1.0
// : 2013-4-1
// ע: 
//========================================================================
void ClearLine(u8 row)
{
	u8 i;
	Write_CMD(((row & 1) << 6) | 0x80);
	for(i=0; i<LineLength; i++)	Write_DIS_Data(' ');
}

//========================================================================
// : void WriteChar(u8 row, u8 column, u8 dat)
// : ָСкַ, дһַ
// : row: (01),  column: ڼַ(0~15),  dat: Ҫдַ.
// : none.
// 汾: VER1.0
// : 2013-4-1
// ע: 
//========================================================================
void WriteChar(u8 row, u8 column, u8 dat)
{
	Write_CMD((((row & 1) << 6) + column) | 0x80);
	Write_DIS_Data(dat);
}

//========================================================================
// : void PutString(u8 row, u8 column, u8 *puts)
// : дһַָСкַ׵ַ
// : row: (01),  column: ڼַ(0~15),  puts: Ҫдַָ.
// : none.
// 汾: VER1.0
// : 2013-4-1
// ע: 
//========================================================================
void PutString(u8 row, u8 column, u8 *puts)
{
	Write_CMD((((row & 1) << 6) + column) | 0x80);
	for ( ;  *puts != 0;  puts++)		//ֹͣ0
	{
		Write_DIS_Data(*puts);
		if(++column >= LineLength)	break;
	}
}

//******************** LCD20 Module END ***************************
