
#define 	MAIN_Fosc		40000000UL	//ʱ
#include <intrins.h>
#include "../comm/AI8051U.h"

#define	Pin5		0x20	//IO Px.5
#define	Pin6		0x40	//IO Px.6
#define	Pin7		0x80	//IO Px.7
#define P2n_standard(bitn)			P2M1 &= ~(bitn),	P2M0 &= ~(bitn)
#define P2n_push_pull(bitn)			P2M1 &= ~(bitn),	P2M0 |=  (bitn)
#define P2n_pure_input(bitn)		P2M1 |=  (bitn),	P2M0 &= ~(bitn)
#define P2n_open_drain(bitn)		P2M1 |=  (bitn),	P2M0 |=  (bitn)

#define P3n_standard(bitn)			P3M1 &= ~(bitn),	P3M0 &= ~(bitn)
#define P3n_push_pull(bitn)			P3M1 &= ~(bitn),	P3M0 |=  (bitn)
#define P3n_pure_input(bitn)		P3M1 |=  (bitn),	P3M0 &= ~(bitn)
#define P3n_open_drain(bitn)		P3M1 |=  (bitn),	P3M0 |=  (bitn)

#define P4n_standard(bitn)			P4M1 &= ~(bitn),	P4M0 &= ~(bitn)

typedef     unsigned char   u8;
typedef     unsigned int    u16;
typedef     unsigned long   u32;

/*************	˵	**************

ȱ޸ĳ, ֱ"LCD1602.hex", ʱѡƵ40MHz.

LCM1602ַҺģ飬8λݣȫLCM DMAʡCPUʱ(LCD1602IOʽٶȺ!)

AI8051Uʵ֤ʹ3.3VLCD1602ģ顣

*******************************************/


/*************  س    **************/
const u8  text1[] = {" LCD1602 8-DATA "};
const u8  text2[] = {" AI8051U-34K64  "};
const u8  text3[] = {"2024-10-22 21:29"};
const u8  text4[] = {" WWW.STCAI.com  "};


/*************  ر    **************/
u16	LCM_TxCnt;		//LCM DMAʹ, һ16ֽ, һ64
bit	B_LCM_DMA_busy;	//LCM DMAæ־ 1־LCM-DMAæLCM DMAж˱־ʹLCM DMAǰҪȷϴ˱־Ϊ0
bit	B_TxCmd;		//ѷ־
u8	xdata CmdTmp[2];	//
u8	xdata DisTmp1[16];	//һʾ壬ҪʾݷԴDMA.
u8	xdata DisTmp2[16];	//ڶʾ壬ҪʾݷԴDMA.


/*************  غ    **************/



/*************	Pin define	*****************************************************/
sfr		LCD_DATA = 0xa0;	//P0--0x80,  P1--0x90,  P2--0xa0,  P3--0xb0
sbit	LCD_B7  = P2^7;	//Pin 14	B3--Pin 10		LED+ -- Pin 15
						//Pin 13	B2--Pin 9		LED- -- Pin 16
						//Pin 12	B1--Pin 8		Vo   -- Pin 3
						//Pin 11	B0--Pin 7		VDD  -- Pin 2		VSS -- Pin 1

sbit	LCD_ENA	= P3^7;	//Pin 6
sbit	LCD_RW	= P3^6;	//Pin 5	//LCD_RS   R/W   DB7--DB0        FOUNCTION
sbit	LCD_RS	= P4^5;	//Pin 4	//	0		0	  INPUT      write the command to LCD model
								//	0		1     OUTPUT     read BF and AC pointer from LCD model
								//	1		0     INPUT      write the data to LCD  model
								//	1		1     OUTPUT     read the data from LCD model

/******************************************************************************
                 HD44780U    LCD_MODUL DRIVE PROGRAMME
*******************************************************************************

total 2 lines, 16x2= 32
first line address:  0~15
second line address: 64~79

total 2 lines, 20x2= 40
first line address:  0~19
second line address: 64~83

total 2 lines, 40x2= 80
first line address:  0~39
second line address: 64~103
*/

#define C_CLEAR			0x01		//clear LCD
#define C_HOME 			0x02		//cursor go home
#define C_CUR_L			0x04		//cursor shift left after input
#define C_RIGHT			0x05		//picture shift right after input
#define C_CUR_R			0x06		//cursor shift right after input
#define C_LEFT 			0x07		//picture shift left after input
#define C_OFF  			0x08		//turn off LCD
#define C_ON   			0x0C		//turn on  LCD
#define C_FLASH			0x0D		//turn on  LCD, flash
#define C_CURSOR		0x0E		//turn on  LCD and cursor
#define C_FLASH_ALL		0x0F		//turn on  LCD and cursor, flash
#define C_CURSOR_LEFT	0x10		//single cursor shift left
#define C_CURSOR_RIGHT	0x10		//single cursor shift right
#define C_PICTURE_LEFT	0x10		//single picture shift left
#define C_PICTURE_RIGHT	0x10		//single picture shift right
#define C_BIT8			0x30		//set the data is 8 bits
#define C_BIT4			0x20		//set the data is 8 bits
#define C_L1DOT7		0x30		//8 bits,one line 5*7  dots
#define C_L1DOT10		0x34		//8 bits,one line 5*10 dots
#define C_8bitL2DOT7	0x38		//8 bits,tow lines 5*7 dots
#define C_4bitL2DOT7	0x28		//4 bits,tow lines 5*7 dots
#define C_CGADDRESS0	0x40		//CGRAM address0 (addr=40H+x)
#define C_DDADDRESS0	0x80		//DDRAM address0 (addr=80H+x)


//========================================================================
// : void  delay_ms(u16 ms)
// : ʱ
// : ms,Ҫʱms, 1~65535ms. ԶӦʱ.
// : none.
// 汾: VER1.0
// : 2013-4-1
// ע:
//========================================================================
void  delay_ms(u16 ms)
{
     u16 i;
	 do
	 {
	 	i = MAIN_Fosc / 6000;
		while(--i)	;
     }while(--ms);
}

void	LCD_DelayNop(void)
{
	NOP(27);	// ҲԵ ÷6T+24NOP @40MHz, NOPٸ=FOSC(MHz) * 0.75-6
}

void	CheckBusy(void)		//æ־
{
	u16	i;
	LCD_RS = 0;		//æ־ACָ
	LCD_RW = 1;
	LCD_DATA = 0xff;
	LCD_DelayNop();
	LCD_ENA = 1;
	for(i=0; i<10000; i++)		//æ check the LCD busy or not. With time out. ҲԵ6500@40MHz
	{
		if(!LCD_B7)	break;
	}
	LCD_ENA = 0;
}

/**********************************************/
void IniSendCMD(u8 cmd)		//write the command to LCD
{
	LCD_RS = 0;		//д
	LCD_RW = 0;
	LCD_DATA = cmd;
	LCD_DelayNop();
	LCD_ENA = 1;
	LCD_DelayNop();
	LCD_ENA = 0;
	LCD_DATA = 0xff;
	LCD_DelayNop();
}

/**********************************************/
void Write_CMD(u8 cmd)		//write the command to LCD
{
	CheckBusy();	//æ־  check the LCD busy or not.

	LCD_RS = 0;		//д
	LCD_RW = 0;
	LCD_DATA = cmd;
	LCD_DelayNop();
	LCD_ENA = 1;
	LCD_DelayNop();
	LCD_ENA = 0;
	LCD_DATA = 0xff;
	LCD_DelayNop();
}


/*********	ʼ	**************************/
void Initialize_LCD(void)		//intilize LCD, input none, output none
{
	P2n_standard(0xff);
	P3n_standard(Pin7+Pin6);
	P4n_standard(Pin5);
	delay_ms(1);

	LCD_ENA = 0;
	LCD_RS  = 0;
	LCD_RW  = 0;

	delay_ms(100);
	IniSendCMD(C_BIT8);		//set the data is 4 bits

	delay_ms(10);
	IniSendCMD(C_BIT8);		//set the data is 4 bits

	delay_ms(10);
	IniSendCMD(C_8bitL2DOT7);	//tow lines 5*7 dots

	delay_ms(6);
	Write_CMD(C_CLEAR);		//clear LCD RAM
	Write_CMD(C_CUR_R);		//Curror Shift Right
	Write_CMD(C_ON);		//turn on  LCD
}

//******************** LCD40 Module END ***************************

//========================================================================
// : void LCM_Config(void)
// : LCMúST7920 @540KHzָʱΪ1.6msæź0us, д롢ݡ72us. DMAˢʱ84ms @24MHz.
// : none.
// : none.
// 汾: V1.0, 2024-8-17
// ע:
//========================================================================
//LCMIFCFG  (7EFE50H)	TFTӿüĴ
#define	LCMIFIE			(0<<7)	//TFTӿжʹܿλ(bit7), 1->жϣ0->ֹ
#define	LCMIFIP			(0<<4)	//TFTӿжȼλ(bit5~bit4), ()0~3().
#define	LCMIFDPS		(0<<2)	//TFTӿݽѡλ(bit3~bit2), D18_D8=0: 02->8λP2, D18_D8=1: 0: P2-ֽ, P0ֽ, 2: P2-ֽ,ֽP0[7:4] P4.7 P4.6 P4.3 P4.1.
#define	LCM_D16_D8		(0<<1)	//TFTӿݿȿλ(bit1), 0: 8λݣ1:16λ
#define	LCM_M68_I80		1		//TFTӿģʽѡλ(bit0), 0: I8080ģʽ1:M6800ģʽ

//LCMIFCFG2  (7EFE51H)	TFTӿüĴ2
#define	LCMIFCPS		(1<<5)	//TFTӿڿƽѡλ(bit6~bit5), RS RD(E) WR(RW), 0->P4.5 P4.4 P4.21->P4.5 P3.7 P3.6, 2->P4.0 P4.4 P4.2, 3->P4.0 P3.7 P3.6
#define	LCMSETUPT		(4<<2)	//TFTӿݽʱλ(bit4~bit2), 0~7, Ӧ1~8LCMIFʱ, 6800ģʽEߵƽʱ, 20us.
#define	LCMHOLDT		3		//TFTӿݱʱλ(bit1~bit0), 0~3, Ӧ1~4LCMIFʱ

//LCMIFCR  (7EFE52H)	TFTӿڿƼĴ
#define	ENLCMIF			(1<<7)	//TFTӿʹܿλ(bit7), 1->TFTӿڹ, 0->ֹ
#define	LCM_WRCMD		4		//TFTӿڴ(bit2~bit0), 4->д
#define	LCM_WRDAT		5		//TFTӿڴ(bit2~bit0), 5->д
#define	LCM_RDCMD		6		//TFTӿڴ(bit2~bit0), 6->/״̬
#define	LCM_RDDAT		7		//TFTӿڴ(bit2~bit0), 7->

void LCM_Config(void)
{
	LCMIFCFG  = LCMIFIE  | LCMIFIP   | LCMIFDPS | LCM_D16_D8 | LCM_M68_I80;
	LCMIFCFG2 = LCMIFCPS | LCMSETUPT | LCMHOLDT;	//RS:P45,E:P37,RW:P36; Setup Time,HOLD Time
	LCMIFSTA  = 0x00;	//TFTӿж־0
	LCMIFPSCR = (u8)(MAIN_Fosc/250000UL-1);	//TFTӿʱԤƵ0~255, LCMIFʱƵ = SYSclk/(LCMIFPSCR+1), LCD1602ٶ250KHz
	LCMIFCR   = ENLCMIF;
}

//========================================================================
// : void DMA_Config(u8 xdata *pic)
// : LCM DMAú
// : *pic: ׵ַ.
// : none.
// 汾: V1.0, 2024-8-17
// ע:
//========================================================================
//DMA_LCM_CR (7EfA71H) 	LCM_DMAƼĴ
#define		DMA_ENLCM	(1<<7)	// LCM DMAʹܿλ    bit7, 0:ֹLCM DMAܣ  1LCM DMAܡ
#define		LCM_TRIGWC	(1<<6)	// LCM DMAдbit6, 0:д0Ч          1д1ʼLCM DMAʼд
#define		LCM_TRIGWD	(1<<5)	// LCM DMAдݣbit5, 0:д0Ч          1д1ʼLCM DMAʼдݡ
#define		LCM_TRIGRC	(1<<4)	// LCM DMAbit4, 0:д0Ч          1д1ʼLCM DMAʼ
#define		LCM_TRIGRD	(1<<3)	// LCM DMAݣbit3, 0:д0Ч          1д1ʼLCM DMAʼݡ
#define		LCM_CLRFIFO	0		// LCM DMAFIFOλbit0, 0:д0Ч  1д1λFIFOָ롣

//DMA_LCM_CFG 	(7EfA70H)   LCM_DMAüĴ
#define		DMA_LCMIE	(1<<7)	// LCM DMAжʹܿλbit7, 0:ֹSPI DMAжϣ     1жϡ
#define		DMA_LCMIP	(0<<2)	// LCM DMAжȼλbit3~bit2, ()0~3().
#define		DMA_LCMPTY	0		// LCM DMA߷ȼλbit1~bit0, ()0~3().

//DMA_LCM_STA  (7EfA72) 	LCM_DMA״̬Ĵ
#define		LCM_TXOVW	(1<<1)	// LCM DMAݸǱ־λbit1, 0.
#define		DMA_LCMIF	1		// LCM DMAж־λbit0, 0.

void LCM_DMA_Trig(void)
{
	DMA_LCM_STA  = 0x00;
	DMA_LCM_CFG  = DMA_LCMIE | DMA_LCMIP | DMA_LCMPTY;;
	DMA_LCM_ITVH = 0;	//ôʱ(8λ)ӦN+1LCMIFʱ(1~65536LCMIFʱ)
	DMA_LCM_ITVL = 9-1;	//ôʱ(8λ)

	B_TxCmd   = 0;		//ѷ־
	LCM_TxCnt = 0;		//LCM DMAʹ, һ16ֽ, һ64
	B_LCM_DMA_busy = 1;	//־LCM-DMAæLCM DMAж˱־ʹLCM DMAǰҪȷϴ˱־Ϊ0
	DMA_LCM_STA = DMA_LCMIF;	//LCM DMAжϣ
}

//========================================================================
// : void LCMIF_DMA_ISR(void) interrupt USER_VECTOR//DMA_LCM_VECTOR
// : LCM DMAжϺжϴʱ:2.3us @24MHz. ˢʱ䣺84ms @24MHz.
// : none.
// : none.
// 汾: V1.0, 2024-8-17
// ע:
//========================================================================
void LCMIF_DMA_ISR(void) interrupt USER_VECTOR//DMA_LCM_VECTOR
{
	if(DMA_LCM_STA & DMA_LCMIF)
	{
		if(LCM_TxCnt >= 2)	//жϷǷ
		{
			DMA_LCM_CR = 0;
			B_LCM_DMA_busy = 0;		//LCM-DMAæ־LCM DMAж˱־ʹLCM DMAǰҪȷϴ˱־Ϊ0
		}
		else		//Ҫ
		{
			if(!B_TxCmd)	//ûзõַȷõַ
			{
				B_TxCmd = 1;	//ָʾѷַ
				if(LCM_TxCnt == 0)   //һеַ
				{
					LCD_RS = 0;		//д
					LCD_RW = 0;
					CmdTmp[0] = 0x80;	//һACַ
				}
				else if(LCM_TxCnt == 1)   //ڶеַ
				{
					LCD_RS = 0;		//д
					LCD_RW = 0;
					CmdTmp[0] = 0x80 | 64;	//ڶACַ
				}
				DMA_LCM_TXAH = (u8)((u16)CmdTmp >> 8);	//LCM DMA׵ַ
				DMA_LCM_TXAL = (u8)CmdTmp;
				DMA_LCM_AMTH = 0;			//ôֽ(8λ),	ôֽ = N+1
				DMA_LCM_AMT  = 1-1;			//ôֽ(8λ).
				DMA_LCM_CR   = DMA_ENLCM | LCM_TRIGWC;	//LCM DMA
			}
			else	//д
			{
				LCD_RS = 1;		//дʾ
				LCD_RW = 0;
				B_TxCmd = 0;	//ѷַ
				if(LCM_TxCnt == 0)   //һʾַ
				{
					DMA_LCM_TXAH = (u8)((u16)DisTmp1 >> 8);	//LCM DMA׵ַ
					DMA_LCM_TXAL = (u8)DisTmp1;
				}
				else //if(LCM_TxCnt == 1)   //ڶʾַ
				{
					DMA_LCM_TXAH = (u8)((u16)DisTmp2 >> 8);	//LCM DMA׵ַ
					DMA_LCM_TXAL = (u8)DisTmp2;
				}
				DMA_LCM_AMTH = 0;				//ôֽ(8λ),	ôֽ = N+1
				DMA_LCM_AMT  = 16-1;			//ôֽ(8λ).
				DMA_LCM_CR   = DMA_ENLCM | LCM_TRIGWD;	//LCM DMA
				LCM_TxCnt++;		//+1
			}
		}
	}
	DMA_LCM_STA = 0;
}


/***************  *******************************/

void main(void)
{
	u8 i = 0;
	EAXSFR();	//չĴ(XFR)ʹ
	WTST  = 0;	//óָʱֵΪ0ɽCPUִָٶΪ
	CKCON = 0;	//߷XRAMٶ

	P0M1 = 0x00;   P0M0 = 0x00;   //Ϊ׼˫
	P1M1 = 0x00;   P1M0 = 0x00;   //Ϊ׼˫
	P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
	P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
	P4M1 = 0x00;   P4M0 = 0x00;   //Ϊ׼˫
	P5M1 = 0x00;   P5M0 = 0x00;   //Ϊ׼˫
	P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
	P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

	delay_ms(100);	//ȴһ£LCD빤״̬
	LCM_Config();
	Initialize_LCD();	//ʼLCD
	EA = 1;

	while (1)
	{
		if(!B_LCM_DMA_busy)		//DMA
		{
			for(i=0; i<16; i++)	//ҪʾıװصԴ
			{
				DisTmp1[i] = text1[i];	//صһԴ
				DisTmp2[i] = text2[i];	//صڶԴ
			}
			LCM_DMA_Trig();		//DMAʾı
		}
		delay_ms(2000);

		if(!B_LCM_DMA_busy)		//DMA
		{
			for(i=0; i<16; i++)	//ҪʾıװصԴ
			{
				DisTmp1[i] = text3[i];	//صһԴ
				DisTmp2[i] = text4[i];	//صڶԴ
			}
			LCM_DMA_Trig();		//DMAʾı
		}
		delay_ms(2000);
	}
}

