/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻AI8051UΪоƬʵбдԡ

ʹKeil C51,Ϊ˴ﵽȽϸߵЧ,һ㽨ѡ"Small"ģʽ

 "error C249: 'DATA': SEGMENT TOO LARGE" ʱҪֱֶȽϴͨ"xdata" ǿƷ䵽 XDATA (: char xdata buffer [256];)

ͨMDU32ļʵAI8051UӲ˳滻׼㷨㷨

1(115200,N,8,1)ӡ

ͨAI8051U_8_MDU32.LIBIB"ļʾIOڵ͵ƽʱ䣬ԱAI8051UӲ˳Ԫ׼㷨ļЧ

ʱʱɽڴӡָΣ鿴ÿʽļʱ

ʱ, Ĭʱ 24MHz (û޸Ƶ).

******************************************/

#include "..\comm\AI8051U.h"
#include "intrins.h"
#include "stdio.h"

#define MAIN_Fosc        24000000UL

volatile  unsigned long int  uint1;//keil c51 nearؼ
volatile  unsigned long int uint2;
volatile unsigned long int xuint;

volatile long int sint1, sint2;
volatile long int xsint;

unsigned long ultest;
long ltest;

/*****************************************************************************/

sbit TPIN  =  P4^2;

/*****************************************************************************/

#define Baudrate      115200L
#define TM            (65536 -(MAIN_Fosc/Baudrate/4))
#define PrintUart     1        //1:printf ʹ UART1; 2:printf ʹ UART2

/******************** ڴӡ ********************/
void UartInit(void)
{
#if(PrintUart == 1)
    P_SW1 &= ~S1_S1;      //UART1 switch to, 0x00: P3.0 P3.1, 0x40: P3.6 P3.7, 0x80: P1.6 P1.7, 0xC0: P4.3 P4.4
    P_SW1 &= ~S1_S0;
    SCON = (SCON & 0x3f) | 0x40; 
    AUXR |= (1<<6);      //ʱʱ1Tģʽ
    AUXR &= ~S1BRT;      //1ѡʱ1Ϊʷ
    TL1  = TM;
    TH1  = TM>>8;
    TR1 = 1;        //ʱ1ʼʱ

//    SCON = (SCON & 0x3f) | 0x40; 
//    T2L  = TM;
//    T2H  = TM>>8;
//    AUXR |= 0x15;   //1ѡʱ2Ϊʷ
#else
    P_SW2 |= S2_S;       //UART2 switch to: 0: P1.2 P1.3,  1: P4.2 P4.3
    S2CFG |= 0x01;  //ʹô2ʱW1λΪ1ܻԤڵĴ
    S2CON = (S2CON & 0x3f) | 0x40; 
    T2L  = TM;
    T2H  = TM>>8;
    AUXR |= 0x14;   //ʱ2ʱ1Tģʽ,ʼʱ
#endif
}

void UartPutc(unsigned char dat)
{
#if(PrintUart == 1)
    SBUF = dat; 
    while(TI==0);
    TI = 0;
#else
    S2BUF  = dat; 
while((S2CON & S2TI)==0);
    S2CON &= ~S2TI;    //Clear Tx flag
#endif
}

char putchar(char c)
{
    UartPutc(c);
    return c;
}

void delay(unsigned char ms)
{
     while(--ms);
}

/*****************************************************************************/
void main(void)
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXSFR(); //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x00;   P0M0 = 0x00;   //Ϊ׼˫
    P1M1 = 0x00;   P1M0 = 0x00;   //Ϊ׼˫
    P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
    P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
    P4M1 = 0x00;   P4M0 = 0x00;   //Ϊ׼˫
    P5M1 = 0x00;   P5M0 = 0x00;   //Ϊ׼˫
    P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    UartInit();

    printf("AI8051U MDU32 Test.\r\n");
    
    TPIN = 0;  //㿪ʼͬź
    delay(2);
    TPIN = 1;
    delay(2);
    TPIN = 0;
    delay(2);
    TPIN = 1;
    delay(2);
    
    ultest = 12345678UL;
    ltest = 12345678;
    ultest = ultest / 12;
    ltest = ltest / 12;

    sint1 = 0x31030F05;
    sint2 = 0x00401350;
    TPIN = 0;
    xsint = sint1 * sint2;
    TPIN = 1;
    printf("Result1=0x%lx\r\n",xsint);

    uint1 =  5;
    uint2 =  50;
    TPIN = 0;
    xuint = uint1 * uint2;
    TPIN = 1;
    printf("Result2=%d\r\n",xuint);

    uint1 = 654689;
    uint2 = 528;
    TPIN = 0;
    xuint = uint1 / uint2;
    TPIN = 1;
    printf("Result3=%u\r\n",xuint);

    sint1 = 2134135177;
    sint2 = 20000;
    TPIN = 0;
    xsint = sint1 / sint2;
    TPIN = 1;
    printf("Result4=0x%lx\r\n",xsint);

    sint1 = -2134135177;
    sint2 = -20000;
    TPIN = 0;
    xsint = sint1 / sint2;
    TPIN = 1;
    printf("Result5=0x%lx\r\n",xsint);

    sint1 = 2134135177;
    sint2 = -20000;
    TPIN = 0;
    xsint = sint1 / sint2;
    TPIN = 1;
    printf("Result6=0x%lx\r\n",xsint);

    while(1);
}
/*****************************************************************************/
