/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

#include "usb.h"
#include "usb_req_vendor.h"
#include "usb_desc.h"

void usb_req_vendor()
{
    switch (Setup.bRequest)
    {
    case MS_VENDORCODE:
        usb_vendor_code();
        break;
    case VENDOR_INPUT:
        usb_vendor_in();
        break;
    case VENDOR_OUTPUT:
        usb_vendor_out();
        break;
    default:
        usb_setup_stall();
        return;
    }
}

void usb_vendor_code()
{
    if (Setup.bmRequestType != (IN_DIRECT | VENDOR_REQUEST | DEVICE_RECIPIENT))
    {
        usb_setup_stall();
        return;
    }
    
    switch (Setup.wIndexL)
    {
    case 0x04:
        Ep0State.pData = COMPATIBLEIDDESC;
        Ep0State.wSize = sizeof(COMPATIBLEIDDESC);
        break;
    case 0x05:
        Ep0State.pData = EXTPROPERTYDESC;
        Ep0State.wSize = sizeof(EXTPROPERTYDESC);
        break;
    default:
        usb_setup_stall();
        return;
    }
    
    if (Ep0State.wSize > Setup.wLength)
    {
        Ep0State.wSize = Setup.wLength;
    }

    usb_setup_in();
}

void usb_vendor_in()
{
    if ((DeviceState != DEVSTATE_CONFIGURED) ||
        (Setup.bmRequestType != (IN_DIRECT | VENDOR_REQUEST | DEVICE_RECIPIENT)))
    {
        usb_setup_stall();
        return;
    }

    Ep0State.pData = UsbBuffer;
    Ep0State.wSize = Setup.wLength;

    usb_setup_in();
}

void usb_vendor_out()
{
    if ((DeviceState != DEVSTATE_CONFIGURED) ||
        (Setup.bmRequestType != (OUT_DIRECT | VENDOR_REQUEST | DEVICE_RECIPIENT)))
    {
        usb_setup_stall();
        return;
    }

    Ep0State.pData = UsbBuffer;
    Ep0State.wSize = Setup.wLength;

    usb_setup_out();
}

void usb_vendor_polling()
{
    BYTE cnt;
    
    if (DeviceState != DEVSTATE_CONFIGURED)
        return;

    if (!UsbInBusy && (Rptr != Wptr))
    {
        IE2 &= ~EUSB;
        UsbInBusy = 1;
        usb_write_reg(INDEX, 1);
        cnt = 0;
        while (Rptr != Wptr)
        {
            usb_write_reg(FIFO1, UsbBuffer[Rptr++]);
            cnt++;
            if (cnt == EP1IN_SIZE) break;
        }
        usb_write_reg(INCSR1, INIPRDY);
        IE2 |= EUSB;
    }
    
    if (UsbOutBusy)
    {
        IE2 &= ~EUSB;
        if (Wptr - Rptr < 256 - EP1OUT_SIZE)
        {
            UsbOutBusy = 0;
            usb_write_reg(INDEX, 1);
            usb_write_reg(OUTCSR1, 0);
        }
        IE2 |= EUSB;
    }
}
