/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻AI8051UΪоƬʵбдԡ

ʹKeil C51,Ϊ˴ﵽȽϸߵЧ,һ㽨ѡ"Small"ģʽ

 "error C249: 'DATA': SEGMENT TOO LARGE" ʱҪֱֶȽϴͨ"xdata" ǿƷ䵽 XDATA (: char xdata buffer [256];)

USARTLinշĬͨŽţP3.6 P3.7.

һP32ڰ, һ֡.
һP33ڰ, ֡ͷȡӻӦݣϲһ֡.

Ĭϴʣ9600, û޸.

ʱ, Ĭʱ 24MHz (û޸Ƶ).

******************************************/

#include "..\comm\AI8051U.h"
#include "stdio.h"
#include "intrins.h"

typedef 	unsigned char	u8;
typedef 	unsigned int	u16;
typedef 	unsigned long	u32;

#define MAIN_Fosc        24000000UL
#define Baudrate1        9600UL
#define Timer0_Reload    (65536UL -(MAIN_Fosc / 1000))       //Timer 0 жƵ, 1000/
#define TM               (65536UL -(MAIN_Fosc/Baudrate1/4))

/*****************************************************************************/

sbit SLP_N  = P4^7;     //0: Sleep

/*************  س    **************/

#define FRAME_LEN           8    //ݳ: 8 ֽ
#define UART1_BUF_LENGTH    64

/*************  ر    **************/

u8 Lin_ID;
u8 TX_BUF[8];

bit B_1ms;          //1ms־

bit B_TX1_Busy; //æ־
u8  TX1_Cnt;    //ͼ
u8  RX1_Cnt;    //ռ
u8  RX1_TimeOut;

u8  Key1_cnt;
u8  Key2_cnt;
bit Key1_Flag;
bit Key2_Flag;

u8  RX1_Buffer[UART1_BUF_LENGTH]; //ջ

/*************  غ    **************/

void LinInit();
void LinSendMsg(u8 lid, u8 *pdat);
void LinSendHeader(u8 lid);

/******************** ڴӡ ********************/
void UartInit(void)
{
	P_SW2 |= S2_S;       //UART2 switch to: 0: P1.2 P1.3,  1: P4.2 P4.3
    S2CFG |= 0x01;  //ʹô2ʱW1λΪ1ܻԤڵĴ
	S2CON = (S2CON & 0x3f) | 0x40;
	T2L  = TM;
	T2H  = TM>>8;
	AUXR |= 0x14;   //ʱ2ʱ1Tģʽ,ʼʱ
}

void UartPutc(unsigned char dat)
{
	S2BUF  = dat; 
	while((S2CON & S2TI)==0);
	S2CON &= ~S2TI;    //Clear Tx flag
}

char putchar(char c)
{
	UartPutc(c);
	return c;
}

/*********************  *************************/
void main(void)
{
	u8 i;
	
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXSFR(); //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x00;   P0M0 = 0x00;   //Ϊ׼˫
    P1M1 = 0x00;   P1M0 = 0x00;   //Ϊ׼˫
    P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
    P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
    P4M1 = 0x00;   P4M0 = 0x00;   //Ϊ׼˫
    P5M1 = 0x00;   P5M0 = 0x00;   //Ϊ׼˫
    P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

	AUXR = 0x80;    //Timer0 set as 1T, 16 bits timer auto-reload, 
	TH0 = (u8)(Timer0_Reload / 256);
	TL0 = (u8)(Timer0_Reload % 256);
	ET0 = 1;    //Timer0 interrupt enable
	TR0 = 1;    //Tiner0 run

	Lin_ID = 0x32;
	UartInit();
	LinInit();
	EA = 1;               //ж

	SLP_N = 1;
	TX_BUF[0] = 0x81;
	TX_BUF[1] = 0x22;
	TX_BUF[2] = 0x33;
	TX_BUF[3] = 0x44;
	TX_BUF[4] = 0x55;
	TX_BUF[5] = 0x66;
	TX_BUF[6] = 0x77;
	TX_BUF[7] = 0x88;
	
	while(1)
	{
		if(B_1ms)   //1ms
		{
			B_1ms = 0;

			if(!P32)
			{
				if(!Key1_Flag)
				{
					Key1_cnt++;
					if(Key1_cnt > 50)
					{
						Key1_Flag = 1;
						LinSendMsg(Lin_ID, TX_BUF);  //һ
					}
				}
			}
			else
			{
				Key1_cnt = 0;
				Key1_Flag = 0;
			}

			if(!P33)
			{
				if(!Key2_Flag)
				{
					Key2_cnt++;
					if(Key2_cnt > 50)
					{
						Key2_Flag = 1;
						LinSendHeader(0x13);  //֡ͷȡ֡һ֡
					}
				}
			}
			else
			{
				Key2_cnt = 0;
				Key2_Flag = 0;
			}
			
			if(RX1_TimeOut > 0)     //ʱ
			{
				if(--RX1_TimeOut == 0)
				{
					for(i=0; i<RX1_Cnt; i++)    printf("0x%bx ",RX1_Buffer[i]);    //ӴյĴӻ
					RX1_Cnt  = 0;   //ֽ
					printf("\r\n");
				}
			}
		}
	}
}

/********************** Timer0 1msжϺ ************************/
void timer0 (void) interrupt 1
{
    B_1ms = 1;      //1ms־
}

//========================================================================
// : void LinSendByte(u8 dat)
// : һֽں
// : none.
// : none.
// 汾: VER1.0
// : 2024-08-15
// ע: 
//========================================================================
void LinSendByte(u8 dat)
{
	B_TX1_Busy = 1;
	SBUF = dat;
	while(B_TX1_Busy);
}

//========================================================================
// : u16 LinSendData(u8 *pdat)
// : Linݺ
// : *pdat: ݻ.
// : Lin ID.
// 汾: VER1.0
// : 2024-08-15
// ע: 
//========================================================================
void LinSendData(u8 *pdat)
{
	u8 i;

	for(i=0;i<FRAME_LEN;i++)
	{
		LinSendByte(pdat[i]);
	}
}

//========================================================================
// : void SendBreak(void)
// : ģʽLinBreak
// : none.
// : none.
// 汾: VER1.0
// : 2024-08-15
// ע: 
//========================================================================
void SendBreak(void)
{
	USARTCR5 |= 0x04;		//ģʽ Send Break
	LinSendByte(0x00);
}

//========================================================================
// : void LinSendPID(u8 id)
// : IDУתPID벢͡
// : ID.
// : none.
// 汾: VER1.0
// : 2020-12-2
// ע: 
//========================================================================
void LinSendPID(u8 id)
{
	u8 P0 ;
	u8 P1 ;
	
	P0 = (((id)^(id>>1)^(id>>2)^(id>>4))&0x01)<<6 ;
	P1 = ((~((id>>1)^(id>>3)^(id>>4)^(id>>5)))&0x01)<<7 ;
	
	LinSendByte(id|P0|P1);
}

//========================================================================
// : void LINSendChecksum(u8 *dat)
// : У벢͡
// : ݳ.
// : none.
// 汾: VER1.0
// : 2020-12-2
// ע: 
//========================================================================
void LINSendChecksum(u8 *dat)
{
    u16 sum = 0;
    u8 i;

    for(i = 0; i < FRAME_LEN; i++)
    {
        sum += dat[i];
        if(sum & 0xFF00)
        {
            sum = (sum & 0x00FF) + 1;
        }
    }
    sum ^= 0x00FF;
	LinSendByte((u8)sum);
}

//========================================================================
// : void LinSendHeader(u8 lid)
// : Lin֡ͷ
// : ID.
// : none.
// 汾: VER1.0
// : 2024-08-15
// ע: 
//========================================================================
void LinSendHeader(u8 lid)
{
	SendBreak();					//Send Break
	LinSendByte(0x55);				//Send Sync Field
	LinSendPID(lid);				//ID
}

//========================================================================
// : void LinSendMsg(u8 lid, u8 *pdat)
// : Lin֡
// : lid: Lin ID; *pdat: ݻ.
// : none.
// 汾: VER1.0
// : 2024-08-15
// ע: 
//========================================================================
void LinSendMsg(u8 lid, u8 *pdat)
{
	SendBreak();					//Send Break
	LinSendByte(0x55);				//Send Sync Field

	LinSendPID(lid);				//ID
	LinSendData(pdat);
	LINSendChecksum(pdat);
}

//========================================================================
// : void LinSetBaudrate(u16 brt)
// : Lin߲ú
// : brt: .
// : none.
// 汾: VER1.0
// : 2024-08-15
// ע: 
//========================================================================
void LinSetBaudrate(u16 brt)
{
	u16 tmp;
	
	tmp = (MAIN_Fosc >> 4) / brt;
	USARTBRH = (u8)(tmp>>8);
	USARTBRL = (u8)tmp;
}

//========================================================================
// : void LinInit()
// : Linʼ
// : none.
// : none.
// 汾: VER1.0
// : 2024-08-15
// ע: 
//========================================================================
void LinInit()
{
    P_SW1 = (P_SW1 & 0x3f) | 0x40;  //USART1 switch to, 0x00: P3.0 P3.1, 0x40: P3.6 P3.7, 0x80: P1.6 P1.7, 0xC0: P4.3 P4.4

	SCON = (SCON & 0x3f) | 0x40;    //USART1ģʽ, 0x00: ͬλ, 0x40: 8λ,ɱ䲨, 0x80: 9λ,̶, 0xc0: 9λ,ɱ䲨
	TI = 0;
	REN = 1;    //
	ES  = 1;    //ж

	LinSetBaudrate(Baudrate1);		//ò
	PCON |= SMOD;				//1ʷ
	USARTCR1 |= 0x80;		//LIN Mode Enable
	USARTCR5 &= ~0x20;		//LIN Master Mode
	
//	LinSendMsg(Lin_ID, TX_BUF);  //Send data
}

//========================================================================
// : void USART1_int (void) interrupt UART1_VECTOR
// : USART1жϺ
// : nine.
// : none.
// 汾: VER1.0
// : 2024-08-15
// ע: 
//========================================================================
void USART1_int (void) interrupt 4
{
	if(RI)
	{
		RI = 0;    //Clear Rx flag
		if(RX1_Cnt >= UART1_BUF_LENGTH)   RX1_Cnt = 0;
		RX1_Buffer[RX1_Cnt] = SBUF;
		RX1_Cnt++;
		RX1_TimeOut = 5;
	}

	if(TI)
	{
		TI = 0;    //Clear Tx flag
		B_TX1_Busy = 0;
	}
}

