/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

/*************    ˵    **************

̻AI8051UΪоƬʵбдԡ

ʹKeil C51,Ϊ˴ﵽȽϸߵЧ,һ㽨ѡ"Small"ģʽ

 "error C249: 'DATA': SEGMENT TOO LARGE" ʱҪֱֶȽϴͨ"xdata" ǿƷ䵽 XDATA (: char xdata buffer [256];)

ʾ15·ADCbandgapѯ1(P3.0 P3.1)͸λ115200,N,8,1.

0~7ͨӦP1.0~P1.7, 8~14ͨӦP0.0~P0.6, 15ͨΪڲ1.19V׼ѹADCֵ.

ʼʱȰҪADCתΪ.

ʱ, ѡʱ 22.1184MHz (û޸Ƶ).

******************************************/

#include "..\..\comm\AI8051U.h"
#include "intrins.h"
#include "stdio.h"

typedef     unsigned char    u8;
typedef     unsigned int    u16;
typedef     unsigned long    u32;

#define MAIN_Fosc     22118400L  //ʱ
#define Baudrate      115200L
#define TM            (65536 -(MAIN_Fosc/Baudrate/4))

/*************    س    **************/

#define    ADC_SPEED    15        /* 0~15, ADCתʱ(CPUʱ) = (n+1)*32  ADCCFG */
#define    RES_FMT      (1<<5)    /* ADCʽ 0: , ADC_RES: D11 D10 D9 D8 D7 D6 D5 D4, ADC_RESL: D3 D2 D1 D0 0 0 0 0 */
                                  /* ADCCFG      1: Ҷ, ADC_RES: 0 0 0 0 D11 D10 D9 D8, ADC_RESL: D7 D6 D5 D4 D3 D2 D1 D0 */

/*************    ر    **************/


/*************    غ    **************/

void delay_ms(u8 ms);
void ADC_convert(u8 chn);    //chn=0~7ӦP1.0~P1.7, chn=8~14ӦP0.0~P0.6, chn=15ӦBandGapѹ
u16  Get_ADC12bitResult(u8 channel);

/******************** ڴӡ ********************/
void UartInit(void)
{
    P_SW1 &= ~S1_S1;      //UART1 switch to, 00: P3.0 P3.1, 01: P3.6 P3.7, 10: P1.6 P1.7, 11: P4.3 P4.4
    P_SW1 &= ~S1_S0;
    SCON = (SCON & 0x3f) | 0x40; 
    AUXR |= (1<<6);      //ʱʱ1Tģʽ
    AUXR &= ~S1BRT;      //1ѡʱ1Ϊʷ
    TL1  = TM;
    TH1  = TM>>8;
    TR1 = 1;        //ʱ1ʼʱ
}

void UartPutc(unsigned char dat)
{
    SBUF = dat; 
    while(TI == 0);
    TI = 0;
}

char putchar(char c)
{
    UartPutc(c);
    return c;
}

/**********************************************/
void main(void)
{
    u8    i;

    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXSFR(); //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x00;   P0M0 = 0x00;   //Ϊ׼˫
    P1M1 = 0x00;   P1M0 = 0x00;   //Ϊ׼˫
    P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
    P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
    P4M1 = 0x00;   P4M0 = 0x00;   //Ϊ׼˫
    P5M1 = 0x00;   P5M0 = 0x00;   //Ϊ׼˫
    P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    ADCTIM = 0x3f;  //ͨѡʱ䡢ʱ䡢ʱ
    ADCCFG = RES_FMT + ADC_SPEED;
    //ADCģԴ򿪺ȴ1msMCUڲADCԴȶٽADת
    ADC_CONTR = 0x80 + 0;    //ADC on + channel

    UartInit();
    EA = 1;
    printf("AI8051UϵADCԳ!\r\n");

    while (1)
    {
        for(i=0; i<16; i++)
        {
            delay_ms(200);
            //ADC_convert(3);        //͹̶ͨADֵ

            ADC_convert(i);        //ѯͨADֵ
            if((i & 7) == 7)    //дӡ
            {
                printf("\r\n");
            }
        }
    }
}


//========================================================================
// : u16 Get_ADC12bitResult(u8 channel))    //channel = 0~15
// : ѯһADC.
// : channel: ѡҪתADC, 0~15.
// : 12λADC.
// 汾: V1.0, 2016-4-28
//========================================================================
u16 Get_ADC12bitResult(u8 channel)    //channel = 0~15
{
    ADC_RES = 0;
    ADC_RESL = 0;

    ADC_CONTR = (ADC_CONTR & 0xf0) | channel; //ADCתͨ
    ADC_CONTR |= ADC_START;//ADCת
    _nop_();
    _nop_();
    _nop_();
    _nop_();
while((ADC_CONTR & ADC_FLAG)==0);//waitforADCfinish
    ADC_CONTR &= ~ADC_FLAG;     //ADC־
    return (((u16)ADC_RES << 8) | ADC_RESL);
}

#define SUM_LENGTH    16    /* ƽֵ ֵ16 */

/***********************************
ѯʽһADC, chnΪͨ, chn=0~7ӦP1.0~P1.7, chn=8~14ӦP0.0~P0.6, chn=15ӦBandGapѹ.
***********************************/
void ADC_convert(u8 chn)
{
    u16 j;
    u8  k;        //ƽֵ˲ʱʹ

    Get_ADC12bitResult(chn);    //i=0~15,ѯʽһADC, лͨһת. ݵĲдѹӰ.
    Get_ADC12bitResult(chn);    //i=0~15,ѯʽһADC, лͨڶת. ݵĲдѹӰ.
    for(k=0, j=0; k<SUM_LENGTH; k++)    j += Get_ADC12bitResult(chn);    // ۼӺ, 0~15,ѯʽһADC, ֵǽ
    j = j / SUM_LENGTH;        // ƽ

    if(chn == 15)    printf("Bandgap=%04d  ",j);    //ڻ׼ 1.19V
    else        //ADC0~ADC14
    {
        printf("ADC%02d=%04d  ",chn,j);
    }
}

//========================================================================
// : void delay_ms(u8 ms)
// : ʱ
// : ms,Ҫʱms, ֻ֧1~255ms. ԶӦʱ.
// : none.
// 汾: VER1.0
// : 2013-4-1
// ע: 
//========================================================================
void delay_ms(u8 ms)
{
    u16 i;
    do
    {
        i = MAIN_Fosc / 6000;
        while(--i);
    }while(--ms);
}
