/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻AI8051UΪоƬʵбдԡ

ʹKeil C51,Ϊ˴ﵽȽϸߵЧ,һ㽨ѡ"Small"ģʽ

 "error C249: 'DATA': SEGMENT TOO LARGE" ʱҪֱֶȽϴͨ"xdata" ǿƷ䵽 XDATA (: char xdata buffer [256];)

1ȫ˫жϷʽշͨѶ

ͨPCMCU, MCUյԶDMAռ䡣

DMAռôСݺͨ1DMAԶ͹ܰѴ洢ռԭء

ôڳʱжϣMCUڽһݺʱûյݣʱжϣѾȡԭ

öʱʷʹ1Tģʽ(ǵͲ12T)ѡɱʱƵʣ߾ȡ

ʱ, ѡʱ 22.1184MHz (û޸Ƶ).

******************************************/

#include "..\..\comm\AI8051U.h"
#include "stdio.h"
#include "intrins.h"

typedef     unsigned char    u8;
typedef     unsigned int    u16;
typedef     unsigned long    u32;

#define MAIN_Fosc       22118400L   //ʱӣȷ115200ʣ
#define Baudrate1       115200L

bit DmaTxFlag;
bit DmaRxFlag;
bit B_RX1_TimeOut;

u8 xdata DmaBuffer[1024];

void UART1_config(u8 brt);   // ѡ, 2: ʹTimer2, ֵ: ʹTimer1.
void DMA_Config(void);

void UartPutc(unsigned char dat)
{
    SBUF = dat; 
    while(TI == 0); 
    TI = 0;
}
 
char putchar(char c)
{
    UartPutc(c);
    return c;
}

//========================================================================
// : void main(void)
// : 
// : none.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void main(void)
{
    u16 i;
    
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXSFR(); //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x00;   P0M0 = 0x00;   //Ϊ׼˫
    P1M1 = 0x00;   P1M0 = 0x00;   //Ϊ׼˫
    P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
    P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
    P4M1 = 0x00;   P4M0 = 0x00;   //Ϊ׼˫
    P5M1 = 0x00;   P5M0 = 0x00;   //Ϊ׼˫
    P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    for(i=0; i<512; i++)
    {
        DmaBuffer[i] = i;
    }

    UART1_config(1);    // ѡ, 2: ʹTimer2, ֵ: ʹTimer1.
    printf("AI8051U UART1 TimeOut Test Programme!\r\n");  //UART1һַ

    DMA_Config();
    EA = 1; //ж

//    DmaTxFlag = 0;
//    DmaRxFlag = 0;

    while (1)
    {
        if(B_RX1_TimeOut)       //һݽʱж
        {
            B_RX1_TimeOut = 0;

            i = ((u16)DMA_UR1R_DONEH << 8) + DMA_UR1R_DONE; //ȡѽֽڸ
            TI = 0; //ͱ־DMA겻Զ־λ
            printf("cnt=%u\r\n",i);

            DMA_UR1R_CR = 0;
            i--;    //ֽΪ(i-1)
            DMA_UR1T_AMT = (u8)i;       //ôֽ(8λ)n+1
            DMA_UR1T_AMTH = (u8)(i>>8); //ôֽ(8λ)n+1

            DMA_UR1T_CR = 0xc0;         //bit7 1:ʹ UART1_DMA, bit6 1:ʼ UART1_DMA Զ
            DMA_UR1R_CR = 0xa1;         //bit7 1:ʹ UART1_DMA, bit5 1:ʼ UART1_DMA Զ, bit0 1: FIFO
        }

//        if((DmaTxFlag) && (DmaRxFlag))  //շDMAָֽ
//        {
//            DmaTxFlag = 0;
//            DMA_UR1T_CR = 0xc0;         //bit7 1:ʹ UART1_DMA, bit6 1:ʼ UART1_DMA Զ
//            DmaRxFlag = 0;
//            DMA_UR1R_CR = 0xa1;         //bit7 1:ʹ UART1_DMA, bit5 1:ʼ UART1_DMA Զ, bit0 1: FIFO
//        }
    }
}

//========================================================================
// : void DMA_Config(void)
// : UART DMA .
// : none.
// : none.
// 汾: V1.0, 2024-5-6
//========================================================================
void DMA_Config(void)
{
    DMA_UR1T_CFG = 0x00;        //bit7 0:Disable Interrupt
    DMA_UR1T_STA = 0x00;
    DMA_UR1T_AMT = 0xff;        //ôֽ(8λ)n+1
    DMA_UR1T_AMTH = 0x01;       //ôֽ(8λ)n+1
    DMA_UR1T_TXAH = (u8)((u16)&DmaBuffer >> 8);
    DMA_UR1T_TXAL = (u8)((u16)&DmaBuffer);
    DMA_UR1T_CR = 0x80;         //bit7 1:ʹ UART1_DMA, bit6 1:ʼ UART1_DMA Զ

    DMA_UR1R_CFG = 0x00;        //bit7 0:Disable Interrupt
    DMA_UR1R_STA = 0x00;
    DMA_UR1R_AMT = 0xff;        //ôֽ(8λ)n+1
    DMA_UR1R_AMTH = 0x03;       //ôֽ(8λ)n+1
    DMA_UR1R_RXAH = (u8)((u16)&DmaBuffer >> 8);
    DMA_UR1R_RXAL = (u8)((u16)&DmaBuffer);
    DMA_UR1R_CR = 0xa1;         //bit7 1:ʹ UART1_DMA, bit5 1:ʼ UART1_DMA Զ, bit0 1: FIFO
}

//========================================================================
// : SetTimer2Baudraye(u16 dat)
// : Timer2ʷ
// : dat: Timer2װֵ.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void SetTimer2Baudraye(u16 dat)  // ѡ, 2: ʹTimer2, ֵ: ʹTimer1.
{
    AUXR &= ~(1<<4);    //Timer stop
    AUXR &= ~(1<<3);  //Timer2 set As Timer
    AUXR |= (1<<2);  //Timer2 set as 1T mode
    T2H = dat / 256;
    T2L = dat % 256;
    IE2 = (IE2 & ~0x04) | (0 << 2);    //ֹж
    AUXR = (AUXR & ~0x10) | (1 << 4);    //Timer run enable
}

//========================================================================
// : void UART1_config(u8 brt)
// : UART1ʼ
// : brt: ѡ, 2: ʹTimer2, ֵ: ʹTimer1.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART1_config(u8 brt)    // ѡ, 2: ʹTimer2, ֵ: ʹTimer1.
{
    /*********** ʹöʱ2 *****************/
    if(brt == 2)
    {
        AUXR |= S1BRT;      //S1 BRT Use Timer2;
        SetTimer2Baudraye((u16)(65536UL - (MAIN_Fosc / 4) / Baudrate1));
    }

    /*********** ʹöʱ1 *****************/
    else
    {
        TR1 = 0;
        AUXR &= ~S1BRT;      //S1 BRT Use Timer1;
        TMOD &= ~(1<<6);      //Timer1 set As Timer
        AUXR |= (1<<6);      //Timer1 set as 1T mode
        TMOD &= ~0x30;  //Timer1_16bitAutoReload;
        TH1 = (u8)((65536UL - (MAIN_Fosc / 4) / Baudrate1) / 256);
        TL1 = (u8)((65536UL - (MAIN_Fosc / 4) / Baudrate1) % 256);
        ET1 = 0;        //ֹж
        TR1  = 1;
    }
    /*************************************************/

    SCON = (SCON & 0x3f) | 0x40;    //UART1ģʽ, 0x00: ͬλ, 0x40: 8λ,ɱ䲨, 0x80: 9λ,̶, 0xc0: 9λ,ɱ䲨
//  PS  = 1;    //ȼж
//  ES  = 1;    //ж
    REN = 1;    //
    P_SW1 &= 0x3f;
    P_SW1 |= 0x00;  //UART1 switch to, 0x00: P3.0 P3.1, 0x40: P3.6 P3.7, 0x80: P1.6 P1.7, 0xC0: P4.3 P4.4

    UR1TOCR = 0xc0; //ʹܳʱգʹܳʱжϣʱʱѡ 1:ϵͳʱ  0:λ()
    UR1TOTL = 0x10;
    UR1TOTH = 0x00; //0x5666 = 22118
    UR1TOTE = 0x00; //Ҫд UR1TOTE µTMֵŻЧ
}

//========================================================================
// : void UART1_int (void) interrupt UART1_VECTOR
// : UART1жϺ
// : nine.
// : none.
// 汾: VER1.0
// : 2014-11-28
// ע: 
//========================================================================
void UART1_int (void) interrupt 4
{
//    if(RI)
//    {
//        RI = 0;
//        RX1_Buffer[RX1_Cnt] = SBUF;
//        if(++RX1_Cnt >= UART1_BUF_LENGTH)   RX1_Cnt = 0;
//    }

//    if(TI)
//    {
//        TI = 0;
//        B_TX1_Busy = 0;
//    }
    
    if(UR1TOSR & 0x01)
    {
        P42 = !P42;
        B_RX1_TimeOut = 1;
        UR1TOSR = 0x80; // RTOCF ʱ־λ TOIF
    }
}

//========================================================================
// : void UART1_DMA_Interrupt (void) interrupt 50/51
// : UART1 DMAжϺ
// : none.
// : none.
// 汾: VER1.0
// : 2021-5-8
// ע: 
//========================================================================
//void UART1_DMA_Interrupt(void) interrupt 13
//{
//    if (DMA_UR1T_STA & 0x01)    //
//    {
//        DMA_UR1T_STA &= ~0x01;
//        DmaTxFlag = 1;
//    }
//    if (DMA_UR1T_STA & 0x04)    //ݸ
//    {
//        DMA_UR1T_STA &= ~0x04;
//    }
//    
//    if (DMA_UR1R_STA & 0x01)    //
//    {
//        DMA_UR1R_STA &= ~0x01;
//        DmaRxFlag = 1;
//    }
//    if (DMA_UR1R_STA & 0x02)    //ݶ
//    {
//        DMA_UR1R_STA &= ~0x02;
//    }
//}
