/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻AI8051UΪоƬʵбдԡ

ʹKeil C51,Ϊ˴ﵽȽϸߵЧ,һ㽨ѡ"Small"ģʽ

 "error C249: 'DATA': SEGMENT TOO LARGE" ʱҪֱֶȽϴͨ"xdata" ǿƷ䵽 XDATA (: char xdata buffer [256];)

2ȫ˫жϷʽշͨѶ

ͨPCMCU, MCUյԶDMAռ.

DMAݲʱжϺͨڵDMAԶ͹ܰѴ洢ռԭ.

öʱʷʹ1Tģʽ(ǵͲ12T)ѡɱʱƵʣ߾ȡ

ʱ, ѡʱ 22.1184MHz (û޸Ƶ).

******************************************/

#include "..\..\comm\AI8051U.h"
#include "stdio.h"
#include "intrins.h"

typedef     unsigned char    u8;
typedef     unsigned int    u16;
typedef     unsigned long    u32;

#define MAIN_Fosc   22118400L   //ʱӣȷ115200ʣ
#define Baudrate2   115200L

bit DmaTxFlag;
bit DmaRxFlag;
bit B_RX2_TimeOut;

u8 xdata DmaBuffer[256];

void UART2_config(u8 brt);   // ѡ, 2: ʹTimer2, ֵ: Ч.
void DMA_Config(void);

void UartPutc(unsigned char dat)
{
    S2BUF = dat; 
while((S2CON & S2TI)==0);
    S2CON &= ~S2TI;
}
 
char putchar(char c)
{
    UartPutc(c);
    return c;
}

//========================================================================
// : void main(void)
// : 
// : none.
// : none.
// 汾: VER1.0
// : 2024-07-28
// ע: 
//========================================================================
void main(void)
{
    u16 i;
    
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXSFR(); //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x00;   P0M0 = 0x00;   //Ϊ׼˫
    P1M1 = 0x00;   P1M0 = 0x00;   //Ϊ׼˫
    P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
    P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
    P4M1 = 0x00;   P4M0 = 0x00;   //Ϊ׼˫
    P5M1 = 0x00;   P5M0 = 0x00;   //Ϊ׼˫
    P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    for(i=0; i<256; i++)
    {
        DmaBuffer[i] = i;
    }

    UART2_config(2);    // ѡ, 2: ʹTimer2, ֵ: Ч.
    printf("AI8051U UART2 DMA Test Programme!\r\n");  //UART2һַ

    DMA_Config();
    EA = 1; //ж

    DmaTxFlag = 0;
    DmaRxFlag = 0;
    
    while (1)
    {
        if(B_RX2_TimeOut)
        {
            B_RX2_TimeOut = 0;

            i = ((u16)DMA_UR2R_DONEH << 8) + DMA_UR2R_DONE;
            i--;
            DMA_UR2T_AMT = (u8)i;       //ôֽ(8λ)i+1
            DMA_UR2T_AMTH = (u8)(i>>8); //ôֽ(8λ)i+1

            //رսDMA´νյ´ʼַλã´νݼšͬʱ DMA_UR2R_DONE
            DMA_UR2R_CR = 0;
            DMA_UR2T_CR = 0xc0;         //bit7 1:ʹ UART2_DMA, bit6 1:ʼ UART2_DMA Զ
            DMA_UR2R_CR = 0xa1;         //bit7 1:ʹ UART2_DMA, bit5 1:ʼ UART2_DMA Զ, bit0 1: FIFO
        }

//        if((DmaTxFlag) && (DmaRxFlag))
//        {
//            DmaTxFlag = 0;
//            DMA_UR2T_CR = 0xc0;         //bit7 1:ʹ UART2_DMA, bit6 1:ʼ UART2_DMA Զ
//            DmaRxFlag = 0;
//            DMA_UR2R_CR = 0xa1;         //bit7 1:ʹ UART2_DMA, bit5 1:ʼ UART2_DMA Զ, bit0 1: FIFO
//        }
    }
}

//========================================================================
// : void DMA_Config(void)
// : UART DMA á
// : none.
// : none.
// 汾: VER1.0
// : 2024-07-28
// ע: 
//========================================================================
void DMA_Config(void)
{
    DMA_UR2T_CFG = 0x00;        //bit7 1:Enable Interrupt
    DMA_UR2T_STA = 0x00;
    DMA_UR2T_AMT = 0xff;        //ôֽ(8λ)n+1
    DMA_UR2T_AMTH = 0x00;       //ôֽ(8λ)n+1
    DMA_UR2T_TXAH = (u8)((u16)&DmaBuffer >> 8);
    DMA_UR2T_TXAL = (u8)((u16)&DmaBuffer);
    DMA_UR2T_CR = 0xc0;         //bit7 1:ʹ UART2_DMA, bit6 1:ʼ UART2_DMA Զ

    DMA_UR2R_CFG = 0x00;        //bit7 1:Enable Interrupt
    DMA_UR2R_STA = 0x00;
    DMA_UR2R_AMT = 0xff;        //ôֽ(8λ)n+1
    DMA_UR2R_AMTH = 0x00;       //ôֽ(8λ)n+1
    DMA_UR2R_RXAH = (u8)((u16)&DmaBuffer >> 8);
    DMA_UR2R_RXAL = (u8)((u16)&DmaBuffer);
    DMA_UR2R_CR = 0xa1;         //bit7 1:ʹ UART2_DMA, bit5 1:ʼ UART2_DMA Զ, bit0 1: FIFO
}

//========================================================================
// : SetTimer2Baudraye(u16 dat)
// : Timer2ʷ
// : dat: Timer2װֵ.
// : none.
// 汾: VER1.0
// : 2024-07-28
// ע: 
//========================================================================
void SetTimer2Baudraye(u16 dat)  // ʹTimer2.
{
    AUXR &= ~(1<<4);    //Timer stop
    AUXR &= ~(1<<3);  //Timer2 set As Timer
    AUXR |= (1<<2);  //Timer2 set as 1T mode
    T2H = dat / 256;
    T2L = dat % 256;
    IE2 = (IE2 & ~0x04) | (0 << 2);    //ֹж
    AUXR = (AUXR & ~0x10) | (1 << 4);    //Timer run enable
}

//========================================================================
// : void UART2_config(u8 brt)
// : UART2ʼ
// : brt: ѡ, 2: ʹTimer2, ֵ: Ч.
// : none.
// 汾: VER1.0
// : 2024-07-28
// ע: 
//========================================================================
void UART2_config(u8 brt)    // ѡ, 2: ʹTimer2, ֵ: Ч.
{
    /*********** ʹ̶ʹöʱ2 *****************/
    if(brt == 2)
    {
        SetTimer2Baudraye((u16)(65536UL - (MAIN_Fosc / 4) / Baudrate2));

        S2CFG |= 0x01;     //ʹô2ʱW1λΪ1ܻԤڵĴ
        S2CON = (S2CON & 0x3f) | 0x40;    //UART2ģʽ, 0x00: ͬλ, 0x40: 8λ,ɱ䲨, 0x80: 9λ,̶, 0xc0: 9λ,ɱ䲨
//        IE2 |= ES2;       //ж
        S2CON |= S2REN;         //
        P_SW2 |= S2_S;         //UART2 switch to: 0: P1.2 P1.3,  1: P4.2 P4.3

        UR2TOCR = 0xc0; //bit7:ʹܳʱգbit6:ʹܳʱжϣbit5:ʱʱѡ 1:ϵͳʱ  0:λ()
        UR2TOTL = 0x40;
        UR2TOTH = 0x00; //0x5666 = 22118
        UR2TOTE = 0x00; //Ҫд UR2TOTE µTOֵŻЧ
    }
}

//========================================================================
// : void UART2_int (void) interrupt UART2_VECTOR
// : UART2жϺ
// : nine.
// : none.
// 汾: VER1.0
// : 2024-07-28
// ע: 
//========================================================================
void UART2_int (void) interrupt 8
{
//    if(S2CON & S2RI)
//    {
//        S2CON &= ~S2RI;    //Clear Rx flag
//        RX2_Buffer[RX2_Cnt] = S2BUF;
//        if(++RX2_Cnt >= UART2_BUF_LENGTH)   RX2_Cnt = 0;
//    }

//    if(S2CON & S2TI)
//    {
//        S2CON &= ~S2TI;    //Clear Tx flag
//        B_TX2_Busy = 0;
//    }
    
    if(UR2TOSR & 0x01)
    {
        B_RX2_TimeOut = 1;
        UR2TOSR = 0x80; // RTOCF ʱ־λ TOIF
    }
}

//========================================================================
// : void UART2_DMA_Interrupt (void) interrupt 52/53
// : UART2 DMAжϺ
// : none.
// : none.
// 汾: VER1.0
// : 2024-5-8
// ע: 
//========================================================================
void UART2_DMA_Interrupt(void) interrupt 13
{
    if (DMA_UR2T_STA & 0x01)    //
    {
        DMA_UR2T_STA &= ~0x01;
        DmaTxFlag = 1;
    }
    if (DMA_UR2T_STA & 0x04)    //ݸ
    {
        DMA_UR2T_STA &= ~0x04;
    }
    
    if (DMA_UR2R_STA & 0x01)    //
    {
        DMA_UR2R_STA &= ~0x01;
        DmaRxFlag = 1;
    }
    if (DMA_UR2R_STA & 0x02)    //ݶ
    {
        DMA_UR2R_STA &= ~0x02;
    }
}
