/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻AI8051UΪоƬʵбдԡ

ʹKeil C51,Ϊ˴ﵽȽϸߵЧ,һ㽨ѡ"Small"ģʽ

 "error C249: 'DATA': SEGMENT TOO LARGE" ʱҪֱֶȽϴͨ"xdata" ǿƷ䵽 XDATA (: char xdata buffer [256];)

3ȫ˫жϷʽշͨѶ

ͨPCMCU, MCUյԶDMAռ.

DMAݲʱжϺͨڵDMAԶ͹ܰѴ洢ռԭ.

öʱʷʹ1Tģʽ(ǵͲ12T)ѡɱʱƵʣ߾ȡ

ʱ, ѡʱ 22.1184MHz (û޸Ƶ).

******************************************/

#include "..\..\comm\AI8051U.h"
#include "stdio.h"
#include "intrins.h"

typedef     unsigned char    u8;
typedef     unsigned int    u16;
typedef     unsigned long    u32;

#define MAIN_Fosc   22118400L   //ʱӣȷ115200ʣ
#define Baudrate3   115200L

bit DmaTxFlag;
bit DmaRxFlag;
bit B_RX3_TimeOut;

u8 xdata DmaBuffer[256];

void UART3_config(u8 brt);   // ѡ, 2: ʹTimer2, ֵ: ʹTimer3.
void DMA_Config(void);

void UartPutc(unsigned char dat)
{
    S3BUF = dat; 
while((S3CON & S3TI)==0);
    S3CON &= ~S3TI;
}

char putchar(char c)
{
    UartPutc(c);
    return c;
}

//========================================================================
// : void main(void)
// : 
// : none.
// : none.
// 汾: VER1.0
// : 2024-07-28
// ע: 
//========================================================================
void main(void)
{
    u16 i;

    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXSFR(); //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ

    P0M1 = 0x00;   P0M0 = 0x00;   //Ϊ׼˫
    P1M1 = 0x00;   P1M0 = 0x00;   //Ϊ׼˫
    P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
    P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
    P4M1 = 0x00;   P4M0 = 0x00;   //Ϊ׼˫
    P5M1 = 0x00;   P5M0 = 0x00;   //Ϊ׼˫
    P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
    P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫

    for(i=0; i<256; i++)
    {
        DmaBuffer[i] = i;
    }

    UART3_config(0);    // ѡ, 2: ʹTimer2, ֵ: ʹTimer3.
    printf("AI8051U UART3 DMA Test Programme!\r\n");  //UART3һַ
    
    DMA_Config();
    EA = 1;     //ж

    DmaTxFlag = 0;
    DmaRxFlag = 0;
    
    while(1)
    {
        if(B_RX3_TimeOut)
        {
            B_RX3_TimeOut = 0;

            i = ((u16)DMA_UR3R_DONEH << 8) + DMA_UR3R_DONE;
            i--;
            DMA_UR3T_AMT = (u8)i;       //ôֽ(8λ)i+1
            DMA_UR3T_AMTH = (u8)(i>>8); //ôֽ(8λ)i+1

            //رսDMA´νյ´ʼַλã´νݼšͬʱ DMA_UR3R_DONE
            DMA_UR3R_CR = 0;
//            printf("cnt=%u\r\n",i);
            DMA_UR3T_CR = 0xc0;            //bit7 1:ʹ UART3_DMA, bit6 1:ʼ UART3_DMA Զ
            DMA_UR3R_CR = 0xa1;            //bit7 1:ʹ UART3_DMA, bit5 1:ʼ UART3_DMA Զ, bit0 1: FIFO
        }

//        if((DmaTxFlag) && (DmaRxFlag))
//        {
//            DmaTxFlag = 0;
//            DMA_UR3T_CR = 0xc0;            //bit7 1:ʹ UART3_DMA, bit6 1:ʼ UART3_DMA Զ
//            DmaRxFlag = 0;
//            DMA_UR3R_CR = 0xa1;            //bit7 1:ʹ UART3_DMA, bit5 1:ʼ UART3_DMA Զ, bit0 1: FIFO
//        }
    }
}

//========================================================================
// : void DMA_Config(void)
// : UART DMA á
// : none.
// : none.
// 汾: VER1.0
// : 2024-07-28
// ע: 
//========================================================================
void DMA_Config(void)
{
    DMA_UR3T_CFG = 0x00;        //bit7 1:Enable Interrupt
    DMA_UR3T_STA = 0x00;
    DMA_UR3T_AMT = 0xff;        //ôֽ(8λ)n+1
    DMA_UR3T_AMTH = 0x00;       //ôֽ(8λ)n+1
    DMA_UR3T_TXAH = (u8)((u16)&DmaBuffer >> 8);
    DMA_UR3T_TXAL = (u8)((u16)&DmaBuffer);
    DMA_UR3T_CR = 0xc0;         //bit7 1:ʹ UART3_DMA, bit6 1:ʼ UART3_DMA Զ

    DMA_UR3R_CFG = 0x00;        //bit7 1:Enable Interrupt
    DMA_UR3R_STA = 0x00;
    DMA_UR3R_AMT = 0xff;        //ôֽ(8λ)n+1
    DMA_UR3R_AMTH = 0x00;       //ôֽ(8λ)n+1
    DMA_UR3R_RXAH = (u8)((u16)&DmaBuffer >> 8);
    DMA_UR3R_RXAL = (u8)((u16)&DmaBuffer);
    DMA_UR3R_CR = 0xa1;         //bit7 1:ʹ UART3_DMA, bit5 1:ʼ UART3_DMA Զ, bit0 1: FIFO
}

//========================================================================
// : SetTimer2Baudraye(u16 dat)
// : Timer2ʷ
// : dat: Timer2װֵ.
// : none.
// 汾: VER1.0
// : 2024-07-28
// ע: 
//========================================================================
void SetTimer2Baudraye(u16 dat)  // ʹTimer2.
{
    AUXR &= ~(1<<4);    //Timer stop
    AUXR &= ~(1<<3);  //Timer2 set As Timer
    AUXR |= (1<<2);  //Timer2 set as 1T mode
    T2H = dat / 256;
    T2L = dat % 256;
    IE2 = (IE2 & ~0x04) | (0 << 2);    //ֹж
    AUXR = (AUXR & ~0x10) | (1 << 4);    //Timer run enable
}

//========================================================================
// : void UART3_config(u8 brt)
// : UART3ʼ
// : brt: ѡ, 2: ʹTimer2, ֵ: ʹTimer3.
// : none.
// 汾: VER1.0
// : 2024-07-28
// ע: 
//========================================================================
void UART3_config(u8 brt)    // ѡ, 2: ʹTimer2, ֵ: ʹTimer3.
{
    if(brt == 2)
    {
        SetTimer2Baudraye((u16)(65536UL - (MAIN_Fosc / 4) / Baudrate3));
        S3CON = 0x10;   //8λ, ʹTimer2ʷ, 
    }
    else
    {
        S3CON = 0x50;   //8λ, ʹTimer3ʷ, 
        T3H = (65536UL - (MAIN_Fosc / 4) / Baudrate3) / 256;
        T3L = (65536UL - (MAIN_Fosc / 4) / Baudrate3) % 256;
        T4T3M &= ~(1<<2);      //Timer3 set As Timer
        T4T3M |= (1<<1);      //Timer3 set as 1T mode
        T4T3M = (T4T3M & ~0x08) | (1<< 3);        //Timer run enable
    }
//    IE2 |= ES3;       //UART3ж
    P_SW2 &= ~S3_S;       //UART3 switch bit1 to: 0: P0.0 P0.1,  1: P5.0 P5.1

    UR3TOCR = 0xc0; //bit7:ʹܳʱգbit6:ʹܳʱжϣbit5:ʱʱѡ 1:ϵͳʱ  0:λ()
    UR3TOTL = 0x40;
    UR3TOTH = 0x00; //0x5666 = 22118
    UR3TOTE = 0x00; //Ҫд UR3TOTE µTOֵŻЧ
}

//========================================================================
// : void UART3_int (void) interrupt UART3_VECTOR
// : UART3жϺ
// : nine.
// : none.
// 汾: VER1.0
// : 2024-07-28
// ע: 
//========================================================================
void UART3_int (void) interrupt 17
{
//    if(S3CON & S3RI)
//    {
//        S3CON &= ~S3RI;    //Clear Rx flag
//        RX3_Buffer[RX3_Cnt] = S3BUF;
//        if(++RX3_Cnt >= UART3_BUF_LENGTH)   RX3_Cnt = 0;
//    }

//    if(S3CON & S3TI)
//    {
//        S3CON &= ~S3TI;   //Clear Tx flag
//        B_TX3_Busy = 0;
//    }

    if(UR3TOSR & 0x01)
    {
        B_RX3_TimeOut = 1;
        UR3TOSR = 0x80; // RTOCF ʱ־λ TOIF
    }
}

//========================================================================
// : void UART3_DMA_Interrupt (void) interrupt 54/55
// : UART3 DMAжϺ
// : none.
// : none.
// 汾: VER1.0
// : 2024-07-28
// ע: 
//========================================================================
void UART3_DMA_Interrupt(void) interrupt 13
{
    if (DMA_UR3T_STA & 0x01)    //
    {
        DMA_UR3T_STA &= ~0x01;
        DmaTxFlag = 1;
    }
    if (DMA_UR3T_STA & 0x04)    //ݸ
    {
        DMA_UR3T_STA &= ~0x04;
    }
    
    if (DMA_UR3R_STA & 0x01)    //
    {
        DMA_UR3R_STA &= ~0x01;
        DmaRxFlag = 1;
    }
    if (DMA_UR3R_STA & 0x02)    //ݶ
    {
        DMA_UR3R_STA &= ~0x02;
    }
}
