/*---------------------------------------------------------------------*/
/* --- Web: www.STCAI.com ---------------------------------------------*/
/*---------------------------------------------------------------------*/

/*************  ˵    **************

̻AI8051UΪоƬʵV1.1汾бдԡ

ʹKeil C51,Ϊ˴ﵽȽϸߵЧ,һ㽨ѡ"Small"ģʽ

 "error C249: 'DATA': SEGMENT TOO LARGE" ʱҪֱֶȽϴͨ"xdata" ǿƷ䵽 XDATA (: char xdata buffer [256];)

128*64LCDʾʵMCU3.3V磬LCDҪ5V(R175,R176Ͽ).

ʾͼΣ֣Ӣģ

ͼʾݾʹDMA24MHz, ÿLCM DMAжϴռCPUʱΪ2.3us, ʱ84ms.

Ҫʾݷ1024ֽڵԴУDMA伴ɡ

ʱ, ѡʱ 24MHz (û޸Ƶʺ±뼴).

******************************************/

//	#define MAIN_Fosc        12000000UL
	#define MAIN_Fosc        24000000UL
//	#define MAIN_Fosc        40000000UL

	#include "..\..\comm\AI8051U.h"

	#include	<stdio.h>
	#include	<intrins.h>
	#include	"picture1.h"
	#include	"picture2.h"

typedef     unsigned char   u8;
typedef     unsigned int    u16;
typedef     unsigned long   u32;
#define	Pin6		0x40	//IO Px.6
#define	Pin7		0x80	//IO Px.7
#define P3n_push_pull(bitn)			P3M1 &= ~(bitn),	P3M0 |=  (bitn)
//=============================================================================================================
#define	PullUpEnable(port, pu)		port |=  (pu)		/* ˿ڲ       PxPU, ҪõĶ˿ڶӦλΪ1 */
#define	PullUpDisable(port, pu)		port &= ~(pu)		/* ֹ˿ڲ(Ĭ) PxPU, ҪõĶ˿ڶӦλΪ1 */
#define	PullDownEnable(port, pu)	port |=  (pu)		/* ˿ڲ       PxPD, ҪõĶ˿ڶӦλΪ1 */
#define	PullDownDisable(port, pu)	port &= ~(pu)		/* ֹ˿ڲ(Ĭ) PxPD, ҪõĶ˿ڶӦλΪ1 */
#define	SchmitEnable(port, smt)		port &= ~(smt)		/* ˿ʩش(Ĭ) PxNCS, ҪõĶ˿ڶӦλΪ1 */
#define	SchmitDisable(port, smt)	port |=  (smt)		/* ˿ʩش       PxNCS, ҪõĶ˿ڶӦλΪ1 */
#define	SlewRateNormal(port, sr)	port |=  (sr)		/* ˿Ϊͨٶ(Ĭ) PxSR, ҪõĶ˿ڶӦλΪ1 */
#define	SlewRateHigh(port, sr)		port &= ~(sr)		/* ˿Ϊģʽ       PxSR, ҪõĶ˿ڶӦλΪ1 */
#define	CurrentNormal(port, cu)		port |=  (cu)		/* ˿Ϊͨģʽ(Ĭ) PxDR, ҪõĶ˿ڶӦλΪ1 */
#define	CurrentHigt(port, cu)		port &= ~(cu)		/* ˿Ϊģʽ     PxDR, ҪõĶ˿ڶӦλΪ1 */
#define	InputEnable(port, ie)		port |=  (ie)		/* ˿(Ĭ) PxIE, ҪõĶ˿ڶӦλΪ1 */
#define	InputDisable(port, ie)		port &= ~(ie)		/* ֹ˿       PxIE, ҪõĶ˿ڶӦλΪ1 */
#define	BypassEnable(port, bp)		port &= ~(bp)		/* Զƶ˿       PxBP, ҪõĶ˿ڶӦλΪ1 */
#define	BypassDisable(port, bp)		port |=  (bp)		/* ֹԶƶ˿(Ĭ) PxBP, ҪõĶ˿ڶӦλΪ1 */
//=============================================================================================================

/****************************** IO ***********************************/
	sbit	LCD_RS	= P4^5;
	sbit	LCD_RW	= P3^6;
	sbit	LCD_E	= P3^7;
	sbit	LCD_RST	= P4^7;
	#define	LCD_Data	P2

/*****************************************************************************/

/*************  س    **************/
const u8  uctech[] = {"LCD12864ͼʾ"};
const u8  net[]    = {"\xfdоƬST7920"};
const u8  mcu[]    = {"  ڴֿ  "};
const u8  qq[]     = {" AI8051U LQFP48 "};

/*************  ر    **************/
u16	LCM_TxCnt;		//LCM DMAʹ, һ16ֽ, һ64
bit	B_LCM_DMA_busy;	//LCM DMAæ־ 1־LCM-DMAæLCM DMAж˱־ʹLCM DMAǰҪȷϴ˱־Ϊ0
u16	LCM_TxAddr;		//LCM DMAҪݵ׵ַ
bit	B_TxCmd;		//ѷ־
u8	xdata CmdTmp[2];	//
u8	xdata DisTmp[1024] _at_ 0x0000;	//ʾ壬ҪʾݷԴDMA. LCM DMA4ֽڶ⣬ﶨλԵַΪ4ı

/*************  غ    **************/
void    delay_ms(u16 ms);
void    WriteDataLCD(u8 WDLCD);
void    WriteCommandLCD(u8 WCLCD);
void    ReadStatusLCD(void);
void    LCDInit(void);
void    LCDClear(void);
void    DisplayListChar(u8 X, u8 Y, const u8 *DData);
void    DisplayImage (u8 xdata *DData);
void 	LCM_Config(void);
void 	DMA_Config(u8 xdata *pic);

/*********************  *************************/
void main(void)
{
	u16	i;

	EAXSFR();	//չĴ(XFR)ʹ
	WTST  = 0;	//óָʱֵΪ0ɽCPUִָٶΪ
	CKCON = 0;	//߷XRAMٶ

	P0M1 = 0x00;   P0M0 = 0x00;   //Ϊ׼˫
	P1M1 = 0x00;   P1M0 = 0x00;   //Ϊ׼˫
	P2M1 = 0x00;   P2M0 = 0x00;   //Ϊ׼˫
	P3M1 = 0x00;   P3M0 = 0x00;   //Ϊ׼˫
	P4M1 = 0x00;   P4M0 = 0x00;   //Ϊ׼˫
	P5M1 = 0x00;   P5M0 = 0x00;   //Ϊ׼˫
	P6M1 = 0x00;   P6M0 = 0x00;   //Ϊ׼˫
	P7M1 = 0x00;   P7M0 = 0x00;   //Ϊ׼˫
	P3n_push_pull(Pin7+Pin6);	//P3.7 P3.6ΪΪ˫IC

	PullUpEnable(P2PU, 0xff);	// ˿ڲ       PxPU, ҪõĶ˿ڶӦλΪ1
	PullUpEnable(P3PU, 0xc0);	// ˿ڲ       PxPU, ҪõĶ˿ڶӦλΪ1
	PullUpEnable(P4PU, 0xa0);	// ˿ڲ       PxPU, ҪõĶ˿ڶӦλΪ1

	delay_ms(100);	//ȴLCD빤״̬
	LCM_Config();
	delay_ms(10);
	LCDInit();		//LCMʼ
	delay_ms(10);	//ʱƬ
	EA = 1;

    while(1)
    {
		for(i=0; i<1024; i++)	DisTmp[i] = gImage_picture1[i];	//ͼƬװصԴ
		LCDClear();
		DMA_Config(DisTmp);	//DMAʾͼ
		delay_ms(3000);

		for(i=0; i<1024; i++)	DisTmp[i] = gImage_picture2[i];	//ͼƬװصԴ
		LCDClear();
		DMA_Config(DisTmp);	//DMAʾͼ
		delay_ms(3000);

		LCDClear();
		DisplayListChar(0,1,uctech);    //ʾֿе
		DisplayListChar(0,2,net);       //ʾֿе
		DisplayListChar(0,3,mcu);       //ʾֿе
		DisplayListChar(0,4,qq);        //ʾֿе
		delay_ms(3000);
    }
}

//========================================================================
// : void delay_ms(u8 ms)
// : ʱ
// : ms,Ҫʱms, ֻ֧1~255ms. ԶӦʱ.
// : none.
// 汾: VER1.0
// : 2013-4-1
// ע:
//========================================================================
void delay_ms(u16 ms)
{
    u16 i;
    do
    {
        i = MAIN_Fosc / 6000;
        while(--i);
    }while(--ms);
}

//========================================================================
// : void LCM_Config(void)
// : LCMúST7920 @540KHzָʱΪ1.6msæź0us, д롢ݡ72us. DMAˢʱ84ms @24MHz.
// : none.
// : none.
// 汾: V1.0, 2024-8-17
// ע:
//========================================================================
//LCMIFCFG  (7EFE50H)	TFTӿüĴ
#define	LCMIFIE			(0<<7)	//TFTӿжʹܿλ(bit7), 1->жϣ0->ֹ
#define	LCMIFIP			(0<<4)	//TFTӿжȼλ(bit5~bit4), ()0~3().
#define	LCMIFDPS		(0<<2)	//TFTӿݽѡλ(bit3~bit2), D18_D8=0: 02->8λP2, D18_D8=1: 0: P2-ֽ, P0ֽ, 2: P2-ֽ,ֽP0[7:4] P4.7 P4.6 P4.3 P4.1.
#define	LCM_D16_D8		(0<<1)	//TFTӿݿȿλ(bit1), 0: 8λݣ1:16λ
#define	LCM_M68_I80		1		//TFTӿģʽѡλ(bit0), 0: I8080ģʽ1:M6800ģʽ

//LCMIFCFG2  (7EFE51H)	TFTӿüĴ2
#define	LCMIFCPS		(1<<5)	//TFTӿڿƽѡλ(bit6~bit5), RS RD(E) WR(RW), 0->P4.5 P4.4 P4.21->P4.5 P3.7 P3.6, 2->P4.0 P4.4 P4.2, 3->P4.0 P3.7 P3.6
#define	LCMSETUPT		(4<<2)	//TFTӿݽʱλ(bit4~bit2), 0~7, Ӧ1~8LCMIFʱ, 6800ģʽEߵƽʱ, 20us.
#define	LCMHOLDT		3		//TFTӿݱʱλ(bit1~bit0), 0~3, Ӧ1~4LCMIFʱ

//LCMIFCR  (7EFE52H)	TFTӿڿƼĴ
#define	ENLCMIF			(1<<7)	//TFTӿʹܿλ(bit7), 1->TFTӿڹ, 0->ֹ
#define	LCM_WRCMD		4		//TFTӿڴ(bit2~bit0), 4->д
#define	LCM_WRDAT		5		//TFTӿڴ(bit2~bit0), 5->д
#define	LCM_RDCMD		6		//TFTӿڴ(bit2~bit0), 6->/״̬
#define	LCM_RDDAT		7		//TFTӿڴ(bit2~bit0), 7->

void LCM_Config(void)
{
	LCMIFCFG  = LCMIFIE  | LCMIFIP   | LCMIFDPS | LCM_D16_D8 | LCM_M68_I80;
	LCMIFCFG2 = LCMIFCPS | LCMSETUPT | LCMHOLDT;	//RS:P45,E:P37,RW:P36; Setup Time,HOLD Time
	LCMIFSTA  = 0x00;	//TFTӿж־0
	LCMIFPSCR = (u8)(MAIN_Fosc/250000UL-1);	//TFTӿʱԤƵ0~255, LCMIFʱƵ = SYSclk/(LCMIFPSCR+1), LCD12864ٶ250KHz
	LCMIFCR   = ENLCMIF;
}

//========================================================================
// : void DMA_Config(u8 xdata *pic)
// : LCM DMAú
// : *pic: ׵ַ.
// : none.
// 汾: V1.0, 2024-8-17
// ע:
//========================================================================
//DMA_LCM_CR (7EfA71H) 	LCM_DMAƼĴ
#define		DMA_ENLCM	(1<<7)	// LCM DMAʹܿλ    bit7, 0:ֹLCM DMAܣ  1LCM DMAܡ
#define		LCM_TRIGWC	(1<<6)	// LCM DMAдbit6, 0:д0Ч          1д1ʼLCM DMAʼд
#define		LCM_TRIGWD	(1<<5)	// LCM DMAдݣbit5, 0:д0Ч          1д1ʼLCM DMAʼдݡ
#define		LCM_TRIGRC	(1<<4)	// LCM DMAbit4, 0:д0Ч          1д1ʼLCM DMAʼ
#define		LCM_TRIGRD	(1<<3)	// LCM DMAݣbit3, 0:д0Ч          1д1ʼLCM DMAʼݡ
#define		LCM_CLRFIFO	0		// LCM DMAFIFOλbit0, 0:д0Ч  1д1λFIFOָ롣

//DMA_LCM_CFG 	(7EfA70H)   SPI_DMAüĴ
#define		DMA_LCMIE	(1<<7)	// LCM DMAжʹܿλbit7, 0:ֹSPI DMAжϣ     1жϡ
#define		DMA_LCMIP	(0<<2)	// LCM DMAжȼλbit3~bit2, ()0~3().
#define		DMA_LCMPTY	0		// LCM DMA߷ȼλbit1~bit0, ()0~3().

//DMA_LCM_STA  (7EfA72) 	LCM_DMA״̬Ĵ
#define		LCM_TXOVW	(1<<1)	// LCM DMAݸǱ־λbit1, 0.
#define		DMA_LCMIF	1		// LCM DMAж־λbit0, 0.

void DMA_Config(u8 xdata *pic)
{
	WriteCommandLCD(0x36);			//ѡָ, ʾͼ

	LCM_TxAddr   = (u16)pic;		//Ҫݵ׵ַ
	DMA_LCM_STA  = 0x00;
	DMA_LCM_CFG  = DMA_LCMIE | DMA_LCMIP | DMA_LCMPTY;;
	DMA_LCM_ITVH = 0;	//ôʱ(8λ)ӦN+1LCMIFʱ(1~65536LCMIFʱ)
	DMA_LCM_ITVL = 9-1;	//ôʱ(8λ)

	B_TxCmd   = 0;		//ѷ־
	LCM_TxCnt = 0;		//LCM DMAʹ, һ16ֽ, һ64
	B_LCM_DMA_busy = 1;	//־LCM-DMAæLCM DMAж˱־ʹLCM DMAǰҪȷϴ˱־Ϊ0
	DMA_LCM_STA = DMA_LCMIF;	//LCM DMAжϣ
}

//========================================================================
// : void LCMIF_DMA_ISR(interrupt USER_VECTOR//DMA_LCM_VECTORVECTOR
// : LCM DMAжϺжϴʱ:2.3us @24MHz. ˢʱ䣺84ms @24MHz.
// : none.
// : none.
// 汾: V1.0, 2024-8-17
// ע:
//========================================================================
void LCMIF_DMA_ISR(void) interrupt USER_VECTOR//DMA_LCM_VECTOR
{
	if(DMA_LCM_STA & DMA_LCMIF)
	{
		if(LCM_TxCnt >= 64)	//жϷǷ
		{
			DMA_LCM_CR = 0;
			B_LCM_DMA_busy = 0;		//LCM-DMAæ־LCM DMAж˱־ʹLCM DMAǰҪȷϴ˱־Ϊ0
		}
		else		//Ҫ
		{
			if(!B_TxCmd)	//ûзõַȷõַ
			{
				B_TxCmd = 1;	//ָʾѷַ
				if(LCM_TxCnt <32)   //ϰ
				{
					CmdTmp[0] = (u8)(0x80+LCM_TxCnt);	//еַ
					CmdTmp[1] = 0x80;					//еַϰַ0X80
				}
				else   //°
				{
					CmdTmp[0] = (u8)(0x80+LCM_TxCnt-32);	//еַ
					CmdTmp[1] = 0x88;						//еַ°ַ0X88
				}
				DMA_LCM_TXAH = (u8)((u16)CmdTmp >> 8);	//LCM DMA׵ַ
				DMA_LCM_TXAL = (u8)CmdTmp;
				DMA_LCM_AMTH = 0;				//ôֽ(8λ),	ôֽ = N+1
				DMA_LCM_AMT  = 2-1;				//ôֽ(8λ).
				DMA_LCM_CR   = DMA_ENLCM | LCM_TRIGWC;	//LCM DMA
			}
			else
			{
				B_TxCmd = 0;	//ѷַ
				DMA_LCM_TXAH = (u8)(LCM_TxAddr >> 8);	//LCM DMA׵ַ
				DMA_LCM_TXAL = (u8)LCM_TxAddr;
				DMA_LCM_AMTH = 0;				//ôֽ(8λ),	ôֽ = N+1
				DMA_LCM_AMT  = 16-1;			//ôֽ(8λ).
				DMA_LCM_CR   = DMA_ENLCM | LCM_TRIGWD;	//LCM DMA
				LCM_TxAddr  += 16;	//Ҫݵ׵ַ, һDMA16ֽ
				LCM_TxCnt++;		//ʹ+1
			}
		}
	}
	DMA_LCM_STA = 0;
}

//״̬
void ReadStatusLCD(void)
{
//	LCD_Data = 0xFF;
	LCMIFSTA = 0;	//ɱ־
    do
    {
		LCMIFCR   = ENLCMIF | LCM_RDCMD;	//״̬
		while((LCMIFSTA & 1) == 0)	;	//ȴ
		LCMIFSTA = 0;	//ɱ־
		LCD_E = 0;
    }while(LCMIFDATL & 0x80);	//bit7==0
}

//д
void WriteDataLCD(u8 WDLCD)
{
	ReadStatusLCD(); //æ
	LCMIFDATL = WDLCD;
	LCMIFCR   = ENLCMIF | LCM_WRDAT;	//д
	while((LCMIFSTA & 1) == 0)	;	//ȴд
	LCMIFSTA = 0;	//ɱ־
}

//дָ
void WriteCommandLCD(u8 WCLCD)
{
	ReadStatusLCD(); //æ
	LCMIFDATL = WCLCD;
	LCMIFCR   = ENLCMIF | LCM_WRCMD;	//д
	while((LCMIFSTA & 1) == 0)	;	//ȴд
	LCMIFSTA = 0;	//ɱ־
}

void LCDInit(void) //LCMʼ
{
	delay_ms(10);
	LCD_RST = 0;
	delay_ms(10);
	LCD_RST = 1;
	delay_ms(100);	//40ms

	WriteCommandLCD(0x30);	//ʾģʽ,ʼҪÿμæź
	WriteCommandLCD(0x01);	//ʾ
	WriteCommandLCD(0x04);	//ʾã
	WriteCommandLCD(0x0C);	//˯
}

void LCDClear(void) //
{
	WriteCommandLCD(0x30); //ѡָ
	WriteCommandLCD(0x01); //ʾ, æźų1.2ms
}

//ָλʾһַ
void DisplayListChar(u8 X, u8 Y, const u8 *DData)
{
	u8 ListLength,X2;
	X2 = X;
	if(Y < 1)   Y=1;
	if(Y > 4)   Y=4;
	X &= 0x0F; //Xܴ16Y1-4֮
	WriteCommandLCD(0x30);		//ѡָ
	switch(Y)
	{
		case 1: X2 |= 0X80; break;  //ѡӦַ
		case 2: X2 |= 0X90; break;
		case 3: X2 |= 0X88; break;
		case 4: X2 |= 0X98; break;
	}
	WriteCommandLCD(X2); //͵ַ
	ListLength = 0;
	while (DData[ListLength] >= 0x20) //ִβ˳
	{
		if (X <= 0x0F) //XӦС0xF
		{
			WriteDataLCD(DData[ListLength]); //
			ListLength++;
			X++;
		}
	}
}
